/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.jar.Manifest;
import org.netbeans.modules.jarpackager.CompressionEditor;
import org.netbeans.modules.jarpackager.CompressionLevel;
import org.netbeans.modules.jarpackager.ContentMember;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.DataObjectListEditor;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.FilterEditor;
import org.netbeans.modules.jarpackager.JarChildren;
import org.netbeans.modules.jarpackager.JarCompiler;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarContentChildren;
import org.netbeans.modules.jarpackager.JarCreator;
import org.netbeans.modules.jarpackager.JarDataLoader;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.jarpackager.JarExecutor;
import org.netbeans.modules.jarpackager.ManifestTab;
import org.netbeans.modules.jarpackager.api.ExtendedPropertyFactory;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.netbeans.modules.jarpackager.util.BadgeIconCache;
import org.netbeans.modules.jarpackager.wizard.JarContentsWizardIterator;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.cookies.CompilerCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.execution.Executor;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.RepositoryAdapter;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExecSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

public class JarDataObject
extends MultiDataObject
implements OpenCookie,
CompilerCookie.Compile,
CompilerCookie.Build {
    static final long serialVersionUID = 2983457824351249776L;
    static final String EA_JAR_CONTENT = "NetBeans-JarContent";
    static final String LOCATION_PROP = "location";
    static final String CONTENTS_PROP = "contents";
    static final String FILTER_PROP = "filter";
    public static final String VALID_PROP = "contents_valid";
    transient JarContent jarContent;
    private boolean needsCompile = false;
    private boolean allValid;
    private static Map dummyNodes = new WeakHashMap();
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard$Iterator;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject$Save;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataLoader;

    public JarDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.getCookieSet().add((Node.Cookie)new JarExecSupport(this.getPrimaryEntry()));
        boolean bl = false;
        File file = this.findArchiveJarFile();
        if (file != null) {
            long l = file.lastModified();
            if (l == 0L) {
                bl = true;
            } else {
                FileObject fileObject2 = this.findContentFile();
                if (fileObject2 != null) {
                    Date date = fileObject2.lastModified();
                    bl = date.getTime() > l;
                }
            }
        }
        this.needsCompile = bl;
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz.isAssignableFrom(class$org$openide$loaders$TemplateWizard$Iterator == null ? (class$org$openide$loaders$TemplateWizard$Iterator = JarDataObject.class$("org.openide.loaders.TemplateWizard$Iterator")) : class$org$openide$loaders$TemplateWizard$Iterator)) {
            return new JarContentsWizardIterator();
        }
        Node.Cookie cookie = super.getCookie(clazz);
        return cookie;
    }

    public boolean getNeedsCompile() {
        return this.needsCompile;
    }

    void setNeedsCompile(boolean bl) {
        this.needsCompile = bl;
        this.checkIcon();
    }

    public void checkIcon() {
        JarNode jarNode = (JarNode)JarDataObject.safeGetNodeDelegate((DataObject)this, false);
        if (jarNode != null) {
            jarNode.iconChange();
        }
    }

    public void open() {
    }

    protected void handleDelete() throws IOException {
        super.handleDelete();
        this.setModified(false);
    }

    public void setModified(boolean bl, String string) {
        CookieSet cookieSet = this.getCookieSet();
        Save save = (Save)cookieSet.getCookie(class$org$netbeans$modules$jarpackager$JarDataObject$Save == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$Save = JarDataObject.class$("org.netbeans.modules.jarpackager.JarDataObject$Save")) : class$org$netbeans$modules$jarpackager$JarDataObject$Save);
        if (bl && save == null) {
            cookieSet.add((Node.Cookie)new Save());
        } else if (!bl && save != null) {
            cookieSet.remove((Node.Cookie)save);
        }
        if (bl) {
            this.firePropertyChange(string, null, null);
        }
        super.setModified(bl);
        this.setNeedsCompile(true);
    }

    public void setModified(boolean bl) {
        this.setModified(bl, "");
    }

    public void save() throws IOException {
        this.writeJarContent(this.getJarContent());
        this.setModified(false);
    }

    public boolean isDepthSupported(Compiler.Depth depth) {
        return Compiler.DEPTH_ONE.equals(depth);
    }

    public void addToJob(CompilerJob compilerJob, Compiler.Depth depth) {
        JarContent jarContent = this.getJarContent();
        if (jarContent == null) {
            return;
        }
        File file = jarContent.getTargetFile();
        if (file == null) {
            String string;
            FileObject fileObject = this.findContentFile();
            FileObject fileObject2 = FileUtil.findBrother((FileObject)fileObject, (String)(string = ((JarDataLoader)this.getLoader()).getArchiveExt()));
            if (fileObject2 == null) {
                try {
                    fileObject2 = fileObject.getParent().createData(fileObject.getName(), string);
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)iOException, (Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarDataObject.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject)).getString("MSG_CreateArchiveError")));
                    return;
                }
            }
            file = NbClassPath.toFile((FileObject)fileObject2);
            jarContent.setTargetFile(NbClassPath.toFile((FileObject)fileObject2));
            this.setModified(true);
        }
        if (this.isModified()) {
            try {
                this.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        compilerJob.add((Compiler)new JarCompiler(jarContent, this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeJarContent(JarContent jarContent) throws IOException {
        FileObject fileObject = this.findContentFile();
        FileObject fileObject2 = this.getPrimaryFile();
        FileLock fileLock = null;
        try {
            if (fileObject == null) {
                fileObject = fileObject2.getParent().createData(fileObject2.getName(), JarPackagerOption.singleton().getContentExt());
            }
            fileLock = fileObject.lock();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileObject.getOutputStream(fileLock));
            try {
                jarContent.writeContent(objectOutputStream, fileObject);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                objectOutputStream.close();
                throw throwable;
            }
            objectOutputStream.close();
            Object var9_9 = null;
            if (fileLock == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    public JarContent getJarContent() {
        if (this.jarContent == null) {
            FileObject fileObject = this.findContentFile();
            if (fileObject == null) {
                return null;
            }
            this.jarContent = JarContent.readFromFile(fileObject);
        }
        return this.jarContent;
    }

    protected FileObject findContentFile() {
        return this.getPrimaryFile();
    }

    public boolean resolveContents() {
        JarContent jarContent = this.getJarContent();
        if (jarContent != null) {
            ContentMemberList contentMemberList = jarContent.getContentList();
            contentMemberList.resolveAll();
        }
        return this.allValid();
    }

    public boolean allValid() {
        boolean bl = false;
        JarDataObject jarDataObject = this;
        synchronized (jarDataObject) {
            boolean bl2 = this.allValid;
            JarContent jarContent = this.getJarContent();
            if (jarContent != null) {
                ContentMemberList contentMemberList = jarContent.getContentList();
                this.allValid = !contentMemberList.anyInvalid();
            }
            bl = bl2 != this.allValid;
        }
        if (bl) {
            this.checkIcon();
            this.firePropertyChange(VALID_PROP, null, null);
        }
        return this.allValid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Node safeGetNodeDelegate(DataObject dataObject, boolean bl) {
        Node node = null;
        RuntimeException runtimeException = null;
        try {
            try {
                if (dataObject.isValid()) {
                    node = dataObject.getNodeDelegate();
                }
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
                Object var6_5 = null;
                if (!dataObject.isValid()) {
                    if (!bl) return node;
                    Map map = dummyNodes;
                    synchronized (map) {
                        node = (Node)dummyNodes.get(dataObject);
                        if (node != null) return node;
                        node = new DataNode(dataObject, Children.LEAF);
                        dummyNodes.put(dataObject, node);
                        return node;
                    }
                }
                if (runtimeException == null) return node;
                throw runtimeException;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!dataObject.isValid()) {
                if (!bl) throw throwable;
                Map map = dummyNodes;
                synchronized (map) {
                    node = (Node)dummyNodes.get(dataObject);
                    if (node != null) throw throwable;
                    node = new DataNode(dataObject, Children.LEAF);
                    dummyNodes.put(dataObject, node);
                    throw throwable;
                }
            }
            if (runtimeException == null) throw throwable;
            throw runtimeException;
        }
        if (!dataObject.isValid()) {
            if (!bl) return node;
            Map map = dummyNodes;
            synchronized (map) {
                node = (Node)dummyNodes.get(dataObject);
                if (node != null) return node;
                node = new DataNode(dataObject, Children.LEAF);
                dummyNodes.put(dataObject, node);
                return node;
            }
        }
        if (runtimeException == null) return node;
        throw runtimeException;
    }

    public FileObject findArchiveFile() {
        FileObject fileObject = this.findContentFile();
        return FileUtil.findBrother((FileObject)fileObject, (String)((JarDataLoader)this.getLoader()).getArchiveExt());
    }

    public File findArchiveJarFile() {
        return this.getJarContent().getTargetFile();
    }

    public File defaultArchiveFile() {
        return JarDataObject.defaultArchiveFile(NbClassPath.toFile((FileObject)this.getPrimaryFile()), ((JarDataLoader)this.getLoader()).getArchiveExt());
    }

    public static File defaultArchiveFile(File file, String string) {
        if (file != null) {
            String string2;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return null;
            }
            String string3 = string2;
            JarDataLoader jarDataLoader = (JarDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarDataObject.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader));
            int n = string2.lastIndexOf("." + jarDataLoader.getExtension());
            if (n > 0) {
                string3 = string2.substring(0, n);
            }
            return new File(string3 + "." + string);
        }
        return null;
    }

    public boolean usesDefaultArchiveFile() {
        File file = this.getJarContent().getTargetFile();
        File file2 = this.defaultArchiveFile();
        try {
            return file != null && file2 != null && file.getCanonicalPath().equals(file2.getPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected Node createNodeDelegate() {
        return new JarNode((DataObject)this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarDataObject.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class JarExecSupport
    extends ExecSupport {
        public JarExecSupport(MultiDataObject.Entry entry) {
            super(entry);
        }

        protected Executor defaultExecutor() {
            return new JarExecutor();
        }
    }

    public static class JarNode
    extends DataNode {
        private transient RepositoryListener rl;
        private static final String ICON_BASE = "org/netbeans/modules/jarpackager/resources/";
        private static final String JAR_ICON_BASE = "org/netbeans/modules/jarpackager/resources/jar_recipe";
        private static final String BADGE_NEEDS_COMPILE = "org/netbeans/modules/jarpackager/resources/needs-compile";
        private static final int BADGE_NEEDS_COMPILE_KEY = 1;
        private static final String BADGE_DATAOBJECT_INVALID = "org/netbeans/modules/jarpackager/resources/dataobject-invalid";
        private static final int BADGE_DATAOBJECT_INVALID_KEY = 2;
        private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarPackagerModule == null ? (class$org$netbeans$modules$jarpackager$JarPackagerModule = JarNode.class$("org.netbeans.modules.jarpackager.JarPackagerModule")) : class$org$netbeans$modules$jarpackager$JarPackagerModule));
        private static BadgeIconCache badgeCache;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarPackagerModule;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject$JarNode;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject;
        static /* synthetic */ Class class$org$openide$loaders$ExecSupport;
        static /* synthetic */ Class class$java$io$File;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$CompressionLevel;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$FileObjectFilter;
        static /* synthetic */ Class class$java$util$jar$Manifest;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarContent;

        public JarNode(DataObject dataObject) {
            this(dataObject, (Children)new JarChildren((JarDataObject)dataObject));
        }

        public JarNode(DataObject dataObject, Children children) {
            super(dataObject, children);
            this.setIconBase(JAR_ICON_BASE);
            Class clazz = class$org$netbeans$modules$jarpackager$JarDataObject$JarNode == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$JarNode = JarNode.class$("org.netbeans.modules.jarpackager.JarDataObject$JarNode")) : class$org$netbeans$modules$jarpackager$JarDataObject$JarNode;
            synchronized (clazz) {
                if (badgeCache == null) {
                    this.loadBadges();
                }
            }
            this.setDefaultAction(SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JarNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)));
            this.rl = new ReposListener();
            RepositoryListener repositoryListener = WeakListener.repository((RepositoryListener)this.rl, (Object)((Object)this));
            TopManager.getDefault().getRepository().addRepositoryListener(repositoryListener);
        }

        protected void createPasteTypes(Transferable transferable, List list) {
            Node[] nodeArray;
            final Node[] nodeArray2 = NodeTransfer.nodes((Transferable)transferable, (int)1);
            if (nodeArray2 != null) {
                list.add(new PasteType(){
                    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ContentMember;

                    public Transferable paste() throws IOException {
                        Node[] nodeArray = new Node[nodeArray2.length];
                        int n = 0;
                        while (n < nodeArray.length) {
                            if (nodeArray2[n] instanceof DataNode) {
                                this.getJarContent().addDataObject(((DataNode)nodeArray2[n]).getDataObject());
                            } else if (nodeArray2[n] instanceof JarContentChildren.ContentMemberNode) {
                                DataObject dataObject = ((JarContentChildren.ContentMemberNode)nodeArray2[n]).getDataObject();
                                ContentMember contentMember = (ContentMember)nodeArray2[n].getCookie(class$org$netbeans$modules$jarpackager$ContentMember == null ? 1.class$("org.netbeans.modules.jarpackager.ContentMember") : class$org$netbeans$modules$jarpackager$ContentMember);
                                this.getJarContent().addDataObject(dataObject);
                                ContentMemberList contentMemberList = this.getJarContent().getContentList();
                                int n2 = contentMemberList.findDataObject(dataObject);
                                if (n2 >= 0) {
                                    ContentMember contentMember2 = (ContentMember)contentMemberList.get(n2);
                                    contentMember2.copyPropertiesFrom(contentMember);
                                }
                            }
                            ++n;
                        }
                        this.setModified(true, JarDataObject.CONTENTS_PROP);
                        return null;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
            }
            if ((nodeArray = NodeTransfer.nodes((Transferable)transferable, (int)6)) != null) {
                list.add(new PasteType(this, nodeArray){
                    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ContentMember;
                    private final /* synthetic */ Node[] val$nds;
                    private final /* synthetic */ JarNode this$0;
                    {
                        this.this$0 = jarNode;
                        this.val$nds = nodeArray;
                    }

                    public Transferable paste() throws IOException {
                        int n = 0;
                        while (n < this.val$nds.length) {
                            if (this.val$nds[n] instanceof JarContentChildren.ContentMemberNode) {
                                DataObject dataObject = ((JarContentChildren.ContentMemberNode)this.val$nds[n]).getDataObject();
                                ContentMember contentMember = (ContentMember)this.val$nds[n].getCookie(class$org$netbeans$modules$jarpackager$ContentMember == null ? 2.class$("org.netbeans.modules.jarpackager.ContentMember") : class$org$netbeans$modules$jarpackager$ContentMember);
                                this.this$0.getJarContent().addDataObject(dataObject);
                                ContentMemberList contentMemberList = this.this$0.getJarContent().getContentList();
                                int n2 = contentMemberList.findDataObject(dataObject);
                                if (n2 >= 0) {
                                    ContentMember contentMember2 = (ContentMember)contentMemberList.get(n2);
                                    contentMember2.copyPropertiesFrom(contentMember);
                                }
                                this.val$nds[n].destroy();
                            }
                            ++n;
                        }
                        this.this$0.setModified(true, "contents");
                        return null;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
            }
            super.createPasteTypes(transferable, list);
        }

        protected int loadBadges() {
            badgeCache = new BadgeIconCache(JAR_ICON_BASE);
            badgeCache.registerBadge(BADGE_NEEDS_COMPILE, 1, 16, 0);
            badgeCache.registerBadge(BADGE_DATAOBJECT_INVALID, 2, 16, 8);
            return 8;
        }

        public void iconChange() {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            JarDataObject jarDataObject = (JarDataObject)this.getDataObject();
            int n2 = 0;
            if (jarDataObject != null) {
                if (jarDataObject.getNeedsCompile()) {
                    n2 |= 1;
                }
                if (!jarDataObject.allValid()) {
                    n2 |= 2;
                }
            }
            Image image2 = badgeCache.getIcon(image, n2);
            try {
                image2 = jarDataObject.getPrimaryFile().getFileSystem().getStatus().annotateIcon(image2, n, jarDataObject.files());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return image2;
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            PropertySupport.ReadWrite readWrite = (PropertySupport.ReadWrite)this.createLocationProperty();
            readWrite.setValue("files", Boolean.TRUE);
            readWrite.setValue("directories", Boolean.FALSE);
            sheet.get("properties").put((Node.Property)readWrite);
            sheet.get("properties").put(this.createCompressionProperty());
            sheet.get("properties").put(this.createFilterProperty());
            sheet.get("properties").put(this.createManifestProperty());
            sheet.get("properties").put(this.createContentsProperty());
            this.addExtendedProperties(sheet);
            Sheet.Set set = new Sheet.Set();
            set.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarNode.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject)).getString("CTL_ExecutionSet"));
            set.setDisplayName(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject$JarNode == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$JarNode = JarNode.class$("org.netbeans.modules.jarpackager.JarDataObject$JarNode")) : class$org$netbeans$modules$jarpackager$JarDataObject$JarNode)).getString("PROP_executionSetName"));
            set.setShortDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject$JarNode == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$JarNode = JarNode.class$("org.netbeans.modules.jarpackager.JarDataObject$JarNode")) : class$org$netbeans$modules$jarpackager$JarDataObject$JarNode)).getString("HINT_executionSetName"));
            ExecSupport execSupport = (ExecSupport)this.getCookie(class$org$openide$loaders$ExecSupport == null ? (class$org$openide$loaders$ExecSupport = JarNode.class$("org.openide.loaders.ExecSupport")) : class$org$openide$loaders$ExecSupport);
            if (execSupport != null) {
                execSupport.addProperties(set);
                set.remove("debuggerType");
            }
            sheet.put(set);
            return sheet;
        }

        public JarContent getJarContent() {
            return ((JarDataObject)this.getDataObject()).getJarContent();
        }

        public JarDataObject getJarDataObject() {
            return (JarDataObject)this.getDataObject();
        }

        public void setModified(boolean bl) {
            ((JarDataObject)this.getDataObject()).setModified(bl);
        }

        public void setModified(boolean bl, String string) {
            ((JarDataObject)this.getDataObject()).setModified(bl, string);
        }

        public FileObject getJarContentFile() {
            return this.getDataObject().getPrimaryFile();
        }

        public void addExtendedProperties(Sheet sheet) {
            Map map = JarCreator.getExtendedProperties();
            if (map == null) {
                return;
            }
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ExtendedPropertyFactory extendedPropertyFactory = (ExtendedPropertyFactory)iterator.next();
                Node.Property property = extendedPropertyFactory.createProperty(this.getDataObject(), this.getJarContent());
                if (property.isHidden()) continue;
                sheet.get("properties").put(property);
            }
        }

        public Node.Property createLocationProperty() {
            return new PropertySupport.ReadWrite(this, JarDataObject.LOCATION_PROP, class$java$io$File == null ? (class$java$io$File = JarNode.class$("java.io.File")) : class$java$io$File, bundle.getString("PROP_Location"), bundle.getString("CTL_LocationTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = jarNode;
                }

                public Object getValue() {
                    return this.this$0.getJarContent().getTargetFile();
                }

                public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(object instanceof File)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jarContent = this.this$0.getJarContent();
                        File file = jarContent.getTargetFile();
                        jarContent.setTargetFile((File)object);
                        if (!object.equals(file)) {
                            this.this$0.setModified(true, "location");
                        }
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException();
                    }
                }
            };
        }

        public Node.Property createCompressionProperty() {
            return new PropertySupport.ReadWrite(this, "compression", class$org$netbeans$modules$jarpackager$CompressionLevel == null ? (class$org$netbeans$modules$jarpackager$CompressionLevel = JarNode.class$("org.netbeans.modules.jarpackager.CompressionLevel")) : class$org$netbeans$modules$jarpackager$CompressionLevel, bundle.getString("PROP_Compression"), bundle.getString("CTL_CompressionLevelTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = jarNode;
                }

                public Object getValue() {
                    CompressionLevel compressionLevel = this.this$0.getJarContent().getCompLevel();
                    return compressionLevel;
                }

                public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(object instanceof CompressionLevel)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jarContent = this.this$0.getJarContent();
                        CompressionLevel compressionLevel = jarContent.getCompLevel();
                        jarContent.setCompLevel((CompressionLevel)object);
                        if (!object.equals(compressionLevel)) {
                            this.this$0.setModified(true);
                        }
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new CompressionEditor();
                }
            };
        }

        public Node.Property createFilterProperty() {
            PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite(this, JarDataObject.FILTER_PROP, class$org$netbeans$modules$jarpackager$FileObjectFilter == null ? (class$org$netbeans$modules$jarpackager$FileObjectFilter = JarNode.class$("org.netbeans.modules.jarpackager.FileObjectFilter")) : class$org$netbeans$modules$jarpackager$FileObjectFilter, bundle.getString("PROP_Filter"), bundle.getString("CTL_FilterTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = jarNode;
                }

                public Object getValue() {
                    return this.this$0.getJarContent().getFilter();
                }

                public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(object instanceof FileObjectFilter)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jarContent = this.this$0.getJarContent();
                        FileObjectFilter fileObjectFilter = jarContent.getFilter();
                        jarContent.setFilter((FileObjectFilter)object);
                        if (!object.equals(fileObjectFilter)) {
                            this.this$0.setModified(true);
                        }
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new FilterEditor();
                }
            };
            readWrite.setValue("canEditAsText", Boolean.FALSE);
            return readWrite;
        }

        public Node.Property createManifestProperty() {
            PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite(this, "manifest", class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = JarNode.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest, bundle.getString("PROP_Manifest"), bundle.getString("CTL_ManifestTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = jarNode;
                }

                public Object getValue() {
                    return this.this$0.getJarContent().getManifest();
                }

                public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(object instanceof Manifest)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jarContent = this.this$0.getJarContent();
                        Manifest manifest = jarContent.getManifest();
                        jarContent.setManifest((Manifest)object);
                        if (!object.equals(manifest)) {
                            this.this$0.setModified(true);
                        }
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    ManifestTab manifestTab = new ManifestTab();
                    manifestTab.setJarContentFile(this.this$0.getJarContentFile().getPackageNameExt('/', '.'));
                    return manifestTab;
                }
            };
            readWrite.setValue("canEditAsText", Boolean.FALSE);
            return readWrite;
        }

        public Node.Property createContentsProperty() {
            PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite(this, JarDataObject.CONTENTS_PROP, class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = JarNode.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent, bundle.getString("PROP_Contents"), bundle.getString("CTL_ContentsTip")){
                private final /* synthetic */ JarNode this$0;
                {
                    this.this$0 = jarNode;
                }

                public Object getValue() {
                    return this.this$0.getJarContent().makeCopy();
                }

                public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(object instanceof JarContent)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        ContentMemberList contentMemberList = this.this$0.getJarContent().getContentList();
                        ContentMemberList contentMemberList2 = ((JarContent)object).getContentList();
                        this.this$0.getJarContent().setContentList(contentMemberList2);
                        this.this$0.setModified(true, "contents");
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new DataObjectListEditor();
                }
            };
            readWrite.setValue("canEditAsText", Boolean.FALSE);
            return readWrite;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        class ReposListener
        extends RepositoryAdapter
        implements Runnable {
            public static final int DELAY = 5000;

            ReposListener() {
            }

            public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
                RequestProcessor.Task task = RequestProcessor.postRequest((Runnable)this, (int)5000);
            }

            public void run() {
                JarNode.this.iconChange();
            }
        }
    }

    private class Save
    implements SaveCookie {
        private Save() {
        }

        public void save() throws IOException {
            JarDataObject.this.save();
        }
    }
}

