/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.util;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.util.Utilities;

public class BadgeIconCache {
    private Map badges = new HashMap();
    private Map icons = new WeakHashMap();
    private String baseName;

    public BadgeIconCache(String string) {
        this.baseName = string;
    }

    public synchronized void registerBadge(String string, int n, int n2, int n3) {
        this.badges.put(new Integer(n), new BadgeID(string, n, n2, n3));
    }

    public Image getIcon(Image image, int n) {
        Object v = this.icons.get(new Integer(n));
        if (v != null) {
            return (Image)v;
        }
        Image image2 = Utilities.loadImage((String)(this.baseName + ".gif"));
        return this.createCompositeImage(image2, n);
    }

    private Image createCompositeImage(Image image, int n) {
        if (n == 0) {
            return image;
        }
        int n2 = 1;
        int n3 = n;
        while (n3 != 0) {
            if ((n3 & n2) != 0) {
                n3 &= ~n2;
                BadgeID badgeID = (BadgeID)this.badges.get(new Integer(n2));
                if (badgeID != null) {
                    image = BadgeIconCache.addBadge(image, badgeID.iconName, badgeID.x, badgeID.y);
                }
            }
            n2 <<= 1;
        }
        this.icons.put(new Integer(n), image);
        return image;
    }

    public static Image addBadge(Image image, String string, int n, int n2) {
        Image image2 = Utilities.loadImage((String)(string + ".gif"));
        if (image2 == null) {
            System.err.println("[Badging] Badge " + string + " cannot be loaded");
        } else {
            image = Utilities.mergeImages((Image)image, (Image)image2, (int)n, (int)n2);
        }
        return image;
    }

    static class BadgeID {
        String iconName;
        int x;
        int y;
        int key;

        BadgeID(String string, int n, int n2, int n3) {
            this.iconName = string;
            this.key = n;
            this.x = n2;
            this.y = n3;
        }
    }
}

