/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarDataLoader;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.jarpackager.wizard.ContentMemberPanel;
import org.netbeans.modules.jarpackager.wizard.ContentWizardPanel;
import org.netbeans.modules.jarpackager.wizard.ManifestWizardPanel;
import org.netbeans.modules.jarpackager.wizard.RecipeNamePanel;
import org.openide.WizardDescriptor;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class JarContentsWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -1987345873459L;
    private static final int PANEL_COUNT = 4;
    private transient WizardDescriptor.Panel[] panels;
    private transient String[] panelNames;
    private transient int panelIndex = 0;
    private static JarContentsWizardIterator instance = null;
    private transient TemplateWizard wizardInstance;
    private static ResourceBundle bundle;
    private static final String JAR_CONTENT_PROPERTY;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataLoader;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator;

    public static synchronized JarContentsWizardIterator singleton() {
        if (instance == null) {
            instance = new JarContentsWizardIterator();
        }
        return instance;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        Object object;
        JarDataLoader jarDataLoader;
        String string = null;
        if (templateWizard.getTargetName() == null) {
            jarDataLoader = (JarDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarContentsWizardIterator.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader));
            string = templateWizard.getTemplate().getPrimaryFile().getName() + "." + jarDataLoader.getArchiveExt();
        }
        jarDataLoader = this.instantiateTemplate(templateWizard.getTemplate(), templateWizard.getTargetFolder(), templateWizard.getTargetName());
        JarContent jarContent = JarContentsWizardIterator.getJarContent(templateWizard);
        if (string != null) {
            object = jarContent.getTargetFile().getParentFile();
            jarContent.setTargetFile(new File((File)object, string));
        }
        object = (JarDataObject)((Object)jarDataLoader);
        JarContent jarContent2 = ((JarDataObject)((Object)object)).getJarContent();
        int n = 0;
        while (n < 4) {
            if (this.panels[n] instanceof JarContentEditor) {
                ((JarContentEditor)this.panels[n]).applyChanges(jarContent2, jarContent);
            }
            ++n;
        }
        ((JarDataObject)((Object)object)).save();
        return Collections.singleton(jarDataLoader);
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wizardInstance = templateWizard;
        JarDataObject jarDataObject = (JarDataObject)templateWizard.getTemplate();
        JarContent jarContent = jarDataObject.getJarContent();
        JarContent jarContent2 = new JarContent();
        jarContent2.copyContentList(jarContent);
        jarContent2.copyManifest(jarContent);
        JarContentsWizardIterator.setJarContent(templateWizard, jarContent2);
        if (this.panels == null) {
            this.initialize();
            this.panels = new WizardDescriptor.Panel[4];
            this.panels[0] = new RecipeNamePanel(0);
            ((JComponent)this.panels[0].getComponent()).putClientProperty("WizardPanel_contentData", this.panelNames);
            this.panels[1] = new ContentWizardPanel(1);
            this.panels[2] = new ContentMemberPanel(2);
            this.panels[3] = new ManifestWizardPanel(3);
        }
        Component component = templateWizard.targetChooser().getComponent();
        this.panelIndex = 0;
    }

    protected void initialize() {
        if (this.panelNames == null) {
            this.panelNames = new String[4];
            this.panelNames[0] = JarContentsWizardIterator.getString("TIT_ChooseTarget");
            this.panelNames[1] = JarContentsWizardIterator.getString("TIT_Contents");
            this.panelNames[2] = JarContentsWizardIterator.getString("TIT_ContentMembers");
            this.panelNames[3] = JarContentsWizardIterator.getString("TIT_Manifest");
        }
    }

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator == null ? (class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator = JarContentsWizardIterator.class$("org.netbeans.modules.jarpackager.wizard.JarContentsWizardIterator")) : class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator));
        }
        return bundle.getString(string);
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
        this.panelNames = null;
        JarContentsWizardIterator.setJarContent(templateWizard, null);
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.panelIndex];
    }

    public String name() {
        return this.panelNames[this.panelIndex];
    }

    public boolean hasNext() {
        return this.panelIndex < 3;
    }

    public boolean hasPrevious() {
        return this.panelIndex > 0;
    }

    public void nextPanel() {
        ++this.panelIndex;
    }

    public void previousPanel() {
        --this.panelIndex;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private DataObject instantiateTemplate(DataObject dataObject, DataFolder dataFolder, String string) throws IOException {
        return dataObject.createFromTemplate(dataFolder, string);
    }

    public static void setJarContent(TemplateWizard templateWizard, JarContent jarContent) {
        templateWizard.putProperty(JAR_CONTENT_PROPERTY, (Object)jarContent);
    }

    public static JarContent getJarContent(TemplateWizard templateWizard) {
        return (JarContent)templateWizard.getProperty(JAR_CONTENT_PROPERTY);
    }

    public static String getExt() {
        JarDataLoader jarDataLoader = (JarDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarContentsWizardIterator.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader));
        return jarDataLoader.getArchiveExt();
    }

    public static File getJarFile(TemplateWizard templateWizard) {
        JarDataLoader jarDataLoader = (JarDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarContentsWizardIterator.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader));
        String string = jarDataLoader.getArchiveExt();
        try {
            String string2;
            File file = NbClassPath.toFile((FileObject)templateWizard.getTargetFolder().getPrimaryFile());
            String string3 = string2 = file == null ? "" : file.getPath() + File.separator;
            if (templateWizard.getTargetName() == null) {
                return new File(string2 + JarContentsWizardIterator.getString("FMT_DefaultName") + "." + string);
            }
            return new File(string2 + templateWizard.getTargetName() + "." + string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getJarContentFile(TemplateWizard templateWizard) {
        JarDataLoader jarDataLoader = (JarDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarContentsWizardIterator.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader));
        String string = jarDataLoader.getExtension();
        try {
            String string2 = templateWizard.getTargetFolder().getPrimaryFile().getPackageName('/');
            if (string2.length() > 0) {
                string2 = string2 + "/";
            }
            if (templateWizard.getTargetName() == null) {
                return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator == null ? (class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator = JarContentsWizardIterator.class$("org.netbeans.modules.jarpackager.wizard.JarContentsWizardIterator")) : class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator)).getString("ManifestWizardPanel.unknownContentName") + "." + string;
            }
            return string2 + templateWizard.getTargetName() + "." + string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        JAR_CONTENT_PROPERTY = new String("jarContent");
    }

    static interface JarContentEditor {
        public void applyChanges(JarContent var1, JarContent var2);
    }
}

