/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.DiffAction;
import org.netbeans.modules.diff.builtin.Patch;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.io.ReaderInputStream;

public class PatchAction
extends NodeAction {
    static /* synthetic */ Class class$org$netbeans$modules$diff$PatchAction;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public String getName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"CTL_PatchActionName");
    }

    public boolean enable(Node[] nodeArray) {
        DataObject dataObject;
        if (nodeArray.length == 1 && (dataObject = (DataObject)nodeArray[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = PatchAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) != null) {
            if (dataObject instanceof InstanceDataObject) {
                return false;
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                if (fileSystem.isDefault()) {
                    String string = fileObject.getPackageName('/');
                    return string.startsWith("Templates") || string.startsWith("vcs/config") || string.startsWith("org/");
                }
                return true;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return false;
            }
        }
        return false;
    }

    public void performAction(Node[] nodeArray) {
        DataObject dataObject = (DataObject)nodeArray[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = PatchAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        if (dataObject != null) {
            Patch.FileDifferences[] fileDifferencesArray;
            FileObject fileObject = dataObject.getPrimaryFile();
            File file = this.getPatchFor(fileObject);
            if (file == null) {
                return;
            }
            try {
                fileDifferencesArray = Patch.parse(new FileReader(file));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"EXC_PatchParsingFailed", (Object)iOException.getLocalizedMessage())));
                return;
            }
            int n = 0;
            int n2 = 0;
            while (n2 < fileDifferencesArray.length) {
                n += fileDifferencesArray[n2].getDifferences().length;
                ++n2;
            }
            if (n == 0) {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"MSG_NoDifferences", (Object)file.getName())));
                return;
            }
            this.applyFileDiffs(fileDifferencesArray, fileObject);
        }
    }

    private File getPatchFor(FileObject fileObject) {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.home"));
        jFileChooser.setFileSelectionMode(0);
        String string = NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)(fileObject.isData() ? "TITLE_SelectPatchForFile" : "TITLE_SelectPatchForFolder"), (Object)fileObject.getNameExt());
        jFileChooser.setDialogTitle(string);
        jFileChooser.setApproveButtonText(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"BTN_Patch"));
        jFileChooser.setApproveButtonMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"BTN_Patch_mnc").charAt(0));
        jFileChooser.setApproveButtonToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"BTN_Patch_tooltip"));
        int n = jFileChooser.showDialog(new JFrame(string), null);
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private void applyFileDiffs(Patch.FileDifferences[] fileDifferencesArray, FileObject fileObject) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        HashMap<Object, FileObject> hashMap = new HashMap<Object, FileObject>();
        int n = 0;
        while (n < fileDifferencesArray.length) {
            object = fileObject.isData() ? fileObject : PatchAction.findChild(fileObject, fileDifferencesArray[n].getFileName());
            if (object == null) {
                arrayList.add(fileObject.getPackageNameExt(File.separatorChar, '.') + File.separator + fileDifferencesArray[n].getFileName());
            } else {
                FileObject fileObject2 = this.createFileBackup((FileObject)object);
                if (this.applyDiffsTo(fileDifferencesArray[n].getDifferences(), (FileObject)object)) {
                    arrayList2.add(object);
                    hashMap.put(object, fileObject2);
                }
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            object = "";
            int n2 = 0;
            while (n2 < arrayList.size()) {
                object = (String)object + arrayList.get(n2).toString();
                if (n2 < arrayList.size() - 1) {
                    object = (String)object + ", ";
                }
                ++n2;
            }
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"MSG_NotFoundFiles", (Object)object)));
        }
        if (arrayList2.size() > 0 && NotifyDescriptor.YES_OPTION.equals(object = TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"MSG_PatchAppliedSuccessfully"), 0)))) {
            this.showDiffs(arrayList2, hashMap);
        }
    }

    private static FileObject findChild(FileObject fileObject, String string) {
        string = string.replace(File.separatorChar, '/');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        FileObject fileObject2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            fileObject2 = fileObject.getFileObject(string2);
            if (fileObject2 == null || !fileObject2.isFolder()) continue;
            fileObject = fileObject2;
            fileObject2 = null;
        }
        return fileObject2;
    }

    private FileObject createFileBackup(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        try {
            FileObject fileObject3 = fileObject2.getFileObject(fileObject.getNameExt(), "orig");
            if (fileObject3 == null) {
                fileObject3 = fileObject2.createData(fileObject.getNameExt(), "orig");
            }
            FileUtil.copy((InputStream)fileObject.getInputStream(), (OutputStream)fileObject3.getOutputStream(fileObject3.lock()));
            return fileObject3;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean applyDiffsTo(Difference[] differenceArray, FileObject fileObject) {
        File file;
        try {
            file = File.createTempFile("patch", "tmp");
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
        file.deleteOnExit();
        try {
            Reader reader = Patch.apply(differenceArray, new InputStreamReader(fileObject.getInputStream()));
            FileUtil.copy((InputStream)new ReaderInputStream(reader), (OutputStream)new FileOutputStream(file));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"EXC_PatchApplicationFailed", (Object)iOException.getLocalizedMessage(), (Object)fileObject.getNameExt())));
            file.delete();
            return false;
        }
        try {
            FileUtil.copy((InputStream)new FileInputStream(file), (OutputStream)fileObject.getOutputStream(fileObject.lock()));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"EXC_CopyOfAppliedPatchFailed", (Object)fileObject.getNameExt())));
            return false;
        }
        file.delete();
        return true;
    }

    private void showDiffs(ArrayList arrayList, HashMap hashMap) {
        int n = 0;
        while (n < arrayList.size()) {
            FileObject fileObject = (FileObject)arrayList.get(n);
            FileObject fileObject2 = (FileObject)hashMap.get(fileObject);
            DiffAction.performAction(fileObject2, fileObject);
            ++n;
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

