/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.provider.io.LineIndexedAccess;

public class LineDiff {
    public static final boolean DEFAULT_HEURISTIC = true;
    public static final long DEFAULT_MINMATCH = 1L;

    private LineDiff() {
    }

    public static Difference[] diff(LineIndexedAccess lineIndexedAccess, LineIndexedAccess lineIndexedAccess2) throws IOException {
        return LineDiff.diff(lineIndexedAccess, lineIndexedAccess2, true, 1L);
    }

    public static Difference[] diff(LineIndexedAccess lineIndexedAccess, LineIndexedAccess lineIndexedAccess2, boolean bl, long l) throws IOException {
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        long l2 = lineIndexedAccess.length();
        long l3 = lineIndexedAccess2.length();
        if (l2 == 0L && l3 == 0L) {
            return new Difference[0];
        }
        if (l2 == 0L) {
            arrayList.add(LineDiff.createAdd(lineIndexedAccess2, 0L, 0L, l3));
            return arrayList.toArray(new Difference[arrayList.size()]);
        }
        if (l3 == 0L) {
            arrayList.add(LineDiff.createDel(lineIndexedAccess, 0L, l2, 0L));
            return arrayList.toArray(new Difference[arrayList.size()]);
        }
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        while (l2 != l4 && l3 != l5) {
            long l8;
            long l9 = Math.max(l2 - l4, l3 - l5) - l;
            boolean bl2 = false;
            long l10 = 0L;
            block1: while (l10 <= l9) {
                long l11 = 0L;
                while (l11 <= l10) {
                    if (LineDiff.testMinmatch(lineIndexedAccess, l4 + l10, l2, lineIndexedAccess2, l5 + l11, l3, l)) {
                        if (bl) {
                            while (l10 > 0L && l11 > 0L && lineIndexedAccess.readAt(l4 + l10 - 1L).equals(lineIndexedAccess2.readAt(l5 + l11 - 1L))) {
                                --l10;
                                --l11;
                            }
                        }
                        if (l10 > 0L) {
                            arrayList.add(LineDiff.createDel(lineIndexedAccess, l4, l4 + l10, l5));
                        }
                        arrayList.add(LineDiff.createAdd(lineIndexedAccess2, l4, l5, l5 + l11));
                        l4 += l10;
                        l5 += l11;
                        bl2 = true;
                        break block1;
                    }
                    if (LineDiff.testMinmatch(lineIndexedAccess, l4 + l11, l2, lineIndexedAccess2, l5 + l10, l3, l)) {
                        if (bl) {
                            while (l10 > 0L && l11 > 0L && lineIndexedAccess.readAt(l4 + l11 - 1L).equals(lineIndexedAccess2.readAt(l5 + l10 - 1L))) {
                                --l10;
                                --l11;
                            }
                        }
                        if (l11 > 0L) {
                            arrayList.add(LineDiff.createDel(lineIndexedAccess, l4, l4 + l11, l5));
                        }
                        arrayList.add(LineDiff.createAdd(lineIndexedAccess2, l4, l5, l5 + l10));
                        l4 += l11;
                        l5 += l10;
                        bl2 = true;
                        break block1;
                    }
                    ++l11;
                }
                if (bl) {
                    l10 += l10 / 10L;
                }
                ++l10;
            }
            if (!bl2) {
                if (l2 - l4 > 0L) {
                    arrayList.add(LineDiff.createDel(lineIndexedAccess, l4, l2, l5));
                }
                arrayList.add(LineDiff.createAdd(lineIndexedAccess2, l4, l5, l3));
                l4 = l2;
                l5 = l3;
            }
            if (l4 == l2 || l5 == l3 || (l8 = LineDiff.getRun(lineIndexedAccess, l4, l2, lineIndexedAccess2, l5, l3)) <= 0L) continue;
            l4 += l8;
            l5 += l8;
        }
        if (l4 != l2) {
            arrayList.add(LineDiff.createDel(lineIndexedAccess, l4, l2, l5));
        }
        if (l5 != l3) {
            arrayList.add(LineDiff.createAdd(lineIndexedAccess2, l4, l5, l3));
        }
        LineDiff.cleanup(arrayList);
        return arrayList.toArray(new Difference[arrayList.size()]);
    }

    private static long getRun(LineIndexedAccess lineIndexedAccess, long l, long l2, LineIndexedAccess lineIndexedAccess2, long l3, long l4) throws IOException {
        long l5 = l;
        long l6 = l3;
        long l7 = 0L;
        while (l5 < l2 && l6 < l4 && lineIndexedAccess.readAt(l5).equals(lineIndexedAccess2.readAt(l6))) {
            ++l7;
            ++l5;
            ++l6;
        }
        return l7;
    }

    private static boolean testMinmatch(LineIndexedAccess lineIndexedAccess, long l, long l2, LineIndexedAccess lineIndexedAccess2, long l3, long l4, long l5) throws IOException {
        long l6 = l;
        long l7 = l3;
        if (l2 - l6 < l5) {
            return false;
        }
        if (l4 - l7 < l5) {
            return false;
        }
        int n = 0;
        while ((long)n < l5) {
            if (!lineIndexedAccess.readAt(l6).equals(lineIndexedAccess2.readAt(l7))) {
                return false;
            }
            ++n;
            ++l6;
            ++l7;
        }
        return true;
    }

    private static Difference createAdd(LineIndexedAccess lineIndexedAccess, long l, long l2, long l3) {
        if (l2 >= l3) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String[] stringArray = (String[])lineIndexedAccess.readFullyAt(l2, l3 - l2);
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append("\n");
                ++n;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Difference(1, (int)l, 0, (int)l2 + 1, (int)l3, "", stringBuffer.toString());
    }

    private static Difference createDel(LineIndexedAccess lineIndexedAccess, long l, long l2, long l3) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String[] stringArray = (String[])lineIndexedAccess.readFullyAt(l, l2 - l);
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append("\n");
                ++n;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Difference(0, (int)l + 1, (int)l2, (int)l3, 0, stringBuffer.toString(), "");
    }

    private static void cleanup(List list) {
        Difference difference = null;
        int n = 0;
        while (n < list.size()) {
            Difference difference2 = (Difference)list.get(n);
            if (difference2 == null) {
                list.remove(n);
                --n;
            } else {
                if (difference != null && (difference2.getType() == 1 && difference.getType() == 0 || difference2.getType() == 0 && difference.getType() == 1)) {
                    int n2;
                    int n3;
                    Difference difference3;
                    Difference difference4;
                    if (1 == difference2.getType()) {
                        difference4 = difference2;
                        difference3 = difference;
                    } else {
                        difference4 = difference;
                        difference3 = difference2;
                    }
                    int n4 = difference4.getFirstStart() + 1;
                    int n5 = difference3.getFirstStart();
                    if (n4 == n5 && (n3 = difference4.getSecondStart()) == (n2 = difference3.getSecondStart() + 1)) {
                        Difference difference5 = new Difference(2, n4, difference3.getFirstEnd(), n3, difference4.getSecondEnd(), difference3.getFirstText(), difference4.getSecondText());
                        list.set(n - 1, difference5);
                        list.remove(n);
                        --n;
                        difference2 = difference5;
                    }
                }
                difference = difference2;
            }
            ++n;
        }
    }
}

