/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Reader;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.visualizer.DiffComponent;
import org.netbeans.modules.diff.builtin.visualizer.DiffPanel;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class DiffComponent
extends TopComponent {
    public static final Color COLOR_MISSING = new Color(255, 160, 180);
    public static final Color COLOR_ADDED = new Color(180, 255, 180);
    public static final Color COLOR_CHANGED = new Color(160, 200, 255);
    private Difference[] diffs = null;
    private int[][] diffShifts;
    private DiffPanel diffPanel = null;
    private Color colorMissing = COLOR_MISSING;
    private Color colorAdded = COLOR_ADDED;
    private Color colorChanged = COLOR_CHANGED;
    private int currentDiffLine = -1;
    private boolean diffSetSuccess = true;
    static final long serialVersionUID = 3683458237532937983L;
    private Boolean lineNumbersVisible = Boolean.FALSE;
    static /* synthetic */ Class class$org$netbeans$modules$diff$builtin$visualizer$DiffComponent;
    static /* synthetic */ Class class$org$openide$text$CloneableEditorSupport;

    public DiffComponent() {
        ((JComponent)((Object)this)).putClientProperty("PersistenceType", "Never");
    }

    public DiffComponent(Difference[] differenceArray, String string, String string2, String string3, String string4, String string5, String string6, Reader reader, Reader reader2) {
        this(differenceArray, string, string2, string3, string4, string5, string6, reader, reader2, null);
    }

    public DiffComponent(final Difference[] differenceArray, String string, String string2, String string3, String string4, String string5, String string6, Reader reader, Reader reader2, Color[] colorArray) {
        this.diffs = differenceArray;
        this.diffShifts = new int[differenceArray.length][2];
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.diffPanel = new DiffPanel();
        this.diffPanel.addPrevLineButtonListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (differenceArray.length == 0) {
                    return;
                }
                DiffComponent.this.currentDiffLine--;
                if (DiffComponent.this.currentDiffLine < 0) {
                    DiffComponent.this.currentDiffLine = differenceArray.length - 1;
                }
                DiffComponent.this.showCurrentLine();
            }
        });
        this.diffPanel.addNextLineButtonListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (differenceArray.length == 0) {
                    return;
                }
                DiffComponent.this.currentDiffLine++;
                if (DiffComponent.this.currentDiffLine >= differenceArray.length) {
                    DiffComponent.this.currentDiffLine = 0;
                }
                DiffComponent.this.showCurrentLine();
            }
        });
        ((Container)((Object)this)).add(this.diffPanel, "Center");
        if (colorArray != null && colorArray.length >= 3) {
            this.colorMissing = colorArray[0];
            this.colorAdded = colorArray[1];
            this.colorChanged = colorArray[2];
        }
        if (string == null) {
            this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffComponent == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffComponent = DiffComponent.class$("org.netbeans.modules.diff.builtin.visualizer.DiffComponent")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffComponent)).getString("DiffComponent.title"));
        } else {
            this.setName(string);
        }
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/diff/diffSettingsIcon.gif"));
        this.initContent(string2, string3, string4, string5, string6, reader, reader2);
        ((JComponent)((Object)this)).putClientProperty("PersistenceType", "Never");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$diff$builtin$visualizer$DiffComponent == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffComponent = DiffComponent.class$("org.netbeans.modules.diff.builtin.visualizer.DiffComponent")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffComponent);
    }

    private void showCurrentLine() {
        Difference difference = this.diffs[this.currentDiffLine];
        int n = difference.getFirstStart() + this.diffShifts[this.currentDiffLine][0];
        if (difference.getType() == 1) {
            ++n;
        }
        int n2 = difference.getFirstEnd() - difference.getFirstStart() + 1;
        int n3 = difference.getSecondEnd() - difference.getSecondStart() + 1;
        int n4 = Math.max(n2, n3);
        this.diffPanel.setCurrentLine(n, n4);
    }

    private void initContent(String string, String string2, String string3, String string4, String string5, Reader reader, Reader reader2) {
        this.setMimeType1(string);
        this.setMimeType2(string);
        try {
            this.setSource1(reader);
            this.setSource2(reader2);
        }
        catch (IOException iOException) {
            TopManager.getDefault().notifyException((Throwable)iOException);
        }
        this.setSource1Title(string4);
        this.setSource2Title(string5);
        this.insertEmptyLines(true);
        this.setDiffHighlight(true);
    }

    private void addWindowListener(WindowListener windowListener) {
        Container container = ((JComponent)((Object)this)).getTopLevelAncestor();
        if (container instanceof Window) {
            ((Window)container).addWindowListener(windowListener);
        }
    }

    protected Mode getDockingMode(Workspace workspace) {
        Mode mode = workspace.findMode("editor");
        if (mode == null) {
            mode = workspace.createMode("editor", ((Component)((Object)this)).getName(), (class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = DiffComponent.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport).getResource("/org/openide/resources/editorMode.gif"));
        }
        return mode;
    }

    public void open(Workspace workspace) {
        if (workspace == null) {
            workspace = TopManager.getDefault().getWindowManager().getCurrentWorkspace();
        }
        Mode mode = this.getDockingMode(workspace);
        mode.dockInto((TopComponent)this);
        super.open(workspace);
        this.diffPanel.open();
        this.requestFocus();
        if (this.currentDiffLine < 0) {
            this.currentDiffLine = 0;
            this.showCurrentLine();
        }
    }

    public void requestFocus() {
        super.requestFocus();
        this.diffPanel.requestFocus();
    }

    public void addNotify() {
        super.addNotify();
        if (this.currentDiffLine < 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DiffComponent.this.diffPanel.open();
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            Toolkit.getDefaultToolkit().sync();
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ 4 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public void run() {
                                    if (DiffComponent.access$000(3.access$400(4.access$300(this.this$2))) < 0) {
                                        DiffComponent.access$002(3.access$400(4.access$300(this.this$2)), 0);
                                        DiffComponent.access$100(3.access$400(4.access$300(this.this$2)));
                                    }
                                }
                            });
                        }

                        static /* synthetic */ 3 access$300(4 var0) {
                            return var0.this$1;
                        }
                    });
                }

                static /* synthetic */ DiffComponent access$400(3 var0) {
                    return var0.DiffComponent.this;
                }
            });
        }
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        boolean bl2 = super.canClose(workspace, bl);
        if (bl && bl2) {
            this.exitForm(null);
        }
        return bl2;
    }

    public void setSource1(Reader reader) throws IOException {
        this.diffPanel.setSource1(reader);
    }

    public void setSource2(Reader reader) throws IOException {
        this.diffPanel.setSource2(reader);
    }

    public void setSource1Title(String string) {
        this.diffPanel.setSource1Title(string);
    }

    public void setSource2Title(String string) {
        this.diffPanel.setSource2Title(string);
    }

    public void setMimeType1(String string) {
        this.diffPanel.setMimeType1(string);
    }

    public void setMimeType2(String string) {
        this.diffPanel.setMimeType2(string);
    }

    public void setDocument1(Document document) {
        this.diffPanel.setDocument1(document);
    }

    public void setDocument2(Document document) {
        this.diffPanel.setDocument2(document);
    }

    private void setHighlight(StyledDocument styledDocument, int n, int n2, Color color) {
    }

    private void unhighlight(StyledDocument styledDocument) {
    }

    public void unhighlightAll() {
        this.diffPanel.unhighlightAll();
    }

    public void highlightRegion1(int n, int n2, Color color) {
        this.diffPanel.highlightRegion1(n, n2, color);
    }

    public void highlightRegion2(int n, int n2, Color color) {
        this.diffPanel.highlightRegion2(n, n2, color);
    }

    public void addEmptyLines1(int n, int n2) {
        this.diffPanel.addEmptyLines1(n, n2);
    }

    public void addEmptyLines2(int n, int n2) {
        this.diffPanel.addEmptyLines2(n, n2);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.diffs);
    }

    private void insertEmptyLines(boolean bl) {
        int n = this.diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Difference difference = this.diffs[n2];
            int n3 = difference.getFirstStart() + this.diffShifts[n2][0];
            int n4 = difference.getFirstEnd() + this.diffShifts[n2][0];
            int n5 = difference.getSecondStart() + this.diffShifts[n2][1];
            int n6 = difference.getSecondEnd() + this.diffShifts[n2][1];
            if (bl && n2 < n - 1) {
                this.diffShifts[n2 + 1][0] = this.diffShifts[n2][0];
                this.diffShifts[n2 + 1][1] = this.diffShifts[n2][1];
            }
            switch (difference.getType()) {
                case 0: {
                    this.addEmptyLines2(n5, n4 - n3 + 1);
                    if (!bl || n2 >= n - 1) break;
                    int[] nArray = this.diffShifts[n2 + 1];
                    nArray[1] = nArray[1] + (n4 - n3 + 1);
                    break;
                }
                case 1: {
                    this.addEmptyLines1(n3, n6 - n5 + 1);
                    if (!bl || n2 >= n - 1) break;
                    int[] nArray = this.diffShifts[n2 + 1];
                    nArray[0] = nArray[0] + (n6 - n5 + 1);
                    break;
                }
                case 2: {
                    int n7 = n4 - n3;
                    int n8 = n6 - n5;
                    if (n7 < n8) {
                        this.addEmptyLines1(n4, n8 - n7);
                        if (!bl || n2 >= n - 1) break;
                        int[] nArray = this.diffShifts[n2 + 1];
                        nArray[0] = nArray[0] + (n8 - n7);
                        break;
                    }
                    if (n7 <= n8) break;
                    this.addEmptyLines2(n6, n7 - n8);
                    if (!bl || n2 >= n - 1) break;
                    int[] nArray = this.diffShifts[n2 + 1];
                    nArray[1] = nArray[1] + (n7 - n8);
                }
            }
            ++n2;
        }
    }

    private void setDiffHighlight(boolean bl) {
        int n = this.diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Difference difference = this.diffs[n2];
            int n3 = difference.getFirstStart() + this.diffShifts[n2][0];
            int n4 = difference.getFirstEnd() + this.diffShifts[n2][0];
            int n5 = difference.getSecondStart() + this.diffShifts[n2][1];
            int n6 = difference.getSecondEnd() + this.diffShifts[n2][1];
            switch (difference.getType()) {
                case 0: {
                    if (bl) {
                        this.highlightRegion1(n3, n4, this.colorMissing);
                        break;
                    }
                    this.highlightRegion1(n3, n4, Color.white);
                    break;
                }
                case 1: {
                    if (bl) {
                        this.highlightRegion2(n5, n6, this.colorAdded);
                        break;
                    }
                    this.highlightRegion2(n5, n6, Color.white);
                    break;
                }
                case 2: {
                    if (bl) {
                        this.highlightRegion1(n3, n4, this.colorChanged);
                        this.highlightRegion2(n5, n6, this.colorChanged);
                        break;
                    }
                    this.highlightRegion1(n3, n4, Color.white);
                    this.highlightRegion2(n5, n6, Color.white);
                }
            }
            ++n2;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        this.diffs = (Difference[])object;
        this.diffPanel = new DiffPanel();
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.diffSetSuccess) {
            return this;
        }
        return null;
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.exitForm(null);
        return null;
    }

    private void exitForm(WindowEvent windowEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffComponent.this.diffPanel = null;
                DiffComponent.access$502(DiffComponent.this, null);
                ((Container)((Object)DiffComponent.this)).removeAll();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Difference[] access$502(DiffComponent diffComponent, Difference[] differenceArray) {
        diffComponent.diffs = differenceArray;
        return differenceArray;
    }
}

