/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.merge.builtin.visualizer;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.merge.builtin.visualizer.MergePanel;
import org.openide.TopManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MergeControl
implements ActionListener,
VetoableChangeListener {
    private Color colorUnresolvedConflict;
    private Color colorResolvedConflict;
    private Color colorOtherConflict;
    private MergePanel panel;
    private Difference[] diffs;
    private int[][] diffShifts;
    private int currentDiffLine = 0;
    private int[] resultDiffLocations;
    private Set resolvedConflicts = new HashSet();
    private StreamSource resultSource;
    static /* synthetic */ Class class$org$netbeans$modules$merge$builtin$visualizer$MergeControl;

    public MergeControl(MergePanel mergePanel) {
        this.panel = mergePanel;
    }

    public void initialize(Difference[] differenceArray, StreamSource streamSource, StreamSource streamSource2, StreamSource streamSource3, Color color, Color color2, Color color3) {
        this.diffs = differenceArray;
        this.diffShifts = new int[differenceArray.length][2];
        this.resultDiffLocations = new int[differenceArray.length];
        this.panel.setMimeType1(streamSource.getMIMEType());
        this.panel.setMimeType2(streamSource2.getMIMEType());
        this.panel.setMimeType3(streamSource3.getMIMEType());
        this.panel.setSource1Title(streamSource.getTitle());
        this.panel.setSource2Title(streamSource2.getTitle());
        this.panel.setResultSourceTitle(streamSource3.getTitle());
        this.panel.setName(streamSource.getName());
        try {
            this.panel.setSource1(streamSource.createReader());
            this.panel.setSource2(streamSource2.createReader());
            this.panel.setResultSource(new StringReader(""));
        }
        catch (IOException iOException) {
            TopManager.getDefault().notifyException((Throwable)iOException);
        }
        this.colorUnresolvedConflict = color;
        this.colorResolvedConflict = color2;
        this.colorOtherConflict = color3;
        this.insertEmptyLines(true);
        this.setDiffHighlight(true);
        this.copyToResult();
        this.panel.setNumConflicts(differenceArray.length);
        this.panel.addControlActionListener(this);
        this.showCurrentLine();
        this.resultSource = streamSource3;
    }

    private void insertEmptyLines(boolean bl) {
        int n = this.diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Difference difference = this.diffs[n2];
            int n3 = difference.getFirstStart() + this.diffShifts[n2][0];
            int n4 = difference.getFirstEnd() + this.diffShifts[n2][0];
            int n5 = difference.getSecondStart() + this.diffShifts[n2][1];
            int n6 = difference.getSecondEnd() + this.diffShifts[n2][1];
            if (bl && n2 < n - 1) {
                this.diffShifts[n2 + 1][0] = this.diffShifts[n2][0];
                this.diffShifts[n2 + 1][1] = this.diffShifts[n2][1];
            }
            switch (difference.getType()) {
                case 0: {
                    this.panel.addEmptyLines2(n5, n4 - n3 + 1);
                    if (!bl || n2 >= n - 1) break;
                    int[] nArray = this.diffShifts[n2 + 1];
                    nArray[1] = nArray[1] + (n4 - n3 + 1);
                    break;
                }
                case 1: {
                    this.panel.addEmptyLines1(n3, n6 - n5 + 1);
                    if (!bl || n2 >= n - 1) break;
                    int[] nArray = this.diffShifts[n2 + 1];
                    nArray[0] = nArray[0] + (n6 - n5 + 1);
                    break;
                }
                case 2: {
                    int n7 = n4 - n3;
                    int n8 = n6 - n5;
                    if (n7 < n8) {
                        this.panel.addEmptyLines1(n4, n8 - n7);
                        if (!bl || n2 >= n - 1) break;
                        int[] nArray = this.diffShifts[n2 + 1];
                        nArray[0] = nArray[0] + (n8 - n7);
                        break;
                    }
                    if (n7 <= n8) break;
                    this.panel.addEmptyLines2(n6, n7 - n8);
                    if (!bl || n2 >= n - 1) break;
                    int[] nArray = this.diffShifts[n2 + 1];
                    nArray[1] = nArray[1] + (n7 - n8);
                }
            }
            ++n2;
        }
    }

    private void setDiffHighlight(boolean bl) {
        int n = this.diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Difference difference = this.diffs[n2];
            int n3 = difference.getFirstStart() + this.diffShifts[n2][0];
            int n4 = difference.getFirstEnd() + this.diffShifts[n2][0];
            int n5 = difference.getSecondStart() + this.diffShifts[n2][1];
            int n6 = difference.getSecondEnd() + this.diffShifts[n2][1];
            switch (difference.getType()) {
                case 0: {
                    if (bl) {
                        this.panel.highlightRegion1(n3, n4, this.colorUnresolvedConflict);
                        break;
                    }
                    this.panel.highlightRegion1(n3, n4, Color.white);
                    break;
                }
                case 1: {
                    if (bl) {
                        this.panel.highlightRegion2(n5, n6, this.colorUnresolvedConflict);
                        break;
                    }
                    this.panel.highlightRegion2(n5, n6, Color.white);
                    break;
                }
                case 2: {
                    if (bl) {
                        this.panel.highlightRegion1(n3, n4, this.colorUnresolvedConflict);
                        this.panel.highlightRegion2(n5, n6, this.colorUnresolvedConflict);
                        break;
                    }
                    this.panel.highlightRegion1(n3, n4, Color.white);
                    this.panel.highlightRegion2(n5, n6, Color.white);
                }
            }
            ++n2;
        }
    }

    private void copyToResult() {
        int n = this.diffs.length;
        int n2 = 1;
        int n3 = 1;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            Difference difference = this.diffs[n4];
            int n6 = difference.getFirstStart() + this.diffShifts[n4][0];
            int n7 = difference.getFirstEnd() + this.diffShifts[n4][0];
            int n8 = difference.getSecondStart() + this.diffShifts[n4][1];
            int n9 = difference.getSecondEnd() + this.diffShifts[n4][1];
            int n10 = n5 = difference.getType() != 1 ? n6 - 1 : n6;
            if (n5 >= n2) {
                this.panel.copySource1ToResult(n2, n5, n3);
                n3 += n5 + 1 - n2;
            }
            int n11 = Math.max(n7 - n6, n9 - n8);
            this.panel.addEmptyLines3(n3, n11 + 1);
            this.panel.highlightRegion3(n3, n3 + n11, this.colorUnresolvedConflict);
            this.resultDiffLocations[n4] = n3;
            n3 += n11 + 1;
            n2 = Math.max(n7, n9) + 1;
            ++n4;
        }
        this.panel.copySource1ToResult(n2, -1, n3);
    }

    private void showCurrentLine() {
        Difference difference = this.diffs[this.currentDiffLine];
        int n = difference.getFirstStart() + this.diffShifts[this.currentDiffLine][0];
        if (difference.getType() == 1) {
            ++n;
        }
        int n2 = difference.getFirstEnd() - difference.getFirstStart() + 1;
        int n3 = difference.getSecondEnd() - difference.getSecondStart() + 1;
        int n4 = Math.max(n2, n3);
        this.panel.setCurrentLine(n, n4, this.currentDiffLine, this.resultDiffLocations[this.currentDiffLine]);
    }

    private void doResolveConflict(boolean bl, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Difference difference = this.diffs[n];
        int[] nArray = this.diffShifts[n];
        if (difference.getType() == 1) {
            n6 = difference.getFirstStart() + nArray[0] + 1;
            n5 = n6 - 1;
        } else {
            n6 = difference.getFirstStart() + nArray[0];
            n5 = difference.getFirstEnd() + nArray[0];
        }
        if (difference.getType() == 0) {
            n4 = difference.getSecondStart() + nArray[1] + 1;
            n3 = n4 - 1;
        } else {
            n4 = difference.getSecondStart() + nArray[1];
            n3 = difference.getSecondEnd() + nArray[1];
        }
        int n7 = this.resolvedConflicts.contains(difference) ? (bl ? n5 - n6 : n3 - n4) : Math.max(n5 - n6, n3 - n4);
        if (bl) {
            this.panel.replaceSource2InResult(n4, Math.max(n3, 0), this.resultDiffLocations[n], this.resultDiffLocations[n] + n7);
            n2 = n7 - (n3 - n4);
            this.panel.highlightRegion1(n6, Math.max(n5, 0), this.colorOtherConflict);
            this.panel.highlightRegion2(n4, Math.max(n3, 0), this.colorResolvedConflict);
        } else {
            this.panel.replaceSource1InResult(n6, Math.max(n5, 0), this.resultDiffLocations[n], this.resultDiffLocations[n] + n7);
            n2 = n7 - (n5 - n6);
            this.panel.highlightRegion1(n6, Math.max(n5, 0), this.colorResolvedConflict);
            this.panel.highlightRegion2(n4, Math.max(n3, 0), this.colorOtherConflict);
        }
        if (bl && n3 >= n4 || !bl && n5 >= n6) {
            this.panel.highlightRegion3(this.resultDiffLocations[n], this.resultDiffLocations[n] + n7 - n2, this.colorResolvedConflict);
        } else {
            this.panel.unhighlightRegion3(this.resultDiffLocations[n], this.resultDiffLocations[n]);
        }
        int n8 = n + 1;
        while (n8 < this.diffs.length) {
            int n9 = n8++;
            this.resultDiffLocations[n9] = this.resultDiffLocations[n9] - n2;
        }
        this.resolvedConflicts.add(difference);
        this.panel.setNeedsSaveState(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final String string = actionEvent.getActionCommand();
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                if ("firstConflict".equals(string)) {
                    MergeControl.this.currentDiffLine = 0;
                    MergeControl.this.showCurrentLine();
                } else if ("lastConflict".equals(string)) {
                    MergeControl.this.currentDiffLine = MergeControl.this.diffs.length - 1;
                    MergeControl.this.showCurrentLine();
                } else if ("previousConflict".equals(string)) {
                    MergeControl.this.currentDiffLine--;
                    if (MergeControl.this.currentDiffLine < 0) {
                        MergeControl.this.currentDiffLine = MergeControl.this.diffs.length - 1;
                    }
                    MergeControl.this.showCurrentLine();
                } else if ("nextConflict".equals(string)) {
                    MergeControl.this.currentDiffLine++;
                    if (MergeControl.this.currentDiffLine >= MergeControl.this.diffs.length) {
                        MergeControl.this.currentDiffLine = 0;
                    }
                    MergeControl.this.showCurrentLine();
                } else if ("acceptRight".equals(string)) {
                    MergeControl.this.doResolveConflict(true, MergeControl.this.currentDiffLine);
                } else if ("acceptLeft".equals(string)) {
                    MergeControl.this.doResolveConflict(false, MergeControl.this.currentDiffLine);
                }
            }
        });
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        MergePanel mergePanel;
        if ("panelSave".equals(propertyChangeEvent.getPropertyName()) && this.panel == (mergePanel = (MergePanel)propertyChangeEvent.getNewValue())) {
            ArrayList<Difference> arrayList = new ArrayList<Difference>();
            int n = 0;
            int n2 = 0;
            while (n2 < this.diffs.length) {
                if (!this.resolvedConflicts.contains(this.diffs[n2])) {
                    int n3 = this.resultDiffLocations[n2] - n;
                    Difference difference = new Difference(this.diffs[n2].getType(), n3, n3 + this.diffs[n2].getFirstEnd() - this.diffs[n2].getFirstStart(), n3, n3 + this.diffs[n2].getSecondEnd() - this.diffs[n2].getSecondStart(), this.diffs[n2].getFirstText(), this.diffs[n2].getSecondText());
                    arrayList.add(difference);
                    n += Math.max(this.diffs[n2].getFirstEnd() - this.diffs[n2].getFirstStart() + 1, this.diffs[n2].getSecondEnd() - this.diffs[n2].getSecondStart() + 1);
                }
                ++n2;
            }
            try {
                mergePanel.writeResult(this.resultSource.createWriter(arrayList.toArray(new Difference[arrayList.size()])));
                mergePanel.setNeedsSaveState(false);
            }
            catch (IOException iOException) {
                throw new PropertyVetoException(NbBundle.getMessage((Class)(class$org$netbeans$modules$merge$builtin$visualizer$MergeControl == null ? (class$org$netbeans$modules$merge$builtin$visualizer$MergeControl = MergeControl.class$("org.netbeans.modules.merge.builtin.visualizer.MergeControl")) : class$org$netbeans$modules$merge$builtin$visualizer$MergeControl), (String)"MergeControl.failedToSave", (Object)iOException.getLocalizedMessage()), propertyChangeEvent);
            }
        }
        if ("panelClosing".equals(propertyChangeEvent.getPropertyName()) && this.panel == (mergePanel = (MergePanel)propertyChangeEvent.getNewValue())) {
            this.resultSource.close();
        }
        if ("allPanelsClosed".equals(propertyChangeEvent.getPropertyName()) || "allPanelsCancelled".equals(propertyChangeEvent.getPropertyName())) {
            this.resultSource.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

