/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.html.HtmlDataObject;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.windows.CloneableOpenSupport;

public final class HtmlEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie,
PrintCookie {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            HtmlEditorSupport.this.saveDocument();
            HtmlEditorSupport.this.getDataObject().setModified(false);
        }
    };
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    HtmlEditorSupport(HtmlDataObject htmlDataObject) {
        super((DataObject)htmlDataObject, (CloneableEditorSupport.Env)new Environment(htmlDataObject));
        this.setMIMEType("text/html");
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        HtmlDataObject htmlDataObject = (HtmlDataObject)this.getDataObject();
        if (htmlDataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = HtmlEditorSupport.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) == null) {
            htmlDataObject.getCookieSet0().add((Node.Cookie)this.saveCookie);
            htmlDataObject.setModified(true);
        }
    }

    private void removeSaveCookie() {
        HtmlDataObject htmlDataObject = (HtmlDataObject)this.getDataObject();
        Node.Cookie cookie = htmlDataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = HtmlEditorSupport.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            htmlDataObject.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            htmlDataObject.setModified(false);
        }
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        byte[] byArray;
        int n = inputStream.read(byArray = new byte[4096], 0, byArray.length);
        String string = new String(byArray, 0, n >= 0 ? n : 0).toUpperCase();
        string = HtmlEditorSupport.findEncoding(string);
        inputStream = n < byArray.length ? new ByteArrayInputStream(byArray, 0, n) : new SequenceInputStream(new ByteArrayInputStream(byArray), inputStream);
        if (string != null) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
                editorKit.read(inputStreamReader, (Document)styledDocument, 0);
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        editorKit.read(inputStream, (Document)styledDocument, 0);
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        int n = styledDocument.getLength();
        if (n > 4096) {
            n = 4096;
        }
        String string = styledDocument.getText(0, n).toUpperCase();
        if ((string = HtmlEditorSupport.findEncoding(string)) != null) {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
                editorKit.write(outputStreamWriter, (Document)styledDocument, 0, styledDocument.getLength());
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        super.saveFromKitToStream(styledDocument, editorKit, outputStream);
    }

    private static String findEncoding(String string) {
        int n;
        int n2 = string.indexOf("</HEAD>");
        if (n2 == -1) {
            n2 = string.length();
        }
        if ((n = string.indexOf("CONTENT-TYPE")) == -1 || n > n2) {
            return null;
        }
        int n3 = string.indexOf("CHARSET=", n);
        if (n3 == -1) {
            return null;
        }
        int n4 = string.indexOf(34, n3);
        int n5 = string.indexOf(39, n3);
        if (n4 == -1 && n5 == -1) {
            return null;
        }
        if (n5 != -1 && (n4 == -1 || n4 > n5)) {
            n4 = n5;
        }
        return string.substring(n3 + "CHARSET=".length(), n4);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;
        static /* synthetic */ Class class$org$netbeans$modules$html$HtmlEditorSupport;

        public Environment(HtmlDataObject htmlDataObject) {
            super((DataObject)htmlDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((HtmlDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (HtmlEditorSupport)this.getDataObject().getCookie(class$org$netbeans$modules$html$HtmlEditorSupport == null ? (class$org$netbeans$modules$html$HtmlEditorSupport = Environment.class$("org.netbeans.modules.html.HtmlEditorSupport")) : class$org$netbeans$modules$html$HtmlEditorSupport);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

