/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jndi;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;
import javax.swing.JButton;
import org.netbeans.modules.jndi.JndiChildren;
import org.netbeans.modules.jndi.JndiDataType;
import org.netbeans.modules.jndi.JndiDirContext;
import org.netbeans.modules.jndi.JndiException;
import org.netbeans.modules.jndi.JndiLeafNode;
import org.netbeans.modules.jndi.JndiNode;
import org.netbeans.modules.jndi.JndiRootNode;
import org.netbeans.modules.jndi.NewJndiRootPanel;
import org.netbeans.modules.jndi.NewJndiSubContextPanel;
import org.netbeans.modules.jndi.gui.NotFoundPanel;
import org.netbeans.modules.jndi.gui.TimeOutPanel;
import org.netbeans.modules.jndi.settings.JndiSystemOption;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.AbstractNode;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.datatransfer.NewType;

final class JndiDataType
extends NewType {
    private static final int SUCCESSFULL = 0;
    private static final int CLASS_NOT_FOUND_EXCEPTION = 1;
    private static final int NAMING_EXCEPTION = 2;
    private static final int INTERRUPTED_EXCEPTION = 3;
    private static final int NAMING_INTERRUPTED_EXCEPTION = 4;
    private static final int JNDI_EXCEPTION = 5;
    private static final int OTHER_EXCEPTION = 6;
    private static final int TIMEOUT_TO_SHORT = 7;
    protected AbstractNode node;
    private Dialog dlg = null;
    private NewJndiRootPanel panel;
    private short state;

    public JndiDataType(JndiRootNode jndiRootNode) {
        this.node = jndiRootNode;
    }

    public JndiDataType(JndiNode jndiNode) {
        this.node = jndiNode;
    }

    public JndiDataType(JndiLeafNode jndiLeafNode) {
        this.node = jndiLeafNode;
    }

    public void create() throws IOException {
        this.create(null);
    }

    public void create(String string) throws IOException {
        DialogDescriptor dialogDescriptor = null;
        if (this.node instanceof JndiRootNode) {
            this.panel = new NewJndiRootPanel();
            this.panel.select(string);
            final JButton jButton = new JButton(JndiRootNode.getLocalizedString("CTL_Ok"));
            jButton.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("CTL_Ok"));
            final JButton jButton2 = new JButton(JndiRootNode.getLocalizedString("CTL_Cancel"));
            jButton2.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("CTL_Cancel"));
            dialogDescriptor = new DialogDescriptor((Object)this.panel, JndiRootNode.getLocalizedString("TITLE_NewContext"), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == jButton) {
                        Runnable runnable = new Runnable(this){
                            static /* synthetic */ Class class$org$netbeans$modules$jndi$settings$JndiSystemOption;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                try {
                                    1.access$300(this.this$1).setEnabled(false);
                                    1.access$400(this.this$1).setEnabled(false);
                                    TopManager.getDefault().setStatusText(JndiRootNode.getLocalizedString("TITLE_WaitOnConnect"));
                                    class Connector
                                    implements Runnable {
                                        private ConnectOperationStatus status;
                                        private final /* synthetic */ 2 this$2;

                                        Connector(2 var1_1) {
                                            this.this$2 = var1_1;
                                        }

                                        public void run() {
                                            try {
                                                Properties properties = ((JndiRootNode)1.access$100(2.access$000(this.this$2)).node).createContextProperties(JndiDataType.access$200(1.access$100(2.access$000(this.this$2))).getLabel(), JndiDataType.access$200(1.access$100(2.access$000(this.this$2))).getFactory(), JndiDataType.access$200(1.access$100(2.access$000(this.this$2))).getContext(), JndiDataType.access$200(1.access$100(2.access$000(this.this$2))).getRoot(), JndiDataType.access$200(1.access$100(2.access$000(this.this$2))).getAuthentification(), JndiDataType.access$200(1.access$100(2.access$000(this.this$2))).getPrincipal(), JndiDataType.access$200(1.access$100(2.access$000(this.this$2))).getCredentials(), JndiDataType.access$200(1.access$100(2.access$000(this.this$2))).getAditionalProperties());
                                                this.checkContextValidity(properties);
                                                ((JndiRootNode)1.access$100(2.access$000(this.this$2)).node).addContext(properties);
                                                Connector connector = this;
                                                synchronized (connector) {
                                                    this.status = new ConnectOperationStatus(0);
                                                }
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                Connector connector = this;
                                                synchronized (connector) {
                                                    this.status = new ConnectOperationStatus(1, classNotFoundException);
                                                }
                                            }
                                            catch (NamingException namingException) {
                                                Connector connector = this;
                                                synchronized (connector) {
                                                    Throwable throwable = namingException.getRootCause() != null ? namingException.getRootCause() : namingException;
                                                    this.status = throwable instanceof JndiException ? new ConnectOperationStatus(5, throwable) : (throwable instanceof InterruptedNamingException || throwable instanceof InterruptedException ? new ConnectOperationStatus(4, throwable) : new ConnectOperationStatus(2, throwable));
                                                }
                                            }
                                            catch (Exception exception) {
                                                Connector connector = this;
                                                synchronized (connector) {
                                                    this.status = new ConnectOperationStatus(6, exception);
                                                }
                                            }
                                        }

                                        public synchronized ConnectOperationStatus getOperationStatus() {
                                            return this.status;
                                        }

                                        private void checkContextValidity(Hashtable hashtable) throws Exception {
                                            Class.forName((String)hashtable.get("java.naming.factory.initial"), true, TopManager.getDefault().currentClassLoader());
                                            JndiDirContext jndiDirContext = new JndiDirContext(hashtable);
                                            jndiDirContext.checkContext();
                                        }
                                    }
                                    Connector connector = new Connector(this);
                                    Thread thread = new Thread(connector);
                                    thread.start();
                                    try {
                                        JndiSystemOption jndiSystemOption = (JndiSystemOption)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jndi$settings$JndiSystemOption == null ? (class$org$netbeans$modules$jndi$settings$JndiSystemOption = 2.class$("org.netbeans.modules.jndi.settings.JndiSystemOption")) : class$org$netbeans$modules$jndi$settings$JndiSystemOption), (boolean)true);
                                        int n = jndiSystemOption != null ? jndiSystemOption.getTimeOut() : 4000;
                                        thread.join(n);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (thread.isAlive()) {
                                        thread.interrupt();
                                        if (thread.isAlive()) {
                                            thread.stop();
                                        }
                                    }
                                    ConnectOperationStatus connectOperationStatus = connector.getOperationStatus();
                                    int n = 7;
                                    if (connectOperationStatus != null) {
                                        n = connectOperationStatus.getOperationStatus();
                                    }
                                    switch (n) {
                                        case 0: {
                                            TopManager.getDefault().setStatusText(JndiRootNode.getLocalizedString("TXT_Connected"));
                                            ((Component)JndiDataType.access$500(1.access$100(this.this$1))).setVisible(false);
                                            JndiDataType.access$500(1.access$100(this.this$1)).dispose();
                                            break;
                                        }
                                        case 1: {
                                            TopManager.getDefault().setStatusText(JndiRootNode.getLocalizedString("TXT_ConnectFailed"));
                                            NotFoundPanel notFoundPanel = new NotFoundPanel(JndiDataType.access$200(1.access$100(this.this$1)).getFactory());
                                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)notFoundPanel, 0));
                                            break;
                                        }
                                        case 5: {
                                            TopManager.getDefault().setStatusText(JndiRootNode.getLocalizedString("TXT_ConnectFailed"));
                                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JndiRootNode.getLocalizedString("EXC_Items"), 0));
                                            break;
                                        }
                                        case 7: {
                                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JndiRootNode.getLocalizedString("EXC_TimeoutToShort"), 0));
                                            break;
                                        }
                                        case 3: 
                                        case 4: {
                                            Throwable throwable = connectOperationStatus.getException();
                                            String string = throwable.getMessage() == null || throwable.getMessage().equals("") ? throwable.getClass().getName() : throwable.getClass().getName() + ": " + throwable.getMessage();
                                            TopManager.getDefault().setStatusText(JndiRootNode.getLocalizedString("TXT_ConnectFailed"));
                                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception(throwable, (Object)new TimeOutPanel(string, JndiRootNode.getLocalizedString("NOTE_TimeOut"))));
                                            break;
                                        }
                                        case 2: {
                                            TopManager.getDefault().setStatusText(JndiRootNode.getLocalizedString("TXT_ConnectFailed"));
                                            JndiRootNode.notifyForeignException(connectOperationStatus.getException());
                                            break;
                                        }
                                        case 6: {
                                            TopManager.getDefault().setStatusText(JndiRootNode.getLocalizedString("TXT_ConnectFailed"));
                                            JndiRootNode.notifyForeignException(connectOperationStatus.getException());
                                        }
                                    }
                                    Object var9_11 = null;
                                    1.access$300(this.this$1).setEnabled(true);
                                    1.access$400(this.this$1).setEnabled(true);
                                }
                                catch (Throwable throwable) {
                                    Object var9_12 = null;
                                    1.access$300(this.this$1).setEnabled(true);
                                    1.access$400(this.this$1).setEnabled(true);
                                    throw throwable;
                                }
                            }

                            static /* synthetic */ 1 access$000(2 var0) {
                                return var0.this$1;
                            }

                            static /* synthetic */ Class class$(String string) {
                                try {
                                    return Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                        };
                        new Thread(runnable).start();
                    } else if (actionEvent.getSource() == jButton2) {
                        ((Component)JndiDataType.this.dlg).setVisible(false);
                        JndiDataType.this.dlg.dispose();
                    }
                }

                static /* synthetic */ JndiDataType access$100(1 var0) {
                    return var0.JndiDataType.this;
                }

                static /* synthetic */ JButton access$300(1 var0) {
                    return var0.jButton;
                }

                static /* synthetic */ JButton access$400(1 var0) {
                    return var0.jButton2;
                }
            });
            this.dlg = TopManager.getDefault().createDialog(dialogDescriptor);
            ((Component)this.dlg).setVisible(true);
        } else if (this.node instanceof JndiNode) {
            final NewJndiSubContextPanel newJndiSubContextPanel = new NewJndiSubContextPanel();
            dialogDescriptor = new DialogDescriptor((Object)newJndiSubContextPanel, JndiRootNode.getLocalizedString("TITLE_NewJndiDirectory"), false, 2, NotifyDescriptor.OK_OPTION, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
                        JndiChildren jndiChildren = (JndiChildren)JndiDataType.this.node.getChildren();
                        Context context = jndiChildren.getContext();
                        try {
                            context.createSubcontext(newJndiSubContextPanel.getName());
                            jndiChildren.prepareKeys();
                        }
                        catch (NamingException namingException) {
                            JndiRootNode.notifyForeignException(namingException);
                        }
                        ((Component)JndiDataType.this.dlg).setVisible(false);
                        JndiDataType.this.dlg.dispose();
                    } else if (actionEvent.getSource() == NotifyDescriptor.CANCEL_OPTION) {
                        ((Component)JndiDataType.this.dlg).setVisible(false);
                        JndiDataType.this.dlg.dispose();
                    }
                }
            });
            this.dlg = TopManager.getDefault().createDialog(dialogDescriptor);
            ((Component)this.dlg).setVisible(true);
        }
    }

    public String getName() {
        if (this.node instanceof JndiRootNode) {
            return JndiRootNode.getLocalizedString("CTL_Context");
        }
        if (this.node instanceof JndiNode) {
            return JndiRootNode.getLocalizedString("CTL_Directory");
        }
        return "";
    }

    static /* synthetic */ NewJndiRootPanel access$200(JndiDataType jndiDataType) {
        return jndiDataType.panel;
    }

    static class ConnectOperationStatus {
        private int status;
        private Throwable exception;

        public ConnectOperationStatus() {
            this.status = 0;
        }

        public ConnectOperationStatus(int n) {
            this.status = n;
        }

        public ConnectOperationStatus(int n, Throwable throwable) {
            this.status = n;
            this.exception = throwable;
        }

        public int getOperationStatus() {
            return this.status;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

