/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;

final class JndiObjectCreator {
    private static final char[] hexDigitTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    JndiObjectCreator() {
    }

    static String correctValue(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '\\') {
                stringBuffer.insert(n, '\\');
                ++n;
            } else if (stringBuffer.charAt(n) == '\'' && bl) {
                stringBuffer.insert(n, '\\');
                ++n;
            } else if (stringBuffer.charAt(n) == '\"' && bl) {
                stringBuffer.insert(n, '\\');
                ++n;
            } else if (stringBuffer.charAt(n) == '\t') {
                stringBuffer.setCharAt(n, 't');
                stringBuffer.insert(n, '\\');
                ++n;
            } else if (stringBuffer.charAt(n) == '\n') {
                stringBuffer.setCharAt(n, 'n');
                stringBuffer.insert(n, '\\');
                ++n;
            } else if (stringBuffer.charAt(n) == '\b') {
                stringBuffer.setCharAt(n, 'b');
                stringBuffer.insert(n, '\\');
                ++n;
            } else if (stringBuffer.charAt(n) == '\r') {
                stringBuffer.setCharAt(n, 'r');
                stringBuffer.insert(n, '\\');
                ++n;
            } else if (stringBuffer.charAt(n) == '\f') {
                stringBuffer.setCharAt(n, 'f');
                stringBuffer.insert(n, '\\');
                ++n;
            } else if (stringBuffer.charAt(n) < ' ' || stringBuffer.charAt(n) > '\u0127') {
                String string2 = JndiObjectCreator.hexStrVal(stringBuffer.charAt(n));
                stringBuffer.deleteCharAt(n);
                stringBuffer.insert(n, string2);
                n += string2.length() - 1;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String getLookupCode(Context context, String string, String string2) throws NamingException {
        String string3 = JndiObjectCreator.generateProperties(context);
        String string4 = (String)context.getEnvironment().get("HomePath");
        string3 = string3 + JndiObjectCreator.generateObjectReference(string, string4, string2);
        string3 = string3 + JndiObjectCreator.generateTail();
        return string3;
    }

    public static String generateBindingCode(Context context, String string, String string2) throws NamingException {
        String string3 = JndiObjectCreator.generateProperties(context);
        String string4 = (String)context.getEnvironment().get("HomePath");
        string3 = string3 + JndiObjectCreator.generateObjectReference(string, string4, string2);
        string3 = string3 + "    jndiObject.bind(\"<Name>\",<Object>);\n";
        string3 = string3 + JndiObjectCreator.generateTail();
        return string3;
    }

    public static String stringifyCompositeName(Name name) {
        Enumeration<String> enumeration = name.getAll();
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = string == null ? enumeration.nextElement().toString() : string + "/" + enumeration.nextElement().toString();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static String generateProperties(Context context) throws NamingException {
        Hashtable<?, ?> hashtable = context.getEnvironment();
        if (hashtable == null) {
            return null;
        }
        String string = "/** Inserted by Jndi module */\n";
        string = string + "java.util.Properties jndiProperties = new java.util.Properties();\n";
        Enumeration<?> enumeration = hashtable.keys();
        Enumeration<?> enumeration2 = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = JndiObjectCreator.correctValue((String)enumeration.nextElement(), true);
            String string3 = JndiObjectCreator.correctValue((String)enumeration2.nextElement(), true);
            if (string2.equals("HomePath") || string2.equals("NB_LABEL")) continue;
            string = string + "jndiProperties.put(\"" + string2 + "\",\"" + string3 + "\");\n";
        }
        return string;
    }

    private static String generateObjectReference(String string, String string2, String string3) {
        String string4 = new String();
        string4 = string4 + "try {\n    javax.naming.directory.DirContext jndiCtx = new javax.naming.directory.InitialDirContext(jndiProperties);\n";
        if (string2 != null && string2.length() > 0) {
            string4 = string4 + "    javax.naming.Context jndiRootCtx = (javax.naming.Context) jndiCtx.lookup(\"" + JndiObjectCreator.correctValue(string2, true) + "\");\n";
            string4 = string4 + "    " + string3 + " jndiObject = (" + string3 + ")jndiRootCtx.lookup(\"" + JndiObjectCreator.correctValue(string, true) + "\");\n";
        } else {
            string4 = string4 + "    " + string3 + " jndiObject = (" + string3 + ")jndiCtx.lookup(\"" + JndiObjectCreator.correctValue(string, true) + "\");\n";
        }
        return string4;
    }

    private static String generateTail() {
        return "} catch (javax.naming.NamingException ne) {\n    ne.printStackTrace();\n}\n";
    }

    private static String hexStrVal(char n) {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer("\\u0000");
        int n3 = 5;
        do {
            int n4 = n2 & 0xF;
            stringBuffer.setCharAt(n3--, hexDigitTable[n4]);
        } while ((n2 >>>= 4) > 0);
        return stringBuffer.toString();
    }
}

