/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jndi;

import java.awt.datatransfer.StringSelection;
import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.netbeans.modules.jndi.JndiAbstractNode;
import org.netbeans.modules.jndi.JndiKey;
import org.netbeans.modules.jndi.JndiNode;
import org.netbeans.modules.jndi.JndiProperty;
import org.netbeans.modules.jndi.JndiRootNode;
import org.netbeans.modules.jndi.TemplateCreator;
import org.netbeans.modules.jndi.utils.JndiPropertyMutator;
import org.openide.TopManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.datatransfer.ExClipboard;

abstract class JndiObjectNode
extends JndiAbstractNode
implements Node.Cookie,
TemplateCreator,
JndiPropertyMutator {
    public static final String JNDI_PROPERTIES = "Jndi";
    private JndiKey key;
    static /* synthetic */ Class class$java$lang$String;

    public JndiObjectNode(JndiKey jndiKey, Children children) {
        this(jndiKey.name.getName(), children);
        this.key = jndiKey;
    }

    public JndiObjectNode(String string, Children children) {
        super(children, string);
        this.getCookieSet().add((Node.Cookie)this);
    }

    public JndiKey getKey() {
        return this.key;
    }

    public final boolean canCopy() {
        return false;
    }

    public boolean canDestroy() {
        return true;
    }

    public Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = new Sheet.Set();
        set.setName(JNDI_PROPERTIES);
        set.setDisplayName(JndiRootNode.getLocalizedString("TITLE_JndiProperty"));
        sheet.put(set);
        sheet.get("properties").put((Node.Property)new JndiProperty("NAME", class$java$lang$String == null ? (class$java$lang$String = JndiObjectNode.class$("java.lang.String")) : class$java$lang$String, JndiRootNode.getLocalizedString("TXT_Name"), JndiRootNode.getLocalizedString("TIP_Name"), ((FeatureDescriptor)((Object)this)).getName()));
        sheet.get("properties").put((Node.Property)new JndiProperty("OFFSET", class$java$lang$String == null ? (class$java$lang$String = JndiObjectNode.class$("java.lang.String")) : class$java$lang$String, JndiRootNode.getLocalizedString("TXT_Path"), JndiRootNode.getLocalizedString("TIP_Path"), this.getOffsetAsString()));
        sheet.get("properties").put((Node.Property)new JndiProperty("CLASS", class$java$lang$String == null ? (class$java$lang$String = JndiObjectNode.class$("java.lang.String")) : class$java$lang$String, JndiRootNode.getLocalizedString("TXT_Class"), JndiRootNode.getLocalizedString("TIP_Class"), this.getClassName()));
        try {
            Enumeration<?> enumeration = this.getContext().getEnvironment().keys();
            Enumeration<?> enumeration2 = this.getContext().getEnvironment().elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)enumeration2.nextElement();
                if (string.equals("HomePath")) {
                    if (string2.length() <= 0) continue;
                    sheet.get("properties").put((Node.Property)new JndiProperty("ROOT", class$java$lang$String == null ? JndiObjectNode.class$("java.lang.String") : class$java$lang$String, JndiRootNode.getLocalizedString("TXT_Start"), string2));
                    continue;
                }
                if (string.equals("NB_LABEL")) continue;
                sheet.get("properties").put((Node.Property)new JndiProperty(string, class$java$lang$String == null ? JndiObjectNode.class$("java.lang.String") : class$java$lang$String, string, string2));
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.setSheet(sheet);
        return sheet;
    }

    public abstract Context getContext();

    public abstract String createTemplate() throws NamingException;

    public abstract CompositeName getOffset();

    public abstract String getOffsetAsString();

    public abstract String getClassName();

    public final void lookupCopy() {
        try {
            ExClipboard exClipboard = TopManager.getDefault().getClipboard();
            StringSelection stringSelection = new StringSelection(this.createTemplate());
            exClipboard.setContents(stringSelection, stringSelection);
            JndiRootNode.showLocalizedStatus("STS_CopyLookupCode");
        }
        catch (NamingException namingException) {
            JndiRootNode.notifyForeignException(namingException);
        }
    }

    public void destroy() throws IOException {
        super.destroy();
        Node node = this.getParentNode();
        if (node instanceof JndiNode) {
            ((JndiNode)node).refresh();
        }
    }

    public void refresh() {
        throw new UnsupportedOperationException();
    }

    public boolean changeJndiPropertyValue(String string, Object object) {
        try {
            BasicAttributes basicAttributes = new BasicAttributes();
            BasicAttribute basicAttribute = new BasicAttribute(string);
            if (object instanceof String) {
                basicAttributes.put(this.stringToAttr(basicAttribute, (String)object));
            } else {
                basicAttribute.add(object);
                basicAttributes.put(basicAttribute);
            }
            this.handleChangeJndiPropertyValue(basicAttributes);
        }
        catch (NamingException namingException) {
            JndiRootNode.notifyForeignException(namingException);
            return false;
        }
        return true;
    }

    protected String attrToString(Attribute attribute) throws NamingException {
        String string = new String();
        int n = 0;
        while (n < attribute.size()) {
            if (n != 0) {
                string = string + JndiRootNode.getLocalizedString("TXT_ValueSeparator");
            }
            string = string + attribute.get(n).toString();
            ++n;
        }
        return string;
    }

    protected Attribute stringToAttr(Attribute attribute, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, JndiRootNode.getLocalizedString("TXT_ValueSeparator").trim());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            attribute.add(string2);
        }
        return attribute;
    }

    protected abstract void handleChangeJndiPropertyValue(Attributes var1) throws NamingException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

