/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jndi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.NamingException;
import org.netbeans.modules.jndi.JndiDirContext;
import org.netbeans.modules.jndi.JndiDisabledNode;
import org.netbeans.modules.jndi.JndiNode;
import org.netbeans.modules.jndi.JndiProvidersNode;
import org.netbeans.modules.jndi.JndiRootCtxKey;
import org.netbeans.modules.jndi.ProvidersKey;
import org.netbeans.modules.jndi.settings.JndiSystemOption;
import org.openide.TopManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.SharedClassObject;

public class JndiRootNodeChildren
extends Children.Keys
implements PropertyChangeListener {
    private ArrayList contexts;
    private JndiSystemOption settings;
    private JndiProvidersNode providersNode;
    static /* synthetic */ Class class$org$netbeans$modules$jndi$settings$JndiSystemOption;

    public void addNotify() {
        TopManager.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.update();
    }

    public void removeNotify() {
        TopManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        this.setKeys(new Object[0]);
    }

    public void add(Hashtable hashtable) {
        if (this.settings == null) {
            this.init();
        }
        this.contexts.add(hashtable);
        this.settings.setInitialContexts(this.contexts);
        this.update();
    }

    public void add(Hashtable hashtable, int n) {
        if (this.settings == null) {
            this.init();
        }
        this.contexts.add(n, hashtable);
        this.settings.setInitialContexts(this.contexts);
        this.update();
    }

    public void remove(int n) {
        if (n < 0 || n >= this.contexts.size()) {
            return;
        }
        if (this.settings == null) {
            this.init();
        }
        this.contexts.remove(n);
        this.settings.setInitialContexts(this.contexts);
        this.update();
    }

    public void update() {
        if (this.settings == null) {
            this.init();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new ProvidersKey());
        Iterator iterator = ((AbstractList)this.contexts).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Hashtable hashtable = (Hashtable)iterator.next();
            JndiRootCtxKey jndiRootCtxKey = new JndiRootCtxKey(hashtable, n);
            arrayList.add(jndiRootCtxKey);
            ++n;
        }
        this.setKeys(arrayList);
    }

    public void updateKey(Object object) {
        this.refreshKey(object);
    }

    public JndiProvidersNode getProvidersNode() {
        if (this.providersNode == null) {
            this.providersNode = new JndiProvidersNode();
        }
        return this.providersNode;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("places".equals(propertyChangeEvent.getPropertyName())) {
            this.settings = null;
            this.update();
        }
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof ProvidersKey) {
            return new Node[]{this.getProvidersNode()};
        }
        if (object instanceof JndiRootCtxKey) {
            JndiRootCtxKey jndiRootCtxKey = (JndiRootCtxKey)object;
            try {
                Context context = new JndiDirContext(jndiRootCtxKey.getEnvironment());
                String string = (String)jndiRootCtxKey.getEnvironment().get("HomePath");
                if (string != null) {
                    context = (Context)context.lookup(string);
                } else {
                    context.checkContext();
                }
                JndiNode jndiNode = new JndiNode(context, jndiRootCtxKey.getIndex());
                return new Node[]{jndiNode};
            }
            catch (NamingException namingException) {
                return new Node[]{new JndiDisabledNode(jndiRootCtxKey.getEnvironment(), jndiRootCtxKey.getIndex())};
            }
        }
        return new Node[0];
    }

    private void init() {
        this.settings = (JndiSystemOption)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jndi$settings$JndiSystemOption == null ? (class$org$netbeans$modules$jndi$settings$JndiSystemOption = JndiRootNodeChildren.class$("org.netbeans.modules.jndi.settings.JndiSystemOption")) : class$org$netbeans$modules$jndi$settings$JndiSystemOption), (boolean)true);
        this.contexts = this.settings.getInitialContexts();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

