/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jndi;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.util.Vector;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.jndi.JndiDataType;
import org.netbeans.modules.jndi.JndiIcons;
import org.netbeans.modules.jndi.JndiRootNode;
import org.netbeans.modules.jndi.NewProviderPanel;
import org.netbeans.modules.jndi.ProviderProperties;
import org.netbeans.modules.jndi.ProviderProperty;
import org.netbeans.modules.jndi.settings.JndiSystemOption;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

public class ProviderNode
extends AbstractNode
implements Node.Cookie {
    public static final String DRIVER = "DRIVER";
    public static final String DISABLED_DRIVER = "DEADDRIVER";
    private String name;
    private SystemAction[] nodeActions;
    JndiSystemOption settings;
    static /* synthetic */ Class class$org$netbeans$modules$jndi$ProviderTestAction;
    static /* synthetic */ Class class$org$netbeans$modules$jndi$ProviderConnectAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$jndi$ProviderNode;
    static /* synthetic */ Class class$org$netbeans$modules$jndi$settings$JndiSystemOption;

    public ProviderNode(String string) {
        super(Children.LEAF);
        this.getCookieSet().add((Node.Cookie)this);
        this.name = string;
        int n = string.lastIndexOf(46);
        String string2 = n < 0 ? string : string.substring(n + 1);
        this.setName(string2);
        try {
            Class.forName(string, true, TopManager.getDefault().currentClassLoader());
            this.setIconBase("org/netbeans/modules/jndi/resources/" + JndiIcons.getIconName(DRIVER));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.setIconBase("org/netbeans/modules/jndi/resources/" + JndiIcons.getIconName(DISABLED_DRIVER));
        }
    }

    public void setValue(Object object) {
        if (object instanceof String) {
            this.setName((String)object);
        }
    }

    public Object getValue() {
        return ((FeatureDescriptor)((Object)this)).getName();
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canDestroy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$jndi$ProviderTestAction == null ? (class$org$netbeans$modules$jndi$ProviderTestAction = ProviderNode.class$("org.netbeans.modules.jndi.ProviderTestAction")) : class$org$netbeans$modules$jndi$ProviderTestAction)), SystemAction.get((Class)(class$org$netbeans$modules$jndi$ProviderConnectAction == null ? (class$org$netbeans$modules$jndi$ProviderConnectAction = ProviderNode.class$("org.netbeans.modules.jndi.ProviderConnectAction")) : class$org$netbeans$modules$jndi$ProviderConnectAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ProviderNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ProviderNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public SystemAction[] getActions() {
        if (this.nodeActions == null) {
            this.nodeActions = this.createActions();
        }
        return this.nodeActions;
    }

    public Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        ProviderProperties providerProperties = (ProviderProperties)this.getSettings().getProviders(false).get(this.name);
        if (providerProperties != null) {
            ProviderProperty providerProperty = new ProviderProperty("java.naming.factory.initial", class$java$lang$String == null ? (class$java$lang$String = ProviderNode.class$("java.lang.String")) : class$java$lang$String, JndiRootNode.getLocalizedString("TXT_Factory"), JndiRootNode.getLocalizedString("TIP_Factory"), providerProperties, false);
            set.put((Node.Property)providerProperty);
            providerProperty = new ProviderProperty("java.naming.provider.url", class$java$lang$String == null ? (class$java$lang$String = ProviderNode.class$("java.lang.String")) : class$java$lang$String, JndiRootNode.getLocalizedString("TXT_InitialContext"), JndiRootNode.getLocalizedString("TIP_InitialContext"), providerProperties, true);
            set.put((Node.Property)providerProperty);
            providerProperty = new ProviderProperty("HomePath", class$java$lang$String == null ? (class$java$lang$String = ProviderNode.class$("java.lang.String")) : class$java$lang$String, JndiRootNode.getLocalizedString("TXT_Root"), JndiRootNode.getLocalizedString("TIP_Root"), providerProperties, true);
            set.put((Node.Property)providerProperty);
            providerProperty = new ProviderProperty("java.naming.security.authentication", class$java$lang$String == null ? (class$java$lang$String = ProviderNode.class$("java.lang.String")) : class$java$lang$String, JndiRootNode.getLocalizedString("TXT_Auth"), JndiRootNode.getLocalizedString("TIP_Auth"), providerProperties, true);
            set.put((Node.Property)providerProperty);
            providerProperty = new ProviderProperty("java.naming.security.principal", class$java$lang$String == null ? (class$java$lang$String = ProviderNode.class$("java.lang.String")) : class$java$lang$String, JndiRootNode.getLocalizedString("TXT_Principal"), JndiRootNode.getLocalizedString("TIP_Principal"), providerProperties, true);
            set.put((Node.Property)providerProperty);
            providerProperty = new ProviderProperty("java.naming.security.credentials", class$java$lang$String == null ? (class$java$lang$String = ProviderNode.class$("java.lang.String")) : class$java$lang$String, JndiRootNode.getLocalizedString("TXT_Credentials"), JndiRootNode.getLocalizedString("TIP_Credentials"), providerProperties, true);
            set.put((Node.Property)providerProperty);
            providerProperty = new ProviderProperty("Additional", class$java$lang$String == null ? (class$java$lang$String = ProviderNode.class$("java.lang.String")) : class$java$lang$String, JndiRootNode.getLocalizedString("TXT_OtherProps"), JndiRootNode.getLocalizedString("TIP_Additional"), providerProperties, true);
            set.put((Node.Property)providerProperty);
        }
        return sheet;
    }

    public void destroy() throws IOException {
        JndiSystemOption jndiSystemOption = this.getSettings();
        if (jndiSystemOption != null) {
            jndiSystemOption.destroyProvider(this.name);
        }
        super.destroy();
    }

    public void testProvider() {
        try {
            Class.forName(this.name, true, TopManager.getDefault().currentClassLoader());
            this.setIconBase("org/netbeans/modules/jndi/resources/" + JndiIcons.getIconName(DRIVER));
            this.fireIconChange();
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JndiRootNode.getLocalizedString("MSG_CLASS_FOUND"), 1));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.setIconBase("org/netbeans/modules/jndi/resources/" + JndiIcons.getIconName(DISABLED_DRIVER));
            this.fireIconChange();
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JndiRootNode.getLocalizedString("MSG_CLASS_NOT_FOUND"), 1));
        }
    }

    public void connectUsing() {
        try {
            ((JndiDataType)JndiRootNode.getDefault().getNewTypes()[0]).create(this.name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Component getCustomizer() {
        JndiSystemOption jndiSystemOption = this.getSettings();
        if (jndiSystemOption != null) {
            Customizer customizer = new Customizer(jndiSystemOption.getProviders(false).get(this.name));
            return customizer;
        }
        return null;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void updateData(String string, Object object, Object object2) {
        this.firePropertyChange(string, object, object2);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx((class$org$netbeans$modules$jndi$ProviderNode == null ? (class$org$netbeans$modules$jndi$ProviderNode = ProviderNode.class$("org.netbeans.modules.jndi.ProviderNode")) : class$org$netbeans$modules$jndi$ProviderNode).getName());
    }

    private JndiSystemOption getSettings() {
        if (this.settings == null) {
            this.settings = (JndiSystemOption)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jndi$settings$JndiSystemOption == null ? (class$org$netbeans$modules$jndi$settings$JndiSystemOption = ProviderNode.class$("org.netbeans.modules.jndi.settings.JndiSystemOption")) : class$org$netbeans$modules$jndi$settings$JndiSystemOption));
        }
        return this.settings;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Customizer
    extends NewProviderPanel
    implements FocusListener,
    ListDataListener {
        private ProviderProperties target;

        Customizer(Object object) {
            this.target = (ProviderProperties)object;
            this.factory.setText(this.target.getFactory());
            this.context.setText(this.target.getContext());
            this.context.addFocusListener(this);
            this.root.setText(this.target.getRoot());
            this.root.addFocusListener(this);
            this.authentification.setText(this.target.getAuthentification());
            this.authentification.addFocusListener(this);
            this.principal.setText(this.target.getPrincipal());
            this.principal.addFocusListener(this);
            this.credentials.setText(this.target.getCredentials());
            this.credentials.addFocusListener(this);
            this.properties.setData(this.target.getAdditional());
            this.properties.addListDataListener(this);
            this.factory.setEditable(false);
            this.factory.addFocusListener(this);
        }

        public void focusLost(FocusEvent focusEvent) {
            String string;
            String string2;
            if (focusEvent.getSource() == this.context) {
                String string3;
                String string4 = this.context.getText();
                if (!string4.equals(string3 = this.target.getContext())) {
                    this.target.setContext(this.context.getText());
                    ProviderNode.this.updateData("java.naming.provider.url", string3, string4);
                }
            } else if (focusEvent.getSource() == this.authentification) {
                String string5;
                String string6 = this.authentification.getText();
                if (!string6.equals(string5 = this.target.getAuthentification())) {
                    this.target.setAuthentification(this.authentification.getText());
                    ProviderNode.this.updateData("java.naming.security.authentication", string5, string6);
                }
            } else if (focusEvent.getSource() == this.credentials) {
                String string7;
                String string8 = this.credentials.getText();
                if (!string8.equals(string7 = this.target.getCredentials())) {
                    this.target.setCredentials(this.credentials.getText());
                    ProviderNode.this.updateData("java.naming.security.credentials", string7, string8);
                }
            } else if (focusEvent.getSource() == this.principal) {
                String string9;
                String string10 = this.principal.getText();
                if (!string10.equals(string9 = this.target.getPrincipal())) {
                    this.target.setPrincipal(this.principal.getText());
                    ProviderNode.this.updateData("java.naming.security.principal", string9, string10);
                }
            } else if (focusEvent.getSource() == this.root && !(string2 = this.root.getText()).equals(string = this.target.getRoot())) {
                this.target.setRoot(this.root.getText());
                ProviderNode.this.updateData("HomePath", string, string2);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == this.factory) {
                this.factory.selectAll();
            }
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            if (listDataEvent.getSource() == this.properties) {
                Vector vector = this.properties.asVector();
                this.target.setAdditional(vector);
                ProviderNode.this.updateData("Additional", vector, null);
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            if (listDataEvent.getSource() == this.properties) {
                Vector vector = this.properties.asVector();
                this.target.setAdditional(vector);
                ProviderNode.this.updateData("Additional", vector, null);
            }
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (listDataEvent.getSource() == this.properties) {
                Vector vector = this.properties.asVector();
                this.target.setAdditional(vector);
                ProviderNode.this.updateData("Additional", vector, null);
            }
        }
    }
}

