/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jndi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.jndi.JndiRootNode;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;

public class ProviderProperties {
    public static final String ADDITIONAL = "Additional";
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Vector additional = new Vector();
    private String factory = "";
    private String context = "";
    private String credentials = "";
    private String authentification = "";
    private String principal = "";
    private String root = "";

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public final void setFactory(String string) {
        this.factory = string;
        this.firePropertyChange("factory", null, this.factory);
    }

    public final void setContext(String string) {
        this.context = string;
        this.firePropertyChange("context", null, this.context);
    }

    public final void setAuthentification(String string) {
        this.authentification = string;
        this.firePropertyChange("authentification", null, this.authentification);
    }

    public final void setCredentials(String string) {
        this.credentials = string;
        this.firePropertyChange("credentials", null, this.credentials);
    }

    public final void setPrincipal(String string) {
        this.principal = string;
        this.firePropertyChange("principal", null, this.principal);
    }

    public final void setAdditional(Vector vector) {
        this.additional = vector;
        this.firePropertyChange("additional", null, this.additional);
    }

    public final void setRoot(String string) {
        this.root = string;
        this.firePropertyChange("root", null, this.root);
    }

    public final String getFactory() {
        return this.factory;
    }

    public final String getContext() {
        return this.context;
    }

    public final String getAuthentification() {
        return this.authentification;
    }

    public final String getCredentials() {
        return this.credentials;
    }

    public final String getPrincipal() {
        return this.principal;
    }

    public final Vector getAdditional() {
        return this.additional;
    }

    public final Vector getAdditionalSave() {
        return (Vector)this.additional.clone();
    }

    public final String getRoot() {
        return this.root;
    }

    public Object getProperty(String string) {
        if (string.equals("java.naming.factory.initial")) {
            return this.getFactory();
        }
        if (string.equals("java.naming.provider.url")) {
            return this.getContext();
        }
        if (string.equals("java.naming.security.authentication")) {
            return this.getAuthentification();
        }
        if (string.equals("java.naming.security.principal")) {
            return this.getPrincipal();
        }
        if (string.equals("java.naming.security.credentials")) {
            return this.getCredentials();
        }
        if (string.equals("HomePath")) {
            return this.getRoot();
        }
        if (string.equals(ADDITIONAL) && this.additional != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.additional.size()) {
                stringBuffer.append((String)this.additional.elementAt(n));
                if (n != this.additional.size() - 1) {
                    stringBuffer.append("; ");
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public void setProperty(String string, Object object) {
        if (string.equals("java.naming.factory.initial")) {
            this.setFactory((String)object);
        } else if (string.equals("java.naming.provider.url")) {
            this.setContext((String)object);
        } else if (string.equals("java.naming.security.authentication")) {
            this.setAuthentification((String)object);
        } else if (string.equals("java.naming.security.principal")) {
            this.setPrincipal((String)object);
        } else if (string.equals("java.naming.security.credentials")) {
            this.setCredentials((String)object);
        } else if (string.equals("HomePath")) {
            this.setRoot((String)object);
        } else if (string.equals(ADDITIONAL)) {
            this.parseAdditional((String)object);
            this.firePropertyChange(ADDITIONAL, null, this.additional);
        }
    }

    public void load(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer;
            if ((string = string.trim()).startsWith("#") || (stringTokenizer = new StringTokenizer(string, "=")).countTokens() != 2) continue;
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = stringTokenizer.nextToken().trim();
            if (string2.equals("java.naming.factory.initial")) {
                this.factory = string3;
                continue;
            }
            if (string2.equals("java.naming.provider.url")) {
                this.context = string3;
                continue;
            }
            if (string2.equals("java.naming.security.authentication")) {
                this.authentification = string3;
                continue;
            }
            if (string2.equals("java.naming.security.principal")) {
                this.principal = string3;
                continue;
            }
            if (string2.equals("java.naming.security.credentials")) {
                this.credentials = string3;
                continue;
            }
            if (string2.equals("HomePath")) {
                this.root = string3;
                continue;
            }
            this.additional.addElement(string2 + "=" + string3);
        }
        bufferedReader.close();
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        printWriter.println("# " + string);
        printWriter.println("java.naming.factory.initial=" + this.factory);
        printWriter.println("java.naming.provider.url=" + this.context);
        printWriter.println("java.naming.security.authentication=" + this.authentification);
        printWriter.println("java.naming.security.principal=" + this.principal);
        printWriter.println("java.naming.security.credentials=" + this.credentials);
        printWriter.println("HomePath=" + this.root);
        int n = 0;
        while (n < this.additional.size()) {
            printWriter.println((String)this.additional.elementAt(n));
            ++n;
        }
        printWriter.flush();
        printWriter.close();
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        this.listeners.firePropertyChange(propertyChangeEvent);
    }

    private void parseAdditional(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        this.additional.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringTokenizer.nextToken();
            if (n2 == n - 1 && string2.length() < 3) break;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
            if (stringTokenizer2.countTokens() != 2) {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(JndiRootNode.getLocalizedString("EXC_ParseError") + " " + string2 + " " + JndiRootNode.getLocalizedString("EXC_ParseError2")), 0));
            } else {
                String string3 = stringTokenizer2.nextToken().trim();
                String string4 = stringTokenizer2.nextToken().trim();
                this.additional.addElement(string3 + "=" + string4);
            }
            ++n2;
        }
    }
}

