$ goto runide_start
$!*****************************************************************************
$!                                                                            *
$!                        Sun Public License Notice                           *
$!                                                                            *
$! The contents of this file are subject to the Sun Public License Version    *
$! 1.0 (the "License"). You may not use this file except in compliance with   *
$! the License. A copy of the License is available at http://www.sun.com/     *
$!                                                                            *
$!                                                                            *
$! The Original Code is the NetBeans IDE launcher for OpenVMS.                *
$! The Initial Developer of the Original Code is Compaq Computer Corporation. *
$! Portions created by Compaq Computer Corporation are Copyright (C) 2001.    *
$! All Rights Reserved.                                                       *
$!                                                                            *
$! Contributor(s): Compaq Computer Corporation.                               *
$!                                                                            *
$!*****************************************************************************
$!                                                                            *
$! If you have a problem or comment on this program, please send it to:       *
$!                                                                            *
$!                            NetBeans@compaq.com                             *
$!                                                                            *
$!*****************************************************************************
$!                                                                            *
$! OpenVMS NetBeans multiuser IDE launcher                                    *
$!                                                                            *
$!   Format:                                                                  *
$!                                                                            *
$!     @RUNIDEOPENVMS [userdir] [args1] [args2]                               *
$!                                                                            *
$!   Arguments:                                                               *
$!                                                                            *
$!     userdir                                                                *
$!                                                                            *
$!     VMS directory specification which will be used as the home directory   *
$!     for NetBeans user-specific files                                       *
$!                                                                            *
$!     args1                                                                  *
$!                                                                            *
$!     List of switches that will be passed to the Java Virtual Machine. You  *
$!     also specify NetBeans properties (e.g. -Dnetbeans.policy) here.        *
$!                                                                            *
$!     If the list contains more than one value or has lowercase characters   *
$!     which must be preserved, it must be enclosed within "". If the value   *
$!     contains a directory specification, it must be in Unix-style format    *
$!     (i.e. /dev/dir0/dir1/.../file.ext).                                    *
$!                                                                            *
$!     args2                                                                  *
$!                                                                            *
$!     List of switches that will be passed to the NetBeans IDE.              *
$!                                                                            *
$!     If the list contains more than one value or has lowercase characters   *
$!     which must be preserved, it must be enclosed within "". If the value   *
$!     contains a directory specification, it must be in Unix-style format    *
$!     (i.e. /dev/dir0/dir1/.../file.ext).                                    *
$!                                                                            *
$!     Description                                                            *
$!                                                                            *
$!     This command procedure is used to start the NetBeans IDE on an OpenVMS *
$!     system.                                                                *
$!                                                                            *
$!     There are several requirements for this program to work properly:      *
$!                                                                            *
$!         - RUNIDEOPENVMS.COM must either reside in the NetBeans bin         *
$!           directory and be run from there                                  *
$!           (e.g. @disk$:[netbeans.bin]runideopenvms)                        *
$!                                                                            *
$!           or                                                               *
$!                                                                            *
$!           The logical name NETBEANS$HOME must be defined with a string     *
$!           that points to the directory where NetBeans is installed         *
$!           (e.g. disk$:[netbeans.bin]                                       *
$!                                                                            *
$!           or                                                               *
$!                                                                            *
$!           You must specify the NetBeans property "netbeans.home=" on the   *
$!           command line with an appropriate directory path in Unix format   *
$!           (e.g. @RUNIDEOPENVMS "" "-Dnetbeans.home=/dev/netbeans/")        *
$!                                                                            *
$!         - The jdk for OpenVMS should be installed in SYS$COMMON:[JAVA$131] *
$!                                                                            *
$!           or                                                               *
$!                                                                            *
$!           The logical name NETBEANS$JDK_HOME must be defined with a string *
$!           that points to the directory where the jdk is installed          *
$!                                                                            *
$!           The launcher uses the FastVM for the main process.  This can be  *
$!           overridden using the logical name NETBEANS$CLASSIC_VM.           *
$!           If the value of the logical is 1, then the Classic VM will be    *
$!           instead of the FastVM.                                           *
$!                                                                            *
$!         - User process quotas must be sufficient                           *
$!                                                                            *
$!         - The CHANNELCNT sysgen value should be at least 2000              *
$!                                                                            *
$!     Examples:                                                              *
$!                                                                            *
$!         @RUNIDEOPENVMS USER$:[MYACCOUNT.NETBEANS]                          *
$!                                                                            *
$!         Starts NetBeans with the specified user directory. If the required *
$!         directory structure and files do not exist, the NetBeans IDE will  *
$!         create them automatically.                                         *
$!                                                                            *
$!         @RUNIDEOPENVMS "" "" "-fontsize 14"                                *
$!                                                                            *
$!         Starts NetBeans using a fontsize of 14. Note that null arguments   *
$!         ("") are required as placeholders and the quotes around the        *
$!         specified argument are optional for this example.                  *
$!                                                                            *
$!*****************************************************************************
$! 
$runide_start:
$
$ if f$edit("''P1'", "TRIM,UPCASE") .eqs. "-HELP" then $goto displayhelp
$
$ saved_verify = f$verify()
$ on error then goto error_handler
$ on control_y then goto done
$
$! We need parse_style extended for our process
$ set process/parse=extended
$
$! Constants
$ attributes_filename = "_nbattrs."
$ backup_char = "_"
$ jar_fs_refresh = 0
$ local_fs_refresh = 0
$ min_channelcnt = 2000
$ min_astlm = 300
$ min_biolm = 1024
$ min_bytlm = 2000000
$ min_rec_bytlm = 1990000
$ min_diolm = 1024
$ min_enqlm = 2000
$ min_fillm = 300
$ min_jtquota = 60000
$ min_pgflquota = 1500000
$ min_prclm = 10
$ min_tqelm = 400
$ min_wsextent = 524288
$ min_wsmax = 524288
$ temp_dir = "sys$scratch"
$
$! Check to see if we're debugging NetBeans
$!
$ if f$trnlnm("NETBEANS$DEBUG") .eqs. "1"
$ then
$   prev_classic_vm = F$TRNLNM("NETBEANS$CLASSIC_VM")
$!
$! Force the use of the classic VM since the FastVM doesn't support JPDA
$!
$   Define NETBEANS$CLASSIC_VM 1
$ endif
$! Define the NetBeans IDE entry point
$ ide = "org.netbeans.Main"
$
$! Define the NetBeans updater entry point
$ updater = "org.netbeans.updater.UpdaterFrame"
$
$! Get our PID (used for temporary files)
$ userpid = f$getjpi("", "PID")
$
$! NETBEANS$JDK_HOME, if defined, should point to the base directory of a Java
$! kit. This is used to locate things like the Java setup command procedure,
$! tools.jar, etc.
$ jdk_home = f$trnlnm("NETBEANS$JDK_HOME")
$ if jdk_home .eqs. ""
$ then
$   jdk_home = "sys$common:[java$131]"
$ endif
$
$ call convert_to_unix 'jdk_home' "unix_jdk_home"
$
$! Check if the Java setup command procedure from a different version of the
$! JDK that we'll be using was previously executed. We do this by seeing if
$! the symbol JAVA is defined and, if it is, extracting the Java version from
$! the symbol's value. If defined and different from what we're going to use,
$! display a message to the user that a CANCEL_SETUP command procedure must
$! be executed before running NetBeans.
$ if f$type(java) .nes. ""
$ then
$   java_version = f$edit(f$parse(java,,, "DIRECTORY"), "UPCASE")
$   java_version = f$element(0, ".", java_version) - "["
$   jdk_version = f$edit(((f$parse(jdk_home,,, "DIRECTORY") - "[") - "]"), "UPCASE")
$   if java_version .nes. jdk_version
$   then
$     cancel_procedure = (jdk_home - "]") + ".COM]" +java_version + "_CANCEL_SETUP.COM"
$     if f$search("''cancel_procedure'") .nes. ""
$     then
$       @'cancel_procedure'
$     else
$       write sys$output ""
$       write sys$output "Your process has symbol and logical name definitions that were created by a"
$       write sys$output "different version of Java than what will be used by the IDE. To run the IDE,"
$       write sys$output "you must execute a command procedure which will reset your process so that the"
$       write sys$output "required version of Java will run properly. The command procedure name is:"
$       write sys$output java_version, "_CANCEL_SETUP.COM"
$       write sys$output ""
$       write sys$output "If you do not have this file on your system, please refer to the "
$       write sys$output "release notes for information on obtaining this file."
$       write sys$output ""
$       exit
$     endif
$   endif
$ endif
$
$! Create the path to the NetBeans kit. If the NETBEANS$HOME logical is
$! defined, use its value as the NetBeans kit path. If not defined, assume
$! this command file is executed from one level below the NetBeans root
$! directory (typically device:[top_level_dir.netbeans.bin]). Determine the
$! kit's path from there.
$ nbhome = f$trnlnm("NETBEANS$HOME")
$ if nbhome .eqs. ""
$ then
$   nbhome_ = f$env("PROCEDURE")
$   nbhome_ = F$PARSE(nbhome_,,,"DEVICE") + F$PARSE(nbhome_,,,"DIRECTORY")
$   nbhome_ = nbhome_ - "]" + ".-]"
$   nbhome = F$PARSE(nbhome_,,,"DEVICE") + F$PARSE(nbhome_,,,"DIRECTORY")
$ endif
$
$! Convert the NetBeans kit path to unix format
$ call convert_to_unix 'nbhome' "unix_nbhome"
$
$! Build the name of a few directories used during update
$
$ global_update_dir = nbhome - "]" + ".update.download]"
$ mod_dir           = nbhome - "]" + ".modules]"
$ mod_doc_dir       = nbhome - "]" + ".modules.docs]"
$ 
$! Check to make sure that some critical quotas for running NetBeans are
$! sufficient and warn the user if any are not
$ error_count == 0
$ call check_quota "ASTLM" min_astlm min_astlm error_count
$ call check_quota "BIOLM" min_biolm min_biolm error_count
$ call check_quota "BYTLM" min_bytlm min_rec_bytlm error_count
$ call check_quota "DIOLM" min_diolm min_diolm error_count
$ call check_quota "ENQLM" min_enqlm min_enqlm error_count
$ call check_quota "FILLM" min_fillm min_fillm error_count
$ call check_quota "PGFLQUOTA" min_pgflquota min_pgflquota error_count
$ call check_quota "PRCLM" min_prclm min_prclm error_count
$ call check_quota "TQLM" min_tqelm min_tqelm error_count "TQELM"
$ call check_quota "WSEXTENT" min_wsextent min_wsextent error_count
$ call check_sysgen_param "CHANNELCNT" min_channelcnt min_channelcnt error_count
$ call check_sysgen_param "WSMAX" min_wsmax min_wsmax error_count
$ if error_count .ne. 0
$ then
$   write sys$output ""
$   write sys$output "Warning:  The IDE may not start or work properly until all quotas are"
$   write sys$output "          set to at least their recommended minimum values.
$   write sys$output ""
$ endif
$
$! Determine the NetBeans user directory
$!
$ userdir = P1
$ if userdir .eqs. ""
$ then
$   userdir = f$trnlnm("NETBEANS$USER")
$   if userdir .eqs. ""
$   then
$!    Use the default
$     userdir = f$trnlnm("sys$login") - "]" + ".netbeans.3_4]"
$   endif
$ endif
$ if userdir .eqs. "" then goto done
$ if f$getdvi(f$parse(userdir,,, "DEVICE"), "ACPTYPE") .nes. "F11V5"
$ then
$   write sys$output ""
$   write sys$output "Your user directory (''userdir') must reside"
$   write sys$output "on an ODS-5 device!"
$   write sys$output ""
$   goto done
$ endif
$ write sys$output ""
$ write sys$output "Using ''userdir' as user directory..."
$ write sys$output ""
$ call convert_to_unix 'userdir' "unix_userdir"
$
$! Directory which will contain updates
$ update_dir = userdir - "]" + ".update.download]"
$
$! Create the environment file used by NetBeans
$ env_filename = "''temp_dir':nbenv" + userpid + ".dat"
$ call convert_to_unix 'env_filename' "unix_nbenv"
$ open/write env_file 'env_filename'
$ vms_home = f$trnlnm("sys$login")
$ call convert_to_unix 'vms_home' "unix_home"
$ write env_file "HOME=", unix_home
$ close env_file
$
$! Set up the Java environment for NetBeans
$ gosub setup_nb_env
$
$! Flag that this is our first start
$ first_run = "T"
$
$restart:
$
$! Create the JVM command file
$ 
$ cmd_filename = "''temp_dir':nbcmd" + userpid + ".dat"
$ open/write cmd_file 'cmd_filename'
$
$! Initialize the class path symbol builder
$ call init_add_symbol
$
$! Create the classpath and write it to the command file
$ call find_jars userdir "lib.patches.locale"
$ call find_jars userdir "lib.patches" 
$ call find_jars userdir "lib.locale" 
$ call find_jars userdir "lib"
$ call find_jars userdir "lib.ext.locale" 
$ call find_jars userdir "lib.ext" 
$ call find_jars nbhome "lib.patches.locale"
$ call find_jars nbhome "lib.patches" 
$ call find_jars nbhome "lib.locale" 
$ call find_jars nbhome "lib" 
$ call find_jars nbhome "lib.ext.locale" 
$ call find_jars nbhome "lib.ext" 
$ call find_jars jdk_home "lib..." 
$
$! Create a symbol containing the list of symbols
$ call create_concat_symbol "nb$symsym"
$
$! Write the classpath to the command file
$ write/symbol cmd_file "-cp ", 'nb$symsym'
$
$ if f$trnlnm("NETBEANS$DEBUG") .eqs. "1"
$ then
$! Run in debug mode, first get a free port
$   db_port = 9000
$   def sys$output nl:
$   def sys$error nl:
$   set noon
$get_port_loop:
$   if (db_port .le. 9200)
$   then
$     ucx sho dev /port='db_port'
$     if (('$status' .and. 1) .eq. 1)
$     then
$       db_port = db_port + 1
$       goto get_port_loop
$     endif
$     deas sys$output
$     deas sys$error
$     set on
$   else
$     write sys$output "Could not find a free port - try again later"
$     goto done
$   endif
$   write sys$output "*****************************************************"
$   write sys$output "* Starting the IDE in debug mode using port ", db_port, "    *"
$   write sys$output "*                                                   *"
$   write sys$output "* To connect from your client instance of the IDE,  *"
$   write sys$output "* click Debug->Attach and fill in the following:    *"
$   write sys$output "*                                                   *"
$   write sys$output "*    Debugger Type:  Default debugger (JPDA)        *"
$   write sys$output "*    Transport:      dt_socket                      *"
$   write sys$output "*    Host:           <enter the name of this node>  *"
$   write sys$output "*    Port:           ", db_port, "                           *"
$   write sys$output "*                                                   *"
$   write sys$output "* Note that the IDE will appear to hang at the      *"
$   write sys$output "* ""Starting the IDE..."" message until you have      *"
$   write sys$output "* attached.                                         *"
$   write sys$output "*****************************************************"
$   write sys$output ""
$   ! Add the debug switches to the command file
$   write cmd_file "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,address=''db_port'"
$ endif
$ set noverify
$
$! Cleanup the global symbols we created to make the really long 
$! classpath
$ call cleanup_symbols
$
$ max_heap = f$getjpi("", "WSEXTENT") / 2048
$
$ if f$trnlnm("NETBEANS$CLASSIC_VM") .eqs. "1"
$ then
$
$!
$!  For Classic VM, set both the initial and max heap sizes
$!
$   initial_heap = 32
$   write cmd_file "-Xmx''max_heap'm"
$
$! For Classic VM set the stack size using the -oss switch
$!
$   write cmd_file "-oss1m"
$ else
$!   
$!  Pick the initial heap and max heap.  Make sure not to use all the WSEXTENT
$!  for max heap or we'll page lots.
$!
$   if max_heap .gt. 200 
$   then 
$     initial_heap = 100
$     max_heap = 200
$   else
$     initial_heap = max_heap/2
$     max_heap = max_heap - 50
$   endif
$!
$!  For the FASTVM Set the stack size...according to Rae the -Xss switch 
$!  is used by the FastVM to set the DECThreads stack size
$!
$   write cmd_file "-Xss300k"
$!
$!  For the FASTVM use the compacting garbage collector
$!
$!   write cmd_file "-Xgc:compacting"
$
$ endif
$
$ write cmd_file "-Xms''initial_heap'm"
$ write cmd_file "-Xmx''max_heap'm"
$
$! Read the ide configuration file and write the contents into cmd_file
$! Sets up symbols nb_cmds and java_cmds
$!
$ java_cmds == ""
$ nb_cmds == ""
$
$ call read_ide_cfg_file
$
$ java_cmds == java_cmds + " " + P2
$ nb_cmds == nb_cmds + " " + P3
$
$! NetBeans user directory property
$ write cmd_file "-Dnetbeans.user=", f$edit("''unix_userdir'", "LOWERCASE")
$
$ unix_nbhome = f$edit("''unix_nbhome'", "LOWERCASE")
$!
$! NetBeans home directory property
$ write cmd_file "-Dnetbeans.home=", unix_nbhome
$
$! NetBeans security property
$ write cmd_file "-Djava.security.policy=", unix_nbhome, "/bin/ide.policy"
$
$! NetBeans local file system refresh interval
$ write cmd_file "-Dorg.openide.filesystems.LocalFileSystem.REFRESH_TIME=", local_fs_refresh
$
$! NetBeans jar file system refresh interval
$ write cmd_file "-Dorg.openide.filesystems.JarFileSystem.REFRESH_TIME=", jar_fs_refresh
$
$! NetBeans attributes file name
$! Removed begining in NetBeans 3.3
$! write cmd_file "-Dorg.openide.filesystems.DefaultAttributes.ATTR_NAME_EXT_XML=", attributes_filename
$
$! NetBeans backup file character
$! Removed begining in NetBeans 3.3
$! write cmd_file "-Dorg.netbeans.core.ExLocalFileSystem.BACKUP_EXT=", backup_char
$
$! NetBeans OS environment file property
$ write cmd_file "-Dnetbeans.osenv=", f$edit("''unix_nbenv'", "LOWERCASE")
$
$! Define jdk.home property
$ write cmd_file "-Djdk.home=''unix_jdk_home'"
$
$! Set the keyboard type property, if necessary
$ if f$trnlnm("NETBEANS$KEYBOARD_TYPE_DEC") .EQS. "1"
$ then
$   write cmd_file "-DStartup.OpenVMS.edtkeypad.DECkeyboard=true"
$ endif
$
$! Start the NetBeans/FFJ IDE
$ write sys$output ""
$ write sys$output "Starting the IDE..."
$ write sys$output ""
$ close cmd_file
$! The JVM will hang if verify is on, so shut it off but save the current state
$ saved_verify = f$verify(0)
$
$! If the user downloaded one or more modules the last time the IDE was
$! used and chose to defer installation, we need to run the IDE updater
$! now
$!
$ if first_run
$ then
$   first_run = "F"
$!  If the user downloaded one or more new modules and chose to install
$!  them immediately, we need to run the IDE updater and restart
$!
$
$   call check_for_updates
$ 
$   if (NBinstall_later) .and. (NBrun_update) 
$   then
$     java -V 'cmd_filename' 'java_cmds' 'updater' 'nb_cmds'
$     call check_protections_on_update_files
$   endif
$ endif
$!
$! Really start the IDE
$ java -V 'cmd_filename' 'java_cmds' 'ide' 'nb_cmds'
$
$! If the user downloaded one or more new modules and chose to install
$! them immediately, we need to run the IDE updater and restart
$!
$ call check_for_updates
$
$ if .not. (NBinstall_later) .and. (NBrun_update) 
$ then
$   java -V 'cmd_filename' 'java_cmds' 'updater' 'nb_cmds'
$   call check_protections_on_update_files
$   goto restart
$ endif
$
$! Finished. Delete the command files, perform some clean up, restore the
$! verify state and exit
$done:
$ close/nolog cmd_file
$ close/nolog env_file
$ call delete_update_symbols
$ if f$search("''cmd_filename'", 1) .nes. ""
$ then
$   delete 'cmd_filename';*
$ endif
$ if f$search("''env_filename'", 1) .nes. ""
$ then
$   delete 'env_filename';*
$ endif
$ modules_dir = userdir - "]" + ".modules]"
$ if f$search("''modules_dir'installedModules.xml", 1) .nes. ""
$ then
$   purge 'modules_dir'installedModules.xml
$ endif
$ if f$search("''modules_dir'externalizedModules.ser", 1) .nes. ""
$ then
$   purge 'modules_dir'externalizedModules.ser
$ endif
$
$ exit:
$
$ if f$type(nb_cmds) .nes. "" then delete/symbol/global nb_cmds
$ if f$type(java_cmds) .nes. "" then delete/symbol/global java_cmds
$
$ if f$trnlnm("NETBEANS$DEBUG") .eqs. "1"
$ then
$   if prev_classic_vm .nes. ""
$   then
$     Define/nolog NETBEANS$CLASSIC_VM 'prev_classic_vm'
$   else
$     Deassign NETBEANS$CLASSIC_VM
$   endif
$ endif
$
$ saved_verify = f$verify('saved_verify')
$ exit
$ 
$ java_version_too_old:
$ write sys$output " "
$ write sys$output " ***  NetBeans requires Java version 1.3.1 or later. ***"
$ write sys$output " "
$ goto exit
$
$ no_java:
$ write sys$output " "
$ write sys$output " ***  You must run the Java setup command procedure before invoking NetBeans ***"
$ write sys$output " "
$ goto exit
$
$ displayhelp:
$ write sys$output " "
$ write sys$output " OpenVMS NetBeans multiuser IDE launcher help                               "
$ write sys$output " "
$ write sys$output "   General requirements:"
$ write sys$output " "
$ write sys$output "     This version of NetBeans requires Java 1.3.1 or later"
$ write sys$output "     and the FastVM version 1.3.1 or later."
$ write sys$output " "
$ write sys$output "   Command Format:"
$ write sys$output " "
$ write sys$output "     @RUNIDEOPENVMS [userdir|-help] [args1] [args2]                               "
$ write sys$output " "
$ write sys$output "   Arguments:                                                               "
$ write sys$output " "
$ write sys$output "     userdir or -help"
$ write sys$output " "
$ write sys$output "     VMS directory specification which will be used as the home directory   "
$ write sys$output "     for NetBeans user-specific files                                       "
$ write sys$output " "
$ write sys$output "     If this argument is specified as -help, this text is displayed."
$ write sys$output " "
$ write sys$output "     args1"
$ write sys$output " "
$ write sys$output "     List of switches that will be passed to the Java Virtual Machine. You  "
$ write sys$output "     also specify NetBeans properties (e.g. -Dnetbeans.policy) here.        "
$ write sys$output " "
$ write sys$output "     If the list contains more than one value or has lowercase characters   "
$ write sys$output "     which must be preserved, it must be enclosed within """". If the value "
$ write sys$output "     contains a directory specification, it must be in Unix-style format    "
$ write sys$output "     (i.e. /dev/dir0/dir1/.../file.ext).                                    "
$ write sys$output " "
$ write sys$output "     args2                                                                  "
$ write sys$output " "
$ write sys$output "     List of switches that will be passed to the NetBeans IDE.  See the     "
$ write sys$output "     NetBeans documentation for a description of switches that can be passed "
$ write sys$output "     to the IDE."
$ write sys$output " "
$ write sys$output "     If the list contains more than one value or has lowercase characters   "
$ write sys$output "     which must be preserved, it must be enclosed within """". If the value "
$ write sys$output "     contains a directory specification, it must be in Unix-style format    "
$ write sys$output "     (i.e. /dev/dir0/dir1/.../file.ext).                                    "
$ write sys$output " "
$ write sys$output "   Description:                                                            "
$ write sys$output " "
$ write sys$output "     This command procedure is used to start the NetBeans IDE on an OpenVMS "
$ write sys$output "     system.                                                                "
$ write sys$output " "
$ write sys$output "     There are several requirements for this program to work properly:      "
$ write sys$output " "
$ write sys$output "         - RUNIDEOPENVMS.COM must reside in the NetBeans bin         "
$ write sys$output "           directory and be run from there                                  "
$ write sys$output "           (e.g. @disk$:[netbeans.bin]runideopenvms)                        "
$ write sys$output " "
$! write sys$output "           or                                                               "
$! write sys$output " "
$! write sys$output "           The logical name NETBEANS$HOME must be defined with a string     "
$! write sys$output "           that points to the directory where NetBeans is installed         "
$! write sys$output "           (e.g. disk$:[netbeans.bin]                                       "
$! write sys$output " "
$! write sys$output "           or                                                               "
$! write sys$output " "
$! write sys$output "           You must specify the NetBeans property ""netbeans.home="" on the "
$! write sys$output "           command line with an appropriate directory path in Unix format   "
$! write sys$output "           (e.g. @RUNIDEOPENVMS """" ""-Dnetbeans.home=/dev/netbeans/"")    "
$! write sys$output " "
$ write sys$output "         - The JDK for OpenVMS should be installed in SYS$COMMON:[JAVA$131] "
$ write sys$output " "
$ write sys$output "           or                                                               "
$ write sys$output " "
$ write sys$output "           The logical name NETBEANS$JDK_HOME must be defined with a string "
$ write sys$output "           that points to the directory where the JDK is installed          "
$ write sys$output " "
$ write sys$output "         - User process quotas must be sufficient                           "
$ write sys$output " "
$ write sys$output "         - The CHANNELCNT sysgen value should be at least 2000              "
$ write sys$output " "
$ write sys$output "   Logical Names to Control NetBeans  "
$ write sys$output " "
$ write sys$output "         NETBEANS$CLASSIC_VM "
$ write sys$output "             When defined to the value 1, will force the use of "
$ write sys$output "             the classic VM, rather than the default FastVM."
$ write sys$output " "
$ write sys$output "         NETBEANS$KEYBOARD_TYPE_DEC "
$ write sys$output "             When defined to the value 1, will set the logical "
$ write sys$output "             JAVA$KEYBOARD_TYPE_DEC and pass a switch to NetBeans for proper" 
$ write sys$output "             EDT keypad support when the EDTKeypad add-in module is loaded."
$ write sys$output " "
$ write sys$output "         NETBEANS$JDK_HOME "
$ write sys$output "             Supports an alternate JDK home directory.  When defined, should "
$ write sys$output "             point to the directory where the JDK is installed.             "
$ write sys$output " "
$! write sys$output "         NETBEANS$HOME "
$! write sys$output "             The logical name NETBEANS$HOME must be defined with a string     "
$! write sys$output "             that points to the directory where NetBeans is installed         "
$! write sys$output "             (e.g. disk$:[netbeans.bin]                                       "
$! write sys$output " "
$ write sys$output "   IDE Configuration File (ideopenvms.cfg)  "
$ write sys$output " "
$ write sys$output "         The IDE configuration file can contain Java and NetBeans switches "
$ write sys$output "         that should be used each time the IDE is started.  An empty "
$ write sys$output "         configuration file is shipped with NetBeans in the same directory "
$ write sys$output "         as the launcher.  "
$ write sys$output " "
$ write sys$output "   Examples:  "
$ write sys$output " "
$ write sys$output "         @RUNIDEOPENVMS USER$:[MYACCOUNT.NETBEANS]                          "
$ write sys$output " "
$ write sys$output "         Starts NetBeans with the specified user directory. If the required "
$ write sys$output "         directory structure and files do not exist, the NetBeans IDE will  "
$ write sys$output "         create them automatically.                                         "
$ write sys$output " "
$ write sys$output "         @RUNIDEOPENVMS """" """" ""-fontsize 14""                          "
$ write sys$output " "
$ write sys$output "         Starts NetBeans using a fontsize of 14. Note that null arguments   "
$ write sys$output "         ("""") are required as placeholders and the quotes around the      "
$ write sys$output "         specified argument are optional for this example.                  "
$ write sys$output " "
$ goto exit
$! ==============================================================================================
$! Deal with any errors. Simply let the user know something went wrong and
$! display the status code
$!
$error_handler:
$ write sys$output "An error occurred; exit status = ", $status
$ goto done
$
$! Subroutines:
$!
$
$!==================================================================================
$!
$ read_ide_cfg_file: subroutine
$ cmd_proc = f$environment("PROCEDURE")
$ cmd_proc_dir = f$parse(cmd_proc,,, "DEVICE") + f$parse(cmd_proc,,, "DIRECTORY")
$ cfg_file = "''cmd_proc_dir'ideopenvms.cfg"
$ if f$search("''cfg_file'") .eqs. "" Then goto eos
$
$ write sys$output "Reading configuration file ''cfg_file'..."
$ write sys$output ""
$
$ open/read cfg 'cfg_file'
$
$ rloop:
$   read/end=eof cfg cfg_line
$!  extract the first char...if it's a -, then we have an option line,
$!  otherwise, treat as comment and ignore
$!
$   str = f$extract(0,1,cfg_line)
$   if str .eqs. "-" 
$   then
$     str = f$extract(1,1,cfg_line)
$     if str .eqs. "J"			! to be passed to Java
$     then
$       str = f$extract(2,f$length(cfg_line)-2, cfg_line)
$       java_cmds == java_cmds + "-" + str + " "
$     else				! to be passed to NetBeans
$       nb_cmds == nb_cmds + cfg_line + " "
$     endif
$   else
$       goto rloop
$   endif
$   goto rloop
$
$ eof:
$ close cfg
$!
$!
$ eos:
$ endsubroutine   
$! Look for .jar and .zip files down the tree pointed to by P1 and P2.
$! The result is returned in the symbol named by P3
$!
$find_jars: subroutine
$ h = 'P1' - "]"
$top1:
$ x = f$search("''h'.''P2']*.jar", 1)
$ if x .nes. ""
$ then
$   vfs = f$parse(x,,,"DEVICE") + f$parse(x,,,"DIRECTORY") +-
          f$parse(x,,,"NAME") + f$edit(f$parse(x,,,"TYPE"), "LOWERCASE")
$   call convert_to_unix "''vfs'" "ufs"
$   ufs == ufs + ":"
$   call add_symbol ufs 
$   goto top1
$ endif
$top2:
$ x = f$search("''h'.''P2']*.zip", 1)
$ if x .nes. ""
$ then
$   vfs = f$parse(x,,,"DEVICE") + f$parse(x,,,"DIRECTORY") +-
          f$parse(x,,,"NAME") + f$edit(f$parse(x,,,"TYPE"), "LOWERCASE")
$   call convert_to_unix "''vfs'" "ufs"
$   ufs == ufs + ":"
$   call add_symbol ufs 
$   goto top2
$ endif
$
$ endsubroutine
$
$!==================================================================================
$! This is a very simple routine to convert from a VMS style filespec to
$! a Unix style filespec.  The VMS filespec is passed in P2 and the Unix
$! filespec result is returned in the symbol named by P1
$!
$convert_to_unix: subroutine
$ x = P1
$ du = "/" + f$parse(x,,,"DEVICE") - ":"
$ d = f$parse(x,,,"DIRECTORY") - "[" - "]" - "<" - ">"
$ count = 0
$cu_top:
$ e = f$element(count, ".", d)
$ if e .eqs. "." then goto cu_bottom
$ du = du + "/" + e
$ count = count + 1
$ goto cu_top
$cu_bottom:
$ f = f$parse(x,,,"NAME") + f$parse(x,,,"TYPE")
$ if f .nes. "."
$ then
$   du = du + "/" + f
$ endif
$ 'P2' == du
$
$ endsubroutine
$
$!==================================================================================
$! Test a particular process quota against a minimum value. If the quota
$! is not at least the minimum value, display a warning message to the
$! user with the recommended minimum setting.
$!
$! P1 is a string that is the name of the quota in F$GETJPI, P2 is the minimum 
$! value for that the quota, and P3 is the recommended minimum value that is 
$! displayed to the user. The symbol named in P4 is incremented if the specified
$! quota is below the minimum value. P5 is the name of the quota when using the 
$! AUTHORIZE utility (since that's what the user will need to use to change the
$! quota).
$!
$check_quota: subroutine
$ quota_val = f$getjpi("","''P1'")
$ if P5 .nes. "" 
$ then
$   quota_name = P5
$ else
$   quota_name = P1
$ endif
$ if quota_val .lt. 'P3'
$ then
$   write sys$output "The ''quota_name' quota for your process is too low"
$   write sys$output "    Actual: ''quota_val'; recommended minimum: ", 'P3'
$   'P4' == 'P4' + 1
$ endif
$
$ endsubroutine
$
$!==================================================================================
$! Test a particular sysgen parameter against a minimum value. If the param
$! is not at least the minimum value, display a warning message to the
$! user with the recommended minimum setting.
$!
$! P1 is a string that is the name of the param, P2 is the minimum value for
$! that the param, and P3 is the recommended minimum value that is displayed
$! to the user. The symbol named in P4 is incremented if the specified param
$! is below the minimum value.
$!
$check_sysgen_param: subroutine
$ param_val = f$getsyi("''P1'")
$ if param_val .lt. 'P3'
$ then
$   write sys$output "The ''P1' SYSGEN parameter value for your system is too low"
$   write sys$output "    Actual: ''param_val'; recommended minimum: ", 'P3'
$   'P4' == 'P4' + 1
$ endif
$
$ endsubroutine
$
$!==================================================================================
$ check_for_updates: subroutine
$!
$ NBinstall_later == (f$search("''update_dir'install_later.xml") .nes. "") .or. -
                     (f$search("''global_update_dir'install_later.xml") .nes. "")
$ NBnew_local_module == (f$search("''update_dir'*.nbm") .nes. "")
$ NBnew_global_module == (f$search("''global_update_dir'*.nbm") .nes. "")
$ NBrun_update == NBnew_local_module .or. NBnew_global_module
$ exit
$ endsubroutine
$! 
$!==================================================================================
$ delete_update_symbols: subroutine
$! 
$ if f$type(NBinstall_later) .nes. "" then delete/symbol/global NBinstall_later
$ if f$type(NBnew_local_module) .nes. "" then delete/symbol/global NBnew_local_module
$ if f$type(NBnew_global_module) .nes. "" then delete/symbol/global NBnew_global_module
$ if f$type(NBrun_update) .nes. "" then delete/symbol/global NBrun_update
$ exit
$ endsubroutine
$! 
$!==================================================================================
$ check_protections_on_update_files: subroutine
$ if NBnew_global_module
$ then
$!
$!    If this was a global module install then we must fix the protection
$!
$   set file/prot=w:re 'mod_dir'*.*
$   set file/prot=w:re 'mod_doc_dir'*.*
$ endif
$ exit
$ endsubroutine
$!
$!==================================================================================
$ init_add_symbol: subroutine
$! 
$ scount == 0 
$ nbcursym0 :== ""
$ exit
$ endsubroutine
$!
$!
$!==================================================================================
$ add_symbol: subroutine
$
$ newstr = 'P1'
$ newstr = f$edit("''newstr'", "LOWERCASE")
$!
$! see if there is room in the current symbol for this string
$!
$ len = f$length(nbcursym'scount')
$ lenn = f$length(newstr)
$ totlen = len + lenn
$ if (totlen) .gt. 255
$ then                       ! no room, need to create new symbol
$    scount == scount + 1
$    nbcursym'scount' :== ""
$ endif
$!
$ nbcursym'scount' == nbcursym'scount' + newstr
$!
$ exit
$ endsubroutine
$!
$!
$!==================================================================================
$ create_concat_symbol: subroutine
$!
$ nbsymsym := ""
$ i = 0
$ iloop:
$   if (i .ge. scount) then goto endloop
$! 
$   nbsymsym = nbsymsym + "nbcursym''i', "
$   i = i + 1
$   goto iloop
$ endloop:
$   nbsymsym = nbsymsym + "nbcursym''i'"
$!
$ 'P1' == nbsymsym
$!
$ exit
$ endsubroutine
$!
$!==================================================================================
$ cleanup_symbols: subroutine
$ i = 0
$ iloop2:
$   if (i .gt. scount) then goto endloop2
$! 
$   delete/symbol/global nbcursym'i'
$   i = i + 1
$   goto iloop2
$ endloop2:
$
$ delete/symbol/global scount
$ delete/symbol/global nb$symsym
$ exit
$ endsubroutine 
$!
$
$!==================================================================================
$! Command procedure to set up the environment before running
$! NetBeans
$!
$setup_nb_env:
$
$ jdk_root = jdk_home - "]"
$!
$! Save the current value of the define symbol so we can restore it later
$ old_define := 'F$TYPE(define)'
$ if old_define .nes. "" then old_define_str := 'define'
$!
$! Re-define the define symbol so the logicals get put in the job table
$ define :== define/job/nolog
$
$! In case we were previously using the FastVM for NetBeans in this process
$! ...deassign the logicals
$!
$ if f$trnlnm("JAVA$JVM_G_SHR", "LNM$PROCESS") .nes. "" 
$ then 
$   deassign/process JAVA$JVM_G_SHR 
$ endif
$!
$ if f$trnlnm("JAVA$JVM_SHR", "LNM$PROCESS") .nes. "" 
$ then 
$   deassign/process JAVA$JVM_SHR
$ endif
$!
$! Call the JAVA setup command procedure with our altered "define" symbol. All
$! this trickery is to insure that the classic VM is used for sub-processes 
$! spawned from within NetBeans, while NetBeans itself uses the FastVM
$!
$ setup_file = F$SEARCH("''jdk_root'.com]java$%%%_setup.com")
$ @'setup_file'
$! If the logical name NETBEANS$CLASSIC_VM is set to 1, then don't 
$! use the FastVM.
$!
$ if f$trnlnm("NETBEANS$CLASSIC_VM") .eqs. "1"
$ Then
$   Goto Skip_Fastvm
$ Endif
$!
$! Re-define the define symbol so we don't get warnings if we try to define a
$! logical that is already defined
$ define :== define/nolog
$
$! Point our process at the fastVM, but confine the definition so that all
$! subprocess use the classic VM.  This is a hack because fastVM V1.3 doesn't
$! support the -Xdebug switch.
$ define /name_attributes=confine JAVA$JVM_G_SHR -
      'jdk_root'.JRE.LIB.ALPHA.FASTVM]JAVA$FVM_G_SHR.EXE;
$ define /name_attributes=confine JAVA$JVM_SHR -
      'jdk_root'.JRE.LIB.ALPHA.FASTVM]JAVA$FVM_SHR.EXE;
$
$ Skip_FastVM:
$
$! Turn on "all version" deletion and rename.  This makes File.delete() and
$! File.rename() operate on all versions of a file
$ define JAVA$DELETE_ALL_VERSIONS true
$ define JAVA$RENAME_ALL_VERSIONS true
$ define JAVA$CREATE_ONE_VERSION true
$ define JAVA$CREATE_DIR_WITH_OWNER_DELETE true
$ define JAVA$READDIR_CASE_DISABLE true
$ define JAVA$DISABLE_MULTIDOT_DIRECTORY_STAT true
$ define JAVA$CACHING_INTERVAL 120
$ if f$trnlnm("NETBEANS$KEYBOARD_TYPE_DEC") .EQS. "1"
$ then
$   define JAVA$KEYBOARD_TYPE_DEC true
$ endif
$!
$! For debugging, define this logical to have the JVM show you the files it is
$! opening
$!
$! define JAVA$SHOW_FILENAME_MAPPING 1
$
$! Enable unix-like file sharing
$!
$ define/job JAVA$FILE_OPEN_MODE 3
$!
$! For forking, use sockets if TCPIP is started
$!
$ if f$trnlnm("TCPIP$DEVICE") .NES. ""
$ then
$     Define/job JAVA$FORK_PIPE_STYLE 2
$ else
$     Define/job JAVA$FORK_PIPE_STYLE 1
$ endif
$!
$! Now set up the JAVA file control bits
$!
$! Set file controls for ODS-5
$ JAVA$M_UNIX_AND_VMS  = 8
$ option_string = JAVA$M_UNIX_AND_VMS
$ define/job JAVA$FILENAME_CONTROLS 'option_string'
$
$! Define the DECC logicals necessary to run NetBeans
$ define/job  DECC$ARGV_PARSE_STYLE         ENABLE
$ define/job  DECC$EFS_CASE_PRESERVE        ENABLE
$ define/job  DECC$POSIX_SEEK_STREAM_FILE   ENABLE
$ define/job  DECC$EFS_CHARSET              ENABLE
$ define/job  DECC$ENABLE_GETENV_CACHE      ENABLE
$ define/job  DECC$FILE_PERMISSION_UNIX     ENABLE
$ define/job  DECC$FIXED_LENGTH_SEEK_TO_EOF ENABLE
$ define/job  DECC$RENAME_NO_INHERIT        ENABLE
$
$! Reset the define symbol back to what it was before we changed it
$ if old_define .eqs. "" 
$ then 
$     delete/symbol/global define
$ else
$     define :== 'old_define_str'
$ endif
$
$! All done
$ return
$
$!*****************************************************************************
$!                                                                            *
$! Change history:                                                            *
$!                                                                            *
$! 07/22/2002 - (MWG) Change user directory to [.netbeans.3_4] for release34  *
$!                      branch.                                               *
$! 07/17/2002 - (MWG) Issue 25756.  Change jdk.home to Unix syntax for correct*
$!                      processing on the command line.                       *
$!                    Change user directory to [.netbeans.dev] for trunk.     * 
$! 07/12/2002 - (MWG) Issue 25591.  MOdify check_quota to work when the quota *
$!                      name is different when using F$GETJPI and AUTHORIZE.  *
$!                      (TQLM/TQELM)                                          *
$! 06/01/2002 - (MWG) Issues 24746 and 24307                                  * 
$!                    Set jdk.home property on command line.                  *
$!                    Set DECC$RENAME_NO_INHERIT to allow rename of .nbattrs  *
$!                    Check sysgen param WSMAX to make sure it is at least    *
$!                      as large as WSEXTENT for the process.                 *
$!                    Remove MULTI_DOT_KEEP_LAST from filename control bitmask*
$!                    Even better performance improvement by using            *
$!                      JAVA$DISABLE_MULTIDOT_DIRECTORY_STAT                  *
$!                      JAVA$FORK_PIPE_STYLE 2 (if TCPIP)                     *
$!                      JAVA$FIXED_LENGTH_SEEK_TO_EOF (removes STRMLF         *
$!                      requirement)                                          *
$!                      JAVA$CREATE_ONE_VERSION                               *
$!                    Add /job qualifier to defines                           *
$!                    Change JAVA$FILE_OPEN_MODE to 3 for performance         *
$!                      improvement.                                          *
$!                      Add check for minimum CHANNELCNT.                     *
$!                    Don't document NETBEANS$HOME in -help.  Fix a couple of *
$!                      -help typos.                                          *
$!                                                                            *
$! 03/18/2002 - (MWG) Support for debugging NetBeans.  Additional logicals    *
$!                      for DEC$ and JAVA$.                                   *
$!                      Bug fix for quota checking.                           *
$!                                                                            *
$! 02/06/2002 - (MWG) Fixes to make global module installs work.              *
$!                                                                            *
$! 01/28/2002 - (MWG) Changes after tuning analysis:                          *
$!                      Change initial and max heap...don't use up WSEXTENT.  *
$!                      Use default garbage collection algorithm.             *
$!                      Lower stack size for each thread.gorithm.             *
$!                      Enable DECC$enable_getenv_cache.                      *
$!                                                                            *
$! 01/10/2002 - (ttran) Use nbdev as the default user directory for           *
$!                      development version.                                  *
$!                                                                            *
$! 01/07/2002 - (MWG) Add support for using a configuration file.             *
$!                    The file is ideopenvms.cfg.                             *
$!                                                                            *
$! 12/13/2001 - (MWG) Add NETBEANS$CLASSIC_VM logical.                        *
$!                    Set initial heap depending on VM being used.            *
$!                    Set stacksize to 1m                                     *
$!                    Define JAVA$READDIR_CASE_DISABLE.                       *
$!                    Support for NETBEANS$KEYBOARD_TYPE_DEC.                 *
$!                                                                            *
$! 12/03/2001 - (MWG) Remove setting of properties for backup extension and   *
$!                    attributes filename.                                    *
$!                    Remove -Xmx setting to let FastVM figure it out.        *
$!                    Change settings for JAVA$ bits to reflect ODS-5         *
$!                    support in the latest CRTL.                             *
$!                    Define proper DECC$ logical for ODS-5 filename support. *
$!                                                                            *
$! 11/13/2001 - (MWG) Implement -help as argument.                            *
$!                                                                            *
$! 10/29/2001 - (MWG) Use nbuser33 as the default user directory.             *
$!                                                                            *
$! 09/24/2001 - (MWG) Find the proper JAVA setup file to execute.  Make       *
$!              Java 1.3.1 the default.                                       *
$!                                                                            *
$! 07/10/2001 - Added changes to support new behavior of updating the IDE.    *
$!              The user can now elect to defer the installation of any down- *
$!              loaded modules until the next time the IDE is run. We now     *
$!              check for this situation and if true, run the updater before  *
$!              starting the IDE.                                             *
$!                                                                            *
$! 06/06/2001 - (MWG) Rework the creation of the classpath to use an arbitrary*
$!              number of symbols.                                            *
$!              Make sure that all file specs are in lower case.              *
$!              Change output messages to use the word IDE rather than        *
$!              NetBeans so that the script can be used with Forte for Java.  *
$!                                                                            *
$! 05/23/2001 - Modify the check_quota routine to accept a reported value     *
$!              argument. This is for the BYTLM quota for which f$getjpi()    *
$!              returns the authorized quota minus any long-term allocated    *
$!              memory. We can now check for a minimum value that is          *
$!              different from the minimum value that the user sees when a    *
$!              warning message is displayed.                                 *
$!                                                                            *
$! 05/17/2001 - Check to see if the JAVA$xxx_SETUP.COM of a different version *
$!              of Java has been executed by the user. If so, try to run the  *
$!              associated JAVA$xxx_CANCEL procedure. If it can't be found,   *
$!              tell the user they must run it themselves.                    *
$!                                                                            *
$! 04/25/2001 - Moved "set process/parse=extended" from the setup_nb_env      *
$!              subroutine so it is executed earlier.                         *
$!                                                                            *
$! 04/04/2001 - Changed the logical JDK$HOME to NETBEANS$JDK_HOME and did     *
$!              some minor cleanup.                                           *
$!                                                                            *
$! 03/28/2001 - Added test to check that the user directory resides on an     *
$!              ODS-5 device. Added /nolog qualifier to the setup_nb_env      *
$!              routine so we no longer get DCL warnings.                     *
$!                                                                            *
$! 03/27/2001 - Fix three problems with the find_jars subroutine:             *
$!                                                                            *
$!                1) Entries being added to the classpath were being up-cased *
$!                   due to missing "" around a parameter in a subroutine     *
$!                   call                                                     *
$!                                                                            *
$!                2) ZIP file entries in the classpath were not being         *
$!                   converted to Unix format                                 *
$!                                                                            *
$!                3) File extensions in the classpath are now forced to lower *
$!                   case. This is due to a Javac requirement.                *
$!                                                                            *
$! 03/20/2001 - A file is now created with the basic environment variables    *
$!              required to run NetBeans (for now, just HOME) and the name of *
$!              this file is passed via the netbeans.osenv property. This was *
$!              necessary due to changes made to NetBeans for V3.2.           *
$!                                                                            *
$! 03/13/2001 - Added a subroutine to setup the Java environment for          *
$!              NetBeans.                                                     *
$!                                                                            *
$! 03/09/2001 - Removed the code which creates the user directory if it does  *
$!              not exist since this is now done by the IDE. Due to this      *
$!              change, the file containing the JVM command line arguments    *
$!              was moved from the user directory to sys$scratch.             *
$!                                                                            *
$!              JVM arguments were added to the command file to set the       *
$!              refresh rates for the local and jar file systems.             *
$!                                                                            *
$! 03/08/2001 - Fixed a problem that was preventing the updater from running  *
$!              and added a loop to restart the IDE after an update.          *
$!                                                                            *
$! 03/01/2001 - Added some quota checks and the ability to pass arguments on  *
$!              the command line to the JVM and NetBeans.                     *
$!                                                                            *
$! 02/23/2001 - The home directory of the JDK and the NetBeans kits can now   *
$!              be defined with the logical names JDK$HOME and                *
$!              NETBEANS$HOME respectively.                                   *
$!                                                                            *
$! 02/22/2001 - All JVM commands are now written to a file and the VM is      *
$!              started with the "-V filname" switch. This change was made    *
$!              to enable a classpath up to 2048 characters in length.        *
$!                                                                            *
$!              The user directory is now determined in the following         *
$!              sequence:                                                     *
$!                                                                            *
$!                  1) If an argument was entered on the command line, it is  *
$!                     assumed to be the user directory specification         * 
$!                                                                            *
$!                  2) If no argument was entered, the logical name           *
$!                     NETBEANS$USERS is checked. If this logical is defined, *
$!                     its value is used as the root directory of where       *
$!                     the NetBeans user files are kept. To differentiate     *
$!                     this particular user, the current user's account name  *
$!                     is appended to the value of NETBEANS$USERS.            *
$!                                                                            *
$!                  3) If neither of the above conditions is met, NBUSER is   *
$!                     appended to the value of SYS$LOGIN and that is used as *
$!                     the user directory.                                    *
$!                                                                            *
$! 02/21/2001 - Reduced the initial and maximum heap size arguments to the VM *
$!              to force more frequent garbage collection. This is a work-    *
$!              around to fix a VM assert error which cropped up in newer     *
$!              NetBeans development builds.                                  *
$!                                                                            *
$!*****************************************************************************
