/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.gj;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.netbeans.lib.javac.v8.code.ClassReader;
import org.netbeans.lib.javac.v8.code.ClassWriter;
import org.netbeans.lib.javac.v8.code.Symbol;
import org.netbeans.lib.javac.v8.comp.Attr;
import org.netbeans.lib.javac.v8.comp.AttrContext;
import org.netbeans.lib.javac.v8.comp.Check;
import org.netbeans.lib.javac.v8.comp.Enter;
import org.netbeans.lib.javac.v8.comp.Env;
import org.netbeans.lib.javac.v8.comp.Flow;
import org.netbeans.lib.javac.v8.comp.Gen;
import org.netbeans.lib.javac.v8.comp.Infer;
import org.netbeans.lib.javac.v8.comp.Resolve;
import org.netbeans.lib.javac.v8.comp.Symtab;
import org.netbeans.lib.javac.v8.comp.TransInner;
import org.netbeans.lib.javac.v8.comp.TransTypes;
import org.netbeans.lib.javac.v8.tree.Pretty;
import org.netbeans.lib.javac.v8.tree.Tree;
import org.netbeans.lib.javac.v8.tree.TreeMaker;
import org.netbeans.lib.javac.v8.util.Abort;
import org.netbeans.lib.javac.v8.util.Hashtable;
import org.netbeans.lib.javac.v8.util.List;
import org.netbeans.lib.javac.v8.util.ListBuffer;
import org.netbeans.lib.javac.v8.util.Log;
import org.netbeans.lib.javac.v8.util.Name;
import org.netbeans.modules.java.gj.JavaCompilerType;
import org.netbeans.modules.java.gj.ProgressConsumer;
import org.netbeans.modules.java.gj.V8ClassReader;
import org.netbeans.modules.java.gj.V8ClassWriter;
import org.netbeans.modules.java.gj.V8EngineBase;
import org.netbeans.modules.java.gj.V8FileEntry;
import org.netbeans.modules.java.gj.V8Log;
import org.netbeans.modules.java.parser.ParseObjectRequest;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V8Engine
extends V8EngineBase
implements ClassReader.SourceCompleter {
    Gen gen;
    ClassWriter classWriter;
    Hashtable<Tree.TopLevel, FileObject> sourceFiles;
    private ProgressConsumer progressConsumer;
    private static final boolean DEBUG_TIME = false;
    public boolean sourceOutput;
    public boolean classOutput;
    public boolean printFlat;
    public boolean deprecation;
    public boolean warnunchecked;
    ListBuffer<Env<AttrContext>> todo = new ListBuffer();
    static /* synthetic */ Class class$org$openide$compiler$ExternalCompiler;

    protected V8Engine(V8Log v8Log, Symtab symtab, Hashtable<String, String> hashtable) {
        super(v8Log, (V8ClassReader)symtab.reader, hashtable);
        this.syms = symtab;
        this.make = new TreeMaker();
        this.sourceFiles = Hashtable.make();
    }

    protected V8Engine(V8Log v8Log, V8ClassReader v8ClassReader, ClassWriter classWriter, Hashtable<String, String> hashtable) {
        super(v8Log, v8ClassReader, hashtable);
        this.classWriter = classWriter;
        this.make = new TreeMaker();
        this.sourceFiles = Hashtable.make();
    }

    @Override
    protected void loadOptions() {
        super.loadOptions();
        this.sourceOutput = this.options.get((Object)"-s") != null;
        this.classOutput = this.options.get((Object)"-retrofit") == null;
        this.printFlat = this.options.get((Object)"-printflat") != null;
        this.deprecation = this.options.get((Object)"-deprecation") != null;
        this.warnunchecked = this.options.get((Object)"-warnunchecked") != null;
    }

    @Override
    protected boolean needFullInit() {
        return true;
    }

    @Override
    protected void fullInit() {
        this.inputFiles.reset();
        this.syms = new Symtab((ClassReader)this.classReader, this.classWriter);
        this.infer = new Infer((Log)this.log, this.syms);
        this.chk = new Check((Log)this.log, this.syms, this.options);
        this.rs = new Resolve((Log)this.log, this.syms, this.chk, this.infer);
        this.attr = new Attr((Log)this.log, this.syms, this.rs, this.chk, this.infer, this.make, null, this.options);
        this.enter = new Enter((Log)this.log, this.syms, this.rs, this.chk, this.make, this.attr, this.todo);
        this.gen = new Gen((Log)this.log, this.syms, this.chk, this.rs, this.make, this.options);
    }

    public static V8Engine make(V8Log v8Log, Hashtable<String, String> hashtable) {
        try {
            return new V8Engine(v8Log, new V8ClassReader(hashtable), new V8ClassWriter(hashtable), hashtable);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            v8Log.error(0, completionFailure.getMessage());
            return null;
        }
    }

    public static V8Engine make(Hashtable<String, String> hashtable) {
        hashtable.put((Object)"-bootclasspath", (Object)"");
        return V8Engine.make(new V8Log(), hashtable);
    }

    public static V8Engine make() {
        Hashtable hashtable = Hashtable.make();
        return V8Engine.make((Hashtable<String, String>)hashtable);
    }

    private static V8Engine createFromOptions(JavaCompilerType javaCompilerType) {
        String string;
        Hashtable hashtable = Hashtable.make();
        if (javaCompilerType.getDebug()) {
            hashtable.put((Object)"-g", (Object)"");
        }
        if (javaCompilerType.getOptimize()) {
            hashtable.put((Object)"-O", (Object)"");
        }
        if (javaCompilerType.getDeprecation()) {
            hashtable.put((Object)"-deprecation", (Object)"");
        }
        if (javaCompilerType.getCharEncoding() != null) {
            hashtable.put((Object)"-encoding", (Object)javaCompilerType.getCharEncoding());
        }
        if (javaCompilerType.isGjEnabled()) {
            hashtable.put((Object)"-gj", (Object)"");
        }
        if (javaCompilerType.isSource14Enabled()) {
            hashtable.put((Object)"-source", (Object)"1.4");
        }
        if (javaCompilerType.isWarnUnchecked()) {
            hashtable.put((Object)"-warnunchecked", (Object)"");
        }
        if ((string = javaCompilerType.getTargetJDK()) != null && string.length() > 0) {
            hashtable.put((Object)"-target", (Object)string);
        }
        V8Engine v8Engine = V8Engine.make((Hashtable<String, String>)hashtable);
        if (javaCompilerType.getOutputDirectory() != null) {
            ((V8ClassWriter)v8Engine.classWriter).outDirectory = javaCompilerType.getOutputDirectory();
        }
        V8ClassReader v8ClassReader = v8Engine.classReader;
        return v8Engine;
    }

    public static V8Engine get(JavaCompilerType javaCompilerType) {
        return V8Engine.createFromOptions(javaCompilerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printSource(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        FileObject fileObject = ((V8ClassWriter)this.syms.writer).outputFileObject(classDef.sym, ".java", (FileObject)this.sourceFiles.get((Object)env.toplevel));
        if (this.inputFiles.contains((Object)fileObject)) {
            this.log.error(classDef.pos, "source.cant.overwrite.input.file", fileObject.toString());
        } else {
            FileLock fileLock;
            block6: {
                fileLock = fileObject.lock();
                PrintStream printStream = null;
                try {
                    printStream = new PrintStream(new BufferedOutputStream(fileObject.getOutputStream(fileLock)));
                    new Pretty(printStream).printUnit(env.toplevel, classDef);
                    if (this.verbose) {
                        this.printVerbose("wrote.file", V8FileEntry.toString(fileObject));
                    }
                    Object var7_6 = null;
                    if (printStream == null) break block6;
                    printStream.close();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (printStream != null) {
                        printStream.close();
                    }
                    fileLock.releaseLock();
                    throw throwable;
                }
            }
            fileLock.releaseLock();
            {
            }
        }
    }

    void genCode(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        this.gen.genClass(env, classDef);
        this.writeClass(classDef.sym, (FileObject)this.sourceFiles.get((Object)env.toplevel));
    }

    void writeClass(final Symbol.ClassSymbol classSymbol, FileObject fileObject) throws IOException {
        final Object object = ((V8ClassWriter)this.syms.writer).outputFileObject(classSymbol, ".class", false, fileObject);
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            public void run() throws IOException {
                V8Engine.this.doWriteClass(classSymbol, V8Engine.makeFileObject(object, ".class"));
            }
        };
        V8Engine.getAny(object).getFileSystem().runAtomicAction(atomicAction);
    }

    private static FileObject getAny(Object object) {
        if (object instanceof FileObject) {
            return (FileObject)object;
        }
        return (FileObject)((Object[])object)[0];
    }

    private static FileObject makeFileObject(Object object, String string) throws IOException {
        if (object instanceof FileObject) {
            return (FileObject)object;
        }
        Object[] objectArray = (Object[])object;
        FileObject fileObject = (FileObject)objectArray[0];
        String string2 = (String)objectArray[1];
        return fileObject.createData(string2, string.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteClass(Symbol.ClassSymbol classSymbol, FileObject fileObject) throws IOException {
        FileLock fileLock = fileObject.lock();
        BufferedOutputStream bufferedOutputStream = null;
        this.progress(fileObject, 3);
        try {
            bufferedOutputStream = new BufferedOutputStream(fileObject.getOutputStream(fileLock));
            this.syms.writer.writeClassFile((OutputStream)bufferedOutputStream, classSymbol);
            if (this.verbose) {
                this.printVerbose("wrote.file", V8FileEntry.toString(fileObject));
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fileLock.releaseLock();
            if (bufferedOutputStream != null) {
                ((OutputStream)bufferedOutputStream).close();
            }
            throw throwable;
        }
        fileLock.releaseLock();
        if (bufferedOutputStream != null) {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    @Override
    protected Tree.TopLevel parse(FileObject fileObject, char[] cArray, ParseObjectRequest parseObjectRequest, boolean bl) {
        Tree.TopLevel topLevel = super.parse(fileObject, cArray, parseObjectRequest, bl);
        this.sourceFiles.put((Object)topLevel, (Object)fileObject);
        return topLevel;
    }

    public List<Symbol.ClassSymbol> compile(List<FileObject> list) throws Throwable {
        int n;
        this.initialize(true);
        long l = System.currentTimeMillis();
        ListBuffer listBuffer = new ListBuffer();
        try {
            V8Engine.checkInterrupt();
            ListBuffer listBuffer2 = new ListBuffer();
            List list2 = list;
            while (list2.nonEmpty()) {
                try {
                    listBuffer2.append((Object)this.parse((FileObject)list2.head));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                V8Engine.checkInterrupt();
                list2 = list2.tail;
            }
            this.enter.main(listBuffer2.toList());
            while (this.todo.nonEmpty()) {
                Env env = (Env)this.todo.first();
                this.todo.remove();
                if (this.verbose) {
                    this.printVerbose("checking.attribution", env.enclClass.sym.toJava());
                }
                Name name = this.log.useSource(env.enclClass.sym.sourcefile);
                this.attr.attribClass(env.tree.pos, env.enclClass.sym);
                V8Engine.checkInterrupt();
                TreeMaker treeMaker = new TreeMaker(env.toplevel);
                if (this.errorCount() == 0) {
                    new Flow((Log)this.log, this.syms, this.chk, treeMaker, false).analyzeDef(env.tree);
                    V8Engine.checkInterrupt();
                }
                if (this.errorCount() == 0) {
                    env.tree = new TransTypes((Log)this.log, this.syms, treeMaker).translateTopLevelClass(env.tree);
                    V8Engine.checkInterrupt();
                }
                if (this.errorCount() == 0) {
                    Tree.ClassDef classDef = null;
                    try {
                        if (this.sourceOutput) {
                            classDef = (Tree.ClassDef)env.tree;
                            this.printSource((Env<AttrContext>)env, classDef);
                        } else {
                            List list3;
                            V8Engine.checkInterrupt();
                            List list4 = list3 = new TransInner((Log)this.log, this.syms, this.rs, this.chk, this.attr, treeMaker).translateTopLevelClass(env, env.tree);
                            while (this.errorCount() == 0 && list4.nonEmpty()) {
                                classDef = (Tree.ClassDef)list4.head;
                                if (this.printFlat) {
                                    this.printSource((Env<AttrContext>)env, classDef);
                                } else if (this.classOutput) {
                                    V8Engine.checkInterrupt();
                                    this.genCode((Env<AttrContext>)env, classDef);
                                }
                                listBuffer.append((Object)classDef.sym);
                                list4 = list4.tail;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        this.log.error(classDef.pos, "class.cant.write", classDef.sym.toJava(), iOException.getMessage());
                    }
                }
                this.log.useSource(name);
            }
        }
        catch (Abort abort) {
            // empty catch block
        }
        if (this.verbose) {
            this.printVerbose("total", Long.toString(System.currentTimeMillis() - l));
        }
        if (this.chk.deprecatedSource != null && !this.deprecation) {
            this.noteDeprecated(this.chk.deprecatedSource.toString());
        }
        if (this.chk.uncheckedSource != null && !this.warnunchecked) {
            this.noteUnchecked(this.chk.uncheckedSource.toString());
        }
        if ((n = this.errorCount()) == 1) {
            this.printCount("error", n);
        } else {
            this.printCount("error.plural", n);
        }
        if (this.log.nwarnings == 1) {
            this.printCount("warn", this.log.nwarnings);
        } else {
            this.printCount("warn.plural", this.log.nwarnings);
        }
        return listBuffer.toList();
    }

    private void noteDeprecated(String string) {
        if (string.equals("*")) {
            this.log.note("deprecated.plural");
        } else {
            this.log.note("deprecated.filename", string);
        }
        this.log.note("deprecated.recompile");
    }

    void noteUnchecked(String string) {
        if (string.equals("*")) {
            this.log.note("unchecked.plural");
        } else {
            this.log.note("unchecked.filename", string);
        }
        this.log.note("unchecked.recompile");
    }

    void printCount(String string, int n) {
        if (n != 0) {
            this.log.println(V8Log.getLocalizedString((String)new StringBuffer().append("count.").append(string).toString(), (String)Integer.toString(n)));
        }
    }

    public void setProgressConsumer(ProgressConsumer progressConsumer) {
        this.progressConsumer = progressConsumer;
    }

    @Override
    protected void progress(FileObject fileObject, int n) {
        if (this.progressConsumer != null) {
            this.progressConsumer.progress(fileObject, n);
        }
    }

    static void checkInterrupt() throws InterruptedThread {
        if (Thread.interrupted()) {
            throw new InterruptedThread();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class InterruptedThread
    extends Error {
        public InterruptedThread() {
            super(InterruptedThread.getMsg());
        }

        static String getMsg() {
            return NbBundle.getBundle((Class)(class$org$openide$compiler$ExternalCompiler == null ? (class$org$openide$compiler$ExternalCompiler = V8Engine.class$("org.openide.compiler.ExternalCompiler")) : class$org$openide$compiler$ExternalCompiler)).getString("CTL_Interrupted");
        }
    }
}

