/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.mx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicMBeanProxy
implements DynamicMBean {
    Object real;
    String name;
    Method[] methods;
    Hashtable attMap = new Hashtable();
    Hashtable getAttMap = new Hashtable();
    Hashtable setAttMap = new Hashtable();
    Hashtable invokeAttMap = new Hashtable();
    static MBeanServer mserver = null;
    static Hashtable instances = new Hashtable();
    static final Object[] NO_ARGS_PARAM = new Object[0];
    private static Log log = LogFactory.getLog(class$org$apache$tomcat$util$mx$DynamicMBeanProxy != null ? class$org$apache$tomcat$util$mx$DynamicMBeanProxy : (class$org$apache$tomcat$util$mx$DynamicMBeanProxy = DynamicMBeanProxy.class$("org.apache.tomcat.util.mx.DynamicMBeanProxy")));
    static /* synthetic */ Class class$org$apache$tomcat$util$mx$DynamicMBeanProxy;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method m = (Method)this.getAttMap.get(attribute);
        if (m == null) {
            throw new AttributeNotFoundException(attribute);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.valueOf(this.real.getClass().getName()) + " getAttribute " + attribute);
            }
            return m.invoke(this.real, NO_ARGS_PARAM);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            throw new MBeanException(ex);
        }
        catch (InvocationTargetException ex1) {
            ex1.printStackTrace();
            throw new MBeanException(ex1);
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList al = new AttributeList();
        if (attributes == null) {
            return null;
        }
        int i = 0;
        while (i < attributes.length) {
            try {
                Attribute att = new Attribute(attributes[i], this.getAttribute(attributes[i]));
                al.add(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
        return al;
    }

    public MBeanInfo getMBeanInfo() {
        try {
            MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[this.attMap.size()];
            Enumeration en = this.attMap.keys();
            int i = 0;
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                attributes[i++] = new MBeanAttributeInfo(name, "Attribute " + name, (Method)this.getAttMap.get(name), (Method)this.setAttMap.get(name));
            }
            MBeanOperationInfo[] operations = new MBeanOperationInfo[this.invokeAttMap.size()];
            en = this.invokeAttMap.keys();
            i = 0;
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                Method m = (Method)this.invokeAttMap.get(name);
                if (m != null && name != null) {
                    operations[i++] = new MBeanOperationInfo(name, m);
                    continue;
                }
                System.out.println("Null arg " + name + " " + m);
            }
            if (log.isDebugEnabled()) {
                log.debug(String.valueOf(this.real.getClass().getName()) + " getMBeanInfo()");
            }
            return new MBeanInfo(this.real.getClass().getName(), "MBean for " + this.getName(), attributes, new MBeanConstructorInfo[0], operations, new MBeanNotificationInfo[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static MBeanServer getMBeanServer() {
        if (mserver == null) {
            mserver = MBeanServerFactory.findMBeanServer(null).size() > 0 ? MBeanServerFactory.findMBeanServer(null).get(0) : MBeanServerFactory.createMBeanServer();
        }
        return mserver;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.real == null) {
            return null;
        }
        this.name = this.real.getClass().getName();
        this.name = this.name.substring(this.name.lastIndexOf(".") + 1);
        Integer iInt = (Integer)instances.get(this.name);
        if (iInt != null) {
            int i = iInt;
            instances.put(this.name, new Integer(++i));
            this.name = String.valueOf(this.name) + "_" + i;
        } else {
            instances.put(this.name, new Integer(0));
        }
        return this.name;
    }

    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        Method m = (Method)this.invokeAttMap.get(method);
        if (m == null) {
            return null;
        }
        try {
            log.info(String.valueOf(this.real.getClass().getName()) + "invoke " + m.getName());
            return m.invoke(this.real, NO_ARGS_PARAM);
        }
        catch (IllegalAccessException ex) {
            throw new MBeanException(ex);
        }
        catch (InvocationTargetException ex1) {
            throw new MBeanException(ex1);
        }
    }

    public void registerMBean(String domain) {
        try {
            ObjectName oname = new ObjectName(String.valueOf(domain) + ": name=" + this.getName());
            DynamicMBeanProxy.getMBeanServer().registerMBean(this, oname);
        }
        catch (Throwable t) {
            log.error("Error creating mbean ", t);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method m = (Method)this.setAttMap.get(attribute.getName());
        if (m == null) {
            throw new AttributeNotFoundException(attribute.getName());
        }
        try {
            log.info(String.valueOf(this.real.getClass().getName()) + "setAttribute " + attribute.getName());
            m.invoke(this.real, attribute.getValue());
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            throw new MBeanException(ex);
        }
        catch (InvocationTargetException ex1) {
            ex1.printStackTrace();
            throw new MBeanException(ex1);
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        Iterator attE = ((AbstractList)attributes).iterator();
        while (attE.hasNext()) {
            Attribute att = (Attribute)attE.next();
            try {
                this.setAttribute(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return attributes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReal(Object realBean) {
        this.real = realBean;
        this.methods = this.real.getClass().getMethods();
        int j = 0;
        while (j < this.methods.length) {
            String name = this.methods[j].getName();
            if (name.startsWith("get")) {
                Class<?> ret;
                if (this.methods[j].getParameterTypes().length == 0 && Modifier.isPublic(this.methods[j].getModifiers()) && this.supportedType(ret = this.methods[j].getReturnType())) {
                    name = DynamicMBeanProxy.unCapitalize(name.substring(3));
                    this.getAttMap.put(name, this.methods[j]);
                    this.attMap.put(name, this.methods[j]);
                }
            } else if (!name.startsWith("is")) {
                if (name.startsWith("set")) {
                    Class<?> ret;
                    Class<?>[] params = this.methods[j].getParameterTypes();
                    if (params.length == 1 && Modifier.isPublic(this.methods[j].getModifiers()) && this.supportedType(ret = params[0])) {
                        name = DynamicMBeanProxy.unCapitalize(name.substring(3));
                        this.setAttMap.put(name, this.methods[j]);
                        this.attMap.put(name, this.methods[j]);
                    }
                } else if (this.methods[j].getParameterTypes().length == 0 && this.methods[j].getDeclaringClass() != (class$java$lang$Object != null ? class$java$lang$Object : DynamicMBeanProxy.class$("java.lang.Object")) && Modifier.isPublic(this.methods[j].getModifiers())) {
                    this.invokeAttMap.put(name, this.methods[j]);
                }
            }
            ++j;
        }
    }

    private boolean supportedType(Class ret) {
        return ret == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = DynamicMBeanProxy.class$("java.lang.String"))) || ret == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = DynamicMBeanProxy.class$("java.lang.Integer"))) || ret == Integer.TYPE || ret == (class$java$io$File != null ? class$java$io$File : (class$java$io$File = DynamicMBeanProxy.class$("java.io.File"))) || ret == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = DynamicMBeanProxy.class$("java.lang.Boolean")));
    }

    public static String unCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }
}

