/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.netbeans.modules.debugger.CoreBreakpoint;

public abstract class BreakpointGroup
implements Serializable {
    static final long serialVersionUID = 3680012002191932551L;
    public static final String PROP_BREAKPOINTS = "breakpoints";
    public static final String PROP_GROUPS = "groups";
    public static final String PROP_NAME = "name";
    public static final String PROP_PARENT_GROUP = "parentGroup";
    protected transient PropertyChangeSupport pcs;
    private BreakpointGroup parent = null;
    private HashMap breakpoints = new HashMap();
    private CoreBreakpoint[] breakpointsCache;
    private HashMap groups = new HashMap();
    private BreakpointGroup[] groupsCache;
    private String name;

    public BreakpointGroup() {
        this.init();
    }

    protected void init() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = this.name;
        this.name = string;
        this.firePropertyChange(PROP_NAME, string2, this.name);
    }

    public BreakpointGroup getParentGroup() {
        return this.parent;
    }

    protected boolean setParentGroup(BreakpointGroup breakpointGroup) {
        if (this.parent == breakpointGroup) {
            return true;
        }
        BreakpointGroup breakpointGroup2 = this.parent;
        if (this.parent != null) {
            this.parent = null;
            if (!breakpointGroup2.removeGroup(this)) {
                this.parent = breakpointGroup2;
                return false;
            }
        }
        this.parent = breakpointGroup;
        if (breakpointGroup != null && !breakpointGroup.addGroup(this)) {
            this.parent = breakpointGroup2;
            this.parent.addGroup(this);
            return false;
        }
        this.firePropertyChange(PROP_PARENT_GROUP, breakpointGroup2, this.parent);
        return true;
    }

    public CoreBreakpoint[] getBreakpoints() {
        if (this.breakpointsCache != null) {
            return this.breakpointsCache;
        }
        this.breakpointsCache = new CoreBreakpoint[this.breakpoints.size()];
        this.breakpoints.keySet().toArray(this.breakpointsCache);
        return this.breakpointsCache;
    }

    public BreakpointGroup[] getGroups() {
        if (this.groupsCache != null) {
            return this.groupsCache;
        }
        this.groupsCache = new BreakpointGroup[this.groups.size()];
        this.groups.keySet().toArray(this.groupsCache);
        return this.groupsCache;
    }

    public boolean addBreakpoint(CoreBreakpoint coreBreakpoint) {
        if (this.breakpoints.containsKey(coreBreakpoint)) {
            return true;
        }
        BreakpointGroup breakpointGroup = coreBreakpoint.getGroup();
        if (breakpointGroup != null) {
            coreBreakpoint.setGroup(null);
            if (!breakpointGroup.removeBreakpoint(coreBreakpoint)) {
                coreBreakpoint.setGroup(breakpointGroup);
                return false;
            }
        }
        coreBreakpoint.setGroup(this);
        this.breakpointsCache = null;
        this.breakpoints.put(coreBreakpoint, coreBreakpoint);
        this.firePropertyChange(PROP_BREAKPOINTS, null, coreBreakpoint);
        return true;
    }

    public boolean removeBreakpoint(CoreBreakpoint coreBreakpoint) {
        if (!this.breakpoints.containsKey(coreBreakpoint)) {
            return true;
        }
        coreBreakpoint.setGroup(null);
        this.breakpointsCache = null;
        this.breakpoints.remove(coreBreakpoint);
        this.firePropertyChange(PROP_BREAKPOINTS, coreBreakpoint, null);
        return true;
    }

    public boolean addGroup(BreakpointGroup breakpointGroup) {
        if (this.groups.containsKey(breakpointGroup)) {
            return true;
        }
        this.groups.put(breakpointGroup, breakpointGroup);
        if (!breakpointGroup.setParentGroup(this)) {
            this.groups.remove(breakpointGroup);
            return false;
        }
        this.groupsCache = null;
        this.firePropertyChange(PROP_GROUPS, null, breakpointGroup);
        return true;
    }

    public boolean removeGroup(BreakpointGroup breakpointGroup) {
        if (!this.groups.containsKey(breakpointGroup)) {
            return true;
        }
        this.groups.remove(breakpointGroup);
        if (!breakpointGroup.setParentGroup(null)) {
            this.groups.put(breakpointGroup, breakpointGroup);
            return false;
        }
        this.groupsCache = null;
        this.firePropertyChange(PROP_GROUPS, breakpointGroup, null);
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }
}

