/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.multisession;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.execution.ExecInfo;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DebuggerExecutor
extends ProcessExecutor {
    static final long serialVersionUID = 1440216775212461457L;
    public static String PROP_DEBUGGER_EXECUTOR_TYPE = "debuggerExecutorType";
    public static String PROP_CLASSIC_SWITCH = "classicSwitch";
    public static final String PROP_ASSERT_ENABLED = "assertEnabled";
    static final NbProcessDescriptor[] DEFAULT;
    static String[] description;
    private static boolean[] classicPreferred;
    private static boolean classicPreferredResolved;
    private NbProcessDescriptor[] debuggerProcess;
    private Integer selectedType;
    private boolean[] classicValue = new boolean[]{false, false};
    private boolean[] isClassicSet = new boolean[]{false, false};
    private boolean bootClassPathSetManually = false;
    private boolean assertEnabled = false;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$multisession$DebuggerExecutor;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.classicValue == null) {
            this.classicValue = new boolean[]{false, false};
        }
        if (this.isClassicSet == null) {
            this.isClassicSet = new boolean[]{false, false};
        }
        if (this.debuggerProcess == null || this.selectedType == null) {
            this.init();
        }
        this.initBootClassPath();
    }

    private void init() {
        this.selectedType = new Integer(0);
        this.bootClassPathSetManually = false;
        this.debuggerProcess = new NbProcessDescriptor[DEFAULT.length];
        int n = 0;
        while (n < DEFAULT.length) {
            this.debuggerProcess[n] = DEFAULT[n];
            ++n;
        }
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$DebuggerExecutor == null ? (class$org$netbeans$modules$debugger$multisession$DebuggerExecutor = DebuggerExecutor.class$("org.netbeans.modules.debugger.multisession.DebuggerExecutor")) : class$org$netbeans$modules$debugger$multisession$DebuggerExecutor)).getString("CTL_DebuggerExecutorDisplayName"));
        this.setExternalExecutor(this.debuggerProcess[this.selectedType]);
    }

    private void initBootClassPath() {
        if (this.bootClassPathSetManually) {
            return;
        }
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("path.separator");
        String string3 = System.getProperty("java.home") + string;
        String string4 = System.getProperty("jdk.home") + string;
        String string5 = NbClassPath.createBootClassPath().getClassPath();
        if (string5.startsWith("\"")) {
            string5 = string5.substring(1, string5.length());
        }
        if (string5.endsWith("\"")) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        super.setBootClassPath(new NbClassPath(string4 + "lib" + string + "tools.jar" + string2 + string5));
    }

    public DebuggerExecutor() {
        this.init();
        this.initBootClassPath();
    }

    public Integer getDebuggerExecutorType() {
        this.debuggerProcess[this.selectedType.intValue()] = this.getExternalExecutor();
        return this.selectedType;
    }

    public void setDebuggerExecutorType(Integer n) {
        this.debuggerProcess[this.selectedType.intValue()] = this.getExternalExecutor();
        this.selectedType = n > DEFAULT.length ? new Integer(0) : n;
        this.setExternalExecutor(this.debuggerProcess[this.selectedType]);
        this.setClassic(this.isClassic());
    }

    public synchronized void setBootClassPath(NbClassPath nbClassPath) {
        String string = this.getBootClassPath().getClassPath();
        super.setBootClassPath(nbClassPath);
        if (!this.bootClassPathSetManually) {
            String string2 = System.getProperty("path.separator");
            String string3 = this.getBootClassPath().getClassPath();
            if (string.endsWith(string2)) {
                string = string.substring(0, string.length() - string2.length());
            }
            if (string3.endsWith(string2)) {
                string3 = string3.substring(0, string3.length() - string2.length());
            }
            if (!string.equals(string3)) {
                this.bootClassPathSetManually = true;
            }
        }
    }

    public boolean isClassic() {
        int n = this.selectedType;
        if (this.isClassicSet[n]) {
            return this.classicValue[n];
        }
        if (!classicPreferredResolved) {
            String string = System.getProperty("jdk.home") + File.separatorChar + "bin" + File.separatorChar + "java";
            DebuggerExecutor.classicPreferred[0] = Utils.classicPreferred(string);
            DebuggerExecutor.classicPreferred[1] = Utilities.getOperatingSystem() == 2048 ? false : Utils.hasHotSpot(string);
            classicPreferredResolved = true;
        }
        return classicPreferred[n];
    }

    public void setClassic(boolean bl) {
        int n = this.selectedType;
        if (this.classicValue[n] == bl) {
            return;
        }
        this.isClassicSet[n] = true;
        boolean bl2 = this.classicValue[n];
        this.classicValue[n] = bl;
        this.firePropertyChange(PROP_CLASSIC_SWITCH, new Boolean(bl2), new Boolean(bl));
    }

    protected Process createProcess(ExecInfo execInfo) throws IOException {
        return this.getExternalExecutor().exec((java.text.Format)((Object)new Format(execInfo, this.getClassPath(), this.getBootClassPath(), this.getRepositoryPath(), this.getLibraryPath(), this.isClassic(), this.isAssertEnabled())), this.getEnvironmentVariables(), this.getWorkingDirectory());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$debugger$multisession$DebuggerExecutor == null ? (class$org$netbeans$modules$debugger$multisession$DebuggerExecutor = DebuggerExecutor.class$("org.netbeans.modules.debugger.multisession.DebuggerExecutor")) : class$org$netbeans$modules$debugger$multisession$DebuggerExecutor);
    }

    public boolean isAssertEnabled() {
        return this.assertEnabled;
    }

    public void setAssertEnabled(boolean bl) {
        if (this.assertEnabled == bl) {
            return;
        }
        this.assertEnabled = bl;
        this.firePropertyChange(PROP_ASSERT_ENABLED, new Boolean(!bl), new Boolean(bl));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        classicPreferred = new boolean[]{false, false};
        classicPreferredResolved = false;
        int[] nArray = Utils.getJavaVersion();
        boolean bl = nArray[0] == 1 && nArray[1] < 4;
        description = new String[bl ? 2 : 1];
        DEFAULT = new NbProcessDescriptor[bl ? 2 : 1];
        if (bl) {
            DebuggerExecutor.description[1] = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$DebuggerExecutor == null ? (class$org$netbeans$modules$debugger$multisession$DebuggerExecutor = DebuggerExecutor.class$("org.netbeans.modules.debugger.multisession.DebuggerExecutor")) : class$org$netbeans$modules$debugger$multisession$DebuggerExecutor)).getString("CTL_JDK11DebuggerExecutorName");
            DebuggerExecutor.DEFAULT[1] = new NbProcessDescriptor("{java.home}{/}bin{/}java", "{classic}-Xdebug -Djava.compiler=NONE -Xbootclasspath:{bootclasspath} -cp {filesystems} {classname} {arguments}", new ProcessExecutor().getExternalExecutor().getInfo());
        }
        DebuggerExecutor.description[0] = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$DebuggerExecutor == null ? (class$org$netbeans$modules$debugger$multisession$DebuggerExecutor = DebuggerExecutor.class$("org.netbeans.modules.debugger.multisession.DebuggerExecutor")) : class$org$netbeans$modules$debugger$multisession$DebuggerExecutor)).getString("CTL_JPDADebuggerExecutorName");
        DebuggerExecutor.DEFAULT[0] = new NbProcessDescriptor("{java.home}{/}bin{/}java", "{classic}{assertEnabled}-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=n -Djava.compiler=NONE -Xbootclasspath:{bootclasspath} -cp {filesystems} {classname} {arguments}", new ProcessExecutor().getExternalExecutor().getInfo());
    }

    public static class Format
    extends ProcessExecutor.Format {
        public static final String TAG_CLASSIC_SWITCH = "classic";
        public static final String TAG_ASSERT_ENABLED = "assertEnabled";
        static final long serialVersionUID = 1070082399063112986L;

        public Format(ExecInfo execInfo, NbClassPath nbClassPath, NbClassPath nbClassPath2, NbClassPath nbClassPath3, NbClassPath nbClassPath4, boolean bl, boolean bl2) {
            super(execInfo, nbClassPath, nbClassPath2, nbClassPath3, nbClassPath4);
            Map map = this.getMap();
            map.put(TAG_CLASSIC_SWITCH, bl ? "-classic " : "");
            map.put("assertEnabled", bl2 ? "-ea " : "");
        }
    }
}

