/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.java.BreakpointUpdater;
import org.netbeans.modules.debugger.support.java.ClassBreakpointPanel;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.nodes.Node;

public abstract class ClassBreakpointEvent
extends CoreBreakpoint.Event
implements CoreBreakpoint.SessionEvent {
    static final long serialVersionUID = -4544769666886838818L;
    public static final String PROP_CLASS_NAME = "className";
    public static final String TYPE_NAME = "java-class";
    protected String className = "";
    protected transient BreakpointUpdater updater;
    static /* synthetic */ Class class$java$lang$String;

    public ClassBreakpointEvent() {
        this.initUpdater();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initUpdater();
    }

    protected void initUpdater() {
        this.updater = new BreakpointUpdater(this, "setClassNameByUpdater", this.className);
    }

    public void dispose() {
        if (this.updater != null) {
            this.updater.dispose();
        }
        super.dispose();
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = ClassBreakpointEvent.class$("java.lang.String")) : class$java$lang$String, PROP_CLASS_NAME, JavaDebugger.getString("PROP_breakpoint_class_name"), JavaDebugger.getString("HINT_breakpoint_class_name"), "getClassName", "setClassName")};
    }

    protected void perform() {
        super.perform();
        CoreBreakpoint.Action[] actionArray = this.getBreakpoint().getActions();
        int n = 0;
        while (n < actionArray.length) {
            if (actionArray[n] instanceof JavaStopAction) {
                ((JavaStopAction)actionArray[n]).performStopAction(this);
            }
            ++n;
        }
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public String getTypeDisplayName() {
        return JavaDebugger.getString("CTL_Class_event");
    }

    public String getCategoryDisplayName() {
        return JavaDebugger.getString("CTL_Java_breakpoint_events_cathegory_name");
    }

    public boolean isDefault() {
        return JUtils.getDefaultType() == TYPE_NAME;
    }

    public String getIconBase() {
        return null;
    }

    public JComponent getCustomizer() {
        this.setClassName(JUtils.getCurrentClassName());
        return new ClassBreakpointPanel(this);
    }

    public void synchronizeWith(CoreBreakpoint.Event event) {
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.setClassName(string, true);
    }

    public void setClassNameByUpdater(String string) {
        this.setClassName(string, false);
    }

    protected void setClassName(String string, boolean bl) {
        if (string != null) {
            string = string.trim();
        }
        if (string == this.className || string != null && this.className != null && this.className.equals(string)) {
            return;
        }
        String string2 = this.className;
        this.className = string;
        if (bl) {
            this.updater.setClassName(this.className);
        }
        this.firePropertyChange(PROP_CLASS_NAME, string2, this.className);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

