/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.AbstractWatch;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.netbeans.modules.debugger.support.actions.CreateVariableCookie;
import org.netbeans.modules.debugger.support.actions.DisplayAsCookie;
import org.netbeans.modules.debugger.support.actions.GetVariableCookie;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.JavaVariablesFilter;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LeafRefresher;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class JavaVariableNode
extends AbstractNode
implements GetVariableCookie,
CreateVariableCookie,
DisplayAsCookie {
    static final long serialVersionUID = -4167730413290269518L;
    protected static String ICON_BASE = "org/netbeans/modules/debugger/resources/watchesView/Field";
    protected static String ICON_STATIC_VARIABLE = "org/netbeans/modules/debugger/resources/watchesView/StaticField";
    protected static String ICON_FIXED_VARIABLE = "org/netbeans/modules/debugger/resources/watchesView/FixedWatch";
    protected static String ICON_LOCAL_VARIABLE = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    public static final String PROP_MODIFIERS = "modifiers";
    public static final int TYPE_VARIABLE = 0;
    public static final int TYPE_LOCAL_VARIABLE = 1;
    public static final int TYPE_FIXED_VARIABLE = 2;
    private static ResourceBundle bundle;
    private int type;
    protected JavaVariable variable = null;
    protected transient Debugger debugger;
    private PropertyChangeListener pcl;
    protected boolean isArray;
    protected String variableType = "";
    private boolean showFullName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$CreateVariableAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DisplayAsAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$nodes$JavaVariableNode;

    public JavaVariableNode(JavaVariable javaVariable, int n) {
        this(javaVariable, n, false);
    }

    public JavaVariableNode(JavaVariable javaVariable, int n, boolean bl) {
        super((Children)(javaVariable.isLeaf() ? Children.LEAF : new VariableContextChildren()));
        this.type = n;
        this.showFullName = bl;
        this.type = javaVariable.isFixedVariable() ? 2 : n;
        this.variable = javaVariable;
        this.isArray = javaVariable.isArray();
        this.variableType = javaVariable.getInnerType();
        this.init();
    }

    public JavaVariableNode(JavaVariable javaVariable) {
        this(javaVariable, 0, false);
    }

    protected void finalize() {
    }

    protected void init() {
        this.variable.addPropertyChangeListener(new VariableListener(this));
        this.setDisplayName(this.computeName());
        if (this.type == 2) {
            this.setIconBase(ICON_FIXED_VARIABLE);
        } else if (this.type == 1) {
            this.setIconBase(ICON_LOCAL_VARIABLE);
        } else if (!this.variable.isFixedVariable() && this.variable.getModifiers() != null && this.variable.getModifiers().indexOf("static") > -1) {
            this.setIconBase(ICON_STATIC_VARIABLE);
        } else {
            this.setIconBase(ICON_BASE);
        }
        try {
            this.debugger = TopManager.getDefault().getDebugger();
        }
        catch (DebuggerException debuggerException) {
            TopManager.getDefault().notifyException((Throwable)debuggerException);
        }
        this.createProperties();
        this.getCookieSet().add((Node.Cookie)this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, NotActiveException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerVariableNode");
    }

    protected void createProperties() {
        PropertySupport.Reflection reflection;
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaVariableNode.class$("java.lang.String")) : class$java$lang$String, "variableName", JavaVariableNode.getLocalizedString("PROP_watch_name"), JavaVariableNode.getLocalizedString("HINT_watch_name"), "getVariableName", null));
        if (this.type != 2) {
            set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaVariableNode.class$("java.lang.String")) : class$java$lang$String, "type", JavaVariableNode.getLocalizedString("PROP_watch_type"), JavaVariableNode.getLocalizedString("HINT_watch_type"), "getVariableType", null));
        }
        try {
            reflection = new PropertySupport.Reflection((Object)this, class$java$lang$String == null ? (class$java$lang$String = JavaVariableNode.class$("java.lang.String")) : class$java$lang$String, "getVariableInnerType", "setVariableInnerType");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException.getMessage());
        }
        reflection.setName("type");
        reflection.setDisplayName(JavaVariableNode.getLocalizedString("PROP_watch_inner_type"));
        reflection.setShortDescription(JavaVariableNode.getLocalizedString("HINT_watch_inner_type"));
        try {
            reflection.setPropertyEditorClass(Class.forName("org.netbeans.modules.debugger.support.util.LinkEditor"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException.getMessage());
        }
        set.put((Node.Property)reflection);
        if (this.type != 2) {
            set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaVariableNode.class$("java.lang.String")) : class$java$lang$String, PROP_MODIFIERS, JavaVariableNode.getLocalizedString("PROP_watch_modifiers"), JavaVariableNode.getLocalizedString("HINT_watch_modifiers"), "getVariableModifiers", null));
        }
        set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaVariableNode.class$("java.lang.String")) : class$java$lang$String, "asText", JavaVariableNode.getLocalizedString("PROP_watch_value"), JavaVariableNode.getLocalizedString("HINT_watch_value"), "getVariableAsText", this.type == 2 ? null : "setVariableAsText"));
        VariablesFilter variablesFilter = this.variable.getVariablesFilter();
        Node.Property[] propertyArray = variablesFilter.getProperties(this.variable);
        if (propertyArray != null) {
            int n = 0;
            while (n < propertyArray.length) {
                set.put(propertyArray[n]);
                ++n;
            }
        }
        this.setSheet(sheet);
    }

    public SystemAction[] getActions() {
        int n = 0;
        int n2 = this.getDisplayAsActions().length > 0 ? 6 : 4;
        SystemAction[] systemActionArray = new SystemAction[n2];
        if (this.variable.isFixedVariable()) {
            systemActionArray[n++] = SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = JavaVariableNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction));
        } else {
            systemActionArray[n++] = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateVariableAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateVariableAction = JavaVariableNode.class$("org.netbeans.modules.debugger.support.actions.CreateVariableAction")) : class$org$netbeans$modules$debugger$support$actions$CreateVariableAction));
        }
        systemActionArray[n++] = null;
        if (this.getDisplayAsActions().length > 0) {
            systemActionArray[n++] = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DisplayAsAction == null ? (class$org$netbeans$modules$debugger$support$actions$DisplayAsAction = JavaVariableNode.class$("org.netbeans.modules.debugger.support.actions.DisplayAsAction")) : class$org$netbeans$modules$debugger$support$actions$DisplayAsAction));
            systemActionArray[n++] = null;
        }
        systemActionArray[n++] = SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = JavaVariableNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction));
        systemActionArray[n++] = SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JavaVariableNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
        return systemActionArray;
    }

    public boolean canDestroy() {
        return this.variable.isFixedVariable();
    }

    public String getName() {
        return this.variable.getAsText();
    }

    public void setName(String string) {
        try {
            this.variable.setAsText(string);
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    public void destroy() throws IOException {
        if (this.variable == null) {
            super.destroy();
            return;
        }
        this.variable.removePropertyChangeListener(this.pcl);
        if (this.variable instanceof AbstractWatch) {
            ((AbstractWatch)((Object)this.variable)).remove();
        }
        this.variable = null;
        if (this.getChildren() == Children.LEAF) {
            super.destroy();
            return;
        }
        VariableContextChildren variableContextChildren = (VariableContextChildren)this.getChildren();
        if (!variableContextChildren.initialized) {
            super.destroy();
            return;
        }
        Node[] nodeArray = variableContextChildren.getNodes();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ((JavaVariableNode)nodeArray[n2]).destroy();
            ++n2;
        }
        super.destroy();
    }

    public AbstractVariable getVariable() {
        return this.variable;
    }

    public SystemAction[] getDisplayAsActions() {
        VariablesFilter variablesFilter = this.variable.getVariablesFilter();
        return variablesFilter.getActions(this.variable);
    }

    public Object getSpecialVariable(String string) {
        return this.variable.getSpecialVariable(string);
    }

    public void setSpecialVariable(String string, Object object) {
        this.variable.setSpecialVariable(string, object);
    }

    public String getVariableName() {
        return this.variable != null ? this.variable.getVariableName() : "";
    }

    public String getVariableType() {
        return this.variable != null ? this.variable.getType() : "";
    }

    public String getVariableInnerType() {
        if (this.variable == null) {
            return "";
        }
        String string = this.variable.getInnerType();
        return string;
    }

    public void setVariableInnerType(String string) {
    }

    public String getVariableModifiers() {
        return this.variable != null ? this.variable.getModifiers() : "";
    }

    public String getVariableAsText() {
        String string = this.variable.getVariablesFilter().getDisplayName(this.variable);
        if (string != null) {
            return string;
        }
        return this.variable != null ? this.variable.getAsText() : "";
    }

    public void setVariableAsText(String string) {
        try {
            this.variable.setAsText(string);
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$nodes$JavaVariableNode == null ? (class$org$netbeans$modules$debugger$support$java$nodes$JavaVariableNode = JavaVariableNode.class$("org.netbeans.modules.debugger.support.java.nodes.JavaVariableNode")) : class$org$netbeans$modules$debugger$support$java$nodes$JavaVariableNode));
        }
        return bundle.getString(string);
    }

    public String computeName() {
        if (!this.showFullName) {
            return this.variable.getVariableName();
        }
        String string = this.variable.getVariablesFilter().getDisplayName(this.variable);
        return this.variable.getVariableName() + " = (" + this.variable.getInnerType() + ") " + string;
    }

    public void createVariable() {
        try {
            DebuggerSupport debuggerSupport = (DebuggerSupport)TopManager.getDefault().getDebugger();
            JavaVariable javaVariable = this.variable.createFixedVariable();
            if (javaVariable instanceof AbstractWatch) {
                debuggerSupport.addWatch((AbstractWatch)((Object)javaVariable));
            }
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
    }

    public boolean canCreateVariable() {
        return !this.variable.isFixedVariable();
    }

    void parameterChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.variable.getInnerType() != this.variableType) {
            this.isArray = !this.isArray;
            this.variableType = this.variable.getInnerType();
            this.createProperties();
        }
        String string = this.computeName();
        this.setDisplayName(string);
        this.changeChildren();
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    void changeChildren() {
        if (this.getChildren() == Children.LEAF) {
            Node node = this.getParentNode();
            if (node == null) {
                return;
            }
            JavaVariable javaVariable = (JavaVariable)this.getVariable();
            if (!javaVariable.isLeaf()) {
                LeafRefresher leafRefresher = (LeafRefresher)node.getChildren();
                leafRefresher.refreshMyKey(javaVariable);
            }
            return;
        }
        VariableContextChildren variableContextChildren = (VariableContextChildren)this.getChildren();
        if (!variableContextChildren.initialized) {
            return;
        }
        JavaVariablesFilter javaVariablesFilter = (JavaVariablesFilter)this.variable.getVariablesFilter();
        Object[] objectArray = javaVariablesFilter.getVariables(this.variable);
        if (!javaVariablesFilter.elementsSorted(this.variable)) {
            Arrays.sort(objectArray, Utils.variablesComparator);
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n].getVariableName().equals("super")) {
                    Object object = objectArray[n];
                    int n2 = n + 1;
                    while (n2 < objectArray.length) {
                        objectArray[n2 - 1] = objectArray[n2];
                        ++n2;
                    }
                    objectArray[objectArray.length - 1] = object;
                }
                ++n;
            }
        }
        variableContextChildren.setMyKeys(objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class VariableListener
    implements PropertyChangeListener {
        private WeakReference node;
        private AbstractVariable variable;

        VariableListener(JavaVariableNode javaVariableNode) {
            this.node = new WeakReference<JavaVariableNode>(javaVariableNode);
            this.variable = javaVariableNode.variable;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JavaVariableNode javaVariableNode = (JavaVariableNode)this.node.get();
            if (javaVariableNode == null) {
                this.variable.removePropertyChangeListener(this);
                return;
            }
            javaVariableNode.parameterChanged(propertyChangeEvent);
        }
    }

    private static final class VariableContextChildren
    extends Children.Keys
    implements LeafRefresher {
        private boolean initialized = false;

        private VariableContextChildren() {
        }

        protected void addNotify() {
            this.initialized = true;
            ((JavaVariableNode)this.getNode()).changeChildren();
        }

        protected void removeNotify() {
            this.initialized = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            return new Node[]{DebuggerNode.createNode(object)};
        }

        private void setMyKeys(Object[] objectArray) {
            this.setKeys(objectArray);
        }

        public void refreshMyKey(Object object) {
            this.refreshKey(object);
        }
    }
}

