/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LeafRefresher;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class JavaVariablesRootNode
extends AbstractNode {
    static final long serialVersionUID = -5432455019958452231L;
    private static String ICON_BASE = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    private static String ICON_PENDING_VARIABLES = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    private static ResourceBundle bundle;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$nodes$JavaVariablesRootNode;

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$nodes$JavaVariablesRootNode == null ? (class$org$netbeans$modules$debugger$support$java$nodes$JavaVariablesRootNode = JavaVariablesRootNode.class$("org.netbeans.modules.debugger.support.java.nodes.JavaVariablesRootNode")) : class$org$netbeans$modules$debugger$support$java$nodes$JavaVariablesRootNode));
        }
        return bundle.getString(string);
    }

    public JavaVariablesRootNode() {
        this(false);
    }

    public JavaVariablesRootNode(boolean bl) {
        super((Children)new VariablesRootChildren());
        String string = null;
        if (bl) {
            string = JavaVariablesRootNode.getLocalizedString("PROP_locals_column_name");
            this.setShortDescription(JavaVariablesRootNode.getLocalizedString("HINT_locals_column_name"));
        } else {
            string = JavaVariablesRootNode.getLocalizedString("CTL_Variables_root");
        }
        this.setDisplayName(string);
        this.setName("JavaVariablesRootNode");
        this.setIconBase(ICON_BASE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerVariablesRootNode");
    }

    public Node.Handle getHandle() {
        return new VariablesHandle();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class VariablesHandle
    implements Node.Handle {
        static final long serialVersionUID = -45182213487259891L;

        private VariablesHandle() {
        }

        public Node getNode() {
            return NodesRegistry.getNode("localsRootNode", new Object[0]);
        }
    }

    static class VRListener
    implements PropertyChangeListener {
        private Debugger debugger;
        private AbstractThread currentThread;
        private WeakReference node;
        protected static String stdIcon = JavaVariablesRootNode.access$200();
        protected static String pendingIcon = JavaVariablesRootNode.access$300();

        VRListener(Node node, Debugger debugger) {
            this.debugger = debugger;
            this.node = new WeakReference<Node>(node);
            Validator validator = ((ValidatorHolder)debugger).getValidator();
            validator.addPropertyChangeListener(this);
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
            AbstractThread abstractThread = ((ThreadsRoot)debugger).getCurrentThread();
            if (abstractThread instanceof CallStackProducer) {
                this.currentThread = abstractThread;
                this.currentThread.addPropertyChangeListener(this);
            }
        }

        JavaVariablesRootNode getNode() {
            JavaVariablesRootNode javaVariablesRootNode = (JavaVariablesRootNode)((Object)this.node.get());
            if (javaVariablesRootNode != null) {
                return javaVariablesRootNode;
            }
            this.destroy();
            return null;
        }

        void destroy() {
            Validator validator = ((ValidatorHolder)this.debugger).getValidator();
            validator.removePropertyChangeListener(this);
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.currentThread != null) {
                this.currentThread.removePropertyChangeListener(this);
            }
            this.currentThread = null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JavaVariablesRootNode javaVariablesRootNode = this.getNode();
            if (javaVariablesRootNode == null) {
                return;
            }
            if (propertyChangeEvent.getSource() instanceof Validator) {
                javaVariablesRootNode.setIconBase(((Validator)propertyChangeEvent.getSource()).isValidated() ? ICON_BASE : ICON_PENDING_VARIABLES);
                return;
            }
            if (propertyChangeEvent.getSource() instanceof CoreDebugger && propertyChangeEvent.getPropertyName() == "currentThread") {
                AbstractThread abstractThread;
                if (this.currentThread != null) {
                    this.currentThread.removePropertyChangeListener(this);
                }
                if ((abstractThread = ((ThreadsRoot)this.debugger).getCurrentThread()) instanceof CallStackProducer) {
                    this.currentThread = abstractThread;
                    this.currentThread.addPropertyChangeListener(this);
                }
                ((VariablesRootChildren)javaVariablesRootNode.getChildren()).validate();
            } else if (propertyChangeEvent.getSource() instanceof CallStackProducer && (propertyChangeEvent.getPropertyName() == "callstack" || propertyChangeEvent.getPropertyName() == "currentCallstackFrameIndex")) {
                ((VariablesRootChildren)javaVariablesRootNode.getChildren()).validate();
            }
        }
    }

    private static final class VariablesRootChildren
    extends Children.Keys
    implements LeafRefresher,
    Validator.Object {
        private VRListener l;
        private Debugger debugger;

        private VariablesRootChildren() {
        }

        protected Node[] createNodes(Object object) {
            Node node = DebuggerNode.createNode(object, new Object[]{object, new Integer(1)});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        protected void addNotify() {
            try {
                this.debugger = TopManager.getDefault().getDebugger();
                this.l = new VRListener(this.getNode(), this.debugger);
                Validator validator = ((ValidatorHolder)this.debugger).getValidator();
                validator.add(this);
                this.validate();
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
        }

        protected void removeNotify() {
            this.l.destroy();
            Validator validator = ((ValidatorHolder)this.debugger).getValidator();
            validator.remove(this);
            this.setKeys(Collections.EMPTY_SET);
        }

        public void validate() {
            HashMap hashMap = new HashMap();
            Object[] objectArray = new AbstractVariable[]{};
            Object object = ((ThreadsRoot)this.debugger).getCurrentThread();
            JavaVariablesRootNode javaVariablesRootNode = (JavaVariablesRootNode)this.getNode();
            if (object != null) {
                Location location;
                int n;
                if (object instanceof CallStackProducer && (n = ((CallStackProducer)object).getCurrentCallStackFrameIndex()) >= 0 && n < ((CallStackProducer)object).getCallStack().length && (location = ((CallStackProducer)object).getCallStack()[n]) instanceof VariablesProducer) {
                    object = location;
                }
                if (object instanceof VariablesProducer) {
                    objectArray = ((VariablesProducer)object).getVariablesFilter().getVariables((VariablesProducer)object);
                    Arrays.sort(objectArray, Utils.variablesComparator);
                }
            }
            this.setKeys(objectArray);
        }

        public boolean canRemove() {
            return false;
        }

        public void refreshMyKey(Object object) {
            this.refreshKey(object);
        }
    }
}

