/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import org.netbeans.modules.debugger.support.java.JavaClass;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.nodes.ClassNode;
import org.netbeans.modules.debugger.support.java.nodes.ConstructorNode;
import org.netbeans.modules.debugger.support.java.nodes.FieldNode;
import org.netbeans.modules.debugger.support.java.nodes.JavaVariableNode;
import org.netbeans.modules.debugger.support.java.nodes.MethodNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.MethodElement;
import org.openide.src.nodes.DefaultFactory;
import org.openide.src.nodes.ElementNodeFactory;

class LoadedClassFactory
extends DefaultFactory {
    private ClassNode node;
    private JavaClass clazz;

    public LoadedClassFactory(JavaClass javaClass) {
        super(false);
        this.clazz = javaClass;
    }

    public Children createChildren(JavaClass javaClass, ClassElement classElement) {
        Children children = this.createClassChildren(classElement, (ElementNodeFactory)this);
        JavaVariable javaVariable = javaClass.getClassLoader();
        if (javaVariable != null) {
            children.add(new Node[]{new JavaVariableNode(javaVariable)});
        }
        return children;
    }

    public Node createClassNode(ClassElement classElement) {
        JavaClass javaClass = this.clazz.findInnerClass(classElement);
        if (javaClass != null) {
            return new ClassNode(javaClass, classElement, new LoadedClassFactory(javaClass));
        }
        return new AbstractNode(Children.LEAF);
    }

    public Node createConstructorNode(ConstructorElement constructorElement) {
        return new ConstructorNode(constructorElement, false, this.clazz.getName());
    }

    public Node createMethodNode(MethodElement methodElement) {
        return new MethodNode(methodElement, false, this.clazz.getName());
    }

    public Node createFieldNode(FieldElement fieldElement) {
        return new FieldNode(this.clazz, fieldElement, false);
    }
}

