/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.ThreadListener;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.openide.TopManager;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class ThreadGroupNode
extends AbstractNode {
    static final long serialVersionUID = -4736310787523747464L;
    public static final String PROP_GROUP_NAME = "threadName";
    protected static Image threadGroupIcon;
    protected static Image threadGroupCurrentIcon;
    private static SystemAction[] staticActions;
    protected static final String ICON_CURRENT = "org/netbeans/modules/debugger/resources/threadsView/CurrentThreadGroup";
    protected static final String ICON_BASE = "org/netbeans/modules/debugger/resources/threadsView/ThreadGroup";
    protected static final String ICON_SESSION_CURRENT = "org/netbeans/modules/debugger/resources/sessionsView/CurrentSession";
    protected static final String ICON_SESSION_BASE = "org/netbeans/modules/debugger/resources/sessionsView/Session";
    private transient ThreadsProducer threadGroup;
    private transient CoreDebugger coreDebugger;
    private transient AbstractDebugger debugger;
    private transient TGListener listener;
    private boolean current = false;
    protected boolean showSubNodes = true;
    private boolean session = false;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public ThreadGroupNode(ThreadsProducer threadsProducer, AbstractDebugger abstractDebugger) {
        this(threadsProducer, abstractDebugger, true);
        this.session = true;
        this.current = !this.isCurrent();
        this.changeProperties();
    }

    public ThreadGroupNode(ThreadsProducer threadsProducer, AbstractDebugger abstractDebugger, boolean bl) {
        super((Children)new ThreadGroupContextChildren());
        this.showSubNodes = bl;
        this.threadGroup = threadsProducer;
        this.debugger = abstractDebugger;
        this.current = !this.isCurrent();
        this.changeProperties();
        if (this.listener == null) {
            this.listener = new TGListener(this);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerThreadGroupNode");
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ThreadGroupNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ThreadGroupNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return staticActions;
    }

    public void destroy() throws IOException {
        super.destroy();
        if (this.listener != null) {
            this.listener.destroy();
        }
        this.listener = null;
    }

    private CoreDebugger getCoreDebugger() {
        if (this.coreDebugger != null) {
            return this.coreDebugger;
        }
        try {
            this.coreDebugger = (CoreDebugger)TopManager.getDefault().getDebugger();
            return this.coreDebugger;
        }
        catch (DebuggerException debuggerException) {
            return null;
        }
    }

    ThreadsProducer getDebuggerThreadGroup() {
        return this.threadGroup;
    }

    void changeProperties() {
        if (this.threadGroup != null && this.current != this.isCurrent()) {
            this.current = this.isCurrent();
            if (!this.session) {
                if (this.current) {
                    this.setIconBase(ICON_CURRENT);
                } else {
                    this.setIconBase(ICON_BASE);
                }
            } else if (this.current) {
                this.setIconBase(ICON_SESSION_CURRENT);
            } else {
                this.setIconBase(ICON_SESSION_BASE);
            }
        }
        String string = this.getTGName();
        this.setDisplayName(string);
        this.setName(string);
    }

    String getTGName() {
        if (this.threadGroup instanceof AbstractThread) {
            return ((AbstractThread)((Object)this.threadGroup)).getName();
        }
        AbstractDebuggerInfo abstractDebuggerInfo = (AbstractDebuggerInfo)this.debugger.getDebuggerInfo();
        if (abstractDebuggerInfo != null && abstractDebuggerInfo instanceof AbstractDebuggerInfo) {
            return abstractDebuggerInfo.getProcessName();
        }
        return DebuggerNode.getLocalizedString("CTL_Thread_group");
    }

    boolean isCurrent() {
        if (this.threadGroup instanceof AbstractThread) {
            return ((AbstractThread)((Object)this.threadGroup)).isCurrent() && this.getCoreDebugger().getCurrentDebugger() == this.debugger;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ThreadsHandle
    implements Node.Handle {
        static final long serialVersionUID = -4518262935887219735L;

        private ThreadsHandle() {
        }

        public Node getNode() {
            return NodesRegistry.getNode("threadsRootNode", new Object[0]);
        }
    }

    private static final class ThreadGroupContextChildren
    extends Children.Keys {
        private boolean initialized = false;

        private ThreadGroupContextChildren() {
        }

        protected Node[] createNodes(Object object) {
            Node node = DebuggerNode.createNode(object, new Object[]{object, ((ThreadGroupNode)this.getNode()).debugger, new Boolean(((ThreadGroupNode)this.getNode()).showSubNodes)});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        protected void addNotify() {
            this.initialized = true;
            ThreadsProducer threadsProducer = ((ThreadGroupNode)this.getNode()).threadGroup;
            TGListener tGListener = ((ThreadGroupNode)this.getNode()).listener;
            if (tGListener == null) {
                tGListener = ((ThreadGroupNode)this.getNode()).listener = new TGListener((ThreadGroupNode)this.getNode());
            }
            threadsProducer.addThreadListener(tGListener);
            this.update();
        }

        protected void removeNotify() {
            ThreadsProducer threadsProducer = ((ThreadGroupNode)this.getNode()).threadGroup;
            TGListener tGListener = ((ThreadGroupNode)this.getNode()).listener;
            threadsProducer.removeThreadListener(tGListener);
            this.setKeys(Collections.EMPTY_SET);
            this.initialized = false;
        }

        void update() {
            if (!this.initialized) {
                return;
            }
            ThreadsProducer threadsProducer = ((ThreadGroupNode)this.getNode()).threadGroup;
            Object[] objectArray = threadsProducer.getThreads();
            this.setKeys(objectArray);
        }
    }

    private static class TGListener
    implements ThreadListener,
    PropertyChangeListener {
        private WeakReference node;
        private ThreadsProducer threadGroup;
        private CoreDebugger coreDebugger;

        TGListener(ThreadGroupNode threadGroupNode) {
            this.node = new WeakReference<ThreadGroupNode>(threadGroupNode);
            this.threadGroup = threadGroupNode.threadGroup;
            this.coreDebugger = threadGroupNode.getCoreDebugger();
            this.coreDebugger.addPropertyChangeListener(this);
            if (this.threadGroup instanceof AbstractThread) {
                ((AbstractThread)((Object)this.threadGroup)).addPropertyChangeListener(this);
            }
        }

        void destroy() {
            this.threadGroup.removeThreadListener(this);
            this.coreDebugger.removePropertyChangeListener(this);
            if (this.threadGroup instanceof AbstractThread) {
                ((AbstractThread)((Object)this.threadGroup)).removePropertyChangeListener(this);
            }
        }

        public void threadCreated(AbstractThread abstractThread) {
            this.updateChindren();
        }

        public void threadDeath(AbstractThread abstractThread) {
            this.updateChindren();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == this.coreDebugger && propertyChangeEvent.getPropertyName() != "currentDebugger") {
                return;
            }
            ThreadGroupNode threadGroupNode = this.getTG();
            if (threadGroupNode == null) {
                return;
            }
            threadGroupNode.changeProperties();
        }

        private void updateChindren() {
            ThreadGroupNode threadGroupNode = this.getTG();
            if (threadGroupNode == null) {
                return;
            }
            ThreadGroupContextChildren threadGroupContextChildren = (ThreadGroupContextChildren)threadGroupNode.getChildren();
            threadGroupContextChildren.update();
        }

        private ThreadGroupNode getTG() {
            ThreadGroupNode threadGroupNode = (ThreadGroupNode)((Object)this.node.get());
            if (threadGroupNode == null) {
                this.destroy();
            }
            return threadGroupNode;
        }
    }
}

