/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.actions.GoToSourceCookie;
import org.netbeans.modules.debugger.support.actions.SwitchOnCookie;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class ThreadNode
extends AbstractNode
implements SwitchOnCookie,
GoToSourceCookie {
    static final long serialVersionUID = 2202990736781011814L;
    public static final String PROP_THREAD_NAME = "threadName";
    public static final String PROP_THREAD_STATE = "threadState";
    public static final String PROP_THREAD_CLASS = "threadClass";
    public static final String PROP_THREAD_METHOD = "threadMethod";
    public static final String PROP_THREAD_LINE = "threadLine";
    public static final String PROP_THREAD_STACK_DEPTH = "threadStackDepth";
    public static final String PROP_THREAD_FRAME_INDEX = "threadFrameIndex";
    public static final String PROP_THREAD_SUSPENDED = "threadSuspended";
    public static final int STATE_MAIN = 1;
    public static final int STATE_STOPPED = 2;
    protected static String ICON_CURRENT = "org/netbeans/modules/coreDebugger/resources/threadsView/CurrentThread";
    protected static String ICON_RUNNING = "org/netbeans/modules/coreDebugger/resources/threadsView/Thread";
    protected static Image threadFolderIcon;
    protected static Image threadFolderIcon32;
    protected static Image threadCurrentIcon;
    protected static Image threadCurrentIcon32;
    protected static Image threadRunningIcon;
    protected static Image threadRunningIcon32;
    private static SystemAction[] staticActions;
    private static ResourceBundle bundle;
    private CoreDebugger coreDebugger;
    private AbstractDebugger debugger;
    private final AbstractThread thread;
    private ThreadListener threadListener;
    private int state = 4;
    private boolean oldSuspended = false;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$ThreadNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$SwitchOnAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToSourceAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$nodes$ThreadNode == null ? (class$org$netbeans$modules$debugger$support$nodes$ThreadNode = ThreadNode.class$("org.netbeans.modules.debugger.support.nodes.ThreadNode")) : class$org$netbeans$modules$debugger$support$nodes$ThreadNode));
        }
        return bundle.getString(string);
    }

    public ThreadNode(AbstractThread abstractThread, AbstractDebugger abstractDebugger) {
        this(abstractThread, abstractDebugger, true);
    }

    public ThreadNode(AbstractThread abstractThread, AbstractDebugger abstractDebugger, boolean bl) {
        super((Children)(bl ? new ThreadChildren() : Children.LEAF));
        this.thread = abstractThread;
        this.debugger = abstractDebugger;
        try {
            this.coreDebugger = (CoreDebugger)TopManager.getDefault().getDebugger();
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
        this.setName();
        this.createProperties();
        this.getCookieSet().add((Node.Cookie)this);
        this.threadListener = new ThreadListener(this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerThreadNode");
    }

    private void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(Utils.createProperty(this.thread, class$java$lang$String == null ? (class$java$lang$String = ThreadNode.class$("java.lang.String")) : class$java$lang$String, PROP_THREAD_NAME, ThreadNode.getLocalizedString("PROP_thread_name"), ThreadNode.getLocalizedString("HINT_thread_name"), "getName", null));
        if (this.thread instanceof Location) {
            set.put(Utils.createProperty(this, Integer.TYPE, PROP_THREAD_LINE, ThreadNode.getLocalizedString("PROP_thread_line"), ThreadNode.getLocalizedString("HINT_thread_line"), "getLineNumber", null));
        }
        if (this.thread instanceof CallStackProducer) {
            set.put(Utils.createProperty(this, Integer.TYPE, PROP_THREAD_STACK_DEPTH, ThreadNode.getLocalizedString("PROP_thread_stack_depth"), ThreadNode.getLocalizedString("HINT_thread_stack_depth"), "getStackDepth", null));
        }
        this.setSheet(sheet);
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchOnAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchOnAction = ThreadNode.class$("org.netbeans.modules.debugger.support.actions.SwitchOnAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchOnAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToSourceAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToSourceAction = ThreadNode.class$("org.netbeans.modules.debugger.support.actions.GoToSourceAction")) : class$org$netbeans$modules$debugger$support$actions$GoToSourceAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ThreadNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ThreadNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return staticActions;
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchOnAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchOnAction = ThreadNode.class$("org.netbeans.modules.debugger.support.actions.SwitchOnAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchOnAction));
    }

    public void destroy() throws IOException {
        super.destroy();
        this.coreDebugger.removePropertyChangeListener(this.threadListener);
        this.thread.removePropertyChangeListener(this.threadListener);
    }

    public boolean canSetCurrent() {
        return !this.thread.isCurrent();
    }

    public void setCurrent() {
        this.thread.setCurrent(true);
        this.coreDebugger.setCurrentDebugger(this.debugger);
    }

    public void goToSource() {
        Line line = ((Location)((Object)this.thread)).getLine();
        if (line != null) {
            line.show(2);
        }
    }

    public boolean canGoToSource() {
        Line line = ((Location)((Object)this.thread)).getLine();
        return line != null;
    }

    public int getLineNumber() {
        if (!(this.thread instanceof Location) || ((Location)((Object)this.thread)).getLine() == null) {
            return -1;
        }
        return ((Location)((Object)this.thread)).getLine().getLineNumber();
    }

    public int getStackDepth() {
        if (!(this.thread instanceof CallStackProducer)) {
            return -1;
        }
        return ((CallStackProducer)((Object)this.thread)).getCallStack().length;
    }

    void refreshIcon() {
        if ((this.state & 1) != 0) {
            this.setIconBase(ICON_CURRENT);
        } else {
            this.setIconBase(ICON_RUNNING);
        }
    }

    public final boolean equals(Object object) {
        return object instanceof ThreadNode && ((ThreadNode)object).thread.equals(this.thread);
    }

    public final int hashCode() {
        return this.thread.hashCode();
    }

    void changeProperties() {
        this.setName();
        this.firePropertyChange(null, null, null);
    }

    void setName() {
        int n = 0;
        if (this.thread.isCurrent() && this.coreDebugger.getCurrentDebugger() == this.debugger) {
            n = 1;
        }
        if (this.state != n) {
            this.state = n;
            this.refreshIcon();
        }
        String string = this.thread.getName();
        this.setDisplayName(string);
        this.setName(string);
    }

    AbstractThread getDebuggerThread() {
        return this.thread;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ThreadListener
    implements PropertyChangeListener {
        private WeakReference node;
        private CoreDebugger coreDebugger;
        private AbstractThread thread;

        ThreadListener(ThreadNode threadNode) {
            this.node = new WeakReference<ThreadNode>(threadNode);
            this.coreDebugger = threadNode.coreDebugger;
            this.thread = threadNode.thread;
            this.thread.addPropertyChangeListener(this);
            this.coreDebugger.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ThreadNode threadNode = (ThreadNode)this.node.get();
            if (threadNode == null) {
                this.coreDebugger.removePropertyChangeListener(this);
                this.thread.removePropertyChangeListener(this);
                return;
            }
            if (propertyChangeEvent.getSource() == this.coreDebugger && propertyChangeEvent.getPropertyName() != "currentDebugger") {
                return;
            }
            threadNode.changeProperties();
            ((ThreadChildren)threadNode.getChildren()).refreshAll();
        }
    }

    public static interface Refreshable {
        public void refresh();
    }

    private static final class ThreadChildren
    extends Children.Keys {
        private boolean initialized = false;

        private ThreadChildren() {
        }

        protected void addNotify() {
            this.initialized = true;
            AbstractThread abstractThread = ((ThreadNode)this.getNode()).thread;
            LinkedList<String> linkedList = new LinkedList<String>();
            if (abstractThread instanceof VariablesProducer) {
                linkedList.add("localsNode");
            }
            if (abstractThread instanceof CallStackProducer) {
                linkedList.add("callStackNode");
            }
            this.setKeys(linkedList);
        }

        protected void removeNotify() {
            this.initialized = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            AbstractThread abstractThread = ((ThreadNode)this.getNode()).thread;
            Node node = NodesRegistry.getNode(object, new Object[]{abstractThread});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        void refreshAll() {
            if (!this.initialized) {
                return;
            }
            Node[] nodeArray = this.getNodes();
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (nodeArray[n2] instanceof Refreshable) {
                    ((Refreshable)nodeArray[n2]).refresh();
                }
                ++n2;
            }
        }
    }
}

