/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LeafRefresher;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class VariablesRootNode
extends AbstractNode {
    static final long serialVersionUID = -5432455019958452231L;
    private static String ICON_BASE = "org/netbeans/modules/debugger/resources/allInOneView/Locals";
    private static String ICON_PENDING_VARIABLES = "org/netbeans/modules/debugger/resources/allInOneView/Locals";
    private static String ICON_LOCAL_VARIABLE = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    private static ResourceBundle bundle;
    private static HashMap locals;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$DebuggerNode;

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$nodes$DebuggerNode == null ? (class$org$netbeans$modules$debugger$support$nodes$DebuggerNode = VariablesRootNode.class$("org.netbeans.modules.debugger.support.nodes.DebuggerNode")) : class$org$netbeans$modules$debugger$support$nodes$DebuggerNode));
        }
        return bundle.getString(string);
    }

    public VariablesRootNode() {
        this(false);
    }

    public VariablesRootNode(boolean bl) {
        super((Children)new VariablesRootChildren());
        String string = null;
        if (bl) {
            string = VariablesRootNode.getLocalizedString("PROP_locals_column_name");
            this.setShortDescription(VariablesRootNode.getLocalizedString("HINT_locals_column_name"));
        } else {
            string = VariablesRootNode.getLocalizedString("CTL_Variables_root");
        }
        this.setDisplayName(string);
        this.setName("VariablesRootNode");
        this.setIconBase(ICON_BASE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerVariablesRootNode");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        locals = new HashMap();
    }

    private static class VariablesHandle
    implements Node.Handle {
        static final long serialVersionUID = -45182213487259891L;

        private VariablesHandle() {
        }

        public Node getNode() {
            return NodesRegistry.getNode("localsRootNode", new Object[0]);
        }
    }

    static class VRListener
    implements PropertyChangeListener {
        private CoreDebugger debugger;
        private AbstractThread currentThread;
        private WeakReference node;
        protected static String stdIcon = VariablesRootNode.access$300();
        protected static String pendingIcon = VariablesRootNode.access$400();

        VRListener(Node node, CoreDebugger coreDebugger) {
            this.debugger = coreDebugger;
            this.node = new WeakReference<Node>(node);
            Validator validator = ((ValidatorHolder)((Object)coreDebugger)).getValidator();
            validator.addPropertyChangeListener(this);
            coreDebugger.addPropertyChangeListener(this);
            AbstractThread abstractThread = ((ThreadsRoot)((Object)coreDebugger)).getCurrentThread();
            if (abstractThread instanceof CallStackProducer) {
                this.currentThread = abstractThread;
                this.currentThread.addPropertyChangeListener(this);
            }
        }

        VariablesRootNode getNode() {
            VariablesRootNode variablesRootNode = (VariablesRootNode)((Object)this.node.get());
            if (variablesRootNode != null) {
                return variablesRootNode;
            }
            this.destroy();
            return null;
        }

        void destroy() {
            Validator validator = ((ValidatorHolder)((Object)this.debugger)).getValidator();
            validator.removePropertyChangeListener(this);
            this.debugger.removePropertyChangeListener(this);
            if (this.currentThread != null) {
                this.currentThread.removePropertyChangeListener(this);
            }
            this.currentThread = null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            VariablesRootNode variablesRootNode = this.getNode();
            if (variablesRootNode == null) {
                return;
            }
            if (propertyChangeEvent.getSource() instanceof Validator) {
                variablesRootNode.setIconBase(((Validator)propertyChangeEvent.getSource()).isValidated() ? ICON_BASE : ICON_PENDING_VARIABLES);
                return;
            }
            if (propertyChangeEvent.getSource() instanceof CoreDebugger && propertyChangeEvent.getPropertyName() == "currentThread") {
                AbstractThread abstractThread;
                if (this.currentThread != null) {
                    this.currentThread.removePropertyChangeListener(this);
                }
                if ((abstractThread = ((ThreadsRoot)((Object)this.debugger)).getCurrentThread()) instanceof CallStackProducer) {
                    this.currentThread = abstractThread;
                    this.currentThread.addPropertyChangeListener(this);
                }
                ((VariablesRootChildren)variablesRootNode.getChildren()).validate();
            } else if (propertyChangeEvent.getSource() instanceof CallStackProducer && (propertyChangeEvent.getPropertyName() == "callstack" || propertyChangeEvent.getPropertyName() == "currentCallstackFrameIndex")) {
                ((VariablesRootChildren)variablesRootNode.getChildren()).validate();
            }
        }
    }

    private static final class VariablesRootChildren
    extends Children.Keys
    implements LeafRefresher,
    Validator.Object {
        private VRListener l;
        private AbstractDebugger debugger;

        private VariablesRootChildren() {
        }

        protected Node[] createNodes(Object object) {
            Node node = DebuggerNode.createNode(object);
            if (node == null) {
                return new Node[0];
            }
            if (locals.containsKey(object) && node instanceof AbstractNode) {
                ((AbstractNode)node).setIconBase(ICON_LOCAL_VARIABLE);
            }
            return new Node[]{node};
        }

        protected void addNotify() {
            try {
                this.debugger = (AbstractDebugger)TopManager.getDefault().getDebugger();
                this.l = new VRListener(this.getNode(), (CoreDebugger)((Object)this.debugger));
                Validator validator = ((ValidatorHolder)((Object)this.debugger)).getValidator();
                validator.add(this);
                this.validate();
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
        }

        protected void removeNotify() {
            this.l.destroy();
            Validator validator = ((ValidatorHolder)((Object)this.debugger)).getValidator();
            validator.remove(this);
            this.setKeys(Collections.EMPTY_SET);
        }

        public void validate() {
            HashMap hashMap = new HashMap();
            Object[] objectArray = new AbstractVariable[]{};
            Object object = ((ThreadsRoot)((Object)this.debugger)).getCurrentThread();
            if (object != null) {
                if (object instanceof CallStackProducer) {
                    int n = ((CallStackProducer)object).getCurrentCallStackFrameIndex();
                    Location location = ((CallStackProducer)object).getCallStack()[n];
                    if (location instanceof VariablesProducer) {
                        object = location;
                    }
                }
                if (object instanceof VariablesProducer) {
                    objectArray = ((VariablesProducer)object).getVariablesFilter().getVariables((VariablesProducer)object);
                    Arrays.sort(objectArray, Utils.localsComparator);
                }
            }
            this.setKeys(objectArray);
        }

        public boolean canRemove() {
            return false;
        }

        public void refreshMyKey(Object object) {
            this.refreshKey(object);
        }
    }
}

