/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class PackageListLoader {
    private static final int NOT_LOADED = 0;
    private static final int LOADING = 1;
    private static final int LOADED = 2;
    private static int state;
    private static List packageList;
    private static Task task;
    private static Performer performer;
    private static TaskListener listener;
    private static boolean wantsReset;

    public static synchronized List getPackageNames() {
        return packageList;
    }

    public static synchronized Task loadPackageNames(TaskListener taskListener) {
        switch (state) {
            case 2: {
                if (taskListener != null) {
                    taskListener.taskFinished(Task.EMPTY);
                }
                return Task.EMPTY;
            }
            case 1: {
                if (taskListener != null) {
                    task.addTaskListener(taskListener);
                    listener = taskListener;
                }
                return task;
            }
            case 0: {
                if (performer == null) {
                    performer = new Performer();
                }
                task = new Task((Runnable)performer);
                if (taskListener != null) {
                    task.addTaskListener(taskListener);
                    listener = taskListener;
                }
                new Thread((Runnable)task, "Package List Loader").start();
                return task;
            }
        }
        return null;
    }

    private static synchronized void setState(int n) {
        state = n;
    }

    public static synchronized void reset() {
        if (state == 1 && listener != null) {
            task.removeTaskListener(listener);
            listener = null;
        } else {
            packageList = null;
        }
        state = 0;
    }

    private static synchronized void finished() {
        if (wantsReset) {
            packageList = null;
            wantsReset = false;
        } else {
            state = 2;
        }
        task = null;
    }

    private static class Performer
    implements Runnable {
        private Performer() {
        }

        public void run() {
            PackageListLoader.setState(1);
            packageList = Arrays.asList(Utils.getPackageNames(true, true, true));
            PackageListLoader.finished();
        }
    }
}

