/*
 * Decompiled with CFR 0.152.
 */
package tyrex.conf;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import tyrex.conf.Constants;
import tyrex.conf.Domain;
import tyrex.util.Logger;
import tyrex.util.Messages;

public class Server
extends Constants
implements Serializable {
    private transient File _source;
    private Hashtable _domains = new Hashtable();
    private String _default;
    static /* synthetic */ Class class$tyrex$conf$Server;

    public void addDomain(Domain domain) {
        if (this._domains.put(domain.getName(), domain) != null) {
            throw new IllegalArgumentException("Multiple domains found with the same name " + domain.getName());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getDefault() {
        if (this._default == null || this._default.length() == 0) {
            this._default = "default";
        }
        return this._default;
    }

    public String getVendor() {
        return Constants.Implementation.Vendor;
    }

    public String getVersion() {
        return Constants.Implementation.Version;
    }

    public Enumeration listDomains() {
        return this._domains.elements();
    }

    public static Server load() throws IOException {
        try {
            File file;
            URL uRL = (class$tyrex$conf$Server != null ? class$tyrex$conf$Server : (class$tyrex$conf$Server = Server.class$("tyrex.conf.Server"))).getResource("/tyrex.xml");
            if (uRL != null && (file = new File(uRL.getFile())).exists()) {
                Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingServer", file));
                return Server.load(file);
            }
            file = new File(System.getProperty("user.dir"), "tyrex.xml");
            if (file.exists()) {
                Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingServer", file));
                return Server.load(file);
            }
            file = new File(System.getProperty("java.home"), "lib");
            if ((file = new File(file, "tyrex.xml")).exists()) {
                Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingServer", file));
                return Server.load(file);
            }
        }
        catch (IOException iOException) {
            Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingServerError", iOException));
            throw iOException;
        }
        Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingServerMissing", "tyrex.xml"));
        throw new IOException(Messages.format("tyrex.conf.loadingServerMissing", "tyrex.xml"));
    }

    public static Server load(File file) throws IOException {
        Server server = Server.load(new FileReader(file));
        server._source = file;
        return server;
    }

    public static Server load(Reader reader) throws IOException {
        try {
            Unmarshaller unmarshaller = new Unmarshaller(class$tyrex$conf$Server != null ? class$tyrex$conf$Server : (class$tyrex$conf$Server = Server.class$("tyrex.conf.Server")));
            unmarshaller.setLogWriter((PrintWriter)Logger.getSystemLogger());
            unmarshaller.setEntityResolver((EntityResolver)new SchemaEntityResolver());
            return (Server)unmarshaller.unmarshal(reader);
        }
        catch (MarshalException marshalException) {
            Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingResourcesError", (Object)marshalException));
            throw new IOException(marshalException.toString());
        }
        catch (Exception exception) {
            Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingResourcesError", exception));
            throw new IOException("Nested exception: " + exception);
        }
    }

    public void save() throws IOException {
        if (this._source == null) {
            throw new IOException(Messages.message("tyrex.conf.savingServerNotLoaded"));
        }
        this.save(new FileWriter(this._source));
    }

    public void save(Writer writer) throws IOException {
        try {
            Marshaller marshaller = new Marshaller(writer);
            marshaller.setLogWriter((PrintWriter)Logger.getSystemLogger());
            marshaller.marshal((Object)this);
        }
        catch (MarshalException marshalException) {
            throw new IOException(marshalException.toString());
        }
        catch (Exception exception) {
            throw new IOException("Nested exception: " + exception);
        }
    }

    public void setDefault(String string) {
        this._default = string == null ? null : string.trim();
    }

    static class SchemaEntityResolver
    implements EntityResolver {
        SchemaEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws IOException {
            if (string.equals("-//EXOLAB/Tyrex Configuration DTD Version 1.0//EN") || string2.equals("http://tyrex.exolab.org/tyrex.dtd")) {
                InputSource inputSource = new InputSource();
                inputSource.setByteStream((class$tyrex$conf$Server != null ? class$tyrex$conf$Server : (class$tyrex$conf$Server = Server.class$("tyrex.conf.Server"))).getResourceAsStream("/tyrex/conf/tyrex.dtd"));
                return inputSource;
            }
            if (string.equals("-//EXOLAB/Tyrex Configuration Schema Version 1.0//EN") || string2.equals("http://tyrex.exolab.org/tyrex.xsd")) {
                InputSource inputSource = new InputSource();
                inputSource.setByteStream((class$tyrex$conf$Server != null ? class$tyrex$conf$Server : (class$tyrex$conf$Server = Server.class$("tyrex.conf.Server"))).getResourceAsStream("/tyrex/conf/tyrex.xsd"));
                return inputSource;
            }
            return null;
        }
    }
}

