/*
 * Decompiled with CFR 0.152.
 */
package tyrex.connector.jdbc;

import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import tyrex.connector.AbstractManagedConnection;
import tyrex.connector.ConnectionException;
import tyrex.connector.ManagedConnection;
import tyrex.connector.jdbc.JDBCConnectionHandle;
import tyrex.connector.jdbc.JDBCConnectionInfo;

public final class JDBCManagedConnection
extends AbstractManagedConnection
implements ManagedConnection,
ConnectionEventListener {
    private final XAConnection xaConnection;
    private final Connection connection;
    private WeakReference currentHandleReference;
    private final JDBCConnectionInfo info;

    public JDBCManagedConnection(XAConnection xAConnection, JDBCConnectionInfo jDBCConnectionInfo) throws ConnectionException {
        this.xaConnection = xAConnection;
        this.xaConnection.addConnectionEventListener(this);
        this.info = jDBCConnectionInfo;
        try {
            this.connection = xAConnection.getConnection();
            this.connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new ConnectionException(sQLException);
        }
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        this.fireConnectionErrorOccurredEvent(new ConnectionException("The underlying java.sql.Connection used by the JDBCManagedConnection has been closed externally."));
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        this.fireConnectionErrorOccurredEvent(connectionEvent.getSQLException());
    }

    protected XAResource createXAResource() throws ConnectionException {
        try {
            return this.xaConnection.getXAResource();
        }
        catch (SQLException sQLException) {
            throw new ConnectionException("Failed to get XA resource for <" + this.toString() + ">.");
        }
    }

    private void disconnectCurrentConnection() {
        JDBCConnectionHandle jDBCConnectionHandle;
        JDBCConnectionHandle jDBCConnectionHandle2 = jDBCConnectionHandle = this.currentHandleReference == null ? null : (JDBCConnectionHandle)this.currentHandleReference.get();
        if (jDBCConnectionHandle != null) {
            jDBCConnectionHandle.disconnect();
            this.currentHandleReference = null;
        }
    }

    public synchronized Object getConnection(Object object) throws ConnectionException {
        this.checkClosed();
        this.disconnectCurrentConnection();
        JDBCConnectionHandle jDBCConnectionHandle = new JDBCConnectionHandle(this, this.connection);
        this.currentHandleReference = new WeakReference<JDBCConnectionHandle>(jDBCConnectionHandle);
        return jDBCConnectionHandle;
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    boolean isSameInfo(JDBCConnectionInfo jDBCConnectionInfo) {
        return this.info == null && jDBCConnectionInfo == null || this.info != null && this.info.equals(jDBCConnectionInfo);
    }

    synchronized void notifyClosed() {
        this.currentHandleReference = null;
        this.fireConnectionClosedEvent();
    }

    protected void performClose() throws ConnectionException {
        this.xaConnection.removeConnectionEventListener(this);
        try {
            try {
                this.xaConnection.close();
            }
            catch (SQLException sQLException) {
                throw new ConnectionException(sQLException);
            }
            Object var2_2 = null;
            this.disconnectCurrentConnection();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.disconnectCurrentConnection();
            throw throwable;
        }
    }

    public void setLogWriter(PrintWriter printWriter) {
    }
}

