/*
 * Decompiled with CFR 0.152.
 */
package tyrex.recovery;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import org.omg.CORBA.ORB;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Vote;
import tyrex.recovery.ConnectionLog;
import tyrex.recovery.LogReader;
import tyrex.recovery.ResourceLog;
import tyrex.tm.XidImpl;

public class LogMonitor {
    private LogReader _reader;
    private String _last_log;
    private ORB _orb;
    private String _directory;

    public LogMonitor(String string) {
        this._directory = string;
    }

    private void exception(String string, String string2, Exception exception) {
    }

    public Resource[] free_ots_resources(XidImpl xidImpl) {
        Resource[] resourceArray = null;
        Vector vector = new Vector();
        this.openLast();
        boolean bl = this._reader.free_ots_resources(xidImpl, vector);
        if (bl) {
            while (this.openPrevious() && !(bl = this._reader.free_ots_resources(xidImpl, vector))) {
            }
        }
        this._reader.close();
        int n = 0;
        ResourceLog resourceLog = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            resourceLog = (ResourceLog)vector.elementAt(n2);
            if (!resourceLog.reserved) {
                ++n;
            }
            ++n2;
        }
        resourceArray = new Resource[n];
        n = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            resourceLog = (ResourceLog)vector.elementAt(n3);
            if (!resourceLog.reserved) {
                resourceArray[n++] = resourceLog.resource;
            }
            ++n3;
        }
        return resourceArray;
    }

    public boolean is_any_rollback(XidImpl xidImpl) {
        boolean bl = false;
        this.openLast();
        int n = this._reader.is_any_rollback(xidImpl);
        if (n == 0) {
            while (this.openPrevious() && (n = this._reader.is_any_rollback(xidImpl)) == 0) {
            }
        }
        this._reader.close();
        if (n == 1) {
            bl = true;
        }
        return bl;
    }

    private void openLast() {
        if (this._reader != null) {
            this._reader.close();
        }
        if (this._last_log == null) {
            if (!this._directory.endsWith(File.separator)) {
                this._directory = String.valueOf(this._directory) + File.separator;
            }
            String string = String.valueOf(this._directory) + "ots.log";
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                this._last_log = dataInputStream.readUTF();
                dataInputStream.close();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                this.exception("LogMonitor", "Unable to read lock file for log !", iOException);
            }
        }
        this.openReader(this._last_log);
    }

    private boolean openPrevious() {
        String string = this._reader.previous_log();
        if (string == null) {
            return false;
        }
        this._reader.close();
        this.openReader(string);
        return true;
    }

    private void openReader(String string) {
        this._reader = new LogReader(string, this._orb);
    }

    public ConnectionLog[] open_connections() {
        return this._reader.open_connections();
    }

    public Vote prepare_vote(XidImpl xidImpl) {
        this.openLast();
        int n = this._reader.prepare_vote(xidImpl);
        if (n == -1) {
            while (this.openPrevious() && (n = this._reader.prepare_vote(xidImpl)) == -1) {
            }
        }
        this._reader.close();
        return Vote.from_int((int)n);
    }

    public Resource[] prepared_ots_resources(XidImpl xidImpl) {
        Resource[] resourceArray = null;
        Vector vector = new Vector();
        this.openLast();
        boolean bl = this._reader.prepared_ots_resources(xidImpl, vector);
        if (bl) {
            while (this.openPrevious() && !(bl = this._reader.prepared_ots_resources(xidImpl, vector))) {
            }
        }
        this._reader.close();
        int n = 0;
        ResourceLog resourceLog = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            resourceLog = (ResourceLog)vector.elementAt(n2);
            if (!resourceLog.reserved) {
                ++n;
            }
            ++n2;
        }
        resourceArray = new Resource[n];
        n = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            resourceLog = (ResourceLog)vector.elementAt(n3);
            if (!resourceLog.reserved) {
                resourceArray[n++] = resourceLog.resource;
            }
            ++n3;
        }
        return resourceArray;
    }

    public Resource[] registered_ots_resources(XidImpl xidImpl) {
        Resource[] resourceArray = null;
        Vector vector = new Vector();
        this.openLast();
        boolean bl = this._reader.registered_ots_resources(xidImpl, vector);
        if (bl) {
            while (this.openPrevious() && !(bl = this._reader.registered_ots_resources(xidImpl, vector))) {
            }
        }
        this._reader.close();
        resourceArray = new Resource[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            resourceArray[n] = (Resource)vector.elementAt(n);
            ++n;
        }
        return resourceArray;
    }

    public void setORB(ORB oRB) {
        this._orb = oRB;
    }

    public Status transaction_status(XidImpl xidImpl) {
        Status status = null;
        this.openLast();
        status = this._reader.transaction_status(xidImpl);
        if (status.value() == 6) {
            while (this.openPrevious() && (status = this._reader.transaction_status(xidImpl)).value() == 6) {
            }
        }
        this._reader.close();
        return status;
    }

    public XidImpl[] uncompleted_transactions() {
        this.openLast();
        XidImpl[] xidImplArray = this._reader.uncompleted_transactions();
        this._reader.close();
        return xidImplArray;
    }
}

