/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tools;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Random;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import tyrex.server.Configure;
import tyrex.tm.Tyrex;

public class Demo
extends Thread {
    private static TransactionManager _tmManager;
    private static Random _random;
    private static PrintWriter _writer;

    static {
        _random = new Random();
    }

    static int getArgumentValue(String[] stringArray, String string, int n) {
        string = "--" + string;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals(string) && n2 + 1 < stringArray.length) {
                try {
                    return Integer.parseInt(stringArray[n2 + 1]);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n2;
        }
        return n;
    }

    static String getArgumentValue(String[] stringArray, String string, String string2) {
        string = "--" + string;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string) && n + 1 < stringArray.length) {
                return stringArray[n + 1];
            }
            ++n;
        }
        return string2;
    }

    static boolean hasArgument(String[] stringArray, String string) {
        string = "--" + string;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        if (Demo.hasArgument(stringArray, "help")) {
            Demo.showUsage();
            System.exit(0);
        } else if (stringArray.length == 0) {
            System.out.println("Run with --help to see list of options");
        }
        try {
            _writer = Demo.hasArgument(stringArray, "log") ? new PrintWriter(new FileOutputStream(Demo.getArgumentValue(stringArray, "log", "log"))) : new PrintWriter(System.out, true);
            Configure configure = new Configure();
            if (Demo.hasArgument(stringArray, "activity")) {
                configure.setLogWriter(_writer);
            }
            configure.startServer();
            if (Demo.hasArgument(stringArray, "choke")) {
                configure.setTransactionTimeout(10);
                configure.setThreadTerminate(true);
            }
            _tmManager = Tyrex.getTransactionManager();
            int n = Demo.getArgumentValue(stringArray, "count", 100);
            _writer.println("Running demonstration with " + n + " concurrent threads");
            while (n-- > 0) {
                new Demo().start();
            }
            if (Demo.hasArgument(stringArray, "dump")) {
                while (true) {
                    Thread.sleep(2000L);
                    Tyrex.dumpTransactionList(_writer);
                }
            }
        }
        catch (Exception exception) {
            _writer.println(exception);
            exception.printStackTrace(_writer);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    _tmManager.begin();
                    Thread.sleep(_random.nextInt(5000));
                    if (_random.nextBoolean()) {
                        Transaction transaction = _tmManager.suspend();
                        Thread.sleep(_random.nextInt(5000));
                        _tmManager.resume(transaction);
                    }
                    if (_random.nextBoolean()) {
                        _tmManager.commit();
                    } else {
                        _tmManager.rollback();
                    }
                    Thread.sleep(_random.nextInt(5000));
                }
            }
            catch (Exception exception) {
                _writer.println(exception);
                exception.printStackTrace();
                try {
                    Tyrex.dumpCurrentTransaction(_writer);
                    Tyrex.recycleThread();
                    continue;
                }
                catch (Exception exception2) {
                    continue;
                }
            }
            break;
        }
    }

    static void showUsage() {
        System.out.println("java tyrex.server.Demo [options]");
        System.out.println("  --help      Show this message");
        System.out.println("  --count n   How many threads to run (default 100)");
        System.out.println("  --log file  Dump all logs to the named file");
        System.out.println("  --meter     Log: meter counters");
        System.out.println("  --activity  Log: transaction server activity log");
        System.out.println("  --dump      Log: transaction list every 2 seconds");
        System.out.println("  --choke     Unrealistic limit on active transactions");
        System.out.println("");
    }
}

