/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.beans.beaninfo.BiIconEditor;
import org.openide.NotifyDescriptor;
import org.openide.Places;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

class BiIconEditor
extends PropertyEditorSupport {
    private static final String BEAN_ICONEDITOR_HELP = "beans.icon";
    static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$beans$beaninfo$BiIconEditor == null ? (class$org$netbeans$modules$beans$beaninfo$BiIconEditor = BiIconEditor.class$("org.netbeans.modules.beans.beaninfo.BiIconEditor")) : class$org$netbeans$modules$beans$beaninfo$BiIconEditor));
    static /* synthetic */ Class class$org$netbeans$modules$beans$beaninfo$BiIconEditor;

    public static boolean isImage(String string) {
        return (string = string.toLowerCase()).endsWith(".jpg") || string.endsWith(".gif") || string.endsWith(".jpeg") || string.endsWith(".jpe") || string.equals("jpg") || string.equals("gif") || string.equals("jpeg") || string.equals("jpe");
    }

    public String getSourceName() {
        if (this.getValue() instanceof BiImageIcon) {
            return ((BiImageIcon)this.getValue()).name;
        }
        return null;
    }

    public String getAsText() {
        Object object = this.getValue();
        if (object == null) {
            return "null";
        }
        if (object instanceof BiImageIcon) {
            BiImageIcon biImageIcon = (BiImageIcon)object;
            return biImageIcon.name;
        }
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(this.iconFromText(string));
    }

    private BiImageIcon iconFromText(String string) throws IllegalArgumentException {
        BiImageIcon biImageIcon;
        try {
            if (string.length() == 0 || string.equals("null")) {
                biImageIcon = null;
            } else {
                URL uRL = TopManager.getDefault().currentClassLoader().getResource(string);
                biImageIcon = new BiImageIcon(uRL);
                biImageIcon.name = string;
            }
        }
        catch (Throwable throwable) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                throwable.printStackTrace();
            }
            throw new IllegalArgumentException(throwable.toString());
        }
        return biImageIcon;
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new IconPanel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class IconPanel
    extends JPanel
    implements EnhancedCustomPropertyEditor {
        JRadioButton rbClasspath;
        JRadioButton rbNoPicture;
        JTextField tfName;
        JButton bSelect;
        JScrollPane spImage;
        static final long serialVersionUID = -6904264999063788703L;

        IconPanel() {
            this.setLayout(new BorderLayout(6, 6));
            this.setBorder(new EmptyBorder(6, 6, 6, 6));
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACS_IconPanelA11yName"));
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_IconPanelA11yDesc"));
            JPanel jPanel = new JPanel(new BorderLayout(3, 3));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(new TitledBorder(new EtchedBorder(), bundle.getString("CTL_ImageSourceType")));
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(new EmptyBorder(0, 3, 0, 3));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel3.setLayout(gridBagLayout);
            gridBagConstraints.anchor = 17;
            this.rbClasspath = new JRadioButton(bundle.getString("CTL_Classpath"));
            jPanel3.add(this.rbClasspath);
            this.rbClasspath.setToolTipText(bundle.getString("ACS_ClasspathA11yDesc"));
            this.rbClasspath.setMnemonic(bundle.getString("CTL_Classpath_Mnemonic").charAt(0));
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.rbClasspath, gridBagConstraints);
            JLabel jLabel = new JLabel(bundle.getString("CTL_ClasspathExample"));
            jPanel3.add(jLabel);
            jLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ClasspathExampleA11yDesc"));
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.rbNoPicture = new JRadioButton(bundle.getString("CTL_NoPicture"));
            jPanel3.add(this.rbNoPicture);
            this.rbNoPicture.setToolTipText(bundle.getString("ACS_NoPictureA11yDesc"));
            this.rbNoPicture.setMnemonic(bundle.getString("CTL_NoPicture_Mnemonic").charAt(0));
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.rbNoPicture, gridBagConstraints);
            jLabel = new JLabel(bundle.getString("CTL_Null"));
            jPanel3.add(jLabel);
            jLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NullA11yDesc"));
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbClasspath);
            buttonGroup.add(this.rbNoPicture);
            this.rbClasspath.setSelected(true);
            jPanel2.add((Component)jPanel3, "West");
            jPanel.add((Component)jPanel2, "North");
            jPanel2 = new JPanel(new BorderLayout(6, 6));
            JLabel jLabel2 = new JLabel(bundle.getString("CTL_ImageSourceName"));
            jLabel2.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ImageSourceNameA11yDesc"));
            jLabel2.setDisplayedMnemonic(bundle.getString("CTL_ImageSourceName_Mnemonic").charAt(0));
            jPanel2.add((Component)jLabel2, "West");
            this.tfName = new JTextField();
            jPanel2.add((Component)this.tfName, "Center");
            jLabel2.setLabelFor(this.tfName);
            this.tfName.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ImageSourceNameTextFieldA11yName"));
            this.tfName.setToolTipText(bundle.getString("ACS_ImageSourceNameTextFieldA11yDesc"));
            this.bSelect = new JButton("...");
            jPanel2.add((Component)this.bSelect, "East");
            this.bSelect.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ImageSourceNameBrowseButtonA11yName"));
            this.bSelect.setToolTipText(bundle.getString("ACS_ImageSourceNameBrowseButtonA11yDesc"));
            this.bSelect.setEnabled(false);
            jPanel.add((Component)jPanel2, "South");
            this.add((Component)jPanel, "North");
            this.spImage = new JScrollPane(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(60, 60);
                }
            };
            this.add((Component)this.spImage, "Center");
            this.tfName.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.setValue();
                }
            });
            this.rbClasspath.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.bSelect.setEnabled(true);
                    this.this$1.tfName.setEnabled(true);
                    this.this$1.setValue();
                }
            });
            this.rbNoPicture.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.bSelect.setEnabled(false);
                    this.this$1.tfName.setEnabled(false);
                    IconPanel.access$000(this.this$1).setValue(null);
                    this.this$1.updateIcon();
                }
            });
            this.bSelect.addActionListener(new ActionListener(this){
                static /* synthetic */ Class class$org$openide$loaders$DataObject;
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.rbClasspath.isSelected()) {
                        String string;
                        Places places = TopManager.getDefault().getPlaces();
                        Node node = places.nodes().repository(new DataFilter(this){
                            private final /* synthetic */ 5 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public boolean acceptDataObject(DataObject dataObject) {
                                if (dataObject instanceof DataFolder) {
                                    return !dataObject.getPrimaryFile().isReadOnly() || dataObject.getPrimaryFile().getParent() != null;
                                }
                                return BiIconEditor.isImage(dataObject.getPrimaryFile().getExt());
                            }
                        });
                        try {
                            DataObject dataObject = (DataObject)TopManager.getDefault().getNodeOperation().select(bundle.getString("CTL_OpenDialogName"), bundle.getString("CTL_FileSystemName"), TopManager.getDefault().getPlaces().nodes().repository(), new NodeAcceptor(this){
                                static /* synthetic */ Class class$org$openide$loaders$DataFolder;
                                private final /* synthetic */ 5 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public boolean acceptNodes(Node[] nodeArray) {
                                    if (nodeArray == null || nodeArray.length != 1) {
                                        return false;
                                    }
                                    return nodeArray[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = 7.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) == null;
                                }

                                static /* synthetic */ Class class$(String string) {
                                    try {
                                        return Class.forName(string);
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                            }, null)[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = 5.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                            string = dataObject.getPrimaryFile().getPackageNameExt('/', '.');
                        }
                        catch (UserCancelException userCancelException) {
                            return;
                        }
                        this.this$1.tfName.setText("/" + string);
                        this.this$1.setValue();
                    }
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
            this.updateIcon();
            HelpCtx.setHelpIDString((JComponent)this, (String)BiIconEditor.BEAN_ICONEDITOR_HELP);
            Icon icon = (Icon)BiIconEditor.this.getValue();
            if (icon == null) {
                this.rbNoPicture.setSelected(true);
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(false);
                return;
            }
            if (!(icon instanceof BiImageIcon)) {
                return;
            }
            this.rbClasspath.setSelected(true);
            this.bSelect.setEnabled(true);
            this.tfName.setText(((BiImageIcon)icon).name);
        }

        void updateIcon() {
            Icon icon = (Icon)BiIconEditor.this.getValue();
            this.spImage.setViewportView(icon == null ? new JLabel() : new JLabel(icon));
            this.validate();
        }

        void setValue() {
            block3: {
                String string = this.tfName.getText();
                string.trim();
                if ("".equals(string)) {
                    BiIconEditor.this.setValue(null);
                    return;
                }
                try {
                    BiIconEditor.this.setValue(BiIconEditor.this.iconFromText(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                    illegalArgumentException.printStackTrace();
                }
            }
            this.updateIcon();
        }

        public Object getPropertyValue() throws IllegalStateException {
            BiImageIcon biImageIcon = null;
            String string = this.tfName.getText().trim();
            try {
                if (this.rbClasspath.isSelected() && string.length() != 0) {
                    URL uRL = TopManager.getDefault().currentClassLoader().getResource(string);
                    try {
                        biImageIcon = new BiImageIcon(uRL);
                        biImageIcon.name = string;
                    }
                    catch (Throwable throwable) {
                        MessageFormat messageFormat = new MessageFormat(bundle.getString("CTL_Icon_not_exists"));
                        Object[] objectArray = new Object[]{string};
                        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)messageFormat.format(objectArray), 0));
                    }
                }
            }
            catch (Exception exception) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    exception.printStackTrace();
                }
                throw new IllegalStateException(exception.toString());
            }
            BiIconEditor.this.setValue(biImageIcon);
            return biImageIcon;
        }

        static /* synthetic */ BiIconEditor access$000(IconPanel iconPanel) {
            return iconPanel.BiIconEditor.this;
        }
    }

    public static class BiImageIcon
    extends ImageIcon
    implements Externalizable {
        static final long serialVersionUID = 7018807466471349466L;
        String name;

        public BiImageIcon() {
        }

        BiImageIcon(URL uRL) {
            super(uRL);
        }

        BiImageIcon(String string) {
            super(string);
        }

        String getName() {
            return this.name;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this.name);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.name = (String)objectInput.readObject();
            ImageIcon imageIcon = null;
            imageIcon = new ImageIcon(TopManager.getDefault().currentClassLoader().getResource(this.name));
            this.setImage(imageIcon.getImage());
        }
    }
}

