/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;

public class ChunkedInputFilter
implements InputFilter {
    protected static final String ENCODING_NAME = "chunked";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected InputBuffer buffer;
    protected int remaining = 0;
    protected int pos = 0;
    protected int lastValid = 0;
    protected byte[] buf = null;
    protected ByteChunk readChunk = new ByteChunk();
    protected boolean endChunk = false;

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
    }

    public int doRead(ByteChunk chunk, Request req) throws IOException {
        if (this.endChunk) {
            return -1;
        }
        if (this.remaining <= 0) {
            if (!this.parseChunkHeader()) {
                throw new IOException("Invalid chunk");
            }
            if (this.endChunk) {
                this.parseEndChunk();
                return -1;
            }
        }
        int result = 0;
        if (this.pos >= this.lastValid) {
            this.readBytes();
        }
        if (this.remaining > this.lastValid - this.pos) {
            result = this.lastValid - this.pos;
            this.remaining -= result;
            chunk.setBytes(this.buf, this.pos, result);
            this.pos = this.lastValid;
        } else {
            result = this.remaining;
            chunk.setBytes(this.buf, this.pos, this.remaining);
            this.pos += this.remaining;
            this.remaining = 0;
            this.parseCRLF();
        }
        return result;
    }

    public long end() throws IOException {
        while (this.doRead(this.readChunk, null) >= 0) {
        }
        return this.lastValid - this.pos;
    }

    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    protected boolean parseCRLF() throws IOException {
        boolean eol = false;
        while (!eol) {
            if (this.pos >= this.lastValid && this.readBytes() <= 0) {
                return false;
            }
            if (this.buf[this.pos] != 13) {
                if (this.buf[this.pos] == 10) {
                    eol = true;
                } else {
                    return false;
                }
            }
            ++this.pos;
        }
        return true;
    }

    protected boolean parseChunkHeader() throws IOException {
        int begin;
        int result = 0;
        boolean eol = false;
        int end = begin = this.pos;
        boolean readDigit = false;
        while (!eol) {
            if (this.pos >= this.lastValid && this.readBytes() <= 0) {
                return false;
            }
            if (this.buf[this.pos] != 13) {
                if (this.buf[this.pos] == 10) {
                    eol = true;
                } else if (HexUtils.DEC[this.buf[this.pos]] != -1) {
                    if (!readDigit) {
                        readDigit = true;
                        begin = this.pos;
                    }
                    end = this.pos;
                }
            }
            ++this.pos;
        }
        if (!readDigit) {
            return false;
        }
        int offset = 1;
        int i = end;
        while (i >= begin) {
            int val = HexUtils.DEC[this.buf[i]];
            if (val == -1) {
                return false;
            }
            result += val * offset;
            offset *= 16;
            --i;
        }
        if (result == 0) {
            this.endChunk = true;
        }
        this.remaining = result;
        return true;
    }

    protected boolean parseEndChunk() throws IOException {
        return this.parseCRLF();
    }

    protected int readBytes() throws IOException {
        int nRead = this.buffer.doRead(this.readChunk, null);
        this.pos = this.readChunk.getStart();
        this.lastValid = this.pos + nRead;
        this.buf = this.readChunk.getBytes();
        return nRead;
    }

    public void recycle() {
        this.remaining = 0;
        this.pos = 0;
        this.lastValid = 0;
        this.endChunk = false;
    }

    public void setBuffer(InputBuffer buffer) {
        this.buffer = buffer;
    }

    public void setRequest(Request request) {
    }
}

