/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jndi.settings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import org.netbeans.modules.jndi.JndiRootNode;
import org.netbeans.modules.jndi.ProviderProperties;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;

public class JndiSystemOption
extends SystemOption
implements PropertyChangeListener {
    public static final int DEFAULT_TIMEOUT = 4000;
    private static final long serialVersionUID = -4589004604197297781L;
    private static int timeOut;
    private transient ArrayList redProviders;
    private transient HashMap providers;
    static /* synthetic */ Class class$org$netbeans$modules$jndi$JndiProvidersNode;

    public JndiSystemOption() {
        timeOut = 4000;
    }

    public int getTimeOut() {
        return timeOut;
    }

    public void setTimeOut(int n) {
        int n2 = timeOut;
        timeOut = n;
        this.firePropertyChange("timeOut", new Integer(n2), new Integer(n));
    }

    public String displayName() {
        return JndiRootNode.getLocalizedString("Module_Name");
    }

    public void readExternal(ObjectInput objectInput) {
        try {
            timeOut = (Integer)objectInput.readObject();
            this.redProviders = (ArrayList)objectInput.readObject();
            if (this.redProviders == null) {
                this.redProviders = new ArrayList();
            }
        }
        catch (IOException iOException) {
            timeOut = 4000;
        }
        catch (ClassNotFoundException classNotFoundException) {
            timeOut = 4000;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) {
        try {
            objectOutput.writeObject(new Integer(timeOut));
            objectOutput.writeObject(this.redProviders);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final boolean isGlobal() {
        return false;
    }

    public ArrayList getInitialContexts() {
        return this.redProviders;
    }

    public void setInitialContexts(ArrayList arrayList) {
        ArrayList arrayList2 = this.redProviders;
        this.redProviders = arrayList;
        this.firePropertyChange("initialContexts", null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroyProvider(String string) throws IOException {
        block4: {
            FileLock fileLock = null;
            try {
                FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
                FileObject fileObject = fileSystem.getRoot().getFileObject("JNDI");
                String string2 = string.replace('.', '_');
                fileObject = fileObject.getFileObject(string2, "impl");
                if (fileObject != null) {
                    fileLock = fileObject.lock();
                    fileObject.delete(fileLock);
                }
                Object var7_6 = null;
                if (fileLock == null) break block4;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                throw throwable;
            }
            fileLock.releaseLock();
        }
        this.providers.remove(string);
    }

    public HashMap getProviders(boolean bl) {
        if (this.providers == null || bl) {
            this.readProperties();
        }
        return this.providers;
    }

    private void readProperties() {
        if (this.providers == null) {
            this.providers = new HashMap();
        } else {
            this.providers.clear();
        }
        Repository repository = TopManager.getDefault().getRepository();
        FileSystem fileSystem = repository.getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject("JNDI");
        if (fileObject == null) {
            TopManager.getDefault().getErrorManager().log(NbBundle.getBundle((Class)(class$org$netbeans$modules$jndi$JndiProvidersNode == null ? (class$org$netbeans$modules$jndi$JndiProvidersNode = JndiSystemOption.class$("org.netbeans.modules.jndi.JndiProvidersNode")) : class$org$netbeans$modules$jndi$JndiProvidersNode)).getString("ERR_CanNotOpenJNDIFolder"));
            return;
        }
        Enumeration enumeration = fileObject.getData(false);
        while (enumeration.hasMoreElements()) {
            fileObject = (FileObject)enumeration.nextElement();
            try {
                if (!fileObject.getExt().equals("impl")) continue;
                InputStream inputStream = fileObject.getInputStream();
                ProviderProperties providerProperties = new ProviderProperties();
                providerProperties.load(inputStream);
                providerProperties.addPropertyChangeListener(this);
                this.providers.put(providerProperties.getFactory(), providerProperties);
                inputStream.close();
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().log(NbBundle.getBundle((Class)(class$org$netbeans$modules$jndi$JndiProvidersNode == null ? JndiSystemOption.class$("org.netbeans.modules.jndi.JndiProvidersNode") : class$org$netbeans$modules$jndi$JndiProvidersNode)).getString("ERR_ErrorReadProvider" + fileObject.getName()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ProviderProperties providerProperties = (ProviderProperties)propertyChangeEvent.getSource();
        String string = providerProperties.getFactory().replace('.', '_');
        FileObject fileObject = TopManager.getDefault().getRepository().getDefaultFileSystem().getRoot().getFileObject("JNDI");
        if (fileObject == null) {
            this.notifyFileError();
            return;
        }
        if ((fileObject = fileObject.getFileObject(string, "impl")) == null) {
            this.notifyFileError();
            return;
        }
        FileLock fileLock = null;
        try {
            try {
                fileLock = fileObject.lock();
                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                providerProperties.store(outputStream, JndiRootNode.getLocalizedString("FILE_COMMENT"));
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                this.notifyFileError();
                Object var8_9 = null;
                if (fileLock == null) return;
                fileLock.releaseLock();
                return;
            }
            Object var8_8 = null;
            if (fileLock == null) return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    private void notifyFileError() {
        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JndiRootNode.getLocalizedString("EXC_Template_IOError"), 0));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

