/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.netbeans.core.NbErrorManager;
import org.netbeans.lib.logger.LoggerChangedEvent;
import org.netbeans.lib.logger.LoggerChangedListener;
import org.netbeans.lib.logger.TraceLogger;
import org.netbeans.lib.logger.impl.TraceLoggerImpl;
import org.openide.ErrorManager;

public final class NbTraceErrorManager
extends ErrorManager
implements LoggerChangedListener {
    private int minLogSeverity = 0;
    private String name;
    private int moduleId;
    private TraceLogger traceLgr = TraceLogger.getTraceLogger();
    public boolean debug;
    private static final int MAX_DBG_GROUP = 1;
    public static final int UNKNOWN = 1;
    public static final int ERROR = 11;
    public static final int EXCEPTION = 21;
    public static final int USER = 31;
    public static final int WARNING = 41;
    public static final int INFORMATIONAL = 51;
    NbTraceErrorManager parentErrMgr;
    static HashMap errorManagers = new HashMap();
    NbErrorManager delegate;
    private static final String DEFAULT_NAME = "default";

    public NbTraceErrorManager(String string) {
        this.moduleId = this.traceLgr.getModuleId(string);
        this.name = string;
        this.delegate = new NbErrorManager();
        this.setupDebugNotification();
    }

    public NbTraceErrorManager() {
        this(DEFAULT_NAME);
    }

    public boolean isLoggable(int n) {
        if (!this.debug) {
            return false;
        }
        int n2 = this.mapSeverity(n);
        boolean bl = this.traceLgr.test(7, this.moduleId, 1, n2);
        if (bl) {
            return true;
        }
        if (this.parentErrMgr != null) {
            return this.parentErrMgr.isLoggable(n);
        }
        return false;
    }

    protected int mapSeverity(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 51;
                break;
            }
            case 16: {
                n2 = 41;
                break;
            }
            case 256: {
                n2 = 31;
                break;
            }
            case 4096: {
                n2 = 21;
                break;
            }
            case 65536: {
                n2 = 11;
                break;
            }
        }
        return n2;
    }

    public void log(int n, String string) {
        if (this.debug) {
            int n2 = this.mapSeverity(n);
            Vector vector = ((TraceLoggerImpl)this.traceLgr).getLogStreamNames();
            int n3 = 0;
            while (n3 < vector.size()) {
                String string2 = (String)vector.get(n3);
                if (string2 != null) {
                    this.hierarchyLogging(n2, string + "\n", string2);
                }
                ++n3;
            }
        }
    }

    void hierarchyLogging(int n, String string, String string2) {
        if (this.debug) {
            boolean bl = false;
            bl = ((TraceLoggerImpl)this.traceLgr).testAndPrintToLogStream(string2, 7, this.moduleId, 1, n, string);
            if (!bl && this.parentErrMgr != null) {
                this.parentErrMgr.hierarchyLogging(n, string, string2);
            }
        }
    }

    void setupDebugNotification() {
        TraceLogger.getTraceLogger().addLoggerChangedListener(this);
        this.updateDebugField();
    }

    public void loggerChanged(LoggerChangedEvent loggerChangedEvent) {
        this.updateDebugField();
    }

    boolean updateDebugField() {
        int n;
        this.debug = TraceLogger.dbg ? ((n = this.traceLgr.getLevel(7, this.moduleId, 1)) > 0 ? true : (this.parentErrMgr != null ? this.parentErrMgr.updateDebugField() : false)) : false;
        return this.debug;
    }

    public final ErrorManager getInstance(String string) {
        int n = -1;
        NbTraceErrorManager nbTraceErrorManager = null;
        if (string == null) {
            throw new RuntimeException("Null name specified for NbTraceErrorManager.getInstance method parameter.");
        }
        if (string.length() > 0 && (nbTraceErrorManager = (NbTraceErrorManager)errorManagers.get(string)) == null) {
            nbTraceErrorManager = new NbTraceErrorManager(string);
            errorManagers.put(string, nbTraceErrorManager);
            n = string.lastIndexOf(46);
            String string2 = n > 0 ? string.substring(0, n) : "";
            nbTraceErrorManager.parentErrMgr = (NbTraceErrorManager)this.getInstance(string2);
            nbTraceErrorManager.updateDebugField();
        }
        return nbTraceErrorManager;
    }

    public synchronized ErrorManager.Annotation[] findAnnotations(Throwable throwable) {
        return this.delegate.findAnnotations(throwable);
    }

    public synchronized Throwable annotate(Throwable throwable, int n, String string, String string2, Throwable throwable2, Date date) {
        return this.delegate.annotate(throwable, n, string, string2, throwable2, date);
    }

    public synchronized Throwable attachAnnotations(Throwable throwable, ErrorManager.Annotation[] annotationArray) {
        return this.delegate.attachAnnotations(throwable, annotationArray);
    }

    public synchronized void notify(int n, Throwable throwable) {
        this.delegate.notify(n, throwable);
    }

    public String toString() {
        return super.toString() + "  Name is " + this.name;
    }
}

