/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.logger;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.lib.logger.LoggerChangedEvent;
import org.netbeans.lib.logger.LoggerChangedListener;
import org.netbeans.lib.logger.TraceService;
import org.netbeans.lib.logger.impl.StringScanner;
import org.netbeans.lib.logger.impl.TraceLoggerImpl;

public abstract class TraceLogger {
    public static final int MAXLEVEL = 255;
    public static final int MAXGROUP = 63;
    public static final int ERROR = 1;
    public static final int SECURITY = 2;
    public static final int RESOURCE = 3;
    public static final int AUDIT = 4;
    public static final int CONFIGURATION = 5;
    public static final int PERFORMANCE = 6;
    public static final int DEBUG = 7;
    public static boolean err = false;
    public static boolean sec = false;
    public static boolean res = false;
    public static boolean aud = false;
    public static boolean cfg = false;
    public static boolean prf = false;
    public static boolean dbg = false;
    public static final int MAXTYPE = 7;
    public static final int TEST_MODULE_ID = 1;
    public static final int CFG_DIFFABLE_EXCEPTS = 1;
    private static TraceLogger lgr;
    protected static int currModuleCount;
    private ArrayList loggerChangedListenerList = new ArrayList();

    protected TraceLogger() {
    }

    public void addLoggerChangedListener(LoggerChangedListener loggerChangedListener) {
        ArrayList arrayList = this.loggerChangedListenerList;
        synchronized (arrayList) {
            this.loggerChangedListenerList.add(loggerChangedListener);
        }
    }

    public void removeLoggerChangedListener(LoggerChangedListener loggerChangedListener) {
        ArrayList arrayList = this.loggerChangedListenerList;
        synchronized (arrayList) {
            ((AbstractCollection)this.loggerChangedListenerList).remove(loggerChangedListener);
        }
    }

    public void notifyLoggerChangedListeners(LoggerChangedEvent loggerChangedEvent) {
        ArrayList arrayList = this.loggerChangedListenerList;
        synchronized (arrayList) {
            if (this.loggerChangedListenerList.size() == 0) {
                return;
            }
            Iterator iterator = ((AbstractList)this.loggerChangedListenerList).iterator();
            while (iterator.hasNext()) {
                LoggerChangedListener loggerChangedListener = (LoggerChangedListener)iterator.next();
                try {
                    loggerChangedListener.loggerChanged(loggerChangedEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public abstract void flush();

    public abstract void modifyFlags(String var1);

    public abstract void modifyFlags(String var1, String var2);

    public abstract void modifyFlags(PrintWriter var1, String var2);

    public abstract void modifyFlags(PrintStream var1, String var2);

    public void put(int n) {
        this.put(StringScanner.getIntStr(n), false);
    }

    public void putHex(int n) {
        this.put(Integer.toHexString(n), false);
    }

    public void put(double d) {
        this.put(Double.toString(d), false);
    }

    public void put(boolean bl) {
        this.put(bl ? "true" : "false", false);
    }

    public void put(Object object) {
        this.put(object.toString(), false);
    }

    public void put(String string, boolean bl) {
        this.put(0, 0, 0, 0, string, bl);
    }

    public abstract void put(int var1, int var2, int var3, int var4, String var5, boolean var6);

    public abstract void put(int var1, int var2, int var3, int var4, int var5, Object var6);

    public abstract void println(int var1, int var2, int var3, int var4, int var5, Object var6);

    public void putLine(int n) {
        this.put(StringScanner.getIntStr(n), true);
    }

    public void putHexLine(int n) {
        this.put(Integer.toHexString(n), true);
    }

    public void putLine(double d) {
        this.put(Double.toString(d), true);
    }

    public void putLine(boolean bl) {
        this.put(bl ? "true" : "false", true);
    }

    public void putLine(Object object) {
        this.put(object.toString(), true);
    }

    public void put(int n, int n2, int n3, int n4, int n5) {
        if (this.test(n, n2, n3, n4)) {
            this.put(n, n2, n3, n4, StringScanner.getIntStr(n5), false);
        }
    }

    public void put(int n, int n2, int n3, int n4, double d) {
        if (this.test(n, n2, n3, n4)) {
            this.put(n, n2, n3, n4, Double.toString(d), false);
        }
    }

    public void put(int n, int n2, int n3, int n4, boolean bl) {
        if (this.test(n, n2, n3, n4)) {
            this.put(n, n2, n3, n4, bl ? "true" : "false", false);
        }
    }

    public void put(int n, int n2, int n3, int n4, Object object) {
        if (this.test(n, n2, n3, n4)) {
            this.put(n, n2, n3, n4, object.toString(), false);
        }
    }

    public void putLine(int n, int n2, int n3, int n4, int n5) {
        if (this.test(n, n2, n3, n4)) {
            this.put(n, n2, n3, n4, StringScanner.getIntStr(n5), true);
        }
    }

    public void putLine(int n, int n2, int n3, int n4, double d) {
        if (this.test(n, n2, n3, n4)) {
            this.put(n, n2, n3, n4, Double.toString(d), true);
        }
    }

    public void putLine(int n, int n2, int n3, int n4, boolean bl) {
        if (this.test(n, n2, n3, n4)) {
            this.put(n, n2, n3, n4, bl ? "true" : "false", true);
        }
    }

    public void putLine(int n, int n2, int n3, int n4, Object object) {
        if (this.test(n, n2, n3, n4)) {
            this.put(n, n2, n3, n4, object.toString(), true);
        }
    }

    public abstract boolean test(int var1, int var2, int var3, int var4);

    public abstract int getLevel(int var1, int var2, int var3);

    public abstract Vector getFilters();

    public void print(String string) {
        this.print(string, 0, null, null, null, null, null, null, null, null, null, false);
    }

    public void print(String string, Object object) {
        this.print(string, 1, object, null, null, null, null, null, null, null, null, false);
    }

    public void print(String string, Object object, Object object2) {
        this.print(string, 2, object, object2, null, null, null, null, null, null, null, false);
    }

    public void print(String string, Object object, Object object2, Object object3) {
        this.print(string, 3, object, object2, object3, null, null, null, null, null, null, false);
    }

    public void print(String string, Object object, Object object2, Object object3, Object object4) {
        this.print(string, 4, object, object2, object3, object4, null, null, null, null, null, false);
    }

    public void print(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        this.print(string, 5, object, object2, object3, object4, object5, null, null, null, null, false);
    }

    public void print(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this.print(string, 6, object, object2, object3, object4, object5, object6, null, null, null, false);
    }

    public void print(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        this.print(string, 7, object, object2, object3, object4, object5, object6, object7, null, null, false);
    }

    public void print(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        this.print(string, 8, object, object2, object3, object4, object5, object6, object7, object8, null, false);
    }

    public void print(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        this.print(string, 9, object, object2, object3, object4, object5, object6, object7, object8, object9, false);
    }

    public void println(String string) {
        this.print(string, 0, null, null, null, null, null, null, null, null, null, true);
    }

    public void println(String string, Object object) {
        this.print(string, 1, object, null, null, null, null, null, null, null, null, true);
    }

    public void println(String string, Object object, Object object2) {
        this.print(string, 2, object, object2, null, null, null, null, null, null, null, true);
    }

    public void println(String string, Object object, Object object2, Object object3) {
        this.print(string, 3, object, object2, object3, null, null, null, null, null, null, true);
    }

    public void println(String string, Object object, Object object2, Object object3, Object object4) {
        this.print(string, 4, object, object2, object3, object4, null, null, null, null, null, true);
    }

    public void println(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        this.print(string, 5, object, object2, object3, object4, object5, null, null, null, null, true);
    }

    public void println(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this.print(string, 6, object, object2, object3, object4, object5, object6, null, null, null, true);
    }

    public void println(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        this.print(string, 7, object, object2, object3, object4, object5, object6, object7, null, null, true);
    }

    public void println(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        this.print(string, 8, object, object2, object3, object4, object5, object6, object7, object8, null, true);
    }

    public void println(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        this.print(string, 9, object, object2, object3, object4, object5, object6, object7, object8, object9, true);
    }

    public void print(int n, int n2, int n3, int n4, String string) {
        this.print(n, n2, n3, n4, string, 0, null, null, null, null, null, null, null, null, null, false);
    }

    public void print(int n, int n2, int n3, int n4, String string, Object object) {
        this.print(n, n2, n3, n4, string, 1, object, null, null, null, null, null, null, null, null, false);
    }

    public void print(int n, int n2, int n3, int n4, String string, Object object, Object object2) {
        this.print(n, n2, n3, n4, string, 2, object, object2, null, null, null, null, null, null, null, false);
    }

    public void print(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3) {
        this.print(n, n2, n3, n4, string, 3, object, object2, object3, null, null, null, null, null, null, false);
    }

    public void print(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3, Object object4) {
        this.print(n, n2, n3, n4, string, 4, object, object2, object3, object4, null, null, null, null, null, false);
    }

    public void print(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        this.print(n, n2, n3, n4, string, 5, object, object2, object3, object4, object5, null, null, null, null, false);
    }

    public void print(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this.print(n, n2, n3, n4, string, 6, object, object2, object3, object4, object5, object6, null, null, null, false);
    }

    public void print(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        this.print(n, n2, n3, n4, string, 7, object, object2, object3, object4, object5, object6, object7, null, null, false);
    }

    public void print(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        this.print(n, n2, n3, n4, string, 8, object, object2, object3, object4, object5, object6, object7, object8, null, false);
    }

    public void print(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        this.print(n, n2, n3, n4, string, 9, object, object2, object3, object4, object5, object6, object7, object8, object9, false);
    }

    public void println(int n, int n2, int n3, int n4, String string) {
        this.print(n, n2, n3, n4, string, 0, null, null, null, null, null, null, null, null, null, true);
    }

    public void println(int n, int n2, int n3, int n4, String string, Object object) {
        this.print(n, n2, n3, n4, string, 1, object, null, null, null, null, null, null, null, null, true);
    }

    public void println(int n, int n2, int n3, int n4, String string, Object object, Object object2) {
        this.print(n, n2, n3, n4, string, 2, object, object2, null, null, null, null, null, null, null, true);
    }

    public void println(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3) {
        this.print(n, n2, n3, n4, string, 3, object, object2, object3, null, null, null, null, null, null, true);
    }

    public void println(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3, Object object4) {
        this.print(n, n2, n3, n4, string, 4, object, object2, object3, object4, null, null, null, null, null, true);
    }

    public void println(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        this.print(n, n2, n3, n4, string, 5, object, object2, object3, object4, object5, null, null, null, null, true);
    }

    public void println(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this.print(n, n2, n3, n4, string, 6, object, object2, object3, object4, object5, object6, null, null, null, true);
    }

    public void println(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        this.print(n, n2, n3, n4, string, 7, object, object2, object3, object4, object5, object6, object7, null, null, true);
    }

    public void println(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        this.print(n, n2, n3, n4, string, 8, object, object2, object3, object4, object5, object6, object7, object8, null, true);
    }

    public void println(int n, int n2, int n3, int n4, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        this.print(n, n2, n3, n4, string, 9, object, object2, object3, object4, object5, object6, object7, object8, object9, true);
    }

    private void print(int n, int n2, int n3, int n4, String string, int n5, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, boolean bl) {
        if (this.test(n, n2, n3, n4)) {
            String string2 = StringScanner.createParamString(string, n5, object, object2, object3, object4, object5, object6, object7, object8, object9);
            this.put(n, n2, n3, n4, string2, bl);
        }
    }

    private void print(String string, int n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, boolean bl) {
        this.print(7, 0, 0, 0, string, n, object, object2, object3, object4, object5, object6, object7, object8, object9, bl);
    }

    public static synchronized TraceLogger getTraceLogger() {
        if (lgr != null) {
            return lgr;
        }
        lgr = new TraceLoggerImpl();
        return lgr;
    }

    public abstract void addLogStream(String var1, String var2);

    public abstract void addLogStream(PrintWriter var1, String var2);

    public abstract void addLogStream(PrintStream var1, String var2);

    public abstract void removeLogStream(PrintWriter var1);

    public abstract void removeLogStream(PrintStream var1);

    public abstract void removeLogStream(String var1);

    public abstract int getModuleId(String var1);

    public abstract int getModuleId(String var1, TraceService var2);

    public abstract String getModuleName(int var1);

    static {
        currModuleCount = 0;
    }
}

