/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.logger;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.ResourceBundle;
import org.netbeans.lib.logger.LoggerChangedEvent;
import org.netbeans.lib.logger.LoggerChangedListener;
import org.netbeans.lib.logger.TraceLogger;
import org.netbeans.lib.logger.impl.StringScanner;

public abstract class TraceService
implements LoggerChangedListener {
    protected int moduleId;
    static ResourceBundle resBundle = ResourceBundle.getBundle("org.netbeans.lib.logger.impl.MsgCat", Locale.getDefault());
    protected String[] dbgNames;
    protected String[][] actionSets;
    public static final int MAX_DBG_GROUP = 63;
    int maxGroup;

    public static void setupDebugNotification(TraceService traceService, int n, int n2) {
        traceService.maxGroup = n2;
        traceService.moduleId = n;
        TraceLogger.getTraceLogger().addLoggerChangedListener(traceService);
        traceService.updateField();
    }

    public static String objToStringSuppress(Object object) {
        String string = TraceLogger.getTraceLogger().test(5, 1, 1, 1) ? "<suppressed>" : object.toString();
        return string;
    }

    public String logParamsToString(int n, int n2, int n3, String string, Object object) {
        String string2 = null;
        if (this.dbgNames != null && this.dbgNames.length > n - 1) {
            string2 = this.dbgNames[n - 1];
        }
        if (this.dbgNames == null || string2 == null) {
            string2 = "<Unknown group>";
        }
        String string3 = this.actionSets != null && this.actionSets.length > n - 1 && this.actionSets[n - 1] != null && this.actionSets[n - 1].length > n3 - 1 ? this.actionSets[n - 1][n3 - 1] : "<Unknown action>";
        if (string == null) {
            string = " ";
        }
        String string4 = object != null ? object + " " : " ";
        String string5 = string2 + " " + string3 + " " + string + " " + string4;
        return string5;
    }

    public void loggerChanged(LoggerChangedEvent loggerChangedEvent) {
        this.updateField();
    }

    void updateField() {
        TraceLogger traceLogger = TraceLogger.getTraceLogger();
        if (TraceLogger.dbg) {
            try {
                Class<?> clazz = this.getClass();
                Field field = clazz.getDeclaredField("debug");
                int n = 1;
                while (n <= this.maxGroup) {
                    int n2 = traceLogger.getLevel(7, this.moduleId, n);
                    if (n2 > 0) {
                        field.setBoolean(clazz, true);
                        return;
                    }
                    field.setBoolean(clazz, false);
                    ++n;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string = resBundle.getString(String.valueOf(23));
                String string2 = StringScanner.createParamString(string, noSuchFieldException.toString());
                this.badSetting(string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string = resBundle.getString(String.valueOf(24));
                String string3 = StringScanner.createParamString(string, illegalAccessException.toString());
                this.badSetting(string3);
            }
        }
    }

    private void badSetting(String string) throws RuntimeException {
        throw new RuntimeException(string);
    }
}

