/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.logger.impl;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.netbeans.lib.logger.impl.LogStream;

public class FileLogStream
implements LogStream {
    PrintWriter writer;
    OutputStream stream;
    String fileName;

    public FileLogStream(String string) {
        if (string.equals("%stdout")) {
            this.stream = System.out;
        } else if (string.equals("%stderr")) {
            this.stream = System.err;
        } else {
            boolean bl = false;
            if (string.charAt(string.length() - 1) == '+') {
                string = string.substring(0, string.length() - 1);
                bl = true;
            }
            try {
                this.stream = new FileOutputStream(string, bl);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.toString() + throwable.getMessage());
            }
        }
        this.fileName = string;
        this.writer = new PrintWriter(this.stream, true);
    }

    public FileLogStream(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public FileLogStream(PrintStream printStream) {
        this.stream = printStream;
        this.writer = new PrintWriter(this.stream, true);
    }

    public void flush() {
        this.writer.flush();
    }

    public void print(String string) {
        this.writer.print(string);
        if (string.endsWith("\n")) {
            this.writer.flush();
        }
    }

    public void println(String string) {
        this.writer.println(string);
    }

    public void println() {
        this.writer.println();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileLogStream)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.writer != null && this.writer.equals(((FileLogStream)object).writer)) {
            return true;
        }
        if (this.stream != null && this.stream.equals(((FileLogStream)object).stream)) {
            return true;
        }
        return this.fileName != null && this.fileName.equals(((FileLogStream)object).fileName);
    }
}

