/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.logger.impl;

import org.netbeans.lib.logger.impl.FlagsAsInts;
import org.netbeans.lib.logger.impl.StringScanner;
import org.netbeans.lib.logger.impl.TraceLoggerImpl;

public class FlagsAsStrings
implements Comparable {
    public String type;
    public String modName;
    public String groupStart;
    public String groupEnd;
    public String level;

    public FlagsAsStrings(String string, String string2, String string3, String string4, String string5) {
        this.type = string == null ? "" : string;
        this.modName = string2 == null ? "" : string2;
        this.groupStart = string3 == null ? "0" : string3;
        this.groupEnd = string4 == null ? "0" : string4;
        this.level = string5 == null ? "0" : string5;
    }

    public FlagsAsStrings(FlagsAsInts flagsAsInts) {
        this.type = flagsAsInts.type < 0 ? "*" : TraceLoggerImpl.msgNames[flagsAsInts.type - 1];
        this.modName = flagsAsInts.modName;
        if (flagsAsInts.groupStart == 1 && flagsAsInts.groupEnd == 63) {
            this.groupStart = "*";
            this.groupEnd = "*";
        } else {
            this.groupStart = StringScanner.getIntStr(flagsAsInts.groupStart);
            this.groupEnd = StringScanner.getIntStr(flagsAsInts.groupEnd);
        }
        this.level = StringScanner.getIntStr(flagsAsInts.level);
    }

    public int compareTo(Object object) {
        if (this.modName == null) {
            if (((FlagsAsStrings)object).modName == null) {
                return 0;
            }
            return -1;
        }
        if (((FlagsAsStrings)object).modName == null) {
            return 1;
        }
        return this.modName.compareTo(((FlagsAsStrings)object).modName);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FlagsAsStrings)) {
            return false;
        }
        FlagsAsStrings flagsAsStrings = (FlagsAsStrings)object;
        return this.type.equals(flagsAsStrings.type) && this.modName.equals(flagsAsStrings.modName) && this.groupStart.equals(flagsAsStrings.groupStart) && this.groupEnd.equals(flagsAsStrings.groupEnd) && this.level.equals(flagsAsStrings.level);
    }

    boolean sameSettingsExceptModule(FlagsAsStrings flagsAsStrings) {
        if (flagsAsStrings == null) {
            return false;
        }
        return this.type.equals(flagsAsStrings.type) && this.groupStart.equals(flagsAsStrings.groupStart) && this.groupEnd.equals(flagsAsStrings.groupEnd) && this.level.equals(flagsAsStrings.level);
    }

    public String toString() {
        String string = this.type + ":" + this.modName + ":" + this.groupStart;
        if (!this.groupEnd.equals(this.groupStart) && !this.groupEnd.equals("0")) {
            string = string + "-" + this.groupEnd;
        }
        string = string + ":" + this.level;
        return string;
    }
}

