/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.logger.impl;

import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.lib.logger.impl.FlagsAsStrings;
import org.netbeans.lib.logger.impl.LogStream;
import org.netbeans.lib.logger.impl.StringScanner;
import org.netbeans.lib.logger.impl.TraceLoggerImpl;

class LogStreamInfo {
    Vector modules;
    static final int ZEROLEVEL = -128;
    static final int FLAGSVECTORGROWTH = 5;
    static final int CFG_PRINT_TIMESTAMPS = 5;
    public boolean err = false;
    public boolean sec = false;
    public boolean res = false;
    public boolean aud = false;
    public boolean cfg = false;
    public boolean prf = false;
    public boolean dbg = false;
    LogStream logStream;
    String fileName;
    byte[] allModules = new byte[441];
    static final int LOGSTRM_AUTOFLUSH = 1;
    static final int LOGSTRM_TIMESTAMP = 2;
    static final int LOGSTRM_FILEOWNED = 4;
    static final int LOGSTRM_TAGOUTPUT = 8;
    static final int LOGSTRM_EXPLICIT = 16;
    static final int LOGSTRM_NO_MODLOGGER = 32;
    static final int LOGSTRM_NEWLINE_WASLAST = 64;
    static final int LOGSTRM_NO_PRINT_APPNAME = 128;
    static final int LOGSTRM_TIMESTAMP_MS = 256;
    static final int LOGSTRM_MANAGED = 63;
    int status = 64;

    LogStreamInfo(LogStream logStream) {
        this(logStream, null);
    }

    LogStreamInfo(LogStream logStream, String string) {
        this.logStream = logStream;
        this.fileName = string;
        this.resetAllFlags();
    }

    public boolean test(int n, int n2, int n3, int n4) {
        if (this.testTypeFlag(n)) {
            return n4 <= this.getLevel(n, n2, n3);
        }
        return false;
    }

    public int getLevel(int n, int n2, int n3) {
        byte[] byArray;
        int n4 = 0;
        int n5 = 0;
        try {
            byArray = (byte[])this.modules.get(n2 - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byArray = this.allModules;
        }
        if (byArray == null) {
            byArray = this.allModules;
        }
        n5 = (n - 1) * 63 + (n3 - 1);
        n4 = byArray[n5];
        return n4 -= -128;
    }

    boolean testTypeFlag(int n) {
        switch (n) {
            case 1: {
                return this.err;
            }
            case 2: {
                return this.sec;
            }
            case 3: {
                return this.res;
            }
            case 4: {
                return this.aud;
            }
            case 5: {
                return this.cfg;
            }
            case 6: {
                return this.prf;
            }
            case 7: {
                return this.dbg;
            }
        }
        return false;
    }

    synchronized void setTypeFlag(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.err = bl;
                break;
            }
            case 2: {
                this.sec = bl;
                break;
            }
            case 3: {
                this.res = bl;
                break;
            }
            case 4: {
                this.aud = bl;
                break;
            }
            case 5: {
                this.cfg = bl;
                break;
            }
            case 6: {
                this.prf = bl;
                break;
            }
            case 7: {
                this.dbg = bl;
            }
        }
    }

    boolean testAndSetTypeFlag(int n) {
        int n2 = (n - 1) * 63;
        int n3 = n * 63;
        int n4 = n2;
        while (n4 < n3) {
            if (this.allModules[n4] > -128) {
                this.setTypeFlag(n, true);
                return true;
            }
            ++n4;
        }
        int n5 = 1;
        while (n5 <= this.modules.size()) {
            byte[] byArray = (byte[])this.modules.get(n5 - 1);
            if (byArray != null) {
                int n6 = n2;
                while (n6 < n3) {
                    byte by = byArray[n6];
                    if (by > -128) {
                        this.setTypeFlag(n, true);
                        return true;
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        this.setTypeFlag(n, false);
        return false;
    }

    synchronized void setOrClear(boolean bl, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        boolean bl2 = false;
        if (!bl) {
            n5 = 0;
        }
        if (n2 == (n12 = TraceLoggerImpl.getModId("logger", null)) && n == 5 && (n3 <= 5 && n4 >= 5 || n3 == 5 && n4 == 0)) {
            if (n5 == 0) {
                this.status &= 0xFFFFFEFD;
            } else if (n5 == 255) {
                this.status |= 0x102;
            } else {
                this.status |= 2;
                this.status &= 0xFFFFFEFF;
            }
        }
        n5 += -128;
        if (n == -1) {
            n11 = 1;
            n10 = 7;
        } else {
            n11 = n;
            n10 = n;
        }
        if (n3 == 0) {
            n3 = 1;
            n4 = 63;
        } else if (n4 == 0) {
            n4 = n3;
        }
        int n13 = 0;
        if (n2 == -1) {
            bl2 = true;
            if (TraceLoggerImpl.getMaxModuleId() > 0) {
                n9 = 1;
                n8 = TraceLoggerImpl.getMaxModuleId();
            } else {
                n9 = -1;
                n8 = -1;
            }
        } else {
            n9 = n2;
            n8 = n2;
        }
        if (n9 != -1) {
            n7 = n9;
            while (n7 <= n8) {
                byte[] byArray = bl ? (bl2 ? this.getModuleSettings(n7, false) : this.getModuleSettings(n7, true)) : this.getModuleSettings(n7, false);
                if (byArray != null) {
                    n6 = n11 - 1;
                    while (n6 < n10) {
                        int n14 = n3 - 1;
                        while (n14 < n4) {
                            n13 = n6 * 63 + n14;
                            byArray[n13] = (byte)n5;
                            ++n14;
                        }
                        if (n5 > -128) {
                            this.setTypeFlag(n6 + 1, true);
                        } else {
                            this.testAndSetTypeFlag(n6 + 1);
                        }
                        ++n6;
                    }
                }
                ++n7;
            }
        }
        if (bl2) {
            n7 = n11 - 1;
            while (n7 < n10) {
                n6 = n3 - 1;
                while (n6 < n4) {
                    n13 = n7 * 63 + n6;
                    this.allModules[n13] = (byte)n5;
                    ++n6;
                }
                if (n5 > -128) {
                    this.setTypeFlag(n7 + 1, true);
                } else {
                    this.testAndSetTypeFlag(n7 + 1);
                }
                ++n7;
            }
        }
    }

    byte[] getModuleSettings(int n, boolean bl) {
        byte[] byArray = null;
        try {
            byArray = (byte[])this.modules.get(n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Vector vector = this.modules;
            synchronized (vector) {
                byArray = null;
                if (n - 1 >= this.modules.size()) {
                    this.modules.setSize(n + 5);
                }
            }
        }
        if (byArray == null && bl) {
            Vector vector = this.modules;
            synchronized (vector) {
                byArray = new byte[441];
                int n2 = 0;
                while (n2 < byArray.length) {
                    byArray[n2] = this.allModules[n2];
                    ++n2;
                }
                this.modules.set(n - 1, byArray);
            }
        }
        return byArray;
    }

    public String getFlagsAsString() {
        StringBuffer stringBuffer = new StringBuffer(this.fileName + "(");
        Vector vector = this.getFlagList();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            FlagsAsStrings flagsAsStrings = (FlagsAsStrings)vector.get(n2);
            stringBuffer.append(flagsAsStrings.type + ":" + flagsAsStrings.modName + ":" + flagsAsStrings.groupStart);
            if (flagsAsStrings.groupStart == flagsAsStrings.groupEnd) {
                stringBuffer.append(":" + flagsAsStrings.level);
            } else {
                stringBuffer.append("-" + flagsAsStrings.groupEnd + ":" + flagsAsStrings.level);
            }
            if (n2 + 1 < n) {
                stringBuffer.append(" ");
            }
            ++n2;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    void dumpFlags() {
        Vector vector = this.getFlagList();
        String string = "Type Groups Level Module Name\n---- ------ ----- -----------\n";
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = vector.size();
        stringBuffer.append(string);
        int n2 = 0;
        while (n2 < n) {
            FlagsAsStrings flagsAsStrings = (FlagsAsStrings)vector.get(n2);
            StringScanner.format(stringBuffer, "%3  ", flagsAsStrings.type);
            if (flagsAsStrings.groupStart == "*") {
                stringBuffer.append("  *   ");
            } else if (flagsAsStrings.groupStart == flagsAsStrings.groupEnd) {
                StringScanner.format(stringBuffer, "  %-2  ", flagsAsStrings.groupStart);
            } else {
                StringScanner.format(stringBuffer, "%2-%-2 ", flagsAsStrings.groupStart, flagsAsStrings.groupEnd);
            }
            StringScanner.format(stringBuffer, "  %3   ", flagsAsStrings.level);
            if (flagsAsStrings.modName == "*") {
                stringBuffer.append(flagsAsStrings.modName + " (Default)\n");
            } else {
                stringBuffer.append(flagsAsStrings.modName + "\n");
            }
            ++n2;
        }
        this.logStream.println(stringBuffer.toString());
    }

    public Vector getFlagList() {
        Vector<FlagsAsStrings> vector = new Vector<FlagsAsStrings>();
        Vector<FlagsAsStrings> vector2 = new Vector<FlagsAsStrings>();
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        while (n2 < this.modules.size()) {
            byte[] byArray = n2 < 0 ? this.allModules : (byte[])this.modules.get(n2);
            if (byArray != null) {
                int n3 = 0;
                while (n3 < 7) {
                    int n4 = 0;
                    while (n4 < 63) {
                        n = n3 * 63 + n4;
                        int n5 = byArray[n];
                        if (n5 > -128) {
                            FlagsAsStrings flagsAsStrings;
                            String string;
                            String string2;
                            int n6 = n + 1;
                            String string3 = TraceLoggerImpl.msgNames[n3];
                            int n7 = n4 + 1;
                            while (n7 < 63) {
                                if (byArray[n] != byArray[n6]) break;
                                ++n7;
                                ++n6;
                            }
                            if (n4 == --n7) {
                                string = string2 = StringScanner.getIntStr(n4 + 1);
                            } else if (n4 == 0 && n7 == 62) {
                                string2 = "*";
                                string = "*";
                            } else {
                                string2 = StringScanner.getIntStr(n4 + 1);
                                string = StringScanner.getIntStr(n7 + 1);
                            }
                            String string4 = StringScanner.getIntStr(n5 -= -128);
                            String string5 = TraceLoggerImpl.getModName(n2 + 1);
                            if (n2 < 0) {
                                flagsAsStrings = new FlagsAsStrings(string3, "*", string2, string, string4);
                                vector2.add(flagsAsStrings);
                            } else {
                                flagsAsStrings = new FlagsAsStrings(string3, string5, string2, string, string4);
                                bl = false;
                                Iterator iterator = ((AbstractList)vector2).iterator();
                                while (iterator.hasNext()) {
                                    FlagsAsStrings flagsAsStrings2 = (FlagsAsStrings)iterator.next();
                                    if (!flagsAsStrings2.sameSettingsExceptModule(flagsAsStrings)) continue;
                                    bl = true;
                                }
                                if (!bl) {
                                    vector.add(flagsAsStrings);
                                }
                            }
                            n4 = n7;
                        }
                        ++n4;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        vector.addAll(vector2);
        Collections.sort(vector);
        return vector;
    }

    synchronized void resetAllFlags() {
        this.modules = new Vector(TraceLoggerImpl.getMaxModuleId());
        int n = 0;
        while (n < this.allModules.length) {
            this.allModules[n] = -128;
            ++n;
        }
    }

    private void badSetting(String string) throws RuntimeException {
        throw new RuntimeException(string);
    }
}

