/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.logger.impl;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.netbeans.lib.logger.LoggerChangedEvent;
import org.netbeans.lib.logger.TraceLogger;
import org.netbeans.lib.logger.TraceService;
import org.netbeans.lib.logger.impl.FileLogStream;
import org.netbeans.lib.logger.impl.FlagsAsInts;
import org.netbeans.lib.logger.impl.FlagsAsStrings;
import org.netbeans.lib.logger.impl.HexConverter;
import org.netbeans.lib.logger.impl.LogStream;
import org.netbeans.lib.logger.impl.LogStreamInfo;
import org.netbeans.lib.logger.impl.ModuleEntry;
import org.netbeans.lib.logger.impl.StreamFlagSettings;
import org.netbeans.lib.logger.impl.StringScanner;
import org.netbeans.lib.logger.impl.TraceServiceSubclass;

public class TraceLoggerImpl
extends TraceLogger {
    public static final int ALL = -1;
    static final String[] msgNames = new String[]{"err", "sec", "res", "aud", "cfg", "prf", "dbg"};
    static final String[] msgFullNames = new String[]{"error", "security", "resource", "audit", "configuration", "performance", "debug"};
    static final String TEST_NAME = "test";
    private static final int LOGBUFSIZE = 512;
    static ResourceBundle resBundle = ResourceBundle.getBundle("org.netbeans.lib.logger.impl.MsgCat", Locale.getDefault());
    private LogBufEntry[] logBuf;
    private int logBufPosition;
    private int logBufSize;
    private boolean stdoutRedirected = false;
    private static Vector modulesById;
    private static Hashtable modulesByName;
    static final int Debug = 0;
    public boolean isDefaultSetting = true;
    private static final SimpleDateFormat timestampFormat;
    private static final SimpleDateFormat timestampFormatMS;
    Vector logStreams = new Vector();

    protected void initTraceLogger(String string) {
        String string2;
        boolean bl = false;
        modulesByName = new Hashtable();
        modulesById = new Vector();
        String string3 = TEST_NAME;
        ModuleEntry moduleEntry = new ModuleEntry(string3, 1);
        modulesByName.put(string3, moduleEntry);
        modulesById.add(moduleEntry);
        TraceLogger.currModuleCount = modulesByName.size();
        try {
            string2 = System.getProperty("netbeans.logger.bufSize");
        }
        catch (SecurityException securityException) {
            string2 = null;
        }
        if (string2 != null) {
            this.logBufSize = Integer.decode(string2);
            if (this.logBufSize != 0) {
                if (this.logBufSize < 32) {
                    this.logBufSize = 512;
                }
                this.logBuf = new LogBufEntry[this.logBufSize];
                int n = 0;
                while (n < this.logBufSize) {
                    this.logBuf[n] = new LogBufEntry();
                    ++n;
                }
            }
        } else {
            this.logBufSize = 0;
        }
        if (string == null) {
            this.addLogStreamInternal("%stdout", "err:*");
            this.isDefaultSetting = true;
        } else {
            this.updateFlagsWithString(string, true);
        }
        this.dumpFlags();
    }

    public TraceLoggerImpl(String string) {
        this.initTraceLogger(string);
    }

    public TraceLoggerImpl() {
        try {
            String string = System.getProperty("netbeans.logger.settings");
            this.initTraceLogger(string);
        }
        catch (SecurityException securityException) {
            this.initTraceLogger(null);
        }
    }

    void setOrClearFlags(Vector vector, boolean bl, LogStreamInfo logStreamInfo) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.isDefaultSetting = false;
            FlagsAsInts flagsAsInts = (FlagsAsInts)vector.get(n2);
            if (logStreamInfo != null) {
                logStreamInfo.setOrClear(bl, flagsAsInts.type, this.getModuleId(flagsAsInts.modName), flagsAsInts.groupStart, flagsAsInts.groupEnd, flagsAsInts.level);
            } else {
                int n3 = 0;
                while (n3 < this.logStreams.size()) {
                    LogStreamInfo logStreamInfo2 = (LogStreamInfo)this.logStreams.elementAt(n3);
                    logStreamInfo2.setOrClear(bl, flagsAsInts.type, this.getModuleId(flagsAsInts.modName), flagsAsInts.groupStart, flagsAsInts.groupEnd, flagsAsInts.level);
                    ++n3;
                }
            }
            if (bl) {
                this.setTypeFlag(flagsAsInts.type, true);
            } else {
                this.testAndSetTypeFlag(flagsAsInts.type);
            }
            ++n2;
        }
    }

    int getType(String string) {
        if (string.equals("*")) {
            return -1;
        }
        if (string.equals("trc")) {
            return 7;
        }
        int n = 0;
        while (n < msgNames.length) {
            if (string.equalsIgnoreCase(msgNames[n])) {
                return n + 1;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < msgFullNames.length) {
            if (string.equalsIgnoreCase(msgFullNames[n2])) {
                return n2 + 1;
            }
            ++n2;
        }
        String string2 = resBundle.getString(String.valueOf(4));
        String string3 = StringScanner.createParamString(string2, string);
        this.badSetting(string3);
        return 0;
    }

    public void addLogStream(String string, String string2) {
        LogStreamInfo logStreamInfo = this.findLogStream(string);
        if (logStreamInfo != null) {
            string2 = "+(" + string2 + ")";
            this.modifyFlags(logStreamInfo, string2);
        } else {
            FileLogStream fileLogStream = new FileLogStream(string);
            Vector vector = this.parseFlags(string2);
            this.addLogStreamMain(fileLogStream, vector, string, true);
        }
    }

    public void addLogStream(PrintWriter printWriter, String string) {
        FileLogStream fileLogStream = new FileLogStream(printWriter);
        Vector vector = this.parseFlags(string);
        this.addLogStreamMain(fileLogStream, vector, null, true);
    }

    public void addLogStream(PrintStream printStream, String string) {
        FileLogStream fileLogStream = new FileLogStream(printStream);
        Vector vector = this.parseFlags(string);
        this.addLogStreamMain(fileLogStream, vector, null, true);
    }

    public void addLogStream(LogStream logStream, String string) {
        Vector vector = this.parseFlags(string);
        this.addLogStreamMain(logStream, vector, null, true);
    }

    LogStreamInfo addLogStreamMain(LogStream logStream, Vector vector, String string, boolean bl) {
        LogStreamInfo logStreamInfo;
        if (logStream == null) {
            return null;
        }
        Vector vector2 = this.logStreams;
        synchronized (vector2) {
            logStreamInfo = this.findLogStream(logStream);
            if (logStreamInfo == null) {
                logStreamInfo = new LogStreamInfo(logStream, string);
                this.logStreams.addElement(logStreamInfo);
            }
        }
        if (vector != null) {
            this.setOrClearFlags(vector, true, logStreamInfo);
        }
        if (bl) {
            logStreamInfo.dumpFlags();
        }
        this.notifyLoggerChangedListeners(new LoggerChangedEvent(this, "addLogStream"));
        return logStreamInfo;
    }

    LogStreamInfo addLogStreamInternal(String string, String string2) {
        FileLogStream fileLogStream = new FileLogStream(string);
        Vector vector = this.parseFlags(string2);
        return this.addLogStreamMain(fileLogStream, vector, string, false);
    }

    LogStreamInfo addLogStreamInternal(String string, Vector vector) {
        FileLogStream fileLogStream = new FileLogStream(string);
        return this.addLogStreamMain(fileLogStream, vector, string, false);
    }

    LogStreamInfo addLogStreamInternal(PrintWriter printWriter, String string) {
        FileLogStream fileLogStream = new FileLogStream(printWriter);
        Vector vector = this.parseFlags(string);
        return this.addLogStreamMain(fileLogStream, vector, null, false);
    }

    LogStreamInfo addLogStreamInternal(PrintStream printStream, String string) {
        FileLogStream fileLogStream = new FileLogStream(printStream);
        Vector vector = this.parseFlags(string);
        return this.addLogStreamMain(fileLogStream, vector, null, false);
    }

    public void removeLogStream(String string) {
        Vector vector = this.logStreams;
        synchronized (vector) {
            LogStreamInfo logStreamInfo = this.findLogStream(string);
            if (logStreamInfo != null) {
                PrintWriter printWriter = ((FileLogStream)logStreamInfo.logStream).writer;
                this.logStreams.removeElement(logStreamInfo);
                printWriter.println("");
                printWriter.flush();
                if (!string.equals("%stdout") && !string.equals("%stderr")) {
                    printWriter.close();
                }
                this.testTypeFlags();
                this.notifyLoggerChangedListeners(new LoggerChangedEvent(this, "removeLogStream"));
            }
        }
    }

    public void removeLogStream(PrintWriter printWriter) {
        if (this.logStreams.isEmpty()) {
            return;
        }
        Vector vector = this.logStreams;
        synchronized (vector) {
            LogStreamInfo logStreamInfo = this.findLogStream(printWriter);
            if (logStreamInfo != null) {
                this.logStreams.removeElement(logStreamInfo);
                printWriter.println("");
                printWriter.flush();
                if (logStreamInfo.fileName == null || !logStreamInfo.fileName.equals("%stdout") && !logStreamInfo.fileName.equals("%stderr")) {
                    printWriter.close();
                }
                this.testTypeFlags();
                this.notifyLoggerChangedListeners(new LoggerChangedEvent(this, "removeLogStream"));
            }
        }
    }

    public void removeLogStream(PrintStream printStream) {
        if (this.logStreams.isEmpty()) {
            return;
        }
        Vector vector = this.logStreams;
        synchronized (vector) {
            LogStreamInfo logStreamInfo = this.findLogStream(printStream);
            if (logStreamInfo != null) {
                this.logStreams.removeElement(logStreamInfo);
                printStream.println("");
                printStream.flush();
                if (printStream != System.out && printStream != System.err) {
                    printStream.close();
                }
                this.testTypeFlags();
                this.notifyLoggerChangedListeners(new LoggerChangedEvent(this, "removeLogStream"));
            }
        }
    }

    public void flush() {
        if (this.logStreams.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.logStreams.size()) {
            LogStreamInfo logStreamInfo = (LogStreamInfo)this.logStreams.elementAt(n);
            logStreamInfo.logStream.flush();
            ++n;
        }
    }

    public void modifyFlags(String string) {
        if (this.logStreams.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = string.length();
        while ((n = StringScanner.skipWhite(string, n)) < n2) {
            int n3;
            String string2;
            Object object;
            boolean bl = true;
            if (string.charAt(n) == '-') {
                bl = false;
                ++n;
            } else if (string.charAt(n) == '+') {
                ++n;
            }
            n = StringScanner.skipWhite(string, n);
            if (n >= n2) {
                throw new RuntimeException("No settings after +/- in " + string);
            }
            if (string.charAt(n) != '(') {
                object = resBundle.getString(String.valueOf(5));
                string2 = StringScanner.createParamString((String)object, string);
                this.badSetting(string2);
            }
            if ((n3 = StringScanner.skipTo(string, ++n, ')')) >= n2) {
                object = resBundle.getString(String.valueOf(6));
                string2 = StringScanner.createParamString((String)object, string);
                this.badSetting(string2);
            }
            object = this.parseFlags(string.substring(n, n3));
            this.setOrClearFlags((Vector)object, bl, null);
            n = n3 + 1;
        }
        this.dumpFlags();
        this.notifyLoggerChangedListeners(new LoggerChangedEvent(this, "modifyFlags"));
    }

    public void modifyFlags(String string, String string2) {
        if (string.equals("")) {
            this.modifyFlags(string2);
        } else {
            LogStreamInfo logStreamInfo = this.findLogStream(string);
            if (logStreamInfo != null) {
                this.modifyFlags(logStreamInfo, string2);
            } else {
                logStreamInfo = this.addLogStreamInternal(string, "");
                this.modifyFlags(logStreamInfo, string2);
            }
        }
    }

    public void modifyFlags(PrintWriter printWriter, String string) {
        LogStreamInfo logStreamInfo = this.findLogStream(printWriter);
        if (logStreamInfo != null) {
            this.modifyFlags(logStreamInfo, string);
        } else {
            logStreamInfo = this.addLogStreamInternal(printWriter, null);
            this.modifyFlags(logStreamInfo, string);
        }
    }

    public void modifyFlags(PrintStream printStream, String string) {
        LogStreamInfo logStreamInfo = this.findLogStream(printStream);
        if (logStreamInfo != null) {
            this.modifyFlags(logStreamInfo, string);
        } else {
            logStreamInfo = this.addLogStreamInternal(printStream, null);
            this.modifyFlags(logStreamInfo, string);
        }
    }

    public void modifyFlags(LogStreamInfo logStreamInfo, String string) {
        int n = 0;
        int n2 = string.length();
        while ((n = StringScanner.skipWhite(string, n)) < n2) {
            int n3;
            String string2;
            Object object;
            boolean bl = true;
            if (string.charAt(n) == '-') {
                bl = false;
                ++n;
            } else if (string.charAt(n) == '+') {
                ++n;
            }
            n = StringScanner.skipWhite(string, n);
            if (n >= n2) {
                throw new RuntimeException("No settings after +/- in " + string);
            }
            if (string.charAt(n) != '(') {
                object = resBundle.getString(String.valueOf(5));
                string2 = StringScanner.createParamString((String)object, string);
                this.badSetting(string2);
            }
            if ((n3 = StringScanner.skipTo(string, ++n, ')')) >= n2) {
                object = resBundle.getString(String.valueOf(6));
                string2 = StringScanner.createParamString((String)object, string);
                this.badSetting(string2);
            } else {
                object = this.parseFlags(string.substring(n, n3));
                this.setOrClearFlags((Vector)object, bl, logStreamInfo);
            }
            n = n3 + 1;
        }
        if (logStreamInfo != null) {
            logStreamInfo.dumpFlags();
        } else {
            this.dumpFlags();
        }
        this.notifyLoggerChangedListeners(new LoggerChangedEvent(this, "modifyFlags"));
    }

    LogStreamInfo findLogStream(LogStreamInfo logStreamInfo) {
        if (logStreamInfo == null) {
            return null;
        }
        if (!this.logStreams.isEmpty()) {
            Enumeration enumeration = this.logStreams.elements();
            while (enumeration.hasMoreElements()) {
                LogStreamInfo logStreamInfo2 = (LogStreamInfo)enumeration.nextElement();
                if (!(logStreamInfo2.logStream instanceof FileLogStream) || !((FileLogStream)logStreamInfo2.logStream).equals(logStreamInfo)) continue;
                return logStreamInfo2;
            }
        }
        return null;
    }

    LogStreamInfo findLogStream(PrintWriter printWriter) {
        if (printWriter == null) {
            return null;
        }
        if (!this.logStreams.isEmpty()) {
            Enumeration enumeration = this.logStreams.elements();
            while (enumeration.hasMoreElements()) {
                LogStreamInfo logStreamInfo = (LogStreamInfo)enumeration.nextElement();
                if (!(logStreamInfo.logStream instanceof FileLogStream) || ((FileLogStream)logStreamInfo.logStream).writer != printWriter) continue;
                return logStreamInfo;
            }
        }
        return null;
    }

    LogStreamInfo findLogStream(PrintStream printStream) {
        if (!this.logStreams.isEmpty()) {
            Enumeration enumeration = this.logStreams.elements();
            while (enumeration.hasMoreElements()) {
                LogStreamInfo logStreamInfo = (LogStreamInfo)enumeration.nextElement();
                if (!(logStreamInfo.logStream instanceof FileLogStream) || ((FileLogStream)logStreamInfo.logStream).stream != printStream) continue;
                return logStreamInfo;
            }
        }
        return null;
    }

    LogStreamInfo findLogStream(String string) {
        if (!this.logStreams.isEmpty()) {
            Enumeration enumeration = this.logStreams.elements();
            while (enumeration.hasMoreElements()) {
                LogStreamInfo logStreamInfo = (LogStreamInfo)enumeration.nextElement();
                if (!(logStreamInfo.logStream instanceof FileLogStream) || logStreamInfo.fileName == null || !logStreamInfo.fileName.equals(string)) continue;
                return logStreamInfo;
            }
        }
        return null;
    }

    LogStreamInfo findLogStream(LogStream logStream) {
        if (logStream == null) {
            return null;
        }
        if (!this.logStreams.isEmpty()) {
            Enumeration enumeration = this.logStreams.elements();
            while (enumeration.hasMoreElements()) {
                LogStreamInfo logStreamInfo = (LogStreamInfo)enumeration.nextElement();
                if (!(logStreamInfo.logStream instanceof FileLogStream) || !((FileLogStream)logStreamInfo.logStream).equals(logStream)) continue;
                return logStreamInfo;
            }
        }
        return null;
    }

    public void put(int n, int n2, int n3, int n4, String string, boolean bl) {
        boolean bl2 = n == 1 || n3 == 0 && n4 == 0;
        this.checkParams("put", n, n2, n3, n4, true);
        if ((n3 == 0 || n4 == 0 || this.getTypeFlag(n)) && !this.logStreams.isEmpty()) {
            int n5 = 0;
            while (n5 < this.logStreams.size()) {
                LogStreamInfo logStreamInfo = (LogStreamInfo)this.logStreams.elementAt(n5);
                if (n3 == 0 || n4 == 0 || logStreamInfo.test(n, n2, n3, n4)) {
                    bl2 = false;
                    if ((logStreamInfo.status & 0x40) != 0 && (logStreamInfo.status & 2) != 0) {
                        String string2 = (logStreamInfo.status & 0x100) != 0 ? timestampFormatMS.format(new Date()) : timestampFormat.format(new Date());
                        logStreamInfo.logStream.print(string2);
                    }
                    logStreamInfo.logStream.print(string);
                    if (bl) {
                        logStreamInfo.logStream.println();
                        logStreamInfo.status |= 0x40;
                    } else {
                        logStreamInfo.status = string != null && string.length() > 0 && string.charAt(string.length() - 1) == '\n' ? (logStreamInfo.status |= 0x40) : (logStreamInfo.status &= 0xFFFFFFBF);
                    }
                }
                ++n5;
            }
        }
        if (bl2) {
            System.out.print(string);
            if (bl) {
                System.out.println();
            }
        }
    }

    public void println(int n, int n2, int n3, int n4, int n5, Object object) {
        this.put(n, n2, n3, n4, n5, object);
    }

    public void put(int n, int n2, int n3, int n4, int n5, Object object) {
        Object object2;
        if (this.logBufSize > 0) {
            TraceLoggerImpl traceLoggerImpl = this;
            synchronized (traceLoggerImpl) {
                object2 = this.logBuf[this.logBufPosition];
                ((LogBufEntry)object2).moduleId = n2;
                ((LogBufEntry)object2).group = n3;
                ((LogBufEntry)object2).action = n5;
                ((LogBufEntry)object2).threadName = Thread.currentThread().getName();
                ((LogBufEntry)object2).obj = object;
                ++this.logBufPosition;
                if (this.logBufPosition >= this.logBufSize) {
                    this.logBufPosition = 0;
                }
            }
        }
        boolean bl = false;
        if (this.getTypeFlag(n) && this.test(n, n2, n3, n4)) {
            object2 = this;
            synchronized (object2) {
                bl = this.initTraceServiceSubclass(n2);
            }
            if (bl) {
                this.put(n, n2, n3, n4, this.getModuleName(n2) + " " + this.getModule((int)n2).traceSvc.logParamsToString(n3, n4, n5, Thread.currentThread().getName(), object), true);
            } else {
                this.put(n, n2, n3, n4, this.getModuleName(n2) + " " + new TraceServiceSubclass().logParamsToString(n3, n4, n5, Thread.currentThread().getName(), object), true);
            }
        }
    }

    private boolean initTraceServiceSubclass(int n) {
        ModuleEntry moduleEntry = this.getModule(n);
        if (moduleEntry.traceSvc != null) {
            return true;
        }
        String string = new String(moduleEntry.name + ".LogFlags");
        try {
            Class<?> clazz = Class.forName(string);
            moduleEntry.traceSvc = (TraceService)clazz.newInstance();
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            TraceLogger.getTraceLogger().println("***Cannot load class " + string + " because cannot find it. You must define a subclass of TraceService " + "that defines the debugNames and actionSets values before you can use " + "the variants of put and println in TraceLogger that specify actions. " + "The default name for " + "this subclass is LogFlags. See the JavaDoc for TraceService for more " + "information.");
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            String string2 = resBundle.getString(String.valueOf(7));
            String string3 = StringScanner.createParamString(string2, exceptionInInitializerError.getException().toString());
            this.badSetting(string3);
        }
        catch (Throwable throwable) {
            String string4 = resBundle.getString(String.valueOf(8));
            String string5 = StringScanner.createParamString(string4, string);
            this.badSetting(string5);
        }
        return false;
    }

    public boolean test(int n, int n2, int n3, int n4) {
        this.checkParams(TEST_NAME, n, n2, n3, n4, true);
        if (this.logStreams.isEmpty()) {
            return false;
        }
        if (n3 == 0 && n4 == 0) {
            return true;
        }
        if (this.getTypeFlag(n)) {
            int n5 = 0;
            while (n5 < this.logStreams.size()) {
                LogStreamInfo logStreamInfo = (LogStreamInfo)this.logStreams.elementAt(n5);
                if (logStreamInfo.test(n, n2, n3, n4)) {
                    return true;
                }
                ++n5;
            }
        }
        return false;
    }

    public int getLevel(int n, int n2, int n3) {
        this.checkParams("getLevel", n, n2, n3);
        if (this.logStreams.isEmpty()) {
            return 0;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.logStreams.size()) {
            LogStreamInfo logStreamInfo = (LogStreamInfo)this.logStreams.elementAt(n5);
            int n6 = logStreamInfo.getLevel(n, n2, n3);
            if (n6 > n4) {
                n4 = n6;
            }
            ++n5;
        }
        return n4;
    }

    boolean testAndSetTypeFlag(int n) {
        int n2 = 0;
        while (n2 < this.logStreams.size()) {
            LogStreamInfo logStreamInfo = (LogStreamInfo)this.logStreams.elementAt(n2);
            if (logStreamInfo.testTypeFlag(n)) {
                this.setTypeFlag(n, true);
                return true;
            }
            ++n2;
        }
        this.setTypeFlag(n, false);
        return false;
    }

    void testTypeFlags() {
        int n = 1;
        while (n <= 7) {
            this.testAndSetTypeFlag(n);
            ++n;
        }
    }

    protected void checkParams(String string, int n, int n2, int n3) {
        if (n < 1 || n > 7) {
            String string2 = resBundle.getString(String.valueOf(9));
            String string3 = StringScanner.createParamString(string2, string, "type", new Integer(n), new Integer(7));
            this.badSetting(string3);
        } else if (n2 < 0 || n2 > TraceLoggerImpl.getMaxModuleId()) {
            String string4 = resBundle.getString(String.valueOf(9));
            String string5 = StringScanner.createParamString(string4, string, "module id", new Integer(n2), new Integer(TraceLoggerImpl.getMaxModuleId()));
            this.badSetting(string5);
        } else if (n3 < 1 || n3 > 63) {
            String string6 = resBundle.getString(String.valueOf(9));
            String string7 = StringScanner.createParamString(string6, string, "group", new Integer(n3), new Integer(63));
            this.badSetting(string7);
        }
    }

    protected void checkParams(String string, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            return;
        }
        this.checkParams(string, n, n2, n3);
        if (n4 < 0 || n4 > 255) {
            String string2 = resBundle.getString(String.valueOf(9));
            String string3 = StringScanner.createParamString(string2, string, "level", new Integer(n4), new Integer(255));
            this.badSetting(string3);
        }
    }

    void dumpFlags() {
        if (this.logStreams == null) {
            return;
        }
        int n = 0;
        while (n < this.logStreams.size()) {
            LogStreamInfo logStreamInfo = (LogStreamInfo)this.logStreams.elementAt(n);
            logStreamInfo.dumpFlags();
            ++n;
        }
    }

    public synchronized void dumpLogBuffer() {
        int n;
        if (this.logBufSize == 0) {
            return;
        }
        int n2 = n = this.logBufPosition;
        do {
            LogBufEntry logBufEntry = this.logBuf[n];
            if (logBufEntry.moduleId != 0) {
                try {
                    if (this.initTraceServiceSubclass(logBufEntry.moduleId)) {
                        this.put(7, logBufEntry.moduleId, 0, 0, this.getModuleName(logBufEntry.moduleId) + " " + this.getModule((int)logBufEntry.moduleId).traceSvc.logParamsToString(logBufEntry.group, logBufEntry.level, logBufEntry.action, logBufEntry.threadName, logBufEntry.obj), true);
                    } else {
                        this.put(7, logBufEntry.moduleId, 0, 0, this.getModuleName(logBufEntry.moduleId) + " " + new TraceServiceSubclass().logParamsToString(logBufEntry.group, logBufEntry.level, logBufEntry.action, logBufEntry.threadName, logBufEntry.obj), true);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (++n < this.logBufSize) continue;
            n = 0;
        } while (n != n2);
    }

    private void badSetting(String string) throws RuntimeException {
        throw new RuntimeException(string);
    }

    public String toString() {
        return "TraceLoggerImpl{ " + this.getFlagsAsString() + "}";
    }

    public void redirectStdout(PrintStream printStream, String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("MsgCat");
        int n = 3;
        String string2 = StringScanner.createParamString(resourceBundle.getString(String.valueOf(n)), string);
        if (!this.stdoutRedirected) {
            // empty if block
        }
        System.out.println(string2);
        System.setOut(printStream);
        System.setErr(printStream);
        this.stdoutRedirected = true;
    }

    public Vector getFilters() {
        Vector vector = new Vector();
        int[] nArray = new int[5];
        int n = 1;
        while (n <= 7) {
            int n2 = 1;
            while (n2 <= TraceLoggerImpl.getMaxModuleId()) {
                int n3 = 1;
                while (n3 < 63) {
                    int n4 = this.getLevel(n, n2, n3);
                    if (n4 > 0) {
                        int n5 = n3;
                        int n6 = n3 + 1;
                        while (n6 <= 63) {
                            if (this.getLevel(n, n2, n6) != n4) break;
                            n5 = n6++;
                        }
                        nArray[0] = n;
                        nArray[1] = n2;
                        nArray[2] = n3;
                        nArray[3] = n5;
                        nArray[4] = n4;
                        Vector<Integer> vector2 = new Vector<Integer>();
                        int n7 = 0;
                        while (n7 < 5) {
                            vector2.add(new Integer(nArray[n7]));
                            ++n7;
                        }
                        vector.add(vector2);
                        if (n5 > n3) {
                            n3 = n5;
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    public int getModuleId(String string) {
        return TraceLoggerImpl.getModId(string, null);
    }

    public int getModuleId(String string, TraceService traceService) {
        return TraceLoggerImpl.getModId(string, traceService);
    }

    static int getModId(String string, TraceService traceService) {
        if (string.equals("*")) {
            return -1;
        }
        if (string.equals(TEST_NAME)) {
            return 1;
        }
        ModuleEntry moduleEntry = (ModuleEntry)modulesByName.get(string);
        if (moduleEntry != null) {
            moduleEntry.traceSvc = traceService;
            return moduleEntry.moduleId;
        }
        Hashtable hashtable = modulesByName;
        synchronized (hashtable) {
            ModuleEntry moduleEntry2 = new ModuleEntry(string, traceService, ++TraceLogger.currModuleCount);
            modulesByName.put(string, moduleEntry2);
            modulesById.add(moduleEntry2);
            int n = TraceLogger.currModuleCount;
            return n;
        }
    }

    static String getModName(int n) {
        try {
            ModuleEntry moduleEntry = (ModuleEntry)modulesById.get(n - 1);
            return moduleEntry.name;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public String getModuleName(int n) {
        return TraceLoggerImpl.getModName(n);
    }

    ModuleEntry getModule(int n) {
        return (ModuleEntry)modulesById.get(n - 1);
    }

    static int getMaxModuleId() {
        return TraceLogger.currModuleCount;
    }

    public void putHexBytes(byte[] byArray, int n) {
        this.put(HexConverter.formatHexBytes(byArray, n), false);
    }

    public void putHexBytesSimple(byte[] byArray, int n) {
        this.put(HexConverter.simpleFormatHexBytes(byArray, n), false);
    }

    public String getFlagsAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.logStreams.isEmpty()) {
            return "";
        }
        Enumeration enumeration = this.logStreams.elements();
        while (enumeration.hasMoreElements()) {
            LogStreamInfo logStreamInfo = (LogStreamInfo)enumeration.nextElement();
            if (!(logStreamInfo.logStream instanceof FileLogStream) || logStreamInfo.fileName == null) continue;
            stringBuffer.append(logStreamInfo.getFlagsAsString() + " ");
        }
        return stringBuffer.toString();
    }

    public void updateFlagsWithString(String string) {
        this.updateFlagsWithString(string, false);
    }

    void updateFlagsWithString(String string, boolean bl) {
        int n;
        Object object;
        Vector vector = this.parseStreamsAndFlags(string);
        int n2 = vector.size();
        LogStreamInfo logStreamInfo = null;
        Vector<Object> vector2 = new Vector<Object>();
        if (!bl) {
            Object object2;
            Object object3;
            object = ((AbstractList)this.logStreams).iterator();
            while (object.hasNext()) {
                n = 0;
                object3 = (LogStreamInfo)object.next();
                object2 = ((AbstractList)vector).iterator();
                while (object2.hasNext() && n == 0) {
                    StreamFlagSettings streamFlagSettings = (StreamFlagSettings)object2.next();
                    if (!streamFlagSettings.logStreamName.equals(((LogStreamInfo)object3).fileName)) continue;
                    n = 1;
                }
                if (n != 0) continue;
                vector2.add(object3);
            }
            object3 = ((AbstractList)vector2).iterator();
            while (object3.hasNext()) {
                object2 = (LogStreamInfo)object3.next();
                if (((LogStreamInfo)object2).fileName == null) continue;
                this.removeLogStream((LogStreamInfo)object2);
            }
        }
        n = 0;
        while (n < n2) {
            StreamFlagSettings streamFlagSettings = (StreamFlagSettings)vector.get(n);
            if (!bl) {
                logStreamInfo = this.findLogStream(streamFlagSettings.logStreamName);
            }
            if (logStreamInfo == null) {
                if (bl) {
                    this.addLogStreamInternal(streamFlagSettings.logStreamName, streamFlagSettings.flags);
                } else {
                    object = new FileLogStream(streamFlagSettings.logStreamName);
                    this.addLogStreamMain((LogStream)object, streamFlagSettings.flags, streamFlagSettings.logStreamName, true);
                }
            } else {
                int n3 = this.logStreams.indexOf(logStreamInfo);
                if (!streamFlagSettings.flags.equals(logStreamInfo.getFlagList())) {
                    logStreamInfo.resetAllFlags();
                    int n4 = streamFlagSettings.flags.size();
                    int n5 = 0;
                    while (n5 < n4) {
                        this.isDefaultSetting = false;
                        FlagsAsInts flagsAsInts = (FlagsAsInts)streamFlagSettings.flags.get(n5);
                        logStreamInfo.setOrClear(true, flagsAsInts.type, this.getModuleId(flagsAsInts.modName), flagsAsInts.groupStart, flagsAsInts.groupEnd, flagsAsInts.level);
                        ++n5;
                    }
                    logStreamInfo.dumpFlags();
                }
            }
            ++n;
        }
        this.notifyLoggerChangedListeners(new LoggerChangedEvent(this, "updateFlagsWithString"));
    }

    public void removeLogStream(LogStreamInfo logStreamInfo) {
        if (this.logStreams.isEmpty()) {
            return;
        }
        Vector vector = this.logStreams;
        synchronized (vector) {
            boolean bl = this.logStreams.removeElement(logStreamInfo);
            if (bl) {
                logStreamInfo.logStream.println("");
                logStreamInfo.logStream.flush();
                if ((logStreamInfo.fileName == null || !logStreamInfo.fileName.equals("%stdout") && !logStreamInfo.fileName.equals("%stderr")) && logStreamInfo.logStream instanceof FileLogStream) {
                    ((FileLogStream)logStreamInfo.logStream).writer.close();
                }
                this.testTypeFlags();
                this.notifyLoggerChangedListeners(new LoggerChangedEvent(this, "removeLogStream"));
            }
        }
    }

    public Vector parseStreamsAndFlags(String string) {
        return this.parseStreamsAndFlags(string, false);
    }

    public Vector parseStreamsAndFlags(String string, boolean bl) {
        int n = string.length();
        int n2 = 0;
        Vector<StreamFlagSettings> vector = new Vector<StreamFlagSettings>();
        Vector vector2 = new Vector();
        while ((n2 = StringScanner.skipWhite(string, n2)) < n) {
            String string2;
            String string3;
            int n3 = StringScanner.skipTo(string, n2, " \t\r\n(");
            if (n3 >= n || n2 == n3) {
                string3 = resBundle.getString(String.valueOf(10));
                string2 = StringScanner.createParamString(string3, string);
                this.badSetting(string2);
            }
            String string4 = string.substring(n2, n3);
            if (bl) {
                this.validateLogFile(string4);
            }
            if ((n2 = StringScanner.skipWhite(string, n3)) < n && string.charAt(n2) == '(') {
                if ((n3 = StringScanner.skipTo(string, ++n2, ')')) < n && string.charAt(n3) == ')') {
                    String string5 = string.substring(n2, n3);
                    vector2 = this.parseFlags(string5);
                    vector.add(new StreamFlagSettings(string4, vector2));
                    n2 = n3 + 1;
                    continue;
                }
                string3 = resBundle.getString(String.valueOf(12));
                string2 = StringScanner.createParamString(string3, string, string4);
                this.badSetting(string2);
                continue;
            }
            string3 = resBundle.getString(String.valueOf(13));
            string2 = StringScanner.createParamString(string3, string, string4);
            this.badSetting(string2);
        }
        return vector;
    }

    public void validateLogFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = resBundle.getString(String.valueOf(11));
            String string3 = StringScanner.createParamString(string2, string);
            this.badSetting(string3);
        }
        catch (IOException iOException) {
            String string4 = resBundle.getString(String.valueOf(11));
            String string5 = StringScanner.createParamString(string4, string);
            this.badSetting(string5);
        }
    }

    public Vector parseFlags(String string) {
        Vector<FlagsAsInts> vector = new Vector<FlagsAsInts>();
        int n = 0;
        String string2 = new String("");
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        while ((n = StringScanner.skipWhite(string, n)) < n2) {
            String string3;
            String string4;
            int n3 = -1;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = StringScanner.skipTo(string, n, " \t\r\n:");
            if (n7 >= n2 || n == n7) {
                string4 = resBundle.getString(String.valueOf(14));
                string3 = StringScanner.createParamString(string4, string);
                this.badSetting(string3);
            }
            n3 = this.getType(string.substring(n, n7));
            n = StringScanner.skipWhite(string, n7);
            if (n < n2 && string.charAt(n) == ':') {
                ++n;
                if ((n = StringScanner.skipWhite(string, n)) == (n7 = StringScanner.skipTo(string, n, " \r\t\n:"))) {
                    string4 = resBundle.getString(String.valueOf(15));
                    string3 = StringScanner.createParamString(string4, string);
                    this.badSetting(string3);
                }
                string2 = string.substring(n, n7);
                if (n3 == -1 && string2.equals("*")) {
                    string4 = resBundle.getString(String.valueOf(16));
                    string3 = StringScanner.createParamString(string4, string);
                    this.badSetting(string3);
                }
                if ((n = StringScanner.skipWhite(string, n7)) < n2 && string.charAt(n) == ':') {
                    ++n;
                    if ((n = StringScanner.skipWhite(string, n)) >= n2) {
                        string4 = resBundle.getString(String.valueOf(17));
                        string3 = StringScanner.createParamString(string4, string);
                        this.badSetting(string3);
                    }
                    if (string.charAt(n) == '*') {
                        ++n;
                    } else if (Character.isDigit(string.charAt(n))) {
                        n7 = StringScanner.skipInt(string, n);
                        n4 = Integer.parseInt(string.substring(n, n7));
                        if (n4 < 1 || n4 > 63) {
                            string4 = resBundle.getString(String.valueOf(18));
                            string3 = StringScanner.createParamString(string4, "Group", new Integer(n4), new Integer(63));
                            this.badSetting(string3);
                        }
                        if (StringScanner.charAt(string, n7) == '-') {
                            n = n7 + 1;
                            if (Character.isDigit(StringScanner.charAt(string, n))) {
                                n7 = StringScanner.skipInt(string, n);
                                n5 = Integer.parseInt(string.substring(n, n7));
                                if (n5 < 1 || n5 > 63) {
                                    string4 = resBundle.getString(String.valueOf(18));
                                    string3 = StringScanner.createParamString(string4, "Group", new Integer(n5), new Integer(63));
                                    this.badSetting(string3);
                                } else if (n5 < n4) {
                                    int n8 = n5;
                                    n5 = n4;
                                    n4 = n8;
                                }
                            } else {
                                string4 = resBundle.getString(String.valueOf(19));
                                string3 = StringScanner.createParamString(string4, string);
                                this.badSetting(string3);
                            }
                        }
                        n = n7;
                    } else {
                        string4 = resBundle.getString(String.valueOf(20));
                        string3 = StringScanner.createParamString(string4, string);
                        this.badSetting(string3);
                    }
                    n = StringScanner.skipWhite(string, n);
                    if (n < n2 && string.charAt(n) == ':') {
                        ++n;
                        if ((n = StringScanner.skipWhite(string, n)) >= n2) {
                            String string5 = resBundle.getString(String.valueOf(21));
                            string3 = StringScanner.createParamString(string5, string);
                            this.badSetting(string3);
                        }
                        if (string.charAt(n) == '*') {
                            ++n;
                            n6 = 255;
                        } else if (Character.isDigit(string.charAt(n))) {
                            n7 = StringScanner.skipInt(string, n);
                            n6 = Integer.parseInt(string.substring(n, n7));
                            if (n6 < 1 || n6 > 255) {
                                String string6 = resBundle.getString(String.valueOf(18));
                                string3 = StringScanner.createParamString(string6, "Level", new Integer(n6), new Integer(255));
                                this.badSetting(string3);
                            }
                            n = n7 + 1;
                        } else {
                            String string7 = resBundle.getString(String.valueOf(21));
                            string3 = StringScanner.createParamString(string7, string);
                            this.badSetting(string3);
                        }
                    }
                }
            } else if (n3 == -1) {
                string4 = resBundle.getString(String.valueOf(22));
                string3 = StringScanner.createParamString(string4, string);
                this.badSetting(string3);
            } else {
                string2 = "*";
            }
            if (n6 == 0) {
                n6 = 255;
            }
            if (n4 == 0 && n5 == 0) {
                n4 = 1;
                n5 = 63;
            }
            vector.add(new FlagsAsInts(n3, string2, n4, n5, n6));
        }
        Collections.sort(vector);
        return vector;
    }

    public Vector getLogStreamNames() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.logStreams.size()) {
            String string = ((LogStreamInfo)this.logStreams.get((int)n)).fileName;
            if (string != null) {
                vector.add(string);
            }
            ++n;
        }
        return vector;
    }

    public Vector getStreamFlagsAsStrings(String string) {
        LogStreamInfo logStreamInfo = this.findLogStream(string);
        if (logStreamInfo == null) {
            return new Vector();
        }
        return logStreamInfo.getFlagList();
    }

    public Vector convertToFlagsAsStrings(Vector vector) {
        Vector<FlagsAsStrings> vector2 = new Vector<FlagsAsStrings>();
        int n = 0;
        while (n < vector.size()) {
            FlagsAsStrings flagsAsStrings = new FlagsAsStrings((FlagsAsInts)vector.get(n));
            vector2.add(flagsAsStrings);
            ++n;
        }
        return vector2;
    }

    public Vector getAllModuleNames() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < modulesById.size()) {
            vector.add(((ModuleEntry)TraceLoggerImpl.modulesById.get((int)n)).name);
            ++n;
        }
        Collections.sort(vector);
        return vector;
    }

    public boolean testAndPrintToLogStream(String string, int n, int n2, int n3, int n4, String string2) {
        this.checkParams("testLogStream", n, n2, n3, n4, false);
        LogStreamInfo logStreamInfo = this.findLogStream(string);
        boolean bl = logStreamInfo.test(n, n2, n3, n4);
        if (bl) {
            logStreamInfo.logStream.print(string2);
        }
        return bl;
    }

    public String getShortTypeName(int n) {
        if (n == -1) {
            return "*";
        }
        return msgNames[n - 1];
    }

    public boolean getTypeFlag(int n) {
        switch (n) {
            case 1: {
                return TraceLogger.err;
            }
            case 2: {
                return TraceLogger.sec;
            }
            case 3: {
                return TraceLogger.res;
            }
            case 4: {
                return TraceLogger.aud;
            }
            case 5: {
                return TraceLogger.cfg;
            }
            case 6: {
                return TraceLogger.prf;
            }
            case 7: {
                return TraceLogger.dbg;
            }
        }
        return false;
    }

    void setTypeFlag(int n, boolean bl) {
        switch (n) {
            case 1: {
                TraceLogger.err = bl;
                break;
            }
            case 2: {
                TraceLogger.sec = bl;
                break;
            }
            case 3: {
                TraceLogger.res = bl;
                break;
            }
            case 4: {
                TraceLogger.aud = bl;
                break;
            }
            case 5: {
                TraceLogger.cfg = bl;
                break;
            }
            case 6: {
                TraceLogger.prf = bl;
                break;
            }
            case 7: {
                TraceLogger.dbg = bl;
            }
        }
    }

    static {
        timestampFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy: ");
        timestampFormatMS = new SimpleDateFormat("EEE MMM dd HH:mm:ss.SSS yyyy: ");
    }

    private class LogBufEntry {
        int moduleId;
        int group;
        int level;
        int action;
        String threadName;
        Object obj;

        private LogBufEntry() {
        }
    }
}

