/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ArrayType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.request.EventRequestManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.jpda.FixActionImpl;
import org.netbeans.modules.debugger.jpda.JPDAClass;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.Launcher;
import org.netbeans.modules.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.PopFramesActionImpl;
import org.netbeans.modules.debugger.jpda.RemoteDebuggerInfo;
import org.netbeans.modules.debugger.jpda.StepManager;
import org.netbeans.modules.debugger.jpda.ThreadManager;
import org.netbeans.modules.debugger.jpda.VariableBreakpoint;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.modules.debugger.support.IOManager;
import org.netbeans.modules.debugger.support.StateSupport;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.LoadedClassesProducer;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.Watch;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class JPDADebugger
extends JavaDebugger
implements LoadedClassesProducer {
    static final long serialVersionUID = 2797853329739651906L;
    public static int ACTION_ON_TI_FIND;
    static ResourceBundle bundle;
    private static Random random;
    transient CoreDebugger coreDebugger;
    transient VirtualMachine virtualMachine = null;
    protected transient ThreadManager threadManager;
    private StepManager stepManager;
    private transient Process process;
    private transient Thread debuggerThread;
    transient boolean finishVM;
    private transient boolean disconnected = false;
    private transient Launcher launcher;
    private transient Hashtable loadedClasses = new Hashtable();
    private transient boolean isSuspended = false;
    private transient AttachingConnector connector;
    private transient Map args;
    private transient String mainClassName;
    private transient String stopClassName;
    transient JPDAThread currentThread = null;
    protected transient JPDAThreadGroup threadGroup;
    private transient boolean stopOnMain = false;
    private transient DebuggerInfo debuggerInfo;
    private static transient String[] stopMethodNames;
    private transient CoreBreakpoint[] breakpointMain = null;
    private transient boolean canRedefineClasses;
    private transient boolean canPopFrames;
    private transient FixActionImpl fixActionImpl;
    private transient PopFramesActionImpl popFramesActionImpl;
    transient DataObject dataObjectToFix;
    private transient SelectionListener selectionListener;
    private com.sun.jdi.Method toStringMethod;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDADebugger;
    static /* synthetic */ Class class$com$sun$jdi$VirtualMachine;

    static String getLocString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebugger = JPDADebugger.class$("org.netbeans.modules.debugger.jpda.JPDADebugger")) : class$org$netbeans$modules$debugger$jpda$JPDADebugger));
        }
        return bundle.getString(string);
    }

    public void startDebugger(DebuggerInfo debuggerInfo) throws DebuggerException {
        BreakpointProducer breakpointProducer;
        ((JPDAThreadGroup)this.getThreadsRoot()).setName(((AbstractDebuggerInfo)debuggerInfo).getProcessName());
        this.debuggerInfo = debuggerInfo;
        if (this.virtualMachine != null) {
            this.finishDebugger();
        }
        this.coreDebugger = (CoreDebugger)TopManager.getDefault().getDebugger();
        this.stopOnMain = debuggerInfo.getStopClassName() != null;
        this.mainClassName = debuggerInfo.getClassName();
        this.finishVM = true;
        if (!(debuggerInfo instanceof RemoteDebuggerInfo) && !this.compile(debuggerInfo)) {
            this.finishDebugger();
            return;
        }
        this.disconnected = false;
        super.startDebugger(debuggerInfo);
        if (this.stopOnMain) {
            String string = this.debuggerInfo.getStopClassName();
            breakpointProducer = (BreakpointProducer)this.coreDebugger;
            this.breakpointMain = new CoreBreakpoint[stopMethodNames.length];
            int n = 0;
            while (n < this.breakpointMain.length) {
                this.breakpointMain[n] = breakpointProducer.createBreakpoint(true);
                MethodBreakpoint methodBreakpoint = new MethodBreakpoint();
                methodBreakpoint.setClassName(string);
                methodBreakpoint.setMethodName(stopMethodNames[n]);
                this.breakpointMain[n].setEvent((CoreBreakpoint.Event)methodBreakpoint);
                CoreBreakpoint.Action[] actionArray = this.breakpointMain[n].getActions();
                int n2 = actionArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (actionArray[n3] instanceof PrintAction) {
                        ((PrintAction)actionArray[n3]).setPrintText(JPDADebugger.getLocString("CTL_Stop_On_Main_print_text"));
                    }
                    ++n3;
                }
                ++n;
            }
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("state") && ((Integer)propertyChangeEvent.getNewValue() == 4 || (Integer)propertyChangeEvent.getNewValue() == 1)) {
                        if (JPDADebugger.this.breakpointMain != null) {
                            int n = 0;
                            while (n < JPDADebugger.this.breakpointMain.length) {
                                JPDADebugger.this.breakpointMain[n].remove();
                                ++n;
                            }
                            JPDADebugger.access$002(JPDADebugger.this, null);
                        }
                        JPDADebugger.this.removePropertyChangeListener(this);
                    }
                }
            });
        }
        boolean bl = false;
        breakpointProducer = ((Object)((Object)this)).getClass();
        synchronized (breakpointProducer) {
            if (debuggerInfo instanceof ReconnectDebuggerInfo) {
                this.virtualMachine = this.reconnect((ReconnectDebuggerInfo)debuggerInfo);
            } else if (debuggerInfo instanceof RemoteDebuggerInfo) {
                this.virtualMachine = this.connect((RemoteDebuggerInfo)debuggerInfo);
            } else {
                this.virtualMachine = this.launch(debuggerInfo);
                this.getIOManager().showOutput(this.process, 3, 2);
                this.getIOManager().connectInput(this.process);
                bl = true;
            }
            Operator operator = this.createOperator(bl);
            this.stepManager = this.createStepManager(this.virtualMachine.eventRequestManager(), operator);
            operator.start();
            this.setupHotswapCapabilities(this.virtualMachine);
            if (!bl) {
                this.startDebugger(false);
            }
        }
    }

    public synchronized void finishDebugger() throws DebuggerException {
        StepManager stepManager;
        this.disconnected = true;
        if (this.threadManager != null) {
            this.threadManager.finish();
        }
        this.threadManager = null;
        if (this.debuggerThread != null) {
            this.debuggerThread.interrupt();
            this.debuggerThread.stop();
        }
        this.loadedClasses = new Hashtable();
        if (this.breakpointMain != null) {
            int n = 0;
            while (n < this.breakpointMain.length) {
                this.breakpointMain[n].remove();
                ++n;
            }
            this.breakpointMain = null;
        }
        if ((stepManager = this.getStepManager()) != null) {
            stepManager.destroy();
        }
        if (this.finishVM) {
            try {
                if (this.virtualMachine != null) {
                    if (this.debuggerInfo instanceof RemoteDebuggerInfo) {
                        this.virtualMachine.dispose();
                    } else {
                        this.virtualMachine.exit(0);
                        if (this.process != null) {
                            this.process.destroy();
                        }
                    }
                }
                this.virtualMachine = null;
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        super.finishDebugger();
    }

    public synchronized void traceInto() throws DebuggerException {
        if (this.virtualMachine == null || this.currentThread == null) {
            return;
        }
        this.setLastAction(3);
        this.setState(3);
        this.getStepManager().stepInto();
        this.setState(3);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
        this.getIOManager().println(JavaDebugger.getString((String)"CTL_Debugger_running"), 4);
    }

    public synchronized void traceOver() throws DebuggerException {
        if (this.virtualMachine == null || this.currentThread == null) {
            return;
        }
        this.setLastAction(2);
        this.setState(3);
        this.getStepManager().stepOver();
        this.setState(3);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
        this.getIOManager().println(JavaDebugger.getString((String)"CTL_Debugger_running"), 4);
    }

    public synchronized void go() throws DebuggerException {
        if (this.virtualMachine == null) {
            return;
        }
        this.setLastAction(5);
        this.getStepManager().go();
        super.go();
    }

    public synchronized void stepOut() throws DebuggerException {
        if (this.virtualMachine == null || this.currentThread == null) {
            return;
        }
        this.setLastAction(4);
        this.setState(3);
        this.getStepManager().stepOut();
        this.setState(3);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
        this.getIOManager().println(JavaDebugger.getString((String)"CTL_Debugger_running"), 4);
    }

    public synchronized void runToCursor(Line line) {
        if (this.virtualMachine == null || this.currentThread == null) {
            return;
        }
        this.setLastAction(2);
        this.getStepManager().runToCursor(line);
        super.runToCursor(line);
    }

    public void pause() {
        this.setSuspended(true);
    }

    public void setSuspended(boolean bl) {
        if (bl) {
            Object object;
            this.suspend();
            if (this.currentThread == null && !this.disconnected && (object = this.threadManager.getAnyThread()) != null) {
                object.setCurrent(true);
            }
            this.setState(4);
            object = this.getIOManager();
            SwingUtilities.invokeLater(new Runnable((IOManager)object){
                private final /* synthetic */ IOManager val$ioManager;
                {
                    this.val$ioManager = iOManager;
                }

                public void run() {
                    this.val$ioManager.println(JPDADebugger.getLocString("CTL_Debugger_paused"), 4);
                }
            });
            this.threadManager.refreshStacks();
        } else {
            this.resume();
            this.setState(3);
        }
    }

    private synchronized void suspend() {
        if (this.isSuspended) {
            return;
        }
        this.isSuspended = true;
        if (this.virtualMachine != null) {
            this.virtualMachine.suspend();
        }
    }

    public synchronized void resume() {
        this.isSuspended = false;
        if (this.virtualMachine == null) {
            return;
        }
        if (this.currentThread == null) {
            this.virtualMachine.resume();
            return;
        }
        try {
            ThreadReference threadReference = this.currentThread.getThreadReference();
            int n = threadReference.suspendCount();
            if (n == 0) {
                this.virtualMachine.resume();
                return;
            }
            int n2 = 0;
            while (n2 < n) {
                this.virtualMachine.resume();
                ++n2;
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            this.virtualMachine.resume();
        }
    }

    public Watch createWatch() {
        JPDAWatch jPDAWatch = new JPDAWatch(this, false);
        this.addWatch((Watch)jPDAWatch);
        return jPDAWatch;
    }

    public Watch createWatch(String string, boolean bl) {
        JPDAWatch jPDAWatch = new JPDAWatch(this, false);
        jPDAWatch.setVariableName(string);
        this.addWatch((Watch)jPDAWatch);
        return jPDAWatch;
    }

    public String getLocationName(DebuggerInfo debuggerInfo) {
        if (debuggerInfo instanceof RemoteDebuggerInfo) {
            if (JPDADebugger.hasShmemTransport(((RemoteDebuggerInfo)debuggerInfo).getConnector())) {
                return "localhost";
            }
            if (JPDADebugger.hasSocketTransport(((RemoteDebuggerInfo)debuggerInfo).getConnector())) {
                Connector.Argument argument = (Connector.Argument)((RemoteDebuggerInfo)debuggerInfo).getArgs().get("hostname");
                return argument == null ? "localhost" : argument.value();
            }
            return "localhost";
        }
        return "localhost";
    }

    public ThreadsProducer getThreadsRoot() {
        if (this.threadGroup == null) {
            this.threadGroup = new JPDAThreadGroup("Thread");
        }
        return this.threadGroup;
    }

    public AbstractThread getCurrentThread() {
        return this.currentThread;
    }

    public void setCurrentThread(AbstractThread abstractThread) {
        if (this.currentThread == abstractThread) {
            return;
        }
        JPDAThread jPDAThread = this.currentThread;
        this.currentThread = (JPDAThread)abstractThread;
        this.updateCurrentStackPosition();
        this.updateStoppedState();
        this.firePropertyChange("currentThread", (Object)jPDAThread, abstractThread);
    }

    public List getLoadedClasses() {
        if (this.virtualMachine == null || this.disconnected) {
            this.loadedClasses = new Hashtable();
            return new ArrayList();
        }
        try {
            List<ReferenceType> list = this.virtualMachine.allClasses();
            ArrayList<JPDAClass> arrayList = new ArrayList<JPDAClass>();
            Hashtable<ReferenceType, JPDAClass> hashtable = new Hashtable<ReferenceType, JPDAClass>();
            int n = 0;
            while (n < list.size()) {
                try {
                    ReferenceType referenceType = list.get(n);
                    if (!(referenceType instanceof ArrayType) && referenceType.name().indexOf(36) == -1) {
                        JPDAClass jPDAClass = (JPDAClass)((Object)this.loadedClasses.get(referenceType));
                        if (jPDAClass == null) {
                            jPDAClass = new JPDAClass(referenceType, this);
                        }
                        hashtable.put(referenceType, jPDAClass);
                        arrayList.add(jPDAClass);
                    }
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
                ++n;
            }
            this.loadedClasses = hashtable;
            return arrayList;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.loadedClasses = new Hashtable();
            return new ArrayList();
        }
    }

    void makeCurrent(String string, String string2, String string3, String string4, boolean bl, ThreadReference threadReference, Line line) {
        this.setState(4);
        IOManager iOManager = this.getIOManager();
        if (bl) {
            iOManager.println(new MessageFormat(JPDADebugger.getLocString("CTL_Thread_stopped")).format(new Object[]{string, string2, string3, string4}), 5, line);
        } else {
            iOManager.println(new MessageFormat(JPDADebugger.getLocString("CTL_Thread_stopped_no_source")).format(new Object[]{string, string2, string3, string4}), 5);
        }
        JPDAThread jPDAThread = this.threadManager.getThread(threadReference);
        jPDAThread.setCurrent(true);
        this.updateUI();
    }

    synchronized void stop(boolean bl, AbstractThread abstractThread) {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebugger = JPDADebugger.class$("org.netbeans.modules.debugger.jpda.JPDADebugger")) : class$org$netbeans$modules$debugger$jpda$JPDADebugger));
        if (bl) {
            this.getStepManager().stop();
            if (this.getLastAction() != 10) {
                this.setLastAction(1);
            }
            this.setState(4);
            if (abstractThread != null) {
                abstractThread.setCurrent(true);
            }
            this.updateUI();
        } else {
            this.getStepManager().resumeOperator();
        }
    }

    protected void updateUINow() {
        if (this.threadManager != null) {
            this.threadManager.refreshStacks();
        }
        super.updateUINow();
    }

    private StepManager createStepManager(EventRequestManager eventRequestManager, Operator operator) {
        return new StepManager(this, eventRequestManager, operator);
    }

    private Operator createOperator(boolean bl) {
        return new Operator(this.virtualMachine, bl ? new Runnable(){

            public void run() {
                JPDADebugger.this.startDebugger(true);
            }
        } : null, new Runnable(){

            public void run() {
                try {
                    JPDADebugger.this.finishVM = false;
                    JPDADebugger.this.finishDebugger();
                }
                catch (DebuggerException debuggerException) {
                    // empty catch block
                }
            }
        });
    }

    private void startDebugger(boolean bl) {
        this.threadManager = new ThreadManager(this);
        boolean bl2 = this.virtualMachine.canWatchFieldAccess();
        boolean bl3 = this.virtualMachine.canWatchFieldModification();
        if (!bl2 || !bl3) {
            AbstractDebugger abstractDebugger = (AbstractDebugger)this.coreDebugger;
            Breakpoint[] breakpointArray = abstractDebugger.getBreakpoints();
            int n = 0;
            while (n < breakpointArray.length) {
                CoreBreakpoint.Event event;
                if (((CoreBreakpoint)breakpointArray[n]).isEnabled() && (event = ((CoreBreakpoint)breakpointArray[n]).getEvent((Debugger)abstractDebugger)) instanceof VariableBreakpoint) {
                    if (!bl2 && !bl3) {
                        this.getIOManager().println(JPDADebugger.getLocString("CTL_Break_on_field_not_supported"), 1);
                        break;
                    }
                    if (((VariableBreakpoint)event).getType() == 0 && !bl2) {
                        this.getIOManager().println(JPDADebugger.getLocString("CTL_Break_on_field_access_not_supported"), 1);
                        break;
                    }
                    if (((VariableBreakpoint)event).getType() == 1 && !bl3) {
                        this.getIOManager().println(JPDADebugger.getLocString("CTL_Break_on_field_modification_not_supported"), 1);
                        break;
                    }
                }
                ++n;
            }
        }
        this.getIOManager().println(JPDADebugger.getLocString("CTL_Debugger_running"), 4);
        this.setState(3);
        if (bl) {
            this.getStepManager().resumeOperator();
        } else {
            this.resume();
        }
        if (this.debuggerThread != null) {
            this.debuggerThread.stop();
        }
        this.debuggerThread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (JPDADebugger.this.getState() != 3 || JPDADebugger.this.threadManager == null) continue;
                    JPDADebugger.this.threadManager.refreshThreads();
                }
            }
        }, "Debugger refresh thread");
        this.debuggerThread.setPriority(1);
    }

    private static String generatePassword() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 4) {
            stringBuffer.append((char)(random.nextInt(26) + 97));
            ++n;
        }
        return new String(stringBuffer);
    }

    private void setupHotswapCapabilities(VirtualMachine virtualMachine) {
        try {
            Object object;
            Method method;
            Class clazz = class$com$sun$jdi$VirtualMachine == null ? (class$com$sun$jdi$VirtualMachine = JPDADebugger.class$("com.sun.jdi.VirtualMachine")) : class$com$sun$jdi$VirtualMachine;
            try {
                method = clazz.getMethod("canRedefineClasses", null);
                object = method.invoke((Object)virtualMachine, new Object[0]);
                this.canRedefineClasses = Boolean.TRUE.equals(object);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                method = clazz.getMethod("canPopFrames", null);
                object = method.invoke((Object)virtualMachine, new Object[0]);
                this.canPopFrames = Boolean.TRUE.equals(object);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(4096, (Throwable)exception);
        }
    }

    private VirtualMachine launch(DebuggerInfo debuggerInfo) throws DebuggerException {
        try {
            if (this.launcher == null) {
                this.launcher = new Launcher(this.getIOManager());
            }
            VirtualMachine virtualMachine = this.launcher.launch(debuggerInfo);
            this.process = this.launcher.process();
            this.connector = this.launcher.attachingConnector();
            String string = this.launcher.address();
            this.args = this.connector.defaultArguments();
            if (JPDADebugger.hasShmemTransport(this.connector)) {
                ((Connector.Argument)this.args.get("name")).setValue(string);
            } else {
                ((Connector.Argument)this.args.get("port")).setValue(string);
            }
            return virtualMachine;
        }
        catch (DebuggerException debuggerException) {
            this.finishDebugger();
            throw debuggerException;
        }
    }

    private VirtualMachine reconnect(ReconnectDebuggerInfo reconnectDebuggerInfo) throws DebuggerException {
        return this.connect("CTL_Reconnecting_to", reconnectDebuggerInfo.getConnector(), reconnectDebuggerInfo.getArgs());
    }

    private VirtualMachine connect(RemoteDebuggerInfo remoteDebuggerInfo) throws DebuggerException {
        this.connector = remoteDebuggerInfo.getConnector();
        this.args = remoteDebuggerInfo.getArgs();
        return this.connect("CTL_Connecting_to", this.connector, this.args);
    }

    private VirtualMachine connect(String string, AttachingConnector attachingConnector, Map map) throws DebuggerException {
        Object object;
        if (string != null) {
            if (JPDADebugger.hasShmemTransport(attachingConnector)) {
                object = (Connector.Argument)map.get("name");
                if (object == null) {
                    this.getIOManager().println(JPDADebugger.getLocString(string + "_shmem_noargs"), 1);
                } else {
                    this.getIOManager().println(new MessageFormat(JPDADebugger.getLocString(string + "_shmem")).format(new Object[]{object.value()}), 1);
                }
            } else if (JPDADebugger.hasSocketTransport(attachingConnector)) {
                object = (Connector.Argument)map.get("hostname");
                Connector.Argument argument = (Connector.Argument)map.get("port");
                if (object == null || argument == null) {
                    this.getIOManager().println(JPDADebugger.getLocString(string + "_socket_noargs"), 1);
                } else {
                    this.getIOManager().println(new MessageFormat(JPDADebugger.getLocString(string + "_socket")).format(new Object[]{object.value(), argument.value()}), 1);
                }
            } else {
                this.getIOManager().println(JPDADebugger.getLocString(string), 1);
            }
        }
        try {
            object = attachingConnector.attach(map);
            if (object != null) {
                this.getIOManager().println(JPDADebugger.getLocString("CTL_Connection_established"), 1);
            }
            return object;
        }
        catch (Exception exception) {
            this.finishDebugger();
            throw new DebuggerException(new MessageFormat(JPDADebugger.getLocString("EXC_While_connecting_to_debuggee")).format(new Object[]{exception.toString()}), (Throwable)exception);
        }
    }

    boolean isDisconnected() {
        return this.disconnected;
    }

    protected void setLastAction(int n) {
        super.setLastAction(n);
    }

    public synchronized void setState(int n) {
        if (this.canRedefineClasses) {
            boolean bl;
            boolean bl2 = n == 3 || n == 4;
            boolean bl3 = bl = this.selectionListener != null && this.selectionListener.isEnabled();
            if (bl2 != bl) {
                if (bl2) {
                    if (this.selectionListener == null) {
                        this.selectionListener = new SelectionListener();
                    }
                    this.selectionListener.setEnabled(true);
                    this.selectionListener.setDataObjectToFix();
                } else {
                    this.selectionListener.setEnabled(false);
                }
            }
        }
        super.setState(n);
    }

    private synchronized void setDataObjectToFix(DataObject dataObject) {
        boolean bl = dataObject == null != (this.dataObjectToFix == null);
        this.dataObjectToFix = dataObject;
        if (bl) {
            int n = this.getState();
            if (n == 3) {
                this.updateRunningState();
            } else if (n == 4) {
                this.updateStoppedState();
            }
        }
    }

    protected void updateStoppedState() {
        super.updateStoppedState();
    }

    public StepManager getStepManager() {
        return this.stepManager;
    }

    public EventRequestManager getRequestManager() {
        return this.getStepManager().getRequestManager();
    }

    protected void updateRunningState() {
        if (this.canRedefineClasses && this.dataObjectToFix != null) {
            this.setDebuggerState((State)new StateSupport(1056));
        } else {
            super.updateRunningState();
        }
    }

    private static boolean hasSocketTransport(Connector connector) {
        try {
            return connector.transport().name().toLowerCase().indexOf("socket") > -1;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    private static boolean hasShmemTransport(Connector connector) {
        try {
            return connector.transport().name().toLowerCase().indexOf("shmem") > -1;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    com.sun.jdi.Method getToStringMethod() {
        if (this.toStringMethod != null) {
            return this.toStringMethod;
        }
        List<Comparable<ReferenceType>> list = this.virtualMachine.classesByName("java.lang.Object");
        ReferenceType referenceType = list.iterator().next();
        list = referenceType.methodsByName("toString");
        this.toStringMethod = (com.sun.jdi.Method)list.iterator().next();
        return this.toStringMethod;
    }

    public void fix() {
        if (this.fixActionImpl == null) {
            try {
                this.fixActionImpl = new FixActionImpl(this);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify(4096, (Throwable)noSuchMethodException);
                this.canRedefineClasses = false;
                return;
            }
        }
        this.fixActionImpl.fix();
    }

    public boolean canPopFrames() {
        return this.canPopFrames;
    }

    public void popTopmostFrame() {
        if (this.popFramesActionImpl == null) {
            try {
                this.popFramesActionImpl = new PopFramesActionImpl(this);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify(4096, (Throwable)noSuchMethodException);
                this.canPopFrames = false;
                return;
            }
        }
        this.popFramesActionImpl.popTopmostFrame();
    }

    void popFrames(JPDAThread jPDAThread, int n) throws NativeMethodException, InvocationTargetException, IncompatibleThreadStateException, IllegalAccessException {
        if (this.popFramesActionImpl == null) {
            try {
                this.popFramesActionImpl = new PopFramesActionImpl(this);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify(4096, (Throwable)noSuchMethodException);
                this.canPopFrames = false;
                return;
            }
        }
        this.popFramesActionImpl.popFrames(jPDAThread, n);
    }

    protected boolean getStoppedStateForFix() {
        return this.canRedefineClasses && this.dataObjectToFix != null;
    }

    protected boolean getPopTopmostFrameState() {
        return this.canPopFrames && this.currentThread != null && this.currentThread.isSuspended() && this.currentThread.getStackDepth() > 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ CoreBreakpoint[] access$002(JPDADebugger jPDADebugger, CoreBreakpoint[] coreBreakpointArray) {
        jPDADebugger.breakpointMain = coreBreakpointArray;
        return coreBreakpointArray;
    }

    static {
        random = new Random();
        stopMethodNames = new String[]{"main", "start", "init", "<init>"};
    }

    private final class SelectionListener
    implements PropertyChangeListener {
        private boolean enabled;
        private final TopComponent.Registry registry = TopComponent.getRegistry();
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        public void setEnabled(boolean bl) {
            if (bl == this.enabled) {
                return;
            }
            this.enabled = bl;
            if (bl) {
                this.registry.addPropertyChangeListener((PropertyChangeListener)this);
            } else {
                this.registry.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        private void setDataObjectToFix() {
            DataObject dataObject;
            DataObject dataObject2 = null;
            Node[] nodeArray = this.registry.getCurrentNodes();
            if (nodeArray != null && nodeArray.length == 1 && (dataObject = (DataObject)nodeArray[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SelectionListener.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) != null && dataObject.getPrimaryFile().getMIMEType().equalsIgnoreCase("text/x-java")) {
                dataObject2 = dataObject;
            }
            JPDADebugger.this.setDataObjectToFix(dataObject2);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "currentNodes") {
                int n = JPDADebugger.this.getState();
                if (n != 3 && n != 4) {
                    return;
                }
                this.setDataObjectToFix();
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class ReconnectDebuggerInfo
    extends RemoteDebuggerInfo {
        private ReconnectDebuggerInfo(AttachingConnector attachingConnector, Map map) {
            super(attachingConnector, map);
        }
    }
}

