/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.jpda.WatchVariable;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.Evaluator;
import org.netbeans.modules.debugger.jpda.evaluator.TimeoutException;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.JavaWatch;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class JPDAWatch
extends JavaWatch {
    static final long serialVersionUID = 3439367144447814302L;
    protected WatchVariable var;
    private String errorMessage;
    private HashMap variables = new HashMap();
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDAWatch;

    JPDAWatch(JPDADebugger jPDADebugger, boolean bl) {
        super((JavaDebugger)jPDADebugger, bl);
        this.var = new WatchVariable(jPDADebugger, false);
    }

    public boolean isInScope() {
        return this.getErrorMessage() == null;
    }

    public AbstractVariable getVariable() {
        return this.var;
    }

    public boolean isLeaf() {
        return false;
    }

    public void validate() {
        if (this.debugger.getState() == 1 || ((JPDADebugger)this.debugger).isDisconnected()) {
            this.setErrorMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDAWatch == null ? (class$org$netbeans$modules$debugger$jpda$JPDAWatch = JPDAWatch.class$("org.netbeans.modules.debugger.jpda.JPDAWatch")) : class$org$netbeans$modules$debugger$jpda$JPDAWatch)).getString("EXC_No_session"));
            this.firePropertyChange(null, null, null);
        } else if (this.debugger.getState() != 4) {
            this.setErrorMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDAWatch == null ? (class$org$netbeans$modules$debugger$jpda$JPDAWatch = JPDAWatch.class$("org.netbeans.modules.debugger.jpda.JPDAWatch")) : class$org$netbeans$modules$debugger$jpda$JPDAWatch)).getString("CTL_No_context"));
            this.firePropertyChange(null, null, null);
        } else {
            JPDAThread jPDAThread = (JPDAThread)this.debugger.getCurrentThread();
            if (jPDAThread != null) {
                this.refreshValue(jPDAThread);
            } else {
                this.setErrorMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDAWatch == null ? (class$org$netbeans$modules$debugger$jpda$JPDAWatch = JPDAWatch.class$("org.netbeans.modules.debugger.jpda.JPDAWatch")) : class$org$netbeans$modules$debugger$jpda$JPDAWatch)).getString("CTL_No_context"));
                this.firePropertyChange(null, null, null);
            }
        }
    }

    public boolean canRemove() {
        return false;
    }

    public String getAsText() {
        if (!this.isInScope()) {
            return null;
        }
        String string = this.var.getAsText();
        if (string == null && this.errorMessage == null) {
            string = "null";
        }
        return string;
    }

    public String getType() {
        if (!this.isInScope()) {
            return "";
        }
        return this.var.getType();
    }

    public void setAsText(String string) {
        this.var.setAsText(string);
        this.firePropertyChange(null, null, null);
    }

    public AbstractVariable[] getVariables() {
        if (!this.isInScope()) {
            return new JPDAVariable[0];
        }
        return this.var.getVariables();
    }

    public JavaVariable[] filterVariables(ModifiersFilter modifiersFilter, int n, int n2) {
        if (!this.isInScope()) {
            return new JPDAVariable[0];
        }
        return this.var.filterVariables(modifiersFilter, n, n2);
    }

    public int getVariablesNumber() {
        if (!this.isInScope()) {
            return 0;
        }
        return this.var.getVariablesNumber();
    }

    public String toStringValue() {
        if (!this.isInScope()) {
            return "";
        }
        return this.var.toStringValue();
    }

    public String getInnerType() {
        if (!this.isInScope()) {
            return "";
        }
        return this.var.getInnerType();
    }

    public boolean isObject() {
        if (!this.isInScope()) {
            return false;
        }
        return this.var.isObject();
    }

    public boolean isArray() {
        if (!this.isInScope()) {
            return false;
        }
        return this.var.isArray();
    }

    public String getModifiers() {
        if (!this.isInScope()) {
            return "";
        }
        return this.var.getModifiers();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public AbstractVariable getVariable(String string) {
        if (!this.isInScope()) {
            return null;
        }
        return this.var.getVariable(string);
    }

    public JavaVariable createFixedVariable() {
        return this.var.createFixedVariable();
    }

    public boolean isFixedVariable() {
        return this.var.isFixedVariable();
    }

    protected void refreshValue(JavaThread javaThread) {
        Value value;
        JPDAThread jPDAThread = (JPDAThread)javaThread;
        ThreadReference threadReference = jPDAThread.getThreadReference();
        int n = jPDAThread.getCurrentCallStackFrameIndex();
        try {
            StackFrame stackFrame = threadReference.frame(n);
        }
        catch (Exception exception) {
            this.setErrorMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDAWatch == null ? (class$org$netbeans$modules$debugger$jpda$JPDAWatch = JPDAWatch.class$("org.netbeans.modules.debugger.jpda.JPDAWatch")) : class$org$netbeans$modules$debugger$jpda$JPDAWatch)).getString("CTL_No_context"));
            this.firePropertyChange(null, null, null);
            return;
        }
        this.setErrorMessage(null);
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("java.lang");
        try {
            value = Evaluator.evaluate(this.displayName, ((JPDADebugger)this.debugger).virtualMachine, threadReference, n, linkedList);
        }
        catch (EvaluateException evaluateException) {
            if (evaluateException instanceof TimeoutException) {
                Line line;
                jPDAThread.setSuspended(true);
                jPDAThread.refresh();
                this.debugger.setCurrentLine(null);
                int n2 = jPDAThread.getLineNumber();
                if (n2 >= 0 && (line = jPDAThread.getLine()) != null) {
                    this.debugger.setCurrentLine(line);
                }
                this.debugger.annotateCallStack();
            }
            this.setErrorMessage(evaluateException.getMessage());
            this.firePropertyChange(null, null, null);
            return;
        }
        this.var.update(this.displayName, value, value == null ? "" : value.type().name());
        this.firePropertyChange(null, null, null);
    }

    public String toString() {
        String string = ((Object)((Object)this)).getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string + ((Object)((Object)this)).hashCode() + "[" + this.var + ", " + this.getVariableName() + ", " + this.getErrorMessage() + "]";
    }

    protected void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public int getSize() {
        return this.var.getSize();
    }

    public int getStartIndex() {
        return this.var.getStartIndex();
    }

    public void setStartIndex(int n) {
        this.var.setStartIndex(n);
        this.firePropertyChange(null, null, null);
    }

    public int getLength() {
        return this.var.getLength();
    }

    public void setLength(int n) {
        this.var.setLength(n);
        this.firePropertyChange(null, null, null);
    }

    public Object getSpecialVariable(String string) {
        return this.variables.get(string);
    }

    public void setSpecialVariable(String string, Object object) {
        this.variables.put(string, object);
        this.firePropertyChange(null, null, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

