/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.debugger.Controller;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerProjectSettings;
import org.netbeans.modules.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.support.java.JavaElementSelector;
import org.netbeans.modules.debugger.support.java.PackageClassHistory;
import org.netbeans.modules.debugger.support.util.AbstractHistory;
import org.netbeans.modules.debugger.support.util.PackageListLoader;
import org.netbeans.modules.debugger.support.util.SimpleHistory;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

class LineBreakpointPanel
extends JPanel
implements Controller,
Runnable {
    static final long serialVersionUID = -8164649328980808272L;
    private final String DOT = ".";
    private final JPDADebuggerProjectSettings historyStorage;
    private final SimpleHistory packageHistory;
    private final PackageClassHistory classHistory;
    private final SimpleHistory conditionHistory;
    private LineBreakpoint event;
    private JavaElementSelector javaElementSelector;
    private String pkg;
    private String cls;
    private boolean valid = false;
    private JPanel jPanel1;
    private JComboBox cboxCondition;
    private JLabel lblLineNumber;
    private JTextField tfLineNumber;
    private JComboBox cboxPackage;
    private JLabel lblPackageName;
    private JComboBox cboxClass;
    private JLabel lblClassName;
    private JLabel lblCondition;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings;

    public LineBreakpointPanel(LineBreakpoint lineBreakpoint) {
        this.event = lineBreakpoint;
        this.javaElementSelector = new JavaElementSelector(2);
        this.javaElementSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LineBreakpointPanel.this.setEventSource(changeEvent.getSource());
            }
        });
        this.initComponents();
        this.putClientProperty("HelpID", "debug.add.breakpoint");
        Listener listener = new Listener(this);
        this.cboxClass.getEditor().getEditorComponent().addKeyListener(listener);
        this.cboxClass.addActionListener(listener);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("ACSD_LineBreakpointPanel"));
        this.cboxPackage.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("ACSD_CTL_Package_name"));
        this.cboxClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("ACSD_CTL_Class_name"));
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("ACSD_CTL_Line_number"));
        this.cboxCondition.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("ACSD_CTL_Condition"));
        this.historyStorage = (JPDADebuggerProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.JPDADebuggerProjectSettings")) : class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings), (boolean)true);
        this.packageHistory = this.historyStorage.getPackageHistory();
        this.classHistory = this.historyStorage.getClassHistory();
        this.conditionHistory = this.historyStorage.getBreakpointConditionHistory();
        this.javaElementSelector.setPackageHistory((AbstractHistory)this.packageHistory);
        this.javaElementSelector.setClassHistory(this.classHistory);
        if (this.conditionHistory.getSize() != 0) {
            this.cboxCondition.setModel(new DefaultComboBoxModel<String>(this.conditionHistory.getItemsAsArray()));
        }
        this.fillPackageAndClass();
        this.fillLineNumber();
        this.tfLineNumber.setMinimumSize(this.tfLineNumber.getPreferredSize());
        String string = lineBreakpoint.getCondition();
        this.cboxCondition.setSelectedItem(string == null ? "" : string.trim());
        this.run();
    }

    private void initComponents() {
        this.lblPackageName = new JLabel();
        this.cboxPackage = this.javaElementSelector.getPackageSelector();
        this.lblClassName = new JLabel();
        this.cboxClass = this.javaElementSelector.getClassSelector();
        this.lblLineNumber = new JLabel();
        this.tfLineNumber = new JTextField();
        this.lblCondition = new JLabel();
        this.cboxCondition = new JComboBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblPackageName.setLabelFor(this.cboxPackage);
        this.lblPackageName.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Package_name_mnemonic").charAt(0));
        this.lblPackageName.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Package_name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 2);
        this.add((Component)this.lblPackageName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(4, 6, 2, 2);
        this.add((Component)this.cboxPackage, gridBagConstraints);
        this.lblClassName.setLabelFor(this.cboxClass);
        this.lblClassName.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Class_name_mnemonic").charAt(0));
        this.lblClassName.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Class_name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)this.lblClassName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.add((Component)this.cboxClass, gridBagConstraints);
        this.lblLineNumber.setLabelFor(this.tfLineNumber);
        this.lblLineNumber.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Line_number"));
        this.lblLineNumber.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Line_number_mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)this.lblLineNumber, gridBagConstraints);
        this.tfLineNumber.setColumns(7);
        this.tfLineNumber.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                LineBreakpointPanel.this.tfLineNumberFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                LineBreakpointPanel.this.tfLineNumberFocusLost(focusEvent);
            }
        });
        this.tfLineNumber.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                LineBreakpointPanel.this.tfLineNumberKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.tfLineNumber, gridBagConstraints);
        this.lblCondition.setLabelFor(this.cboxCondition);
        this.lblCondition.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Condition"));
        this.lblCondition.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Condition_mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)this.lblCondition, gridBagConstraints);
        this.cboxCondition.setEditable(true);
        this.cboxCondition.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                LineBreakpointPanel.this.cboxConditionFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                LineBreakpointPanel.this.cboxConditionFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.add((Component)this.cboxCondition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void tfLineNumberKeyTyped(KeyEvent keyEvent) {
        this.run();
    }

    private void cboxConditionFocusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.cboxCondition.getEditor().selectAll();
        }
    }

    private void cboxConditionFocusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            ComboBoxEditor comboBoxEditor = this.cboxCondition.getEditor();
            String string = ((String)comboBoxEditor.getItem()).trim();
            this.event.setCondition(string);
        }
    }

    private void setEventSource(Object object) {
        if (object == this.cboxPackage) {
            this.pkg = this.javaElementSelector.getSelectedPackage().trim();
            this.classHistory.setPackage(this.pkg);
        } else {
            this.cls = this.javaElementSelector.getSelectedClass().trim();
        }
        String string = this.cls.replace('.', '$');
        if (this.pkg.length() == 0) {
            this.event.setSourceName(string);
        } else {
            this.event.setSourceName(this.pkg + '.' + string);
        }
        this.run();
    }

    private void tfLineNumberFocusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            ((JTextField)focusEvent.getComponent()).selectAll();
        }
    }

    private void tfLineNumberFocusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            if (this.tfLineNumber.getText().trim().length() > 0) {
                try {
                    int n = Integer.parseInt(this.tfLineNumber.getText());
                    if (n < 1) {
                        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JPDADebugger.getLocString("CTL_Bad_line_number"), 0));
                    } else {
                        this.event.setLineNumber(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JPDADebugger.getLocString("CTL_Bad_line_number"), 0));
                }
            }
            this.fillLineNumber();
        }
    }

    private void fillPackageAndClass() {
        String string = this.event.getSourceName().trim();
        if (string.length() < 1) {
            this.pkg = "";
            this.cls = "";
        } else {
            int n = string.lastIndexOf(46);
            if (n == -1) {
                this.pkg = "";
                this.cls = string;
            } else {
                this.pkg = string.substring(0, n);
                this.cls = string.substring(n + 1);
            }
            this.cls = this.cls.replace('$', '.');
            this.javaElementSelector.setInitialSelection(this.pkg, this.cls);
        }
    }

    private void fillLineNumber() {
        if (this.event.getLineNumber() < 1) {
            this.tfLineNumber.setText("");
        } else {
            this.tfLineNumber.setText("" + this.event.getLineNumber());
        }
    }

    public boolean ok() {
        if (this.pkg.length() > 0) {
            this.packageHistory.addItem((Object)this.pkg);
        }
        if (this.cls.length() > 0) {
            this.classHistory.addItem((Object)this.cls);
        }
        this.historyStorage.setPackageHistory(this.packageHistory);
        this.historyStorage.setClassHistory(this.classHistory);
        String string = (String)this.cboxCondition.getSelectedItem();
        if (string != null && (string = string.trim()).length() != 0) {
            this.conditionHistory.addItem((Object)string);
            this.historyStorage.setBreakpointConditionHistory(this.conditionHistory);
        }
        PackageListLoader.reset();
        return true;
    }

    public boolean cancel() {
        PackageListLoader.reset();
        return true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl = false;
                String string = LineBreakpointPanel.this.tfLineNumber.getText().trim();
                String string2 = LineBreakpointPanel.this.javaElementSelector.getSelectedClass().trim();
                if (string.length() > 0) {
                    try {
                        int n = Integer.parseInt(string);
                        if (n > 0) {
                            bl = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (string2.length() < 1) {
                    bl = false;
                }
                if (LineBreakpointPanel.this.valid == bl) {
                    return;
                }
                LineBreakpointPanel.this.valid = bl;
                LineBreakpointPanel.super.firePropertyChange("valid", new Boolean(!LineBreakpointPanel.this.valid), new Boolean(LineBreakpointPanel.this.valid));
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Listener
    extends KeyAdapter
    implements ActionListener {
        Runnable validator;

        Listener(Runnable runnable) {
            this.validator = runnable;
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.validator.run();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.validator.run();
        }
    }
}

