/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.StepRequest;
import java.util.LinkedList;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.modules.debugger.support.java.ActionTIPanel;
import org.netbeans.modules.debugger.support.java.JavaDebuggerSettings;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.debugger.DebuggerException;
import org.openide.text.Line;
import org.openide.util.SharedClassObject;

public class StepManager
implements Executor {
    private JPDADebugger debugger;
    private EventRequestManager requestManager = null;
    private Operator operator;
    private EventRequest stepRequest;
    private MethodEntryRequest smartSteppingER;
    private int smartSteppingCounter = 0;
    private long smartSteppingStart = 0L;
    private CoreBreakpoint runToCursorBreakpoint;
    private static int smartSteppingTimeout = 0;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings;

    StepManager(JPDADebugger jPDADebugger, EventRequestManager eventRequestManager, Operator operator) {
        this.debugger = jPDADebugger;
        this.requestManager = eventRequestManager;
        this.operator = operator;
    }

    public EventRequestManager getRequestManager() {
        return this.requestManager;
    }

    public Operator getOperator() {
        return this.operator;
    }

    void destroy() {
        this.removeStepRequest();
        if (this.requestManager != null) {
            try {
                this.requestManager.deleteAllBreakpoints();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (InternalException internalException) {
                // empty catch block
            }
        }
        this.requestManager = null;
    }

    public void stepInto() {
        this.stepInto(((JPDAThread)this.debugger.getCurrentThread()).getThreadReference());
        this.debugger.resume();
    }

    public void stepInto(ThreadReference threadReference) {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            try {
                this.removeStepRequest();
                StepRequest stepRequest = this.requestManager.createStepRequest(threadReference, -2, 1);
                stepRequest.addCountFilter(1);
                this.setRequest(stepRequest);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void stepOut() {
        this.stepOut(((JPDAThread)this.debugger.getCurrentThread()).getThreadReference());
        this.debugger.resume();
    }

    public void stepOut(ThreadReference threadReference) {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            try {
                this.removeStepRequest();
                StepRequest stepRequest = this.requestManager.createStepRequest(threadReference, -2, 3);
                stepRequest.addCountFilter(1);
                this.setRequest(stepRequest);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void stepOver() {
        this.stepOver(((JPDAThread)this.debugger.getCurrentThread()).getThreadReference());
        this.debugger.resume();
    }

    public void stepOver(ThreadReference threadReference) {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            try {
                this.removeStepRequest();
                StepRequest stepRequest = this.requestManager.createStepRequest(threadReference, -2, 2);
                stepRequest.addCountFilter(1);
                this.setRequest(stepRequest);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void go() {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            try {
                this.removeStepRequest();
                this.debugger.resume();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void runToCursor(Line line) {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            try {
                this.removeStepRequest();
                AbstractDebugger abstractDebugger = (AbstractDebugger)TopManager.getDefault().getDebugger();
                this.runToCursorBreakpoint = (CoreBreakpoint)abstractDebugger.createBreakpoint(line, true);
                CoreBreakpoint.Action[] actionArray = this.runToCursorBreakpoint.getActions();
                int n = actionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (actionArray[n2] instanceof PrintAction) {
                        ((PrintAction)actionArray[n2]).setPrintText(PrintAction.RUN_TO_CURSOR_TEXT);
                    }
                    ++n2;
                }
                this.debugger.resume();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
        }
    }

    public void setRequest(EventRequest eventRequest) {
        this.operator.register(eventRequest, this);
        this.stepRequest = eventRequest;
        eventRequest.setSuspendPolicy(2);
        eventRequest.enable();
    }

    public void removeStepRequest() {
        try {
            if (this.runToCursorBreakpoint != null) {
                this.runToCursorBreakpoint.remove();
                this.runToCursorBreakpoint = null;
            }
            if (this.stepRequest != null) {
                this.requestManager.deleteEventRequest(this.stepRequest);
                this.operator.unregister(this.stepRequest);
                this.stepRequest = null;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public void stop() {
        this.removeStepRequest();
        this.operator.stopRequest();
    }

    void resumeOperator() {
        this.operator.resume();
    }

    public void traceToSourceCode(ThreadReference threadReference) {
        this.smartSteppingER = this.requestManager.createMethodEntryRequest();
        this.smartSteppingER.addThreadFilter(threadReference);
        this.smartSteppingCounter = 1;
        this.smartSteppingStart = System.currentTimeMillis();
        this.operator.register(this.smartSteppingER, this);
        this.smartSteppingER.setSuspendPolicy(2);
        this.smartSteppingER.enable();
    }

    public void exec(Event event) {
        LocatableEvent locatableEvent = (LocatableEvent)event;
        ThreadReference threadReference = locatableEvent.thread();
        Location location = locatableEvent.location();
        int n = -1;
        String string = "?";
        String string2 = "?";
        String string3 = "?";
        String string4 = threadReference.name();
        if (location != null) {
            if (location.method() != null) {
                string = location.method().name();
            }
            string2 = location.declaringType().name();
            n = location.lineNumber();
            if (n >= 0) {
                string3 = "" + n;
            }
        }
        Line line = null;
        if (n != -1) {
            try {
                line = Utils.getLineForSource((String)string2, (String)location.sourceName(), (int)n);
            }
            catch (AbsentInformationException absentInformationException) {
                line = Utils.getLine((String)string2, (int)n);
            }
        }
        if (line != null && !this.debugger.canBeCurrent(line, false)) {
            this.stepOver(threadReference);
            this.resumeOperator();
            return;
        }
        if (line == null) {
            if (this.smartSteppingER != null) {
                if (string2 != null && string2.length() > 1) {
                    this.smartSteppingER.disable();
                    this.smartSteppingER.addClassExclusionFilter(string2);
                    this.smartSteppingER.enable();
                }
                this.operator.resume();
                long l = System.currentTimeMillis() - this.smartSteppingStart;
                if (this.smartSteppingCounter >= smartSteppingTimeout || l > (long)smartSteppingTimeout) {
                    if (System.getProperty("netbeans.debug.smartSteppingInfo") != null) {
                        System.out.println("  smartstepping unsuccessful!!!");
                        System.out.println("  time " + l);
                        System.out.println("  steps count " + this.smartSteppingCounter);
                    }
                    if (this.smartSteppingER != null) {
                        this.requestManager.deleteEventRequest(this.smartSteppingER);
                        this.smartSteppingER = null;
                        this.smartSteppingCounter = 0;
                    }
                    return;
                }
                ++this.smartSteppingCounter;
                return;
            }
            int n2 = StepManager.getActionOnTraceInto(string2, string, string3);
            if (n2 == JPDADebugger.ACTION_ON_TI_FIND) {
                if (this.debugger.getLastAction() == 3) {
                    this.stepOut(threadReference);
                }
                this.traceToSourceCode(threadReference);
                this.resumeOperator();
                return;
            }
            if (n2 == JavaDebuggerSettings.ACTION_ON_TI_TRACE_OUT) {
                this.stepOut(threadReference);
                this.resumeOperator();
                return;
            }
        }
        if (this.smartSteppingER != null) {
            if (System.getProperty("netbeans.debug.smartSteppingInfo") != null) {
                System.out.println("  smart stepping successfull!");
            }
            this.smartSteppingCounter = 0;
            this.requestManager.deleteEventRequest(this.smartSteppingER);
            this.smartSteppingER = null;
        }
        this.debugger.makeCurrent(string4, string2, string, string3, line != null, threadReference, line);
        this.operator.stopRequest();
    }

    private static int getActionOnTraceInto(String string, String string2, String string3) {
        JavaDebuggerSettings javaDebuggerSettings = (JavaDebuggerSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings = StepManager.class$("org.netbeans.modules.debugger.support.java.JavaDebuggerSettings")) : class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings), (boolean)true);
        if (javaDebuggerSettings.isActionOnTraceIntoSet()) {
            ActionTIPanel actionTIPanel = new ActionTIPanel(string, string2, string3);
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)actionTIPanel, -1);
            Object object = TopManager.getDefault().notify((NotifyDescriptor)confirmation);
            if (object.equals(NotifyDescriptor.OK_OPTION)) {
                actionTIPanel.updateSettings();
            }
        }
        return javaDebuggerSettings.getActionOnTraceInto();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("netbeans.debug.smartSteppingTimeout");
        smartSteppingTimeout = string != null ? Integer.parseInt(string) : 2500;
    }

    public class Requestor {
        private LinkedList requests = new LinkedList();
        private Executor listener;

        public Requestor(Executor executor) {
            this.listener = executor;
        }

        public int size() {
            return this.requests.size();
        }

        public void add(EventRequest eventRequest) {
            this.requests.add(eventRequest);
            StepManager.this.operator.register(eventRequest, this.listener);
        }

        public void removeRequests() {
            if (this.requests.size() == 0) {
                return;
            }
            int n = this.requests.size();
            try {
                int n2 = 0;
                while (n2 < n) {
                    EventRequest eventRequest = (EventRequest)this.requests.get(n2);
                    if (StepManager.this.requestManager != null) {
                        StepManager.this.requestManager.deleteEventRequest(eventRequest);
                    }
                    StepManager.this.operator.unregister(eventRequest);
                    ++n2;
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (InternalException internalException) {
                // empty catch block
            }
            this.requests = new LinkedList();
        }
    }
}

