/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nOptions;
import org.openide.TopManager;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public final class I18nUtil {
    public static final String HELP_ID_I18N = "internation.internation";
    public static final String HELP_ID_AUTOINSERT = "internation.autoinsert";
    public static final String HELP_ID_MANINSERT = "internation.maninsert";
    public static final String HELP_ID_FORMED = "internation.formed";
    public static final String HELP_ID_TESTING = "internation.testing";
    public static final String HELP_ID_WIZARD = "internation.wizard";
    public static final String HELP_ID_CUSTOM = "internation.custom";
    public static final String HELP_ID_ADDPARAMS = "internation.addparams";
    public static final String HELP_ID_REPLFORMAT = "internation.replformat";
    public static final String HELP_ID_RUNLOCALE = "internation.runlocale";
    public static final String PE_REPLACE_CODE_HELP_ID = "i18n.pe.replacestring";
    public static final String PE_I18N_REGEXP_HELP_ID = "i18n.pe.i18nregexp";
    public static final String PE_BUNDLE_CODE_HELP_ID = "i18n.pe.bundlestring";
    public static final String PE_TEST_REGEXP_HELP_ID = "i18n.pe.testregexp";
    public static final String PE_I18N_STRING_HELP_ID = "i18n.pe.i18nString";
    private static List initFormatItems;
    private static List initHelpItems;
    private static List replaceFormatItems;
    private static List replaceHelpItems;
    private static List regExpItems;
    private static List regExpHelpItems;
    private static List i18nRegExpItems;
    private static ResourceBundle bundle;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$I18nModule;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$I18nOptions;

    public static List getInitFormatItems() {
        if (initFormatItems == null) {
            initFormatItems = new ArrayList(2);
            initFormatItems.add("java.util.ResourceBundle.getBundle(\"{bundleNameSlashes}\")");
            initFormatItems.add("org.openide.util.NbBundle.getBundle({sourceFileName}.class)");
        }
        return initFormatItems;
    }

    public static List getInitHelpItems() {
        if (initHelpItems == null) {
            initHelpItems = new ArrayList(3);
            initHelpItems.add("{bundleNameSlashes} - " + I18nUtil.getBundle().getString("TXT_PackageNameSlashes"));
            initHelpItems.add("{bundleNameDots} - " + I18nUtil.getBundle().getString("TXT_PackageNameDots"));
            initHelpItems.add("{sourceFileName} - " + I18nUtil.getBundle().getString("TXT_SourceDataObjectName"));
        }
        return initHelpItems;
    }

    public static List getReplaceFormatItems() {
        if (replaceFormatItems == null) {
            replaceFormatItems = new ArrayList(7);
            replaceFormatItems.add("{identifier}.getString(\"{key}\")");
            replaceFormatItems.add("Utilities.getString(\"{key}\")");
            replaceFormatItems.add("java.util.ResourceBundle.getBundle(\"{bundleNameSlashes}\").getString(\"{key}\")");
            replaceFormatItems.add("org.openide.util.NbBundle.getBundle({sourceFileName}.class).getString(\"{key}\")");
            replaceFormatItems.add("java.text.MessageFormat(java.util.ResourceBundle.getBundle(\"{bundleNameSlashes}\").getString(\"{key}\"), {arguments})");
            replaceFormatItems.add("org.openide.util.NbBundle.getMessage({sourceFileName}.class, \"{key}\")");
            replaceFormatItems.add("org.openide.util.NbBundle.getMessage({sourceFileName}.class, \"{key}\", {arguments})");
        }
        return replaceFormatItems;
    }

    public static List getReplaceHelpItems() {
        if (replaceHelpItems == null) {
            replaceHelpItems = new ArrayList(5);
            replaceHelpItems.add("{identifier} - " + I18nUtil.getBundle().getString("TXT_FieldIdentifier"));
            replaceHelpItems.add("{key} - " + I18nUtil.getBundle().getString("TXT_KeyHelp"));
            replaceHelpItems.add("{bundleNameSlashes} - " + I18nUtil.getBundle().getString("TXT_PackageNameSlashes"));
            replaceHelpItems.add("{bundleNameDots} - " + I18nUtil.getBundle().getString("TXT_PackageNameDots"));
            replaceHelpItems.add("{sourceFileName} - " + I18nUtil.getBundle().getString("TXT_SourceDataObjectName"));
            replaceHelpItems.add("{arguments} - " + I18nUtil.getBundle().getString("TXT_Arguments"));
        }
        return replaceHelpItems;
    }

    public static List getRegExpItems() {
        if (regExpItems == null) {
            regExpItems = new ArrayList(4);
            regExpItems.add("(getString|getBundle)[:space:]*\\([:space:]*{hardString}");
            regExpItems.add("// NOI18N");
            regExpItems.add("(getString|getBundle)[:space:]*\\([:space:]*{hardString}|// NOI18N");
            regExpItems.add("(getString|getBundle)[:space:]*\\([:space:]*|getMessage[:space:]*\\(([:alnum:]|[:punct:]|[:space:])*,[:space:]*{hardString}|// NOI18N");
        }
        return regExpItems;
    }

    public static List getI18nRegExpItems() {
        if (i18nRegExpItems == null) {
            i18nRegExpItems = new ArrayList(2);
            i18nRegExpItems.add("getString[:space:]*\\([:space:]*{hardString}");
            i18nRegExpItems.add("(getString[:space:]*\\([:space:]*|getMessage[:space:]*\\(([:alnum:]|[:punct:]|[:space:])*,[:space:]*){hardString}");
        }
        return i18nRegExpItems;
    }

    public static List getRegExpHelpItems() {
        if (regExpHelpItems == null) {
            regExpHelpItems = new ArrayList(15);
            regExpHelpItems.add("{hardString} - " + I18nUtil.getBundle().getString("TXT_HardString"));
            regExpHelpItems.add("[:alnum:] - " + I18nUtil.getBundle().getString("TXT_Alnum"));
            regExpHelpItems.add("[:alpha:] - " + I18nUtil.getBundle().getString("TXT_Alpha"));
            regExpHelpItems.add("[:blank:] - " + I18nUtil.getBundle().getString("TXT_Blank"));
            regExpHelpItems.add("[:cntrl:] - " + I18nUtil.getBundle().getString("TXT_Cntrl"));
            regExpHelpItems.add("[:digit:] - " + I18nUtil.getBundle().getString("TXT_Digit"));
            regExpHelpItems.add("[:graph:] - " + I18nUtil.getBundle().getString("TXT_Graph"));
            regExpHelpItems.add("[:lower:] - " + I18nUtil.getBundle().getString("TXT_Lower"));
            regExpHelpItems.add("[:print:] - " + I18nUtil.getBundle().getString("TXT_Print"));
            regExpHelpItems.add("[:punct:] - " + I18nUtil.getBundle().getString("TXT_Punct"));
            regExpHelpItems.add("[:space:] - " + I18nUtil.getBundle().getString("TXT_Space"));
            regExpHelpItems.add("[:upper:] - " + I18nUtil.getBundle().getString("TXT_Upper"));
            regExpHelpItems.add("[:xdigit:] - " + I18nUtil.getBundle().getString("TXT_Xdigit"));
            regExpHelpItems.add("[:javastart:] - " + I18nUtil.getBundle().getString("TXT_Javastart"));
            regExpHelpItems.add("[:javapart:] - " + I18nUtil.getBundle().getString("TXT_Javapart"));
        }
        return regExpHelpItems;
    }

    public static boolean containsAcceptedDataObject(DataFolder folder) {
        DataObject[] children = folder.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof DataFolder ? I18nUtil.containsAcceptedDataObject((DataFolder)children[i]) : FactoryRegistry.hasFactory(children[i].getClass())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List getAcceptedDataObjects(DataFolder folder) {
        ArrayList<DataObject> accepted = new ArrayList<DataObject>();
        DataObject[] children = folder.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof DataFolder) {
                accepted.addAll(I18nUtil.getAcceptedDataObjects((DataFolder)children[i]));
            } else if (FactoryRegistry.hasFactory(children[i].getClass())) {
                accepted.add(children[i]);
            }
            ++i;
        }
        return accepted;
    }

    public static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$I18nModule == null ? (class$org$netbeans$modules$i18n$I18nModule = I18nUtil.class$("org.netbeans.modules.i18n.I18nModule")) : class$org$netbeans$modules$i18n$I18nModule));
        }
        return bundle;
    }

    public static I18nOptions getOptions() {
        return (I18nOptions)SharedClassObject.findObject((Class)(class$org$netbeans$modules$i18n$I18nOptions == null ? (class$org$netbeans$modules$i18n$I18nOptions = I18nUtil.class$("org.netbeans.modules.i18n.I18nOptions")) : class$org$netbeans$modules$i18n$I18nOptions), (boolean)true);
    }

    public static boolean isDebug() {
        return Boolean.getBoolean("netbeans.debug.exceptions");
    }

    public static TopComponent createTopComponent(JPanel interior, String name, String title, URL icon) {
        TopComponent topComponent = new TopComponent(){

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            protected Object writeReplace() throws ObjectStreamException {
                return null;
            }
        };
        topComponent.setCloseOperation(0);
        topComponent.setLayout(new BorderLayout());
        topComponent.add((Component)interior, "Center");
        topComponent.setName(name);
        topComponent.setToolTipText(title);
        topComponent.putClientProperty("TabPolicy", "HideWhenAlone");
        Workspace[] currentWs = TopManager.getDefault().getWindowManager().getWorkspaces();
        int i = currentWs.length;
        while (--i >= 0) {
            Mode i18nMode = currentWs[i].findMode("internationalization");
            if (i18nMode == null) {
                i18nMode = currentWs[i].createMode("internationalization", title, icon);
                Rectangle bounds = i18nMode.getBounds();
                Dimension size = interior.getPreferredSize();
                size.width += 50;
                bounds.setSize(size);
                i18nMode.setBounds(bounds);
            }
            i18nMode.dockInto(topComponent);
        }
        return topComponent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

