/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.io.IOException;
import java.text.Format;
import java.util.Locale;
import java.util.Map;
import org.openide.execution.ExecInfo;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LocaleExecutor
extends ProcessExecutor {
    private Locale locale;
    static final long serialVersionUID = -8606172928148451403L;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$LocaleExecutor;

    public synchronized void setLocale(Locale newLocale) {
        if (this.locale == newLocale || this.locale != null && this.locale.equals(newLocale)) {
            return;
        }
        Locale oldLocale = this.locale;
        this.locale = newLocale;
        this.firePropertyChange("locale", oldLocale, newLocale);
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.setLocale(Locale.getDefault());
        }
        return this.locale;
    }

    protected String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$LocaleExecutor == null ? (class$org$netbeans$modules$i18n$LocaleExecutor = LocaleExecutor.class$("org.netbeans.modules.i18n.LocaleExecutor")) : class$org$netbeans$modules$i18n$LocaleExecutor)).getString("LBL_LocaleExecutorDisplayName");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("internation.runlocale");
    }

    protected Process createProcess(ExecInfo info) throws IOException {
        return this.getExternalExecutor().exec((Format)((Object)new LocaleFormat(info, this.getClassPath(), this.getBootClassPath(), this.getRepositoryPath(), this.getLibraryPath(), this.getLocale())), this.getEnvironmentVariables(), this.getWorkingDirectory());
    }

    public NbProcessDescriptor getExternalExecutor() {
        if (this.externalExecutor == null) {
            LocaleExecutor localeExecutor = this;
            synchronized (localeExecutor) {
                if (this.externalExecutor == null) {
                    this.externalExecutor = new NbProcessDescriptor("{java.home}{/}bin{/}java", "-cp {filesystems}{:}{classpath}{:}{library} {userlanguage} {userregion} {classname} {arguments}", NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$LocaleExecutor == null ? (class$org$netbeans$modules$i18n$LocaleExecutor = LocaleExecutor.class$("org.netbeans.modules.i18n.LocaleExecutor")) : class$org$netbeans$modules$i18n$LocaleExecutor)).getString("MSG_LocaleExecutorHint"));
                }
            }
        }
        return this.externalExecutor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class LocaleFormat
    extends ProcessExecutor.Format {
        public static final String TAG_USERLANGUAGE = "userlanguage";
        public static final String TAG_USERREGION = "userregion";

        public LocaleFormat(ExecInfo info, NbClassPath classPath, NbClassPath bootClassPath, NbClassPath repository, NbClassPath library, Locale locale) {
            super(info, classPath, bootClassPath, repository, library);
            String variant;
            Map map = this.getMap();
            map.put(TAG_USERLANGUAGE, "-Duser.language=" + locale.getLanguage());
            StringBuffer regionCode = new StringBuffer();
            String countryCode = locale.getCountry();
            if (countryCode != null && !"".equals(countryCode)) {
                regionCode.append(countryCode);
            }
            if ((variant = locale.getVariant()) != null && !"".equals(variant)) {
                regionCode.append("_" + variant);
            }
            map.put(TAG_USERREGION, "-Duser.region=" + regionCode.toString());
        }
    }
}

