/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.modules.TimeFunctions;

public class time
implements ClassDictInit {
    protected static DateFormatSymbols datesyms = new DateFormatSymbols();
    protected static String[] shortdays = null;
    protected static String[] shortmonths = null;
    public static int timezone;
    public static int altzone;
    public static int daylight;
    public static PyTuple tzname;
    public static final int accept2dyear = 0;

    public static void classDictInit(PyObject pyObject) {
        pyObject.__setitem__("time", (PyObject)new TimeFunctions("time", 0, 0));
        pyObject.__setitem__("clock", (PyObject)new TimeFunctions("clock", 0, 0));
        TimeZone timeZone = TimeZone.getDefault();
        if (tzname == null) {
            tzname = new PyTuple(new PyObject[]{new PyString(timeZone.getID()), new PyString(timeZone.getID())});
        }
        daylight = timeZone.useDaylightTime() ? 1 : 0;
        timezone = -timeZone.getRawOffset() / 1000;
        if (timeZone instanceof SimpleTimeZone) {
            // empty if block
        }
        if (altzone == -1) {
            altzone = timezone;
        }
    }

    public static double time$() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    private static void throwValueError(String string) {
        throw new PyException(Py.ValueError, new PyString(string));
    }

    private static int item(PyTuple pyTuple, int n) {
        int n2 = pyTuple.__getitem__(n).__int__().getValue();
        boolean bl = true;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                bl = 1 <= n2 && n2 <= 12;
                break;
            }
            case 2: {
                bl = 1 <= n2 && n2 <= 31;
                break;
            }
            case 3: {
                bl = 0 <= n2 && n2 <= 23;
                break;
            }
            case 4: {
                bl = 0 <= n2 && n2 <= 59;
                break;
            }
            case 5: {
                bl = 0 <= n2 && n2 <= 59;
                break;
            }
            case 6: {
                bl = 0 <= n2 && n2 <= 6;
                break;
            }
            case 7: {
                bl = 1 <= n2 && n2 < 367;
                break;
            }
            case 8: {
                boolean bl2 = bl = -1 <= n2 && n2 <= 1;
            }
        }
        if (!bl) {
            String string;
            switch (n) {
                case 1: {
                    string = "month out of range (1-12)";
                    break;
                }
                case 2: {
                    string = "day out of range (1-31)";
                    break;
                }
                case 3: {
                    string = "hour out of range (0-23)";
                    break;
                }
                case 4: {
                    string = "minute out of range (0-59)";
                    break;
                }
                case 5: {
                    string = "second out of range (0-59)";
                    break;
                }
                case 6: {
                    string = "day of week out of range (0-6)";
                    break;
                }
                case 7: {
                    string = "day of year out of range (1-366)";
                    break;
                }
                case 8: {
                    string = "daylight savings flag out of range (-1,0,1)";
                    break;
                }
                default: {
                    string = "ignore";
                }
            }
            time.throwValueError(string);
        }
        if (n == 1) {
            --n2;
        }
        return n2;
    }

    private static GregorianCalendar _tupletocal(PyTuple pyTuple) {
        return new GregorianCalendar(time.item(pyTuple, 0), time.item(pyTuple, 1), time.item(pyTuple, 2), time.item(pyTuple, 3), time.item(pyTuple, 4), time.item(pyTuple, 5));
    }

    public static double mktime(PyTuple pyTuple) {
        GregorianCalendar gregorianCalendar;
        try {
            gregorianCalendar = time._tupletocal(pyTuple);
        }
        catch (PyException pyException) {
            pyException.type = Py.OverflowError;
            throw pyException;
        }
        return (double)gregorianCalendar.getTime().getTime() / 1000.0;
    }

    protected static PyTuple _timefields(double d, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.clear();
        gregorianCalendar.setTime(new Date((long)(d * 1000.0)));
        int n = gregorianCalendar.get(7) - 2;
        if (n < 0) {
            n += 7;
        }
        boolean bl = timeZone.inDaylightTime(gregorianCalendar.getTime());
        return new PyTuple(new PyObject[]{new PyInteger(gregorianCalendar.get(1)), new PyInteger(gregorianCalendar.get(2) + 1), new PyInteger(gregorianCalendar.get(5)), new PyInteger(gregorianCalendar.get(10) + 12 * gregorianCalendar.get(9)), new PyInteger(gregorianCalendar.get(12)), new PyInteger(gregorianCalendar.get(13)), new PyInteger(n), new PyInteger(gregorianCalendar.get(6)), new PyInteger(bl ? 1 : 0)});
    }

    public static PyTuple localtime(double d) {
        return time._timefields(d, TimeZone.getDefault());
    }

    public static PyTuple gmtime(double d) {
        return time._timefields(d, TimeZone.getTimeZone("GMT"));
    }

    public static String ctime(double d) {
        return time.asctime(time.localtime(d));
    }

    private static String _shortday(int n) {
        try {
            if (shortdays == null) {
                shortdays = new String[7];
                String[] stringArray = datesyms.getShortWeekdays();
                int n2 = 0;
                while (n2 < 6) {
                    time.shortdays[n2] = stringArray[n2 + 2];
                    ++n2;
                }
                time.shortdays[6] = stringArray[1];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            time.throwValueError("day of week out of range (0-6)");
        }
        return shortdays[n];
    }

    private static String _shortmonth(int n) {
        try {
            if (shortmonths == null) {
                shortmonths = new String[12];
                String[] stringArray = datesyms.getShortMonths();
                int n2 = 0;
                while (n2 < 12) {
                    time.shortmonths[n2] = stringArray[n2];
                    ++n2;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            time.throwValueError("month out of range (1-12)");
        }
        return shortmonths[n];
    }

    private static String _padint(int n, int n2) {
        String string = Integer.toString(n);
        int n3 = string.length();
        if (n2 <= n3) {
            return string;
        }
        if (n2 == n3 + 1) {
            return "0" + string;
        }
        if (n2 == n3 + 2) {
            return "00" + string;
        }
        char[] cArray = new char[n2 - n3];
        while (n2 > n3) {
            cArray[n2 - n3] = 48;
            --n2;
        }
        return new String(cArray) + string;
    }

    private static String _twodigit(int n) {
        return time._padint(n, 2);
    }

    private static String _truncyear(int n) {
        String string = time._padint(n, 4);
        return string.substring(string.length() - 2, string.length());
    }

    public static String asctime(PyTuple pyTuple) {
        int n = time.item(pyTuple, 6);
        int n2 = time.item(pyTuple, 1);
        return time._shortday(n) + " " + time._shortmonth(n2) + " " + time._twodigit(time.item(pyTuple, 2)) + " " + time._twodigit(time.item(pyTuple, 3)) + ":" + time._twodigit(time.item(pyTuple, 4)) + ":" + time._twodigit(time.item(pyTuple, 5)) + " " + time.item(pyTuple, 0);
    }

    public static void sleep(double d) {
        try {
            Thread.sleep((long)(d * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            throw new PyException(Py.KeyboardInterrupt, "interrupted sleep");
        }
    }

    public static String strftime(String string, PyTuple pyTuple) {
        String string2 = "";
        int n = 0;
        GregorianCalendar gregorianCalendar = null;
        while (n < string.length()) {
            int n2 = string.indexOf("%", n);
            if (n2 < 0) {
                string2 = string2 + string.substring(n);
                break;
            }
            if (n2 == string.length() - 1) {
                string2 = string2 + "%";
                break;
            }
            string2 = string2 + string.substring(n, n2);
            switch (string.charAt(++n2)) {
                case 'a': {
                    int n3 = time.item(pyTuple, 6);
                    string2 = string2 + time._shortday(n3);
                    break;
                }
                case 'A': {
                    String[] stringArray = datesyms.getWeekdays();
                    int n3 = time.item(pyTuple, 6);
                    if (0 <= n3 && n3 < 6) {
                        string2 = string2 + stringArray[n3 + 2];
                        break;
                    }
                    if (n3 == 6) {
                        string2 = string2 + stringArray[1];
                        break;
                    }
                    time.throwValueError("day of week out of range (0 - 6)");
                    break;
                }
                case 'b': {
                    int n3 = time.item(pyTuple, 1);
                    string2 = string2 + time._shortmonth(n3);
                    break;
                }
                case 'B': {
                    String[] stringArray = datesyms.getMonths();
                    int n3 = time.item(pyTuple, 1);
                    string2 = string2 + stringArray[n3];
                    break;
                }
                case 'c': {
                    string2 = string2 + time.asctime(pyTuple);
                    break;
                }
                case 'd': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 2));
                    break;
                }
                case 'H': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 3));
                    break;
                }
                case 'I': {
                    int n3 = time.item(pyTuple, 3) % 12;
                    if (n3 == 0) {
                        n3 = 12;
                    }
                    string2 = string2 + time._twodigit(n3);
                    break;
                }
                case 'j': {
                    string2 = time._padint(time.item(pyTuple, 7), 3);
                    break;
                }
                case 'm': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 1) + 1);
                    break;
                }
                case 'M': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 4));
                    break;
                }
                case 'p': {
                    int n3 = time.item(pyTuple, 3);
                    String[] stringArray = datesyms.getAmPmStrings();
                    if (0 <= n3 && n3 < 12) {
                        string2 = string2 + stringArray[0];
                        break;
                    }
                    if (12 <= n3 && n3 < 24) {
                        string2 = string2 + stringArray[1];
                        break;
                    }
                    time.throwValueError("hour out of range (0-23)");
                    break;
                }
                case 'S': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 5));
                    break;
                }
                case 'U': {
                    if (gregorianCalendar == null) {
                        gregorianCalendar = time._tupletocal(pyTuple);
                    }
                    gregorianCalendar.setFirstDayOfWeek(1);
                    gregorianCalendar.setMinimalDaysInFirstWeek(7);
                    int n3 = gregorianCalendar.get(3);
                    string2 = string2 + time._twodigit(n3);
                    break;
                }
                case 'w': {
                    int n3 = (time.item(pyTuple, 6) + 1) % 7;
                    string2 = string2 + time._twodigit(n3);
                    break;
                }
                case 'W': {
                    if (gregorianCalendar == null) {
                        gregorianCalendar = time._tupletocal(pyTuple);
                    }
                    gregorianCalendar.setFirstDayOfWeek(2);
                    gregorianCalendar.setMinimalDaysInFirstWeek(7);
                    int n3 = gregorianCalendar.get(3);
                    string2 = string2 + time._twodigit(n3);
                    break;
                }
                case 'x': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 1) + 1) + "/" + time._twodigit(time.item(pyTuple, 2)) + "/" + time._truncyear(time.item(pyTuple, 0));
                    break;
                }
                case 'X': {
                    string2 = string2 + time._twodigit(time.item(pyTuple, 3)) + ":" + time._twodigit(time.item(pyTuple, 4)) + ":" + time._twodigit(time.item(pyTuple, 5));
                    break;
                }
                case 'Y': {
                    string2 = string2 + time._padint(time.item(pyTuple, 0), 4);
                    break;
                }
                case 'y': {
                    string2 = string2 + time._truncyear(time.item(pyTuple, 0));
                    break;
                }
                case 'Z': {
                    boolean bl;
                    if (gregorianCalendar == null) {
                        gregorianCalendar = time._tupletocal(pyTuple);
                    }
                    if (!(bl = true)) break;
                    string2 = string2 + ((Calendar)gregorianCalendar).getTimeZone().getID();
                    break;
                }
                case '%': {
                    string2 = string2 + "%";
                    break;
                }
                default: {
                    string2 = string2 + "%" + string.charAt(n2);
                    ++n2;
                }
            }
            n = n2 + 1;
            ++n2;
        }
        return string2;
    }

    static {
        altzone = -1;
        tzname = null;
    }
}

