/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Hashtable;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.netbeans.junit.AssertionFileFailedError;
import org.netbeans.junit.Filter;
import org.netbeans.junit.Manager;
import org.netbeans.junit.NbTest;
import org.netbeans.junit.diff.Diff;

public abstract class NbTestCase
extends TestCase
implements NbTest {
    private Filter filter;
    private String lastTestMethod = null;
    private Hashtable logStreamTable = null;
    PrintStream systemOutPSWrapper = new PrintStream(System.out);

    public NbTestCase(String name) {
        super(name);
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean canRun() {
        if (null == this.filter) {
            return true;
        }
        boolean isIncluded = this.filter.isIncluded(this.getName());
        return isIncluded;
    }

    public void run(TestResult result) {
        if (this.canRun()) {
            super.run(result);
        }
    }

    public static void assertFile(String message, String test, String pass, String diff, Diff externalDiff) {
        Diff diffImpl = null == externalDiff ? Manager.getSystemDiff() : externalDiff;
        File diffFile = NbTestCase.getDiffName(pass, null == diff ? null : new File(diff));
        if (null == diffImpl) {
            Assert.fail((String)"diff is not available");
        } else {
            try {
                if (null == diffFile) {
                    if (diffImpl.diff(test, pass, null)) {
                        throw new AssertionFileFailedError(message, "");
                    }
                } else if (diffImpl.diff(test, pass, diffFile.getAbsolutePath())) {
                    throw new AssertionFileFailedError(message, diffFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                Assert.fail((String)("exception in assertFile : " + e.getMessage()));
            }
        }
    }

    public static void assertFile(String test, String pass, String diff, Diff externalDiff) {
        NbTestCase.assertFile(null, test, pass, diff, externalDiff);
    }

    public static void assertFile(String message, String test, String pass, String diff) {
        NbTestCase.assertFile(message, test, pass, diff, null);
    }

    public static void assertFile(String test, String pass, String diff) {
        NbTestCase.assertFile(null, test, pass, diff, null);
    }

    public static void assertFile(String test, String pass) {
        NbTestCase.assertFile(null, test, pass, null, null);
    }

    public static void assertFile(String message, File test, File pass, File diff, Diff externalDiff) {
        Diff diffImpl = null == externalDiff ? Manager.getSystemDiff() : externalDiff;
        File diffFile = NbTestCase.getDiffName(pass.getAbsolutePath(), diff);
        if (null == diffImpl) {
            Assert.fail((String)"diff is not available");
        } else {
            try {
                if (diffImpl.diff(test, pass, diffFile)) {
                    throw new AssertionFileFailedError(message, null == diffFile ? "" : diffFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                Assert.fail((String)("exception in assertFile : " + e.getMessage()));
            }
        }
    }

    public static void assertFile(File test, File pass, File diff, Diff externalDiff) {
        NbTestCase.assertFile(null, test, pass, diff, externalDiff);
    }

    public static void assertFile(String message, File test, File pass, File diff) {
        NbTestCase.assertFile(message, test, pass, diff, null);
    }

    public static void assertFile(File test, File pass, File diff) {
        NbTestCase.assertFile(null, test, pass, diff, null);
    }

    public static void assertFile(File test, File pass) {
        NbTestCase.assertFile(null, test, pass, null, null);
    }

    private static File getDiffName(String pass, File diff) {
        if (null == diff) {
            return null;
        }
        if (!diff.exists() || diff.isFile()) {
            return diff;
        }
        StringBuffer d = new StringBuffer();
        d.append(diff.getAbsolutePath());
        int i1 = pass.lastIndexOf(92);
        int i2 = pass.lastIndexOf(47);
        i1 = i1 > i2 ? i1 : i2;
        i1 = -1 == i1 ? 0 : i1 + 1;
        i2 = pass.lastIndexOf(46);
        int n = i2 = -1 == i2 ? pass.length() : i2;
        if (0 < d.length()) {
            d.append("/");
        }
        d.append(pass.substring(i1, i2));
        d.append(".diff");
        return new File(d.toString());
    }

    public String getWorkDirPath() throws IOException {
        String path = Manager.getWorkDirPath();
        if (path == null) {
            throw new IOException("nbjunit.workdir is not set, cannot create workdir");
        }
        path = path + File.separator + this.getClass().getName().replace('.', File.separatorChar);
        path = path + File.separator + this.getName();
        return path;
    }

    public File getWorkDir() throws IOException {
        String path = this.getWorkDirPath();
        File workdir = new File(path);
        if (workdir.exists()) {
            if (!workdir.isDirectory()) {
                throw new IOException("workdir exists, but is not a directory, workdir = " + path);
            }
            return workdir;
        }
        boolean result = workdir.mkdirs();
        if (!result) {
            throw new IOException("workdir creation failed, workdir = " + path);
        }
        return workdir;
    }

    private void deleteFile(File file) throws IOException {
        boolean result;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.deleteFile(files[i]);
                ++i;
            }
        }
        if (!(result = file.delete())) {
            throw new IOException("Cannot delete file, file = " + file.getPath());
        }
    }

    private void deleteSubFiles(File file) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.deleteFile(files[i]);
                ++i;
            }
        }
    }

    public void clearWorkDir() throws IOException {
        File workdir = this.getWorkDir();
        this.deleteSubFiles(workdir);
    }

    private OutputStream gettOutputStreamInWorkDir(String filename) throws IOException {
        File aStreamFile = new File(this.getWorkDir(), filename);
        return null;
    }

    private boolean hasTestMethodChanged() {
        if (!this.getName().equals(this.lastTestMethod)) {
            this.lastTestMethod = this.getName();
            return true;
        }
        return false;
    }

    private PrintStream getFileLog(String logName) throws IOException {
        if (this.logStreamTable == null | this.hasTestMethodChanged()) {
            this.logStreamTable = new Hashtable();
        } else if (this.logStreamTable.containsKey(logName)) {
            return (PrintStream)this.logStreamTable.get(logName);
        }
        FileOutputStream fileLog = new FileOutputStream(new File(this.getWorkDir(), logName));
        PrintStream printStreamLog = new PrintStream(fileLog, true);
        this.logStreamTable.put(logName, printStreamLog);
        return printStreamLog;
    }

    public PrintStream getLog(String logName) {
        try {
            return this.getFileLog(logName);
        }
        catch (IOException ioe) {
            return this.systemOutPSWrapper;
        }
    }

    public PrintStream getLog() {
        return this.getLog(this.getName() + ".log");
    }

    public void log(String message) {
        this.getLog().println(message);
    }

    public void log(String log, String message) {
        this.getLog(log).println(message);
    }

    public PrintStream getRef() {
        String refFilename = this.getName() + ".ref";
        try {
            return this.getFileLog(refFilename);
        }
        catch (IOException ioe) {
            Assert.fail((String)("Could not open reference file: " + refFilename));
            return this.systemOutPSWrapper;
        }
    }

    public void ref(String message) {
        this.getRef().println(message);
    }

    public File getGoldenFile(String filename) {
        String fullClassName;
        String className = fullClassName = this.getClass().getName();
        int lastDot = fullClassName.lastIndexOf(46);
        if (lastDot != -1) {
            className = fullClassName.substring(lastDot + 1);
        }
        String goldenFileName = className + "/" + filename;
        URL url = this.getClass().getResource("data/goldenfiles/" + goldenFileName);
        Assert.assertNotNull((String)("Golden file data/goldenfiles/" + goldenFileName + " cannot be found"), (Object)url);
        String resString = NbTestCase.convertNBFSURL(url);
        File goldenFile = new File(resString);
        return goldenFile;
    }

    public File getGoldenFile() {
        return this.getGoldenFile(this.getName() + ".pass");
    }

    public void compareReferenceFiles(String testFilename, String goldenFilename, String diffFilename) {
        try {
            if (!this.getRef().equals(this.systemOutPSWrapper)) {
                this.getRef().flush();
                this.getRef().close();
            }
            File goldenFile = this.getGoldenFile(goldenFilename);
            File testFile = new File(this.getWorkDir(), testFilename);
            File diffFile = new File(this.getWorkDir(), diffFilename);
            NbTestCase.assertFile("Files differ", testFile, goldenFile, diffFile);
        }
        catch (IOException ioe) {
            Assert.fail((String)"Could not obtain working direcory");
        }
    }

    public void compareReferenceFiles() {
        this.compareReferenceFiles(this.getName() + ".ref", this.getName() + ".pass", this.getName() + ".diff");
    }

    public static String convertNBFSURL(URL url) {
        String path = url.getFile();
        if (url.getProtocol().equals("nbfs")) {
            String prefixFS = "FileSystem ";
            if (path.indexOf(prefixFS) > -1) {
                path = path.substring(path.indexOf(prefixFS) + prefixFS.length());
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            int len = path.length();
            while (i < len) {
                char ch;
                if ((ch = path.charAt(i++)) == 'Q' && i < len) {
                    ch = path.charAt(i++);
                    switch (ch) {
                        case 'B': {
                            sb.append('/');
                            break;
                        }
                        case 'C': {
                            sb.append(':');
                            break;
                        }
                        case 'D': {
                            sb.append('\\');
                            break;
                        }
                        case 'E': {
                            sb.append('#');
                            break;
                        }
                        default: {
                            sb.append('Q');
                            sb.append(ch);
                            break;
                        }
                    }
                    continue;
                }
                sb.append(ch);
            }
            path = sb.toString();
        }
        return path;
    }
}

