/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;
import junit.runner.TestSuiteLoader;
import junit.runner.Version;
import org.openide.TopManager;

public class NbTestRunner
extends BaseTestRunner {
    protected String testName;

    public TestSuiteLoader getLoader() {
        return new NbTestSuiteLoader();
    }

    public static void main(String[] args) {
        NbTestRunner aTestRunner = new NbTestRunner();
        try {
            TestResult r = aTestRunner.start(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void addError(Test test, Throwable t) {
    }

    public void addFailure(Test test, AssertionFailedError t) {
    }

    public void endTest(Test test) {
    }

    public void startTest(Test test) {
    }

    protected TestResult doRun(Test suite, boolean wait) {
        TestResult result = new TestResult();
        result.addListener((TestListener)this);
        long startTime = System.currentTimeMillis();
        suite.run(result);
        long endTime = System.currentTimeMillis();
        this.write(result, endTime - startTime);
        if (wait) {
            this.println("Press <RETURN> to continue");
            try {
                System.in.read();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    protected void runFailed(String message) {
        System.out.println(message);
    }

    protected TestResult start(String[] args) throws Exception {
        boolean wait = false;
        this.testName = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-wait")) {
                wait = true;
            } else if (args[i].equals("-c")) {
                this.testName = this.extractClassName(args[++i]);
            } else if (args[i].equals("-v")) {
                System.out.println("JUnit " + Version.id() + " by Kent Beck and Erich Gamma");
            } else {
                this.testName = args[i];
            }
            ++i;
        }
        if (null == this.testName || this.testName.equals("")) {
            throw new Exception("Usage: TestRunner [-wait] testCaseName, where name is the name of the TestCase class");
        }
        try {
            Test suite = this.getTest(this.testName);
            return this.doRun(suite, wait);
        }
        catch (Exception e) {
            throw new Exception("Could not create and run test suite: " + e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String findExactLocation(Throwable t, String testCase) {
        try {
            String line;
            PipedOutputStream out = new PipedOutputStream();
            PipedInputStream in = new PipedInputStream(out);
            PrintStream os = new PrintStream(out);
            StringBuffer toFind = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            WriteStackTrace wt = new WriteStackTrace(os, t);
            toFind.append(testCase.substring(testCase.indexOf(40) + 1, testCase.indexOf(41)));
            toFind.append(".");
            toFind.append(testCase.substring(0, testCase.indexOf(40)));
            wt.start();
            while (null != (line = reader.readLine())) {
                void var9_10;
                if (-1 != var9_10.indexOf(toFind.toString())) break;
            }
            reader.close();
            if (null != line) {
                return line;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        t.printStackTrace();
        return null;
    }

    private void println(String line) {
        if (null != line) {
            System.out.println(line);
        }
    }

    private void write(TestResult result, long time) {
        this.writeSeparator();
        this.writeErrors(result);
        this.writeSeparator();
        this.writeFailures(result);
        this.writeSeparator();
        this.writeSummary(result, time);
        this.println("");
    }

    private void writeErrors(TestResult result) {
        this.println("Errors logged for the '" + this.testName + "' test:");
        if (0 == result.errorCount()) {
            this.println("\tNo errors.");
            return;
        }
        this.println("\tTotal errors: " + result.errorCount());
        this.println("");
        this.writeFailuresOrErrors(result.errors(), true);
    }

    private void writeFailures(TestResult result) {
        this.println("Failures logged for the '" + this.testName + "' test:");
        if (0 == result.failureCount()) {
            this.println("\tNo failures.");
            return;
        }
        this.println("\tTotal failures: " + result.failureCount());
        this.println("");
        this.writeFailuresOrErrors(result.failures(), false);
    }

    private String getStackTrace(Throwable t) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(512);
        PrintStream ps = new PrintStream(bs);
        t.printStackTrace(ps);
        ps.close();
        return bs.toString();
    }

    private void writeFailuresOrErrors(Enumeration fails, boolean error) {
        while (fails.hasMoreElements()) {
            TestFailure f = (TestFailure)fails.nextElement();
            StringBuffer msg = new StringBuffer();
            msg.append("Test case '");
            msg.append(f.failedTest().toString());
            Throwable t = f.thrownException();
            if (null != t) {
                if (null != t && null != t.getMessage() && 0 < t.getMessage().length()) {
                    msg.append("' failed with  '");
                    msg.append(t.getMessage());
                    msg.append("'");
                } else {
                    msg.append("' failed");
                }
                if (error) {
                    msg.append(".\n detailed stack trace: ");
                    msg.append(this.getStackTrace(t));
                } else {
                    msg.append("\n");
                    msg.append(this.findExactLocation(t, f.failedTest().toString()));
                }
            } else {
                msg.append("' failed from unknown reasons.");
            }
            this.println(msg.toString());
            this.println("");
        }
    }

    private void writeSeparator() {
        this.println("===================================================\n");
    }

    private void writeSummary(TestResult result, long time) {
        this.println("Summary of '" + this.testName + "' test:");
        if (result.wasSuccessful()) {
            this.println("\tResult: Succeeded");
        } else if (0 < result.errorCount()) {
            this.println("\tResult: Failed with Errors");
        } else if (0 < result.failureCount()) {
            this.println("\tResult: Failed");
        } else {
            this.println("\tResult: Unknown");
        }
        this.println("");
        this.println("\tRun:          " + result.runCount());
        this.println("\tFailures:     " + result.failureCount());
        this.println("\tErrors:       " + result.errorCount());
        this.println("\tElapsed time: " + this.elapsedTimeAsString(time));
    }

    private class WriteStackTrace
    extends Thread {
        private PrintStream out = null;
        private Throwable stack = null;

        public WriteStackTrace(PrintStream out, Throwable stack) {
            this.out = out;
            this.stack = stack;
        }

        public void run() {
            if (null != this.out && null != this.stack) {
                this.stack.printStackTrace(this.out);
                this.out.close();
            }
        }
    }

    private class NbTestSuiteLoader
    implements TestSuiteLoader {
        private NbTestSuiteLoader() {
        }

        public Class load(String suiteClassName) throws ClassNotFoundException {
            Class<?> clazz = null != System.getProperty("netbeans.home") ? TopManager.getDefault().currentClassLoader().loadClass(suiteClassName) : Class.forName(suiteClassName);
            return clazz;
        }

        public Class reload(Class aClass) throws ClassNotFoundException {
            return aClass;
        }
    }
}

